/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class PostgreForeignServerManager
extends SQLObjectEditor<PostgreForeignServer, PostgreDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<PostgreDatabase, PostgreForeignServer> getObjectsCache(PostgreForeignServer object) {
        return object.getDatabase().foreignServerCache;
    }

    protected PostgreForeignServer createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new PostgreForeignServer((PostgreDatabase)container);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        PostgreForeignServer foreignServer = (PostgreForeignServer)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create extension", "CREATE FOREIGN SERVER " + foreignServer.getName()));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop extension", "DROP FOREIGN SERVER " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }

    public boolean canCreateObject(Object container) {
        return true;
    }

    public boolean canDeleteObject(PostgreForeignServer object) {
        return true;
    }

    public boolean canEditObject(PostgreForeignServer object) {
        return false;
    }
}

