"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
function normalizeSourceMaps(sourceMap) {
    const scripts = !!(typeof sourceMap === 'object' ? sourceMap.scripts : sourceMap);
    const styles = !!(typeof sourceMap === 'object' ? sourceMap.styles : sourceMap);
    const hidden = typeof sourceMap === 'object' && !!sourceMap.hidden;
    const vendor = typeof sourceMap === 'object' && !!sourceMap.vendor;
    return {
        vendor,
        hidden,
        scripts,
        styles,
    };
}
exports.normalizeSourceMaps = normalizeSourceMaps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm9ybWFsaXplLXNvdXJjZS1tYXBzLmpzIiwic291cmNlUm9vdCI6Ii4vIiwic291cmNlcyI6WyJwYWNrYWdlcy9hbmd1bGFyX2RldmtpdC9idWlsZF9hbmd1bGFyL3NyYy91dGlscy9ub3JtYWxpemUtc291cmNlLW1hcHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7R0FNRzs7QUFJSCxTQUFnQixtQkFBbUIsQ0FBQyxTQUEyQjtJQUM3RCxNQUFNLE9BQU8sR0FBRyxDQUFDLENBQUMsQ0FBQyxPQUFPLFNBQVMsS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2xGLE1BQU0sTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLE9BQU8sU0FBUyxLQUFLLFFBQVEsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDaEYsTUFBTSxNQUFNLEdBQUcsT0FBTyxTQUFTLEtBQUssUUFBUSxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDO0lBQ25FLE1BQU0sTUFBTSxHQUFHLE9BQU8sU0FBUyxLQUFLLFFBQVEsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQztJQUVuRSxPQUFPO1FBQ0wsTUFBTTtRQUNOLE1BQU07UUFDTixPQUFPO1FBQ1AsTUFBTTtLQUNQLENBQUM7QUFDSixDQUFDO0FBWkQsa0RBWUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7IE5vcm1hbGl6ZWRTb3VyY2VNYXBzLCBTb3VyY2VNYXBPcHRpb25zIH0gZnJvbSAnLi4vYnJvd3Nlci9zY2hlbWEnO1xuXG5leHBvcnQgZnVuY3Rpb24gbm9ybWFsaXplU291cmNlTWFwcyhzb3VyY2VNYXA6IFNvdXJjZU1hcE9wdGlvbnMpOiBOb3JtYWxpemVkU291cmNlTWFwcyB7XG4gIGNvbnN0IHNjcmlwdHMgPSAhISh0eXBlb2Ygc291cmNlTWFwID09PSAnb2JqZWN0JyA/IHNvdXJjZU1hcC5zY3JpcHRzIDogc291cmNlTWFwKTtcbiAgY29uc3Qgc3R5bGVzID0gISEodHlwZW9mIHNvdXJjZU1hcCA9PT0gJ29iamVjdCcgPyBzb3VyY2VNYXAuc3R5bGVzIDogc291cmNlTWFwKTtcbiAgY29uc3QgaGlkZGVuID0gdHlwZW9mIHNvdXJjZU1hcCA9PT0gJ29iamVjdCcgJiYgISFzb3VyY2VNYXAuaGlkZGVuO1xuICBjb25zdCB2ZW5kb3IgPSB0eXBlb2Ygc291cmNlTWFwID09PSAnb2JqZWN0JyAmJiAhIXNvdXJjZU1hcC52ZW5kb3I7XG5cbiAgcmV0dXJuIHtcbiAgICB2ZW5kb3IsXG4gICAgaGlkZGVuLFxuICAgIHNjcmlwdHMsXG4gICAgc3R5bGVzLFxuICB9O1xufVxuIl19