Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var PackagePanelView = (function () {
  function PackagePanelView(_ref) {
    var _this = this;

    var title = _ref.title;

    _classCallCheck(this, PackagePanelView);

    this.title = title;
    _etch2['default'].initialize(this);

    var clickHandler = function clickHandler(event) {
      var target = event.target.closest('a.package');
      if (target) {
        atom.workspace.open('atom://config/packages/' + target.dataset['package']);
      }
    };
    this.element.addEventListener('click', clickHandler);
    this.disposable = new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    });
  }

  _createClass(PackagePanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposable.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            this.title
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'text-info', ref: 'summary' },
              'Loading…'
            ),
            _etch2['default'].dom('ul', { className: 'list-group', ref: 'list' })
          )
        )
      );
    }
  }, {
    key: 'addPackages',
    value: function addPackages(packages, timeKey) {
      for (var pack of packages) {
        this.addPackage(pack, timeKey);
      }
    }
  }, {
    key: 'addPackage',
    value: function addPackage(pack, timeKey) {
      var li = document.createElement('div');
      li.classList.add('list-item');

      var a = document.createElement('a');
      a.classList.add('inline-block', 'package');
      a.dataset['package'] = pack.name;
      a.textContent = pack.name;
      li.appendChild(a);

      var line = document.createElement('span');
      line.classList.add('timecop-line');
      li.appendChild(line);

      var timeSpan = document.createElement('span');
      timeSpan.classList.add('inline-block', pack[timeKey] > 25 ? 'highlight-error' : 'highlight-warning');
      timeSpan.textContent = pack[timeKey] + 'ms';
      li.appendChild(timeSpan);

      this.refs.list.appendChild(li);
    }
  }]);

  return PackagePanelView;
})();

exports['default'] = PackagePanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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