"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class OfflineView extends _react["default"].Component {
  componentDidMount() {
    window.addEventListener('online', this.props.retry);
  }

  componentWillUnmount() {
    window.removeEventListener('online', this.props.retry);
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Offline github-Message"
    }, _react["default"].createElement("div", {
      className: "github-Message-wrapper"
    }, _react["default"].createElement(_octicon["default"], {
      className: "github-Offline-logo",
      icon: "alignment-unalign"
    }), _react["default"].createElement("h1", {
      className: "github-Message-title"
    }, "Offline"), _react["default"].createElement("p", {
      className: "github-Message-description"
    }, "You don't seem to be connected to the Internet. When you're back online, we'll try again."), _react["default"].createElement("p", {
      className: "github-Message-action"
    }, _react["default"].createElement("button", {
      className: "github-Message-button btn",
      onClick: this.props.retry
    }, "Retry"))));
  }

}

exports["default"] = OfflineView;

_defineProperty(OfflineView, "propTypes", {
  retry: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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