"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _modelObserver = _interopRequireDefault(require("../models/model-observer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ObserveModel extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "fetchData", model => this.props.fetchData(model, ...this.props.fetchParams));

    _defineProperty(this, "didUpdate", () => {
      if (this.mounted) {
        const data = this.modelObserver.getActiveModelData();
        this.setState({
          data
        });
      }
    });

    this.state = {
      data: null
    };
    this.modelObserver = new _modelObserver["default"]({
      fetchData: this.fetchData,
      didUpdate: this.didUpdate
    });
  }

  componentDidMount() {
    this.mounted = true;
    this.modelObserver.setActiveModel(this.props.model);
  }

  componentDidUpdate(prevProps) {
    this.modelObserver.setActiveModel(this.props.model);

    if (!this.modelObserver.hasPendingUpdate() && prevProps.fetchParams.length !== this.props.fetchParams.length || prevProps.fetchParams.some((prevParam, i) => prevParam !== this.props.fetchParams[i])) {
      this.modelObserver.refreshModelData();
    }
  }

  render() {
    return this.props.children(this.state.data);
  }

  componentWillUnmount() {
    this.mounted = false;
    this.modelObserver.destroy();
  }

}

exports["default"] = ObserveModel;

_defineProperty(ObserveModel, "propTypes", {
  model: _propTypes["default"].shape({
    onDidUpdate: _propTypes["default"].func.isRequired
  }),
  fetchData: _propTypes["default"].func.isRequired,
  fetchParams: _propTypes["default"].arrayOf(_propTypes["default"].any),
  children: _propTypes["default"].func.isRequired
});

_defineProperty(ObserveModel, "defaultProps", {
  fetchParams: []
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9ic2VydmUtbW9kZWwuanMiXSwibmFtZXMiOlsiT2JzZXJ2ZU1vZGVsIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwiY29udGV4dCIsIm1vZGVsIiwiZmV0Y2hEYXRhIiwiZmV0Y2hQYXJhbXMiLCJtb3VudGVkIiwiZGF0YSIsIm1vZGVsT2JzZXJ2ZXIiLCJnZXRBY3RpdmVNb2RlbERhdGEiLCJzZXRTdGF0ZSIsInN0YXRlIiwiTW9kZWxPYnNlcnZlciIsImRpZFVwZGF0ZSIsImNvbXBvbmVudERpZE1vdW50Iiwic2V0QWN0aXZlTW9kZWwiLCJjb21wb25lbnREaWRVcGRhdGUiLCJwcmV2UHJvcHMiLCJoYXNQZW5kaW5nVXBkYXRlIiwibGVuZ3RoIiwic29tZSIsInByZXZQYXJhbSIsImkiLCJyZWZyZXNoTW9kZWxEYXRhIiwicmVuZGVyIiwiY2hpbGRyZW4iLCJjb21wb25lbnRXaWxsVW5tb3VudCIsImRlc3Ryb3kiLCJQcm9wVHlwZXMiLCJzaGFwZSIsIm9uRGlkVXBkYXRlIiwiZnVuYyIsImlzUmVxdWlyZWQiLCJhcnJheU9mIiwiYW55Il0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7O0FBRUE7Ozs7OztBQUVlLE1BQU1BLFlBQU4sU0FBMkJDLGtCQUFNQyxTQUFqQyxDQUEyQztBQWN4REMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVFDLE9BQVIsRUFBaUI7QUFDMUIsVUFBTUQsS0FBTixFQUFhQyxPQUFiOztBQUQwQix1Q0F3QmhCQyxLQUFLLElBQUksS0FBS0YsS0FBTCxDQUFXRyxTQUFYLENBQXFCRCxLQUFyQixFQUE0QixHQUFHLEtBQUtGLEtBQUwsQ0FBV0ksV0FBMUMsQ0F4Qk87O0FBQUEsdUNBMEJoQixNQUFNO0FBQ2hCLFVBQUksS0FBS0MsT0FBVCxFQUFrQjtBQUNoQixjQUFNQyxJQUFJLEdBQUcsS0FBS0MsYUFBTCxDQUFtQkMsa0JBQW5CLEVBQWI7QUFDQSxhQUFLQyxRQUFMLENBQWM7QUFBQ0gsVUFBQUE7QUFBRCxTQUFkO0FBQ0Q7QUFDRixLQS9CMkI7O0FBRzFCLFNBQUtJLEtBQUwsR0FBYTtBQUFDSixNQUFBQSxJQUFJLEVBQUU7QUFBUCxLQUFiO0FBQ0EsU0FBS0MsYUFBTCxHQUFxQixJQUFJSSx5QkFBSixDQUFrQjtBQUFDUixNQUFBQSxTQUFTLEVBQUUsS0FBS0EsU0FBakI7QUFBNEJTLE1BQUFBLFNBQVMsRUFBRSxLQUFLQTtBQUE1QyxLQUFsQixDQUFyQjtBQUNEOztBQUVEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQixTQUFLUixPQUFMLEdBQWUsSUFBZjtBQUNBLFNBQUtFLGFBQUwsQ0FBbUJPLGNBQW5CLENBQWtDLEtBQUtkLEtBQUwsQ0FBV0UsS0FBN0M7QUFDRDs7QUFFRGEsRUFBQUEsa0JBQWtCLENBQUNDLFNBQUQsRUFBWTtBQUM1QixTQUFLVCxhQUFMLENBQW1CTyxjQUFuQixDQUFrQyxLQUFLZCxLQUFMLENBQVdFLEtBQTdDOztBQUVBLFFBQ0UsQ0FBQyxLQUFLSyxhQUFMLENBQW1CVSxnQkFBbkIsRUFBRCxJQUNBRCxTQUFTLENBQUNaLFdBQVYsQ0FBc0JjLE1BQXRCLEtBQWlDLEtBQUtsQixLQUFMLENBQVdJLFdBQVgsQ0FBdUJjLE1BRHhELElBRUFGLFNBQVMsQ0FBQ1osV0FBVixDQUFzQmUsSUFBdEIsQ0FBMkIsQ0FBQ0MsU0FBRCxFQUFZQyxDQUFaLEtBQWtCRCxTQUFTLEtBQUssS0FBS3BCLEtBQUwsQ0FBV0ksV0FBWCxDQUF1QmlCLENBQXZCLENBQTNELENBSEYsRUFJRTtBQUNBLFdBQUtkLGFBQUwsQ0FBbUJlLGdCQUFuQjtBQUNEO0FBQ0Y7O0FBV0RDLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQU8sS0FBS3ZCLEtBQUwsQ0FBV3dCLFFBQVgsQ0FBb0IsS0FBS2QsS0FBTCxDQUFXSixJQUEvQixDQUFQO0FBQ0Q7O0FBRURtQixFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLcEIsT0FBTCxHQUFlLEtBQWY7QUFDQSxTQUFLRSxhQUFMLENBQW1CbUIsT0FBbkI7QUFDRDs7QUF0RHVEOzs7O2dCQUFyQzlCLFksZUFDQTtBQUNqQk0sRUFBQUEsS0FBSyxFQUFFeUIsc0JBQVVDLEtBQVYsQ0FBZ0I7QUFDckJDLElBQUFBLFdBQVcsRUFBRUYsc0JBQVVHLElBQVYsQ0FBZUM7QUFEUCxHQUFoQixDQURVO0FBSWpCNUIsRUFBQUEsU0FBUyxFQUFFd0Isc0JBQVVHLElBQVYsQ0FBZUMsVUFKVDtBQUtqQjNCLEVBQUFBLFdBQVcsRUFBRXVCLHNCQUFVSyxPQUFWLENBQWtCTCxzQkFBVU0sR0FBNUIsQ0FMSTtBQU1qQlQsRUFBQUEsUUFBUSxFQUFFRyxzQkFBVUcsSUFBVixDQUFlQztBQU5SLEM7O2dCQURBbkMsWSxrQkFVRztBQUNwQlEsRUFBQUEsV0FBVyxFQUFFO0FBRE8sQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjQxLjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5cbmltcG9ydCBNb2RlbE9ic2VydmVyIGZyb20gJy4uL21vZGVscy9tb2RlbC1vYnNlcnZlcic7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIE9ic2VydmVNb2RlbCBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgbW9kZWw6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBvbkRpZFVwZGF0ZTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICB9KSxcbiAgICBmZXRjaERhdGE6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgZmV0Y2hQYXJhbXM6IFByb3BUeXBlcy5hcnJheU9mKFByb3BUeXBlcy5hbnkpLFxuICAgIGNoaWxkcmVuOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICB9XG5cbiAgc3RhdGljIGRlZmF1bHRQcm9wcyA9IHtcbiAgICBmZXRjaFBhcmFtczogW10sXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcywgY29udGV4dCkge1xuICAgIHN1cGVyKHByb3BzLCBjb250ZXh0KTtcblxuICAgIHRoaXMuc3RhdGUgPSB7ZGF0YTogbnVsbH07XG4gICAgdGhpcy5tb2RlbE9ic2VydmVyID0gbmV3IE1vZGVsT2JzZXJ2ZXIoe2ZldGNoRGF0YTogdGhpcy5mZXRjaERhdGEsIGRpZFVwZGF0ZTogdGhpcy5kaWRVcGRhdGV9KTtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMubW91bnRlZCA9IHRydWU7XG4gICAgdGhpcy5tb2RlbE9ic2VydmVyLnNldEFjdGl2ZU1vZGVsKHRoaXMucHJvcHMubW9kZWwpO1xuICB9XG5cbiAgY29tcG9uZW50RGlkVXBkYXRlKHByZXZQcm9wcykge1xuICAgIHRoaXMubW9kZWxPYnNlcnZlci5zZXRBY3RpdmVNb2RlbCh0aGlzLnByb3BzLm1vZGVsKTtcblxuICAgIGlmIChcbiAgICAgICF0aGlzLm1vZGVsT2JzZXJ2ZXIuaGFzUGVuZGluZ1VwZGF0ZSgpICYmXG4gICAgICBwcmV2UHJvcHMuZmV0Y2hQYXJhbXMubGVuZ3RoICE9PSB0aGlzLnByb3BzLmZldGNoUGFyYW1zLmxlbmd0aCB8fFxuICAgICAgcHJldlByb3BzLmZldGNoUGFyYW1zLnNvbWUoKHByZXZQYXJhbSwgaSkgPT4gcHJldlBhcmFtICE9PSB0aGlzLnByb3BzLmZldGNoUGFyYW1zW2ldKVxuICAgICkge1xuICAgICAgdGhpcy5tb2RlbE9ic2VydmVyLnJlZnJlc2hNb2RlbERhdGEoKTtcbiAgICB9XG4gIH1cblxuICBmZXRjaERhdGEgPSBtb2RlbCA9PiB0aGlzLnByb3BzLmZldGNoRGF0YShtb2RlbCwgLi4udGhpcy5wcm9wcy5mZXRjaFBhcmFtcyk7XG5cbiAgZGlkVXBkYXRlID0gKCkgPT4ge1xuICAgIGlmICh0aGlzLm1vdW50ZWQpIHtcbiAgICAgIGNvbnN0IGRhdGEgPSB0aGlzLm1vZGVsT2JzZXJ2ZXIuZ2V0QWN0aXZlTW9kZWxEYXRhKCk7XG4gICAgICB0aGlzLnNldFN0YXRlKHtkYXRhfSk7XG4gICAgfVxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiB0aGlzLnByb3BzLmNoaWxkcmVuKHRoaXMuc3RhdGUuZGF0YSk7XG4gIH1cblxuICBjb21wb25lbnRXaWxsVW5tb3VudCgpIHtcbiAgICB0aGlzLm1vdW50ZWQgPSBmYWxzZTtcbiAgICB0aGlzLm1vZGVsT2JzZXJ2ZXIuZGVzdHJveSgpO1xuICB9XG59XG4iXX0=