Object.defineProperty(exports, '__esModule', {
  value: true
});
/** @babel */

var _atom = require('atom');

var reporter = undefined;

function getReporter() {
  if (!reporter) {
    var Reporter = require('./reporter');
    reporter = new Reporter();
  }
  return reporter;
}

exports['default'] = {
  activate: function activate() {
    this.subscriptions = new _atom.CompositeDisposable();

    if (!atom.config.get('exception-reporting.userId')) {
      atom.config.set('exception-reporting.userId', require('node-uuid').v4());
    }

    this.subscriptions.add(atom.onDidThrowError(function (_ref) {
      var message = _ref.message;
      var url = _ref.url;
      var line = _ref.line;
      var column = _ref.column;
      var originalError = _ref.originalError;

      try {
        getReporter().reportUncaughtException(originalError);
      } catch (secondaryException) {
        try {
          console.error('Error reporting uncaught exception', secondaryException);
          getReporter().reportUncaughtException(secondaryException);
        } catch (error) {}
      }
    }));

    if (atom.onDidFailAssertion != null) {
      this.subscriptions.add(atom.onDidFailAssertion(function (error) {
        try {
          getReporter().reportFailedAssertion(error);
        } catch (secondaryException) {
          try {
            console.error('Error reporting assertion failure', secondaryException);
            getReporter().reportUncaughtException(secondaryException);
          } catch (error) {}
        }
      }));
    }
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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