//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.3
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * The IceGrid query interface. This interface is accessible to
 * Ice clients who wish to look up well-known objects.
 **/
public interface QueryPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @return The proxy or null if no such object has been found.
     **/
    default com.zeroc.Ice.ObjectPrx findObjectById(com.zeroc.Ice.Identity id)
    {
        return findObjectById(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null if no such object has been found.
     **/
    default com.zeroc.Ice.ObjectPrx findObjectById(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
    {
        return _iceI_findObjectByIdAsync(id, context, true).waitForResponse();
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @return The proxy or null if no such object has been found.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findObjectByIdAsync(com.zeroc.Ice.Identity id)
    {
        return _iceI_findObjectByIdAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null if no such object has been found.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findObjectByIdAsync(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
    {
        return _iceI_findObjectByIdAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_findObjectByIdAsync(com.zeroc.Ice.Identity iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "findObjectById", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, ostr -> {
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_id);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @return The proxy or null, if no such object has been found.
     **/
    default com.zeroc.Ice.ObjectPrx findObjectByType(String type)
    {
        return findObjectByType(type, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     **/
    default com.zeroc.Ice.ObjectPrx findObjectByType(String type, java.util.Map<String, String> context)
    {
        return _iceI_findObjectByTypeAsync(type, context, true).waitForResponse();
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @return The proxy or null, if no such object has been found.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findObjectByTypeAsync(String type)
    {
        return _iceI_findObjectByTypeAsync(type, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findObjectByTypeAsync(String type, java.util.Map<String, String> context)
    {
        return _iceI_findObjectByTypeAsync(type, context, false);
    }

    /**
     * @hidden
     * @param iceP_type -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_findObjectByTypeAsync(String iceP_type, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "findObjectByType", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_type);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @return The proxy or null, if no such object has been found.
     **/
    default com.zeroc.Ice.ObjectPrx findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample)
    {
        return findObjectByTypeOnLeastLoadedNode(type, sample, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     **/
    default com.zeroc.Ice.ObjectPrx findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, java.util.Map<String, String> context)
    {
        return _iceI_findObjectByTypeOnLeastLoadedNodeAsync(type, sample, context, true).waitForResponse();
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @return The proxy or null, if no such object has been found.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findObjectByTypeOnLeastLoadedNodeAsync(String type, LoadSample sample)
    {
        return _iceI_findObjectByTypeOnLeastLoadedNodeAsync(type, sample, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param context The Context map to send with the invocation.
     * @return The proxy or null, if no such object has been found.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findObjectByTypeOnLeastLoadedNodeAsync(String type, LoadSample sample, java.util.Map<String, String> context)
    {
        return _iceI_findObjectByTypeOnLeastLoadedNodeAsync(type, sample, context, false);
    }

    /**
     * @hidden
     * @param iceP_type -
     * @param iceP_sample -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_findObjectByTypeOnLeastLoadedNodeAsync(String iceP_type, LoadSample iceP_sample, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "findObjectByTypeOnLeastLoadedNode", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_type);
                     LoadSample.ice_write(ostr, iceP_sample);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     **/
    default com.zeroc.Ice.ObjectPrx[] findAllObjectsByType(String type)
    {
        return findAllObjectsByType(type, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     **/
    default com.zeroc.Ice.ObjectPrx[] findAllObjectsByType(String type, java.util.Map<String, String> context)
    {
        return _iceI_findAllObjectsByTypeAsync(type, context, true).waitForResponse();
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx[]> findAllObjectsByTypeAsync(String type)
    {
        return _iceI_findAllObjectsByTypeAsync(type, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx[]> findAllObjectsByTypeAsync(String type, java.util.Map<String, String> context)
    {
        return _iceI_findAllObjectsByTypeAsync(type, context, false);
    }

    /**
     * @hidden
     * @param iceP_type -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx[]> _iceI_findAllObjectsByTypeAsync(String iceP_type, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "findAllObjectsByType", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_type);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx[] ret;
                     ret = com.zeroc.Ice.ObjectProxySeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     **/
    default com.zeroc.Ice.ObjectPrx[] findAllReplicas(com.zeroc.Ice.ObjectPrx proxy)
    {
        return findAllReplicas(proxy, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param context The Context map to send with the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     **/
    default com.zeroc.Ice.ObjectPrx[] findAllReplicas(com.zeroc.Ice.ObjectPrx proxy, java.util.Map<String, String> context)
    {
        return _iceI_findAllReplicasAsync(proxy, context, true).waitForResponse();
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx[]> findAllReplicasAsync(com.zeroc.Ice.ObjectPrx proxy)
    {
        return _iceI_findAllReplicasAsync(proxy, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param context The Context map to send with the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx[]> findAllReplicasAsync(com.zeroc.Ice.ObjectPrx proxy, java.util.Map<String, String> context)
    {
        return _iceI_findAllReplicasAsync(proxy, context, false);
    }

    /**
     * @hidden
     * @param iceP_proxy -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx[]> _iceI_findAllReplicasAsync(com.zeroc.Ice.ObjectPrx iceP_proxy, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "findAllReplicas", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_proxy);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx[] ret;
                     ret = com.zeroc.Ice.ObjectProxySeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static QueryPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), QueryPrx.class, _QueryPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static QueryPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), QueryPrx.class, _QueryPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static QueryPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), QueryPrx.class, _QueryPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static QueryPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), QueryPrx.class, _QueryPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static QueryPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, QueryPrx.class, _QueryPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static QueryPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, QueryPrx.class, _QueryPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default QueryPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (QueryPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default QueryPrx ice_adapterId(String newAdapterId)
    {
        return (QueryPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default QueryPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (QueryPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default QueryPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (QueryPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default QueryPrx ice_invocationTimeout(int newTimeout)
    {
        return (QueryPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default QueryPrx ice_connectionCached(boolean newCache)
    {
        return (QueryPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default QueryPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (QueryPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default QueryPrx ice_secure(boolean b)
    {
        return (QueryPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default QueryPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (QueryPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default QueryPrx ice_preferSecure(boolean b)
    {
        return (QueryPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default QueryPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (QueryPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default QueryPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (QueryPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default QueryPrx ice_collocationOptimized(boolean b)
    {
        return (QueryPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default QueryPrx ice_twoway()
    {
        return (QueryPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default QueryPrx ice_oneway()
    {
        return (QueryPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default QueryPrx ice_batchOneway()
    {
        return (QueryPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default QueryPrx ice_datagram()
    {
        return (QueryPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default QueryPrx ice_batchDatagram()
    {
        return (QueryPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default QueryPrx ice_compress(boolean co)
    {
        return (QueryPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default QueryPrx ice_timeout(int t)
    {
        return (QueryPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default QueryPrx ice_connectionId(String connectionId)
    {
        return (QueryPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default QueryPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (QueryPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceGrid::Query";
    }
}
