/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantODataIdQuery
implements Variant {
    private static final Logger log = Logger.getLogger(VariantODataIdQuery.class);
    public static final String RESOURCE_ID_PREFIX = "__ID__";
    private ResourceParameter resourceParameter = null;
    private static final Pattern patternResourceIdentifierUnquoted = Pattern.compile("/(\\w*)\\(([\\w']*)\\)");
    private static final Pattern patternResourceMultipleIdentifier = Pattern.compile("/\\w*\\((.*)\\)");
    private static final Pattern patternResourceMultipleIdentifierDetail = Pattern.compile("(\\w*)=([\\w']*)");
    private String beforeMultipleIDs = null;
    private String afterMultipleIDs = null;
    private List<NameValuePair> listParams = null;

    @Override
    public void setMessage(HttpMessage msg) {
        URI uri = msg.getRequestHeader().getURI();
        this.parse(uri);
    }

    private void parse(URI uri) {
        try {
            this.resourceParameter = null;
            this.beforeMultipleIDs = null;
            this.afterMultipleIDs = null;
            this.listParams = null;
            String path = uri.getPath();
            if (path != null) {
                String resourceName = "";
                Matcher matcher = patternResourceIdentifierUnquoted.matcher(path);
                if (matcher.find()) {
                    resourceName = matcher.group(1);
                    String resourceID = matcher.group(2);
                    String subString = resourceName + "(" + resourceID + ")";
                    int begin = path.indexOf(subString);
                    int end = begin + subString.length();
                    String beforeSubstring = path.substring(0, begin);
                    String afterSubstring = path.substring(end);
                    this.resourceParameter = new ResourceParameter(resourceName, resourceID, beforeSubstring, afterSubstring);
                } else {
                    matcher = patternResourceMultipleIdentifier.matcher(path);
                    if (matcher.find()) {
                        String multipleIdentifierSection = matcher.group(1);
                        int begin = path.indexOf(multipleIdentifierSection);
                        int end = begin + multipleIdentifierSection.length();
                        this.beforeMultipleIDs = path.substring(0, begin);
                        this.afterMultipleIDs = path.substring(end);
                        this.listParams = new ArrayList<NameValuePair>();
                        matcher = patternResourceMultipleIdentifierDetail.matcher(multipleIdentifierSection);
                        int i = 1;
                        while (matcher.find()) {
                            String paramName = matcher.group(1);
                            String value = matcher.group(2);
                            NameValuePair vp = new NameValuePair(1, paramName, value, i++);
                            this.listParams.add(vp);
                        }
                    }
                }
            }
        }
        catch (URIException e) {
            log.error((Object)(e.getMessage() + uri), (Throwable)e);
        }
    }

    public Vector<NameValuePair> getParamList() {
        Vector<NameValuePair> params = new Vector<NameValuePair>();
        if (this.resourceParameter != null) {
            params.add(new NameValuePair(1, this.resourceParameter.getParameterName(), this.resourceParameter.getValue(), 1));
        }
        if (this.listParams != null) {
            params.addAll(this.listParams);
        }
        return params;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        if (this.resourceParameter != null && this.resourceParameter.getParameterName().equals(param)) {
            String query = value;
            String modifiedPath = this.resourceParameter.getModifiedPath(value);
            try {
                msg.getRequestHeader().getURI().setPath(modifiedPath);
            }
            catch (URIException e) {
                throw new RuntimeException("Error with uri " + modifiedPath, e);
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Error with uri " + modifiedPath, e);
            }
            return query;
        }
        if (this.listParams != null) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sbQuery = new StringBuilder();
            sb.append(this.beforeMultipleIDs);
            boolean firstPass = true;
            for (NameValuePair nv : this.listParams) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    sbQuery.append(",");
                }
                sbQuery.append(nv.getName()).append("=");
                if (nv.getName().equals(param)) {
                    sbQuery.append(value);
                    continue;
                }
                sbQuery.append(nv.getValue());
            }
            sb.append((CharSequence)sbQuery);
            sb.append(this.afterMultipleIDs);
            String path = sb.toString();
            String query = sbQuery.toString();
            try {
                msg.getRequestHeader().getURI().setPath(path);
            }
            catch (NullPointerException | URIException e) {
                throw new RuntimeException("Error with uri " + path, e);
            }
            return query;
        }
        return "";
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, originalPair, param, value);
    }

    static class ResourceParameter {
        private String parameterName;
        private String resourceName;
        private String originalValue;
        private String pathBeforeParameter;
        private String pathAfterParamter;

        public ResourceParameter(String resourceName, String originalValue, String pathBeforeParameter, String pathAfterParameter) {
            this.resourceName = resourceName;
            this.parameterName = VariantODataIdQuery.RESOURCE_ID_PREFIX + resourceName;
            this.originalValue = originalValue;
            this.pathBeforeParameter = pathBeforeParameter;
            this.pathAfterParamter = pathAfterParameter;
        }

        public String getValue() {
            return this.originalValue;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getModifiedPath(String newIdValue) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.pathBeforeParameter).append(this.resourceName).append("(").append(newIdValue).append(")").append(this.pathAfterParamter);
            return builder.toString();
        }
    }
}

