
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * ExportOptions.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_0;

import org.virtualbox_6_0.jaxws.*;
import javax.xml.ws.*;

/**
Export options, used with{@link org.virtualbox_6_0.IAppliance#write(String,List,String)}.
Interface ID: <tt>{8F45EB08-FD34-41EE-AF95-A880BDEE5554}</tt>
*/
public enum ExportOptions
{

/**
Write the optional manifest file (.mf) which is used for integrity
checks prior import.
*/
    CreateManifest(1),

/**
Export DVD images. Default is not to export them as it is rarely
needed for typical VMs.
*/
    ExportDVDImages(2),

/**
Do not export any MAC address information. Default is to keep them
to avoid losing information which can cause trouble after import, at the
price of risking duplicate MAC addresses, if the import options are used
to keep them.
*/
    StripAllMACs(3),

/**
Do not export any MAC address information, except for adapters
using NAT. Default is to keep them to avoid losing information which can
cause trouble after import, at the price of risking duplicate MAC
addresses, if the import options are used to keep them.
*/
    StripAllNonNATMACs(4);

    private final int value;

    ExportOptions(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static ExportOptions fromValue(long v)
    {
        for (ExportOptions c: ExportOptions.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static ExportOptions fromValue(String v)
    {
        return valueOf(ExportOptions.class, v);
    }
}

