/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the ARM target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 70;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(ARMInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(ARMInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr&) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static ARMInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static ARMInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_NoHonorSignDependentRoundingBit = 62,
  Feature_HasV4TBit = 6,
  Feature_NoV4TBit = 7,
  Feature_HasV5TBit = 8,
  Feature_NoV5TBit = 59,
  Feature_HasV5TEBit = 12,
  Feature_HasV6Bit = 0,
  Feature_NoV6Bit = 10,
  Feature_HasV6MBit = 29,
  Feature_HasV8MBaselineBit = 33,
  Feature_HasV8_1MMainlineBit = 58,
  Feature_HasMVEIntBit = 57,
  Feature_HasMVEFloatBit = 69,
  Feature_HasFPRegsBit = 38,
  Feature_HasFPRegs16Bit = 39,
  Feature_HasFPRegs64Bit = 48,
  Feature_HasV6T2Bit = 9,
  Feature_HasV6KBit = 19,
  Feature_HasV7Bit = 3,
  Feature_HasV8Bit = 15,
  Feature_PreV8Bit = 20,
  Feature_HasV8_1aBit = 64,
  Feature_NoVFPBit = 23,
  Feature_HasVFP2Bit = 22,
  Feature_HasVFP3Bit = 49,
  Feature_HasVFP4Bit = 46,
  Feature_HasDPVFPBit = 40,
  Feature_HasFPARMv8Bit = 43,
  Feature_HasNEONBit = 50,
  Feature_HasCryptoBit = 51,
  Feature_HasDotProdBit = 52,
  Feature_HasCRCBit = 14,
  Feature_HasFP16Bit = 56,
  Feature_HasFullFP16Bit = 42,
  Feature_HasDivideInThumbBit = 35,
  Feature_HasDivideInARMBit = 13,
  Feature_HasDSPBit = 34,
  Feature_HasDBBit = 16,
  Feature_HasV7ClrexBit = 18,
  Feature_HasAcquireReleaseBit = 17,
  Feature_HasMPBit = 2,
  Feature_HasZCZBit = 53,
  Feature_UseNEONForFPBit = 67,
  Feature_DontUseNEONForFPBit = 41,
  Feature_IsThumbBit = 27,
  Feature_IsThumb1OnlyBit = 28,
  Feature_IsThumb2Bit = 32,
  Feature_IsNotMClassBit = 36,
  Feature_IsARMBit = 1,
  Feature_IsWindowsBit = 30,
  Feature_IsNotWindowsBit = 31,
  Feature_IsReadTPHardBit = 60,
  Feature_IsReadTPSoftBit = 21,
  Feature_UseNaClTrapBit = 4,
  Feature_DontUseNaClTrapBit = 5,
  Feature_UseMovtBit = 37,
  Feature_DontUseMovtBit = 24,
  Feature_UseMovtInPicBit = 25,
  Feature_DontUseMovtInPicBit = 26,
  Feature_UseFPVMLxBit = 45,
  Feature_UseMulOpsBit = 11,
  Feature_UseFusedMACBit = 47,
  Feature_HasFastVGETLNi32Bit = 54,
  Feature_HasSlowVGETLNi32Bit = 65,
  Feature_HasFastVDUP32Bit = 55,
  Feature_HasSlowVDUP32Bit = 66,
  Feature_UseVMOVSRBit = 44,
  Feature_DontUseVMOVSRBit = 68,
  Feature_IsLEBit = 61,
  Feature_IsBEBit = 63,
};

PredicateBitset ARMInstructionSelector::
computeAvailableModuleFeatures(const ARMSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (!TM.Options.HonorSignDependentRoundingFPMath())
    Features[Feature_NoHonorSignDependentRoundingBit] = 1;
  if (Subtarget->hasV4TOps())
    Features[Feature_HasV4TBit] = 1;
  if (!Subtarget->hasV4TOps())
    Features[Feature_NoV4TBit] = 1;
  if (Subtarget->hasV5TOps())
    Features[Feature_HasV5TBit] = 1;
  if (!Subtarget->hasV5TOps())
    Features[Feature_NoV5TBit] = 1;
  if (Subtarget->hasV5TEOps())
    Features[Feature_HasV5TEBit] = 1;
  if (Subtarget->hasV6Ops())
    Features[Feature_HasV6Bit] = 1;
  if (!Subtarget->hasV6Ops())
    Features[Feature_NoV6Bit] = 1;
  if (Subtarget->hasV6MOps())
    Features[Feature_HasV6MBit] = 1;
  if (Subtarget->hasV8MBaselineOps())
    Features[Feature_HasV8MBaselineBit] = 1;
  if (Subtarget->hasV8_1MMainlineOps())
    Features[Feature_HasV8_1MMainlineBit] = 1;
  if (Subtarget->hasMVEIntegerOps())
    Features[Feature_HasMVEIntBit] = 1;
  if (Subtarget->hasMVEFloatOps())
    Features[Feature_HasMVEFloatBit] = 1;
  if (Subtarget->hasFPRegs())
    Features[Feature_HasFPRegsBit] = 1;
  if (Subtarget->hasFPRegs16())
    Features[Feature_HasFPRegs16Bit] = 1;
  if (Subtarget->hasFPRegs64())
    Features[Feature_HasFPRegs64Bit] = 1;
  if (Subtarget->hasV6T2Ops())
    Features[Feature_HasV6T2Bit] = 1;
  if (Subtarget->hasV6KOps())
    Features[Feature_HasV6KBit] = 1;
  if (Subtarget->hasV7Ops())
    Features[Feature_HasV7Bit] = 1;
  if (Subtarget->hasV8Ops())
    Features[Feature_HasV8Bit] = 1;
  if (!Subtarget->hasV8Ops())
    Features[Feature_PreV8Bit] = 1;
  if (Subtarget->hasV8_1aOps())
    Features[Feature_HasV8_1aBit] = 1;
  if (!Subtarget->hasVFP2Base())
    Features[Feature_NoVFPBit] = 1;
  if (Subtarget->hasVFP2Base())
    Features[Feature_HasVFP2Bit] = 1;
  if (Subtarget->hasVFP3Base())
    Features[Feature_HasVFP3Bit] = 1;
  if (Subtarget->hasVFP4Base())
    Features[Feature_HasVFP4Bit] = 1;
  if (Subtarget->hasFP64())
    Features[Feature_HasDPVFPBit] = 1;
  if (Subtarget->hasFPARMv8Base())
    Features[Feature_HasFPARMv8Bit] = 1;
  if (Subtarget->hasNEON())
    Features[Feature_HasNEONBit] = 1;
  if (Subtarget->hasCrypto())
    Features[Feature_HasCryptoBit] = 1;
  if (Subtarget->hasDotProd())
    Features[Feature_HasDotProdBit] = 1;
  if (Subtarget->hasCRC())
    Features[Feature_HasCRCBit] = 1;
  if (Subtarget->hasFP16())
    Features[Feature_HasFP16Bit] = 1;
  if (Subtarget->hasFullFP16())
    Features[Feature_HasFullFP16Bit] = 1;
  if (Subtarget->hasDivideInThumbMode())
    Features[Feature_HasDivideInThumbBit] = 1;
  if (Subtarget->hasDivideInARMMode())
    Features[Feature_HasDivideInARMBit] = 1;
  if (Subtarget->hasDSP())
    Features[Feature_HasDSPBit] = 1;
  if (Subtarget->hasDataBarrier())
    Features[Feature_HasDBBit] = 1;
  if (Subtarget->hasV7Clrex())
    Features[Feature_HasV7ClrexBit] = 1;
  if (Subtarget->hasAcquireRelease())
    Features[Feature_HasAcquireReleaseBit] = 1;
  if (Subtarget->hasMPExtension())
    Features[Feature_HasMPBit] = 1;
  if (Subtarget->hasZeroCycleZeroing())
    Features[Feature_HasZCZBit] = 1;
  if (Subtarget->useNEONForSinglePrecisionFP())
    Features[Feature_UseNEONForFPBit] = 1;
  if (!Subtarget->useNEONForSinglePrecisionFP())
    Features[Feature_DontUseNEONForFPBit] = 1;
  if (Subtarget->isThumb())
    Features[Feature_IsThumbBit] = 1;
  if (Subtarget->isThumb1Only())
    Features[Feature_IsThumb1OnlyBit] = 1;
  if (Subtarget->isThumb2())
    Features[Feature_IsThumb2Bit] = 1;
  if (!Subtarget->isMClass())
    Features[Feature_IsNotMClassBit] = 1;
  if (!Subtarget->isThumb())
    Features[Feature_IsARMBit] = 1;
  if (Subtarget->isTargetWindows())
    Features[Feature_IsWindowsBit] = 1;
  if (!Subtarget->isTargetWindows())
    Features[Feature_IsNotWindowsBit] = 1;
  if (Subtarget->isReadTPHard())
    Features[Feature_IsReadTPHardBit] = 1;
  if (!Subtarget->isReadTPHard())
    Features[Feature_IsReadTPSoftBit] = 1;
  if (Subtarget->useNaClTrap())
    Features[Feature_UseNaClTrapBit] = 1;
  if (!Subtarget->useNaClTrap())
    Features[Feature_DontUseNaClTrapBit] = 1;
  if (Subtarget->useMulOps())
    Features[Feature_UseMulOpsBit] = 1;
  if ((TM.Options.AllowFPOpFusion == FPOpFusion::Fast &&  Subtarget->hasVFP4Base()) && !Subtarget->isTargetDarwin() &&Subtarget->useFPVMLx())
    Features[Feature_UseFusedMACBit] = 1;
  if (!Subtarget->hasSlowVGETLNi32())
    Features[Feature_HasFastVGETLNi32Bit] = 1;
  if (Subtarget->hasSlowVGETLNi32())
    Features[Feature_HasSlowVGETLNi32Bit] = 1;
  if (!Subtarget->hasSlowVDUP32())
    Features[Feature_HasFastVDUP32Bit] = 1;
  if (Subtarget->hasSlowVDUP32())
    Features[Feature_HasSlowVDUP32Bit] = 1;
  if (Subtarget->preferVMOVSR() ||!Subtarget->useNEONForSinglePrecisionFP())
    Features[Feature_UseVMOVSRBit] = 1;
  if (!Subtarget->preferVMOVSR() &&Subtarget->useNEONForSinglePrecisionFP())
    Features[Feature_DontUseVMOVSRBit] = 1;
  return Features;
}

PredicateBitset ARMInstructionSelector::
computeAvailableFunctionFeatures(const ARMSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (Subtarget->useMovt())
    Features[Feature_UseMovtBit] = 1;
  if (!Subtarget->useMovt())
    Features[Feature_DontUseMovtBit] = 1;
  if (Subtarget->useMovt() && Subtarget->allowPositionIndependentMovt())
    Features[Feature_UseMovtInPicBit] = 1;
  if (!Subtarget->useMovt() || !Subtarget->allowPositionIndependentMovt())
    Features[Feature_DontUseMovtInPicBit] = 1;
  if (((Subtarget->useFPVMLx() &&  TM.Options.AllowFPOpFusion != FPOpFusion::Fast) ||Subtarget->hasMinSize()))
    Features[Feature_UseFPVMLxBit] = 1;
  if (MF->getDataLayout().isLittleEndian())
    Features[Feature_IsLEBit] = 1;
  if (MF->getDataLayout().isBigEndian())
    Features[Feature_IsBEBit] = 1;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v8s1,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v16s1,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 13;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(2, 32),
  LLT::vector(2, 64),
  LLT::vector(4, 1),
  LLT::vector(4, 16),
  LLT::vector(4, 32),
  LLT::vector(8, 1),
  LLT::vector(8, 8),
  LLT::vector(8, 16),
  LLT::vector(16, 1),
  LLT::vector(16, 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasDotProd,
  GIFBS_HasFP16,
  GIFBS_HasFPARMv8,
  GIFBS_HasFPRegs,
  GIFBS_HasFullFP16,
  GIFBS_HasMVEFloat,
  GIFBS_HasMVEInt,
  GIFBS_HasNEON,
  GIFBS_HasVFP2,
  GIFBS_HasVFP3,
  GIFBS_HasVFP4,
  GIFBS_IsARM,
  GIFBS_IsThumb,
  GIFBS_IsThumb2,
  GIFBS_NoHonorSignDependentRounding,
  GIFBS_DontUseNEONForFP_HasVFP2,
  GIFBS_HasCrypto_HasV8,
  GIFBS_HasDB_IsARM,
  GIFBS_HasDB_IsThumb,
  GIFBS_HasDPVFP_HasFPARMv8,
  GIFBS_HasDPVFP_HasVFP2,
  GIFBS_HasDPVFP_HasVFP3,
  GIFBS_HasDPVFP_HasVFP4,
  GIFBS_HasDPVFP_NoHonorSignDependentRounding,
  GIFBS_HasDSP_IsThumb2,
  GIFBS_HasDivideInARM_IsARM,
  GIFBS_HasFP16_HasNEON,
  GIFBS_HasFPRegs_UseVMOVSR,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasMVEInt_IsLE,
  GIFBS_HasNEON_HasV8,
  GIFBS_HasNEON_HasV8_1a,
  GIFBS_HasNEON_HasVFP4,
  GIFBS_HasNEON_IsBE,
  GIFBS_HasNEON_IsLE,
  GIFBS_HasV5T_IsARM,
  GIFBS_HasV5TE_IsARM,
  GIFBS_HasV6_IsARM,
  GIFBS_HasV6K_IsARM,
  GIFBS_HasV6M_IsThumb,
  GIFBS_HasV6T2_IsARM,
  GIFBS_HasV6T2_IsThumb2,
  GIFBS_HasV7_IsARM,
  GIFBS_HasV7Clrex_IsThumb,
  GIFBS_HasV8MBaseline_IsThumb,
  GIFBS_IsARM_NoV6,
  GIFBS_IsARM_PreV8,
  GIFBS_IsThumb_IsThumb1Only,
  GIFBS_IsThumb_IsWindows,
  GIFBS_IsThumb_UseMovt,
  GIFBS_IsThumb2_PreV8,
  GIFBS_IsThumb2_UseMulOps,
  GIFBS_HasCRC_HasV8_IsARM,
  GIFBS_HasCRC_HasV8_IsThumb2,
  GIFBS_HasDSP_IsThumb2_UseMulOps,
  GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
  GIFBS_HasFullFP16_HasNEON_HasV8,
  GIFBS_HasFullFP16_HasNEON_UseFPVMLx,
  GIFBS_HasFullFP16_HasNEON_UseFusedMAC,
  GIFBS_HasV5TE_IsARM_UseMulOps,
  GIFBS_HasV6_IsARM_UseMulOps,
  GIFBS_HasV6_IsThumb_IsThumb1Only,
  GIFBS_HasV6T2_IsARM_UseMulOps,
  GIFBS_IsARM_NoV6_UseMulOps,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasDotProdBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFPRegsBit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasMVEFloatBit, },
  {Feature_HasMVEIntBit, },
  {Feature_HasNEONBit, },
  {Feature_HasVFP2Bit, },
  {Feature_HasVFP3Bit, },
  {Feature_HasVFP4Bit, },
  {Feature_IsARMBit, },
  {Feature_IsThumbBit, },
  {Feature_IsThumb2Bit, },
  {Feature_NoHonorSignDependentRoundingBit, },
  {Feature_DontUseNEONForFPBit, Feature_HasVFP2Bit, },
  {Feature_HasCryptoBit, Feature_HasV8Bit, },
  {Feature_HasDBBit, Feature_IsARMBit, },
  {Feature_HasDBBit, Feature_IsThumbBit, },
  {Feature_HasDPVFPBit, Feature_HasFPARMv8Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP2Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP3Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP4Bit, },
  {Feature_HasDPVFPBit, Feature_NoHonorSignDependentRoundingBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, },
  {Feature_HasDivideInARMBit, Feature_IsARMBit, },
  {Feature_HasFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFPRegsBit, Feature_UseVMOVSRBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasMVEIntBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasNEONBit, Feature_HasV8_1aBit, },
  {Feature_HasNEONBit, Feature_HasVFP4Bit, },
  {Feature_HasNEONBit, Feature_IsBEBit, },
  {Feature_HasNEONBit, Feature_IsLEBit, },
  {Feature_HasV5TBit, Feature_IsARMBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, },
  {Feature_HasV6KBit, Feature_IsARMBit, },
  {Feature_HasV6MBit, Feature_IsThumbBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, },
  {Feature_HasV6T2Bit, Feature_IsThumb2Bit, },
  {Feature_HasV7Bit, Feature_IsARMBit, },
  {Feature_HasV7ClrexBit, Feature_IsThumbBit, },
  {Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, },
  {Feature_IsARMBit, Feature_PreV8Bit, },
  {Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_IsThumbBit, Feature_IsWindowsBit, },
  {Feature_IsThumbBit, Feature_UseMovtBit, },
  {Feature_IsThumb2Bit, Feature_PreV8Bit, },
  {Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasCRCBit, Feature_HasV8Bit, Feature_IsARMBit, },
  {Feature_HasCRCBit, Feature_HasV8Bit, Feature_IsThumb2Bit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasDivideInThumbBit, Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFPVMLxBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFusedMACBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, Feature_UseMulOpsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_VectorIndex16 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_VectorIndex32,
  GIPFP_I64_Predicate_VectorIndex64,
  GIPFP_I64_Predicate_VectorIndex8,
  GIPFP_I64_Predicate_imm0_15,
  GIPFP_I64_Predicate_imm0_239,
  GIPFP_I64_Predicate_imm0_255,
  GIPFP_I64_Predicate_imm0_31,
  GIPFP_I64_Predicate_imm0_32,
  GIPFP_I64_Predicate_imm0_4095,
  GIPFP_I64_Predicate_imm0_63,
  GIPFP_I64_Predicate_imm0_65535,
  GIPFP_I64_Predicate_imm0_65535_neg,
  GIPFP_I64_Predicate_imm0_7,
  GIPFP_I64_Predicate_imm16,
  GIPFP_I64_Predicate_imm16_31,
  GIPFP_I64_Predicate_imm1_15,
  GIPFP_I64_Predicate_imm1_16,
  GIPFP_I64_Predicate_imm1_31,
  GIPFP_I64_Predicate_imm1_7,
  GIPFP_I64_Predicate_imm24b,
  GIPFP_I64_Predicate_imm256_510,
  GIPFP_I64_Predicate_imm32,
  GIPFP_I64_Predicate_imm8,
  GIPFP_I64_Predicate_imm8_255,
  GIPFP_I64_Predicate_imm8_or_16,
  GIPFP_I64_Predicate_imm_even,
  GIPFP_I64_Predicate_imm_odd,
  GIPFP_I64_Predicate_mod_imm,
  GIPFP_I64_Predicate_pkh_asr_amt,
  GIPFP_I64_Predicate_pkh_lsl_amt,
  GIPFP_I64_Predicate_shr_imm16,
  GIPFP_I64_Predicate_shr_imm32,
  GIPFP_I64_Predicate_shr_imm64,
  GIPFP_I64_Predicate_shr_imm8,
  GIPFP_I64_Predicate_t2_so_imm,
  GIPFP_I64_Predicate_t2_so_imm_neg,
};
bool ARMInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_VectorIndex16: {
    
  return ((uint64_t)Imm) < 4;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex32: {
    
  return ((uint64_t)Imm) < 2;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex64: {
    
  return ((uint64_t)Imm) < 1;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex8: {
    
  return ((uint64_t)Imm) < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_15: {
    
  return Imm >= 0 && Imm < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_239: {
     return Imm >= 0 && Imm < 240; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_255: {
     return Imm >= 0 && Imm < 256; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_31: {
    
  return Imm >= 0 && Imm < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_32: {
    
  return Imm >= 0 && Imm < 33;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_4095: {
    
  return Imm >= 0 && Imm < 4096;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_63: {
    
  return Imm >= 0 && Imm < 64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_65535: {
    
  return Imm >= 0 && Imm < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_65535_neg: {
    
  return -Imm >= 0 && -Imm < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_7: {
    
  return Imm >= 0 && Imm < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm16: {
     return Imm == 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm16_31: {
    
  return (int32_t)Imm >= 16 && (int32_t)Imm < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_15: {
     return Imm > 0 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_16: {
    
    return Imm > 0 && Imm <= 16;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_31: {
     return Imm > 0 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_7: {
     return Imm > 0 && Imm < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm24b: {
    
  return Imm >= 0 && Imm <= 0xffffff;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm256_510: {
    
  return Imm >= 256 && Imm < 511;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32: {
     return Imm == 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8: {
     return Imm == 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8_255: {
    
  return Imm >= 8 && Imm < 256;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8_or_16: {
     return Imm == 8 || Imm == 16;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_even: {
     return (Imm & 1) == 0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_odd: {
     return (Imm & 1) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_mod_imm: {
    
    return ARM_AM::getSOImmVal(Imm) != -1;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_pkh_asr_amt: {
     return Imm > 0 && Imm <= 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_pkh_lsl_amt: {
     return Imm >= 0 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm16: {
     return Imm > 0 && Imm <= 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm32: {
     return Imm > 0 && Imm <= 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm64: {
     return Imm > 0 && Imm <= 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm8: {
     return Imm > 0 && Imm <= 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_t2_so_imm: {
    
    return ARM_AM::getT2SOImmVal(Imm) != -1;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_t2_so_imm_neg: {
    
  return Imm && ARM_AM::getT2SOImmVal(-(uint32_t)Imm) != -1;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool ARMInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APInt_Predicate_arm_i32imm = GIPFP_APInt_Invalid + 1,
};
bool ARMInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GIPFP_APInt_Predicate_arm_i32imm: {
    
  if (Subtarget->useMovt())
    return true;
  return ARM_AM::isSOImmTwoPartVal(Imm.getZExtValue());

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_bf_inv_mask_imm = GIPFP_MI_Invalid + 1,
  GIPFP_MI_Predicate_vfp_f32imm,
  GIPFP_MI_Predicate_vfp_f64imm,
};
bool ARMInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_bf_inv_mask_imm: {
    
    // There's better methods of implementing this check. IntImmLeaf<> would be
    // equivalent and have less boilerplate but we need a test for C++
    // predicates and this one causes new rules to be imported into GlobalISel
    // without requiring additional features first.
    const auto &MO = MI.getOperand(1);
    if (!MO.isCImm())
      return false;
    return ARM::isBitFieldInvertedMask(MO.getCImm()->getZExtValue());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_vfp_f32imm: {
    
      const auto &MO = MI.getOperand(1);
      if (!MO.isFPImm())
        return false;
      return ARM_AM::getFP32Imm(MO.getFPImm()->getValueAPF()) != -1;
    
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_vfp_f64imm: {
    
      const auto &MO = MI.getOperand(1);
      if (!MO.isFPImm())
        return false;
      return ARM_AM::getFP64Imm(MO.getFPImm()->getValueAPF()) != -1;
    
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

ARMInstructionSelector::ComplexMatcherMemFn
ARMInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderVFPF32Imm, 
  GICR_renderVFPF64Imm, 
};
ARMInstructionSelector::CustomRendererFn
ARMInstructionSelector::CustomRenderers[] = {
  nullptr, // GICP_Invalid
  &ARMInstructionSelector::renderVFPF32Imm, // gi_vfp_f32imm
  &ARMInstructionSelector::renderVFPF64Imm, // gi_vfp_f64imm
};

bool ARMInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  // FIXME: This should be computed on a per-function basis rather than per-insn.
  AvailableFunctionFeatures = computeAvailableFunctionFeatures(&STI, &MF);
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *ARMInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/35, 161, /*)*//*default:*//*Label 49*/ 72143,
    /*TargetOpcode::G_ADD*//*Label 0*/ 131,
    /*TargetOpcode::G_SUB*//*Label 1*/ 7273,
    /*TargetOpcode::G_MUL*//*Label 2*/ 9482,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 10296,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 10396, 0, 0,
    /*TargetOpcode::G_AND*//*Label 5*/ 10496,
    /*TargetOpcode::G_OR*//*Label 6*/ 12469,
    /*TargetOpcode::G_XOR*//*Label 7*/ 16912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 8*/ 17671, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 9*/ 24794,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 10*/ 54217,
    /*TargetOpcode::G_ANYEXT*//*Label 11*/ 58578,
    /*TargetOpcode::G_TRUNC*//*Label 12*/ 58709,
    /*TargetOpcode::G_CONSTANT*//*Label 13*/ 58840,
    /*TargetOpcode::G_FCONSTANT*//*Label 14*/ 59031, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 15*/ 59108,
    /*TargetOpcode::G_ZEXT*//*Label 16*/ 59239,
    /*TargetOpcode::G_SHL*//*Label 17*/ 59751,
    /*TargetOpcode::G_LSHR*//*Label 18*/ 59856,
    /*TargetOpcode::G_ASHR*//*Label 19*/ 59914, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMULH*//*Label 20*/ 60127,
    /*TargetOpcode::G_FADD*//*Label 21*/ 60227,
    /*TargetOpcode::G_FSUB*//*Label 22*/ 60983,
    /*TargetOpcode::G_FMUL*//*Label 23*/ 61731,
    /*TargetOpcode::G_FMA*//*Label 24*/ 62434,
    /*TargetOpcode::G_FDIV*//*Label 25*/ 63521, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 26*/ 63684,
    /*TargetOpcode::G_FPEXT*//*Label 27*/ 64705,
    /*TargetOpcode::G_FPTRUNC*//*Label 28*/ 64862,
    /*TargetOpcode::G_FPTOSI*//*Label 29*/ 65023,
    /*TargetOpcode::G_FPTOUI*//*Label 30*/ 65845,
    /*TargetOpcode::G_SITOFP*//*Label 31*/ 66667,
    /*TargetOpcode::G_UITOFP*//*Label 32*/ 67108,
    /*TargetOpcode::G_FABS*//*Label 33*/ 67549, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 34*/ 67942,
    /*TargetOpcode::G_FMAXNUM*//*Label 35*/ 68302, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 36*/ 68662,
    /*TargetOpcode::G_SMAX*//*Label 37*/ 69162,
    /*TargetOpcode::G_UMIN*//*Label 38*/ 69662,
    /*TargetOpcode::G_UMAX*//*Label 39*/ 70162,
    /*TargetOpcode::G_BR*//*Label 40*/ 70662, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CTLZ*//*Label 41*/ 70724, 0,
    /*TargetOpcode::G_CTPOP*//*Label 42*/ 71053,
    /*TargetOpcode::G_BSWAP*//*Label 43*/ 71142,
    /*TargetOpcode::G_FCEIL*//*Label 44*/ 71256, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 45*/ 71452,
    /*TargetOpcode::G_FFLOOR*//*Label 46*/ 71579,
    /*TargetOpcode::G_FRINT*//*Label 47*/ 71775,
    /*TargetOpcode::G_FNEARBYINT*//*Label 48*/ 72016,
    // Label 0: @131
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 13, /*)*//*default:*//*Label 59*/ 7272,
    /*GILLT_s32*//*Label 50*/ 149,
    /*GILLT_s64*//*Label 51*/ 2095,
    /*GILLT_v2s32*//*Label 52*/ 2146,
    /*GILLT_v2s64*//*Label 53*/ 2606, 0,
    /*GILLT_v4s16*//*Label 54*/ 3324,
    /*GILLT_v4s32*//*Label 55*/ 3784, 0,
    /*GILLT_v8s8*//*Label 56*/ 5028,
    /*GILLT_v8s16*//*Label 57*/ 5488, 0,
    /*GILLT_v16s8*//*Label 58*/ 6732,
    // Label 50: @149
    GIM_Try, /*On fail goto*//*Label 60*/ 2094,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 61*/ 225, // Rule ID 3124 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3124,
        GIR_Done,
      // Label 61: @225
      GIM_Try, /*On fail goto*//*Label 62*/ 291, // Rule ID 3125 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3125,
        GIR_Done,
      // Label 62: @291
      GIM_Try, /*On fail goto*//*Label 63*/ 357, // Rule ID 3158 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3158,
        GIR_Done,
      // Label 63: @357
      GIM_Try, /*On fail goto*//*Label 64*/ 423, // Rule ID 3159 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3159,
        GIR_Done,
      // Label 64: @423
      GIM_Try, /*On fail goto*//*Label 65*/ 489, // Rule ID 1841 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1841,
        GIR_Done,
      // Label 65: @489
      GIM_Try, /*On fail goto*//*Label 66*/ 555, // Rule ID 1842 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1842,
        GIR_Done,
      // Label 66: @555
      GIM_Try, /*On fail goto*//*Label 67*/ 621, // Rule ID 2041 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2041,
        GIR_Done,
      // Label 67: @621
      GIM_Try, /*On fail goto*//*Label 68*/ 687, // Rule ID 2042 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2042,
        GIR_Done,
      // Label 68: @687
      GIM_Try, /*On fail goto*//*Label 69*/ 796, // Rule ID 2907 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2907,
        GIR_Done,
      // Label 69: @796
      GIM_Try, /*On fail goto*//*Label 70*/ 905, // Rule ID 2944 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2944,
        GIR_Done,
      // Label 70: @905
      GIM_Try, /*On fail goto*//*Label 71*/ 1014, // Rule ID 194 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 194,
        GIR_Done,
      // Label 71: @1014
      GIM_Try, /*On fail goto*//*Label 72*/ 1123, // Rule ID 526 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 526,
        GIR_Done,
      // Label 72: @1123
      GIM_Try, /*On fail goto*//*Label 73*/ 1175, // Rule ID 74 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ADDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ADDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 74,
        GIR_Done,
      // Label 73: @1175
      GIM_Try, /*On fail goto*//*Label 74*/ 1227, // Rule ID 412 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ADDri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 412,
        GIR_Done,
      // Label 74: @1227
      GIM_Try, /*On fail goto*//*Label 75*/ 1276, // Rule ID 413 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_4095,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2ADDri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDri12,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 413,
        GIR_Done,
      // Label 75: @1276
      GIM_Try, /*On fail goto*//*Label 76*/ 1346, // Rule ID 173 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 76: @1346
      GIM_Try, /*On fail goto*//*Label 77*/ 1416, // Rule ID 174 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLAv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 174,
        GIR_Done,
      // Label 77: @1416
      GIM_Try, /*On fail goto*//*Label 78*/ 1483, // Rule ID 508 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Ra)  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 78: @1483
      GIM_Try, /*On fail goto*//*Label 79*/ 1550, // Rule ID 182 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SMULH,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm), GPR:{ *:[i32] }:$Ra)  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMMLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 182,
        GIR_Done,
      // Label 79: @1550
      GIM_Try, /*On fail goto*//*Label 80*/ 1617, // Rule ID 514 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SMULH,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMMLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 514,
        GIR_Done,
      // Label 80: @1617
      GIM_Try, /*On fail goto*//*Label 81*/ 1687, // Rule ID 2901 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2901,
        GIR_Done,
      // Label 81: @1687
      GIM_Try, /*On fail goto*//*Label 82*/ 1757, // Rule ID 2902 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLAv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2902,
        GIR_Done,
      // Label 82: @1757
      GIM_Try, /*On fail goto*//*Label 83*/ 1824, // Rule ID 2939 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2939,
        GIR_Done,
      // Label 83: @1824
      GIM_Try, /*On fail goto*//*Label 84*/ 1891, // Rule ID 2903 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SMULH,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMMLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2903,
        GIR_Done,
      // Label 84: @1891
      GIM_Try, /*On fail goto*//*Label 85*/ 1958, // Rule ID 2940 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SMULH,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn))  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMMLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2940,
        GIR_Done,
      // Label 85: @1958
      GIM_Try, /*On fail goto*//*Label 86*/ 2003, // Rule ID 75 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ADDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 75,
        GIR_Done,
      // Label 86: @2003
      GIM_Try, /*On fail goto*//*Label 87*/ 2048, // Rule ID 414 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 414,
        GIR_Done,
      // Label 87: @2048
      GIM_Try, /*On fail goto*//*Label 88*/ 2093, // Rule ID 2921 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2921,
        GIR_Done,
      // Label 88: @2093
      GIM_Reject,
    // Label 60: @2094
    GIM_Reject,
    // Label 51: @2095
    GIM_Try, /*On fail goto*//*Label 89*/ 2145, // Rule ID 771 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (add:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VADDv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv1i64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 771,
      GIR_Done,
    // Label 89: @2145
    GIM_Reject,
    // Label 52: @2146
    GIM_Try, /*On fail goto*//*Label 90*/ 2605,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 91*/ 2230, // Rule ID 3057 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 1175:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VABAsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3057,
        GIR_Done,
      // Label 91: @2230
      GIM_Try, /*On fail goto*//*Label 92*/ 2300, // Rule ID 3063 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 1176:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VABAuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3063,
        GIR_Done,
      // Label 92: @2300
      GIM_Try, /*On fail goto*//*Label 93*/ 2370, // Rule ID 1163 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 1175:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VABAsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1163,
        GIR_Done,
      // Label 93: @2370
      GIM_Try, /*On fail goto*//*Label 94*/ 2440, // Rule ID 1169 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 1176:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VABAuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1169,
        GIR_Done,
      // Label 94: @2440
      GIM_Try, /*On fail goto*//*Label 95*/ 2503, // Rule ID 2987 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2987,
        GIR_Done,
      // Label 95: @2503
      GIM_Try, /*On fail goto*//*Label 96*/ 2566, // Rule ID 886 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 886,
        GIR_Done,
      // Label 96: @2566
      GIM_Try, /*On fail goto*//*Label 97*/ 2604, // Rule ID 767 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VADDv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 767,
        GIR_Done,
      // Label 97: @2604
      GIM_Reject,
    // Label 90: @2605
    GIM_Reject,
    // Label 53: @2606
    GIM_Try, /*On fail goto*//*Label 98*/ 3323,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 99*/ 2703, // Rule ID 3069 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 1175:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)), QPR:{ *:[v2i64] }:$src1)  =>  (VABALsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3069,
        GIR_Done,
      // Label 99: @2703
      GIM_Try, /*On fail goto*//*Label 100*/ 2786, // Rule ID 3072 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 1176:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)), QPR:{ *:[v2i64] }:$src1)  =>  (VABALuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3072,
        GIR_Done,
      // Label 100: @2786
      GIM_Try, /*On fail goto*//*Label 101*/ 2869, // Rule ID 1175 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 1175:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)))  =>  (VABALsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1175,
        GIR_Done,
      // Label 101: @2869
      GIM_Try, /*On fail goto*//*Label 102*/ 2952, // Rule ID 1178 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 1176:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)))  =>  (VABALuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1178,
        GIR_Done,
      // Label 102: @2952
      GIM_Try, /*On fail goto*//*Label 103*/ 3016, // Rule ID 779 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 779,
        GIR_Done,
      // Label 103: @3016
      GIM_Try, /*On fail goto*//*Label 104*/ 3080, // Rule ID 782 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 782,
        GIR_Done,
      // Label 104: @3080
      GIM_Try, /*On fail goto*//*Label 105*/ 3131, // Rule ID 2963 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2963,
        GIR_Done,
      // Label 105: @3131
      GIM_Try, /*On fail goto*//*Label 106*/ 3182, // Rule ID 2966 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2966,
        GIR_Done,
      // Label 106: @3182
      GIM_Try, /*On fail goto*//*Label 107*/ 3233, // Rule ID 785 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 785,
        GIR_Done,
      // Label 107: @3233
      GIM_Try, /*On fail goto*//*Label 108*/ 3284, // Rule ID 788 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 788,
        GIR_Done,
      // Label 108: @3284
      GIM_Try, /*On fail goto*//*Label 109*/ 3322, // Rule ID 772 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VADDv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 772,
        GIR_Done,
      // Label 109: @3322
      GIM_Reject,
    // Label 98: @3323
    GIM_Reject,
    // Label 54: @3324
    GIM_Try, /*On fail goto*//*Label 110*/ 3783,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 111*/ 3408, // Rule ID 3056 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 1175:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VABAsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3056,
        GIR_Done,
      // Label 111: @3408
      GIM_Try, /*On fail goto*//*Label 112*/ 3478, // Rule ID 3062 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 1176:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VABAuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3062,
        GIR_Done,
      // Label 112: @3478
      GIM_Try, /*On fail goto*//*Label 113*/ 3548, // Rule ID 1162 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 1175:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VABAsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1162,
        GIR_Done,
      // Label 113: @3548
      GIM_Try, /*On fail goto*//*Label 114*/ 3618, // Rule ID 1168 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 1176:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VABAuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1168,
        GIR_Done,
      // Label 114: @3618
      GIM_Try, /*On fail goto*//*Label 115*/ 3681, // Rule ID 2986 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2986,
        GIR_Done,
      // Label 115: @3681
      GIM_Try, /*On fail goto*//*Label 116*/ 3744, // Rule ID 885 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 885,
        GIR_Done,
      // Label 116: @3744
      GIM_Try, /*On fail goto*//*Label 117*/ 3782, // Rule ID 766 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VADDv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 766,
        GIR_Done,
      // Label 117: @3782
      GIM_Reject,
    // Label 110: @3783
    GIM_Reject,
    // Label 55: @3784
    GIM_Try, /*On fail goto*//*Label 118*/ 5027,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 119*/ 3881, // Rule ID 3068 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 1175:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)), QPR:{ *:[v4i32] }:$src1)  =>  (VABALsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3068,
        GIR_Done,
      // Label 119: @3881
      GIM_Try, /*On fail goto*//*Label 120*/ 3968, // Rule ID 3071 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 1176:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)), QPR:{ *:[v4i32] }:$src1)  =>  (VABALuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3071,
        GIR_Done,
      // Label 120: @3968
      GIM_Try, /*On fail goto*//*Label 121*/ 4055, // Rule ID 1174 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 1175:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)))  =>  (VABALsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1174,
        GIR_Done,
      // Label 121: @4055
      GIM_Try, /*On fail goto*//*Label 122*/ 4142, // Rule ID 1177 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 1176:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)))  =>  (VABALuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1177,
        GIR_Done,
      // Label 122: @4142
      GIM_Try, /*On fail goto*//*Label 123*/ 4216, // Rule ID 3060 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 1175:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VABAsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3060,
        GIR_Done,
      // Label 123: @4216
      GIM_Try, /*On fail goto*//*Label 124*/ 4290, // Rule ID 3066 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 1176:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VABAuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3066,
        GIR_Done,
      // Label 124: @4290
      GIM_Try, /*On fail goto*//*Label 125*/ 4364, // Rule ID 1166 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1175:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VABAsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1166,
        GIR_Done,
      // Label 125: @4364
      GIM_Try, /*On fail goto*//*Label 126*/ 4438, // Rule ID 1172 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1176:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VABAuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1172,
        GIR_Done,
      // Label 126: @4438
      GIM_Try, /*On fail goto*//*Label 127*/ 4506, // Rule ID 778 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 778,
        GIR_Done,
      // Label 127: @4506
      GIM_Try, /*On fail goto*//*Label 128*/ 4574, // Rule ID 781 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 781,
        GIR_Done,
      // Label 128: @4574
      GIM_Try, /*On fail goto*//*Label 129*/ 4641, // Rule ID 2990 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2990,
        GIR_Done,
      // Label 129: @4641
      GIM_Try, /*On fail goto*//*Label 130*/ 4696, // Rule ID 2962 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2962,
        GIR_Done,
      // Label 130: @4696
      GIM_Try, /*On fail goto*//*Label 131*/ 4751, // Rule ID 2965 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2965,
        GIR_Done,
      // Label 131: @4751
      GIM_Try, /*On fail goto*//*Label 132*/ 4818, // Rule ID 889 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 889,
        GIR_Done,
      // Label 132: @4818
      GIM_Try, /*On fail goto*//*Label 133*/ 4873, // Rule ID 784 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 784,
        GIR_Done,
      // Label 133: @4873
      GIM_Try, /*On fail goto*//*Label 134*/ 4928, // Rule ID 787 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 787,
        GIR_Done,
      // Label 134: @4928
      GIM_Try, /*On fail goto*//*Label 135*/ 4970, // Rule ID 770 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VADDv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 770,
        GIR_Done,
      // Label 135: @4970
      GIM_Try, /*On fail goto*//*Label 136*/ 5026, // Rule ID 2691 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (add:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)  =>  (MVE_VADDi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VADDi32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2691,
        GIR_Done,
      // Label 136: @5026
      GIM_Reject,
    // Label 118: @5027
    GIM_Reject,
    // Label 56: @5028
    GIM_Try, /*On fail goto*//*Label 137*/ 5487,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 138*/ 5112, // Rule ID 3055 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 1175:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VABAsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3055,
        GIR_Done,
      // Label 138: @5112
      GIM_Try, /*On fail goto*//*Label 139*/ 5182, // Rule ID 3061 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 1176:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VABAuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3061,
        GIR_Done,
      // Label 139: @5182
      GIM_Try, /*On fail goto*//*Label 140*/ 5252, // Rule ID 1161 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (intrinsic_wo_chain:{ *:[v8i8] } 1175:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VABAsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1161,
        GIR_Done,
      // Label 140: @5252
      GIM_Try, /*On fail goto*//*Label 141*/ 5322, // Rule ID 1167 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (intrinsic_wo_chain:{ *:[v8i8] } 1176:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VABAuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1167,
        GIR_Done,
      // Label 141: @5322
      GIM_Try, /*On fail goto*//*Label 142*/ 5385, // Rule ID 2985 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2985,
        GIR_Done,
      // Label 142: @5385
      GIM_Try, /*On fail goto*//*Label 143*/ 5448, // Rule ID 884 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 884,
        GIR_Done,
      // Label 143: @5448
      GIM_Try, /*On fail goto*//*Label 144*/ 5486, // Rule ID 765 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VADDv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 765,
        GIR_Done,
      // Label 144: @5486
      GIM_Reject,
    // Label 137: @5487
    GIM_Reject,
    // Label 57: @5488
    GIM_Try, /*On fail goto*//*Label 145*/ 6731,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 146*/ 5585, // Rule ID 3067 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 1175:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)), QPR:{ *:[v8i16] }:$src1)  =>  (VABALsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3067,
        GIR_Done,
      // Label 146: @5585
      GIM_Try, /*On fail goto*//*Label 147*/ 5672, // Rule ID 3070 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 1176:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)), QPR:{ *:[v8i16] }:$src1)  =>  (VABALuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3070,
        GIR_Done,
      // Label 147: @5672
      GIM_Try, /*On fail goto*//*Label 148*/ 5759, // Rule ID 1173 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 1175:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)))  =>  (VABALsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1173,
        GIR_Done,
      // Label 148: @5759
      GIM_Try, /*On fail goto*//*Label 149*/ 5846, // Rule ID 1176 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 1176:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)))  =>  (VABALuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1176,
        GIR_Done,
      // Label 149: @5846
      GIM_Try, /*On fail goto*//*Label 150*/ 5920, // Rule ID 3059 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 1175:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VABAsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3059,
        GIR_Done,
      // Label 150: @5920
      GIM_Try, /*On fail goto*//*Label 151*/ 5994, // Rule ID 3065 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 1176:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VABAuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3065,
        GIR_Done,
      // Label 151: @5994
      GIM_Try, /*On fail goto*//*Label 152*/ 6068, // Rule ID 1165 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 1175:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VABAsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1165,
        GIR_Done,
      // Label 152: @6068
      GIM_Try, /*On fail goto*//*Label 153*/ 6142, // Rule ID 1171 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 1176:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VABAuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1171,
        GIR_Done,
      // Label 153: @6142
      GIM_Try, /*On fail goto*//*Label 154*/ 6210, // Rule ID 777 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 777,
        GIR_Done,
      // Label 154: @6210
      GIM_Try, /*On fail goto*//*Label 155*/ 6278, // Rule ID 780 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 780,
        GIR_Done,
      // Label 155: @6278
      GIM_Try, /*On fail goto*//*Label 156*/ 6345, // Rule ID 2989 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2989,
        GIR_Done,
      // Label 156: @6345
      GIM_Try, /*On fail goto*//*Label 157*/ 6400, // Rule ID 2961 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2961,
        GIR_Done,
      // Label 157: @6400
      GIM_Try, /*On fail goto*//*Label 158*/ 6455, // Rule ID 2964 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2964,
        GIR_Done,
      // Label 158: @6455
      GIM_Try, /*On fail goto*//*Label 159*/ 6522, // Rule ID 888 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 888,
        GIR_Done,
      // Label 159: @6522
      GIM_Try, /*On fail goto*//*Label 160*/ 6577, // Rule ID 783 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 783,
        GIR_Done,
      // Label 160: @6577
      GIM_Try, /*On fail goto*//*Label 161*/ 6632, // Rule ID 786 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 786,
        GIR_Done,
      // Label 161: @6632
      GIM_Try, /*On fail goto*//*Label 162*/ 6674, // Rule ID 769 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VADDv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 769,
        GIR_Done,
      // Label 162: @6674
      GIM_Try, /*On fail goto*//*Label 163*/ 6730, // Rule ID 2690 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (add:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)  =>  (MVE_VADDi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VADDi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2690,
        GIR_Done,
      // Label 163: @6730
      GIM_Reject,
    // Label 145: @6731
    GIM_Reject,
    // Label 58: @6732
    GIM_Try, /*On fail goto*//*Label 164*/ 7271,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 165*/ 6816, // Rule ID 3058 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 1175:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VABAsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3058,
        GIR_Done,
      // Label 165: @6816
      GIM_Try, /*On fail goto*//*Label 166*/ 6890, // Rule ID 3064 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 1176:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VABAuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3064,
        GIR_Done,
      // Label 166: @6890
      GIM_Try, /*On fail goto*//*Label 167*/ 6964, // Rule ID 1164 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (intrinsic_wo_chain:{ *:[v16i8] } 1175:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VABAsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1164,
        GIR_Done,
      // Label 167: @6964
      GIM_Try, /*On fail goto*//*Label 168*/ 7038, // Rule ID 1170 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (intrinsic_wo_chain:{ *:[v16i8] } 1176:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VABAuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1170,
        GIR_Done,
      // Label 168: @7038
      GIM_Try, /*On fail goto*//*Label 169*/ 7105, // Rule ID 2988 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2988,
        GIR_Done,
      // Label 169: @7105
      GIM_Try, /*On fail goto*//*Label 170*/ 7172, // Rule ID 887 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 887,
        GIR_Done,
      // Label 170: @7172
      GIM_Try, /*On fail goto*//*Label 171*/ 7214, // Rule ID 768 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VADDv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 768,
        GIR_Done,
      // Label 171: @7214
      GIM_Try, /*On fail goto*//*Label 172*/ 7270, // Rule ID 2689 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (add:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)  =>  (MVE_VADDi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VADDi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2689,
        GIR_Done,
      // Label 172: @7270
      GIM_Reject,
    // Label 164: @7271
    GIM_Reject,
    // Label 59: @7272
    GIM_Reject,
    // Label 1: @7273
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 13, /*)*//*default:*//*Label 182*/ 9481,
    /*GILLT_s32*//*Label 173*/ 7291,
    /*GILLT_s64*//*Label 174*/ 7784,
    /*GILLT_v2s32*//*Label 175*/ 7835,
    /*GILLT_v2s64*//*Label 176*/ 7948, 0,
    /*GILLT_v4s16*//*Label 177*/ 8232,
    /*GILLT_v4s32*//*Label 178*/ 8345, 0,
    /*GILLT_v8s8*//*Label 179*/ 8768,
    /*GILLT_v8s16*//*Label 180*/ 8881, 0,
    /*GILLT_v16s8*//*Label 181*/ 9304,
    // Label 173: @7291
    GIM_Try, /*On fail goto*//*Label 183*/ 7783,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 184*/ 7353, // Rule ID 98 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, GPR:{ *:[i32] }:$Rn)  =>  (RSBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::RSBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 98,
        GIR_Done,
      // Label 184: @7353
      GIM_Try, /*On fail goto*//*Label 185*/ 7405, // Rule ID 432 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, rGPR:{ *:[i32] }:$Rn)  =>  (t2RSBri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2RSBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 432,
        GIR_Done,
      // Label 185: @7405
      GIM_Try, /*On fail goto*//*Label 186*/ 7457, // Rule ID 78 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (SUBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SUBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 78,
        GIR_Done,
      // Label 186: @7457
      GIM_Try, /*On fail goto*//*Label 187*/ 7509, // Rule ID 416 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2SUBri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 187: @7509
      GIM_Try, /*On fail goto*//*Label 188*/ 7558, // Rule ID 417 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_4095,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2SUBri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBri12,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 188: @7558
      GIM_Try, /*On fail goto*//*Label 189*/ 7625, // Rule ID 175 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (MLS:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 189: @7625
      GIM_Try, /*On fail goto*//*Label 190*/ 7692, // Rule ID 509 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLS:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 190: @7692
      GIM_Try, /*On fail goto*//*Label 191*/ 7737, // Rule ID 79 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SUBrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SUBrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 79,
        GIR_Done,
      // Label 191: @7737
      GIM_Try, /*On fail goto*//*Label 192*/ 7782, // Rule ID 418 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SUBrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 418,
        GIR_Done,
      // Label 192: @7782
      GIM_Reject,
    // Label 183: @7783
    GIM_Reject,
    // Label 174: @7784
    GIM_Try, /*On fail goto*//*Label 193*/ 7834, // Rule ID 958 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (sub:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VSUBv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv1i64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 958,
      GIR_Done,
    // Label 193: @7834
    GIM_Reject,
    // Label 175: @7835
    GIM_Try, /*On fail goto*//*Label 194*/ 7947,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 195*/ 7912, // Rule ID 914 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 914,
        GIR_Done,
      // Label 195: @7912
      GIM_Try, /*On fail goto*//*Label 196*/ 7946, // Rule ID 954 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VSUBv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 954,
        GIR_Done,
      // Label 196: @7946
      GIM_Reject,
    // Label 194: @7947
    GIM_Reject,
    // Label 176: @7948
    GIM_Try, /*On fail goto*//*Label 197*/ 8231,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 198*/ 8026, // Rule ID 966 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 966,
        GIR_Done,
      // Label 198: @8026
      GIM_Try, /*On fail goto*//*Label 199*/ 8090, // Rule ID 969 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 969,
        GIR_Done,
      // Label 199: @8090
      GIM_Try, /*On fail goto*//*Label 200*/ 8141, // Rule ID 972 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 972,
        GIR_Done,
      // Label 200: @8141
      GIM_Try, /*On fail goto*//*Label 201*/ 8192, // Rule ID 975 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 975,
        GIR_Done,
      // Label 201: @8192
      GIM_Try, /*On fail goto*//*Label 202*/ 8230, // Rule ID 959 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VSUBv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 959,
        GIR_Done,
      // Label 202: @8230
      GIM_Reject,
    // Label 197: @8231
    GIM_Reject,
    // Label 177: @8232
    GIM_Try, /*On fail goto*//*Label 203*/ 8344,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 204*/ 8309, // Rule ID 913 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 913,
        GIR_Done,
      // Label 204: @8309
      GIM_Try, /*On fail goto*//*Label 205*/ 8343, // Rule ID 953 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VSUBv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 953,
        GIR_Done,
      // Label 205: @8343
      GIM_Reject,
    // Label 203: @8344
    GIM_Reject,
    // Label 178: @8345
    GIM_Try, /*On fail goto*//*Label 206*/ 8767,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 207*/ 8423, // Rule ID 965 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 965,
        GIR_Done,
      // Label 207: @8423
      GIM_Try, /*On fail goto*//*Label 208*/ 8491, // Rule ID 968 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 968,
        GIR_Done,
      // Label 208: @8491
      GIM_Try, /*On fail goto*//*Label 209*/ 8558, // Rule ID 917 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 917,
        GIR_Done,
      // Label 209: @8558
      GIM_Try, /*On fail goto*//*Label 210*/ 8613, // Rule ID 971 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 971,
        GIR_Done,
      // Label 210: @8613
      GIM_Try, /*On fail goto*//*Label 211*/ 8668, // Rule ID 974 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 974,
        GIR_Done,
      // Label 211: @8668
      GIM_Try, /*On fail goto*//*Label 212*/ 8710, // Rule ID 957 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VSUBv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 957,
        GIR_Done,
      // Label 212: @8710
      GIM_Try, /*On fail goto*//*Label 213*/ 8766, // Rule ID 2694 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (sub:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)  =>  (MVE_VSUBi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VSUBi32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2694,
        GIR_Done,
      // Label 213: @8766
      GIM_Reject,
    // Label 206: @8767
    GIM_Reject,
    // Label 179: @8768
    GIM_Try, /*On fail goto*//*Label 214*/ 8880,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 215*/ 8845, // Rule ID 912 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 912,
        GIR_Done,
      // Label 215: @8845
      GIM_Try, /*On fail goto*//*Label 216*/ 8879, // Rule ID 952 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VSUBv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 952,
        GIR_Done,
      // Label 216: @8879
      GIM_Reject,
    // Label 214: @8880
    GIM_Reject,
    // Label 180: @8881
    GIM_Try, /*On fail goto*//*Label 217*/ 9303,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 218*/ 8959, // Rule ID 964 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 964,
        GIR_Done,
      // Label 218: @8959
      GIM_Try, /*On fail goto*//*Label 219*/ 9027, // Rule ID 967 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 967,
        GIR_Done,
      // Label 219: @9027
      GIM_Try, /*On fail goto*//*Label 220*/ 9094, // Rule ID 916 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 916,
        GIR_Done,
      // Label 220: @9094
      GIM_Try, /*On fail goto*//*Label 221*/ 9149, // Rule ID 970 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 970,
        GIR_Done,
      // Label 221: @9149
      GIM_Try, /*On fail goto*//*Label 222*/ 9204, // Rule ID 973 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 973,
        GIR_Done,
      // Label 222: @9204
      GIM_Try, /*On fail goto*//*Label 223*/ 9246, // Rule ID 956 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VSUBv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 956,
        GIR_Done,
      // Label 223: @9246
      GIM_Try, /*On fail goto*//*Label 224*/ 9302, // Rule ID 2693 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (sub:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)  =>  (MVE_VSUBi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VSUBi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2693,
        GIR_Done,
      // Label 224: @9302
      GIM_Reject,
    // Label 217: @9303
    GIM_Reject,
    // Label 181: @9304
    GIM_Try, /*On fail goto*//*Label 225*/ 9480,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 226*/ 9381, // Rule ID 915 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 915,
        GIR_Done,
      // Label 226: @9381
      GIM_Try, /*On fail goto*//*Label 227*/ 9423, // Rule ID 955 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VSUBv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 955,
        GIR_Done,
      // Label 227: @9423
      GIM_Try, /*On fail goto*//*Label 228*/ 9479, // Rule ID 2692 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (sub:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)  =>  (MVE_VSUBi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VSUBi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2692,
        GIR_Done,
      // Label 228: @9479
      GIM_Reject,
    // Label 225: @9480
    GIM_Reject,
    // Label 182: @9481
    GIM_Reject,
    // Label 2: @9482
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 13, /*)*//*default:*//*Label 236*/ 10295,
    /*GILLT_s32*//*Label 229*/ 9500, 0,
    /*GILLT_v2s32*//*Label 230*/ 9812, 0, 0,
    /*GILLT_v4s16*//*Label 231*/ 9863,
    /*GILLT_v4s32*//*Label 232*/ 9914, 0,
    /*GILLT_v8s8*//*Label 233*/ 10024,
    /*GILLT_v8s16*//*Label 234*/ 10075, 0,
    /*GILLT_v16s8*//*Label 235*/ 10185,
    // Label 229: @9500
    GIM_Try, /*On fail goto*//*Label 237*/ 9811,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 238*/ 9594, // Rule ID 188 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULTT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMULTT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 188,
        GIR_Done,
      // Label 238: @9594
      GIM_Try, /*On fail goto*//*Label 239*/ 9678, // Rule ID 520 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULTT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMULTT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 520,
        GIR_Done,
      // Label 239: @9678
      GIM_Try, /*On fail goto*//*Label 240*/ 9723, // Rule ID 171 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MUL:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MUL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 171,
        GIR_Done,
      // Label 240: @9723
      GIM_Try, /*On fail goto*//*Label 241*/ 9768, // Rule ID 172 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MULv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MULv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 241: @9768
      GIM_Try, /*On fail goto*//*Label 242*/ 9810, // Rule ID 507 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2MUL:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MUL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 242: @9810
      GIM_Reject,
    // Label 237: @9811
    GIM_Reject,
    // Label 230: @9812
    GIM_Try, /*On fail goto*//*Label 243*/ 9862, // Rule ID 834 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VMULv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 834,
      GIR_Done,
    // Label 243: @9862
    GIM_Reject,
    // Label 231: @9863
    GIM_Try, /*On fail goto*//*Label 244*/ 9913, // Rule ID 833 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VMULv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 833,
      GIR_Done,
    // Label 244: @9913
    GIM_Reject,
    // Label 232: @9914
    GIM_Try, /*On fail goto*//*Label 245*/ 10023,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 246*/ 9966, // Rule ID 837 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VMULv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 837,
        GIR_Done,
      // Label 246: @9966
      GIM_Try, /*On fail goto*//*Label 247*/ 10022, // Rule ID 2688 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)  =>  (MVE_VMULt1i32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VMULt1i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2688,
        GIR_Done,
      // Label 247: @10022
      GIM_Reject,
    // Label 245: @10023
    GIM_Reject,
    // Label 233: @10024
    GIM_Try, /*On fail goto*//*Label 248*/ 10074, // Rule ID 832 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv8i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 832,
      GIR_Done,
    // Label 248: @10074
    GIM_Reject,
    // Label 234: @10075
    GIM_Try, /*On fail goto*//*Label 249*/ 10184,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 250*/ 10127, // Rule ID 836 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VMULv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 836,
        GIR_Done,
      // Label 250: @10127
      GIM_Try, /*On fail goto*//*Label 251*/ 10183, // Rule ID 2687 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)  =>  (MVE_VMULt1i16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VMULt1i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2687,
        GIR_Done,
      // Label 251: @10183
      GIM_Reject,
    // Label 249: @10184
    GIM_Reject,
    // Label 235: @10185
    GIM_Try, /*On fail goto*//*Label 252*/ 10294,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 253*/ 10237, // Rule ID 835 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 835,
        GIR_Done,
      // Label 253: @10237
      GIM_Try, /*On fail goto*//*Label 254*/ 10293, // Rule ID 2686 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)  =>  (MVE_VMULt1i8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VMULt1i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2686,
        GIR_Done,
      // Label 254: @10293
      GIM_Reject,
    // Label 252: @10294
    GIM_Reject,
    // Label 236: @10295
    GIM_Reject,
    // Label 3: @10296
    GIM_Try, /*On fail goto*//*Label 255*/ 10395,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 256*/ 10352, // Rule ID 197 //
        GIM_CheckFeatures, GIFBS_HasDivideInARM_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 197,
        GIR_Done,
      // Label 256: @10352
      GIM_Try, /*On fail goto*//*Label 257*/ 10394, // Rule ID 537 //
        GIM_CheckFeatures, GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (sdiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 537,
        GIR_Done,
      // Label 257: @10394
      GIM_Reject,
    // Label 255: @10395
    GIM_Reject,
    // Label 4: @10396
    GIM_Try, /*On fail goto*//*Label 258*/ 10495,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 259*/ 10452, // Rule ID 198 //
        GIM_CheckFeatures, GIFBS_HasDivideInARM_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (UDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 198,
        GIR_Done,
      // Label 259: @10452
      GIM_Try, /*On fail goto*//*Label 260*/ 10494, // Rule ID 538 //
        GIM_CheckFeatures, GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (udiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 538,
        GIR_Done,
      // Label 260: @10494
      GIM_Reject,
    // Label 258: @10495
    GIM_Reject,
    // Label 5: @10496
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 13, /*)*//*default:*//*Label 267*/ 12468,
    /*GILLT_s32*//*Label 261*/ 10514, 0,
    /*GILLT_v2s32*//*Label 262*/ 12112,
    /*GILLT_v2s64*//*Label 263*/ 12163, 0, 0,
    /*GILLT_v4s32*//*Label 264*/ 12228, 0, 0,
    /*GILLT_v8s16*//*Label 265*/ 12338, 0,
    /*GILLT_v16s8*//*Label 266*/ 12403,
    // Label 261: @10514
    GIM_Try, /*On fail goto*//*Label 268*/ 12111,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 269*/ 10586, // Rule ID 1727 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1727,
        GIR_Done,
      // Label 269: @10586
      GIM_Try, /*On fail goto*//*Label 270*/ 10648, // Rule ID 1945 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1945,
        GIR_Done,
      // Label 270: @10648
      GIM_Try, /*On fail goto*//*Label 271*/ 10689, // Rule ID 1838 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 255:{ *:[i32] })  =>  (UXTB:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1838,
        GIR_Done,
      // Label 271: @10689
      GIM_Try, /*On fail goto*//*Label 272*/ 10730, // Rule ID 1839 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 65535:{ *:[i32] })  =>  (UXTH:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1839,
        GIR_Done,
      // Label 272: @10730
      GIM_Try, /*On fail goto*//*Label 273*/ 10771, // Rule ID 1840 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1840,
        GIR_Done,
      // Label 273: @10771
      GIM_Try, /*On fail goto*//*Label 274*/ 10812, // Rule ID 2038 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (t2UXTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2038,
        GIR_Done,
      // Label 274: @10812
      GIM_Try, /*On fail goto*//*Label 275*/ 10853, // Rule ID 2039 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (t2UXTH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2039,
        GIR_Done,
      // Label 275: @10853
      GIM_Try, /*On fail goto*//*Label 276*/ 10894, // Rule ID 2040 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2040,
        GIR_Done,
      // Label 276: @10894
      GIM_Try, /*On fail goto*//*Label 277*/ 10967, // Rule ID 2897 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2897,
        GIR_Done,
      // Label 277: @10967
      GIM_Try, /*On fail goto*//*Label 278*/ 11040, // Rule ID 2930 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2930,
        GIR_Done,
      // Label 278: @11040
      GIM_Try, /*On fail goto*//*Label 279*/ 11113, // Rule ID 2896 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2896,
        GIR_Done,
      // Label 279: @11113
      GIM_Try, /*On fail goto*//*Label 280*/ 11186, // Rule ID 2929 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2929,
        GIR_Done,
      // Label 280: @11186
      GIM_Try, /*On fail goto*//*Label 281*/ 11259, // Rule ID 2895 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2895,
        GIR_Done,
      // Label 281: @11259
      GIM_Try, /*On fail goto*//*Label 282*/ 11332, // Rule ID 2928 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2928,
        GIR_Done,
      // Label 282: @11332
      GIM_Try, /*On fail goto*//*Label 283*/ 11405, // Rule ID 161 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 161,
        GIR_Done,
      // Label 283: @11405
      GIM_Try, /*On fail goto*//*Label 284*/ 11478, // Rule ID 495 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 284: @11478
      GIM_Try, /*On fail goto*//*Label 285*/ 11544, // Rule ID 2898 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2898,
        GIR_Done,
      // Label 285: @11544
      GIM_Try, /*On fail goto*//*Label 286*/ 11610, // Rule ID 2931 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2931,
        GIR_Done,
      // Label 286: @11610
      GIM_Try, /*On fail goto*//*Label 287*/ 11676, // Rule ID 162 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 162,
        GIR_Done,
      // Label 287: @11676
      GIM_Try, /*On fail goto*//*Label 288*/ 11742, // Rule ID 496 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 496,
        GIR_Done,
      // Label 288: @11742
      GIM_Try, /*On fail goto*//*Label 289*/ 11780, // Rule ID 352 //
        GIM_CheckFeatures, GIFBS_HasV6_IsThumb_IsThumb1Only,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (tUXTB:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::tUXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 289: @11780
      GIM_Try, /*On fail goto*//*Label 290*/ 11818, // Rule ID 353 //
        GIM_CheckFeatures, GIFBS_HasV6_IsThumb_IsThumb1Only,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (tUXTH:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::tUXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 290: @11818
      GIM_Try, /*On fail goto*//*Label 291*/ 11870, // Rule ID 149 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ANDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ANDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 149,
        GIR_Done,
      // Label 291: @11870
      GIM_Try, /*On fail goto*//*Label 292*/ 11922, // Rule ID 486 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ANDri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ANDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 486,
        GIR_Done,
      // Label 292: @11922
      GIM_Try, /*On fail goto*//*Label 293*/ 11971, // Rule ID 165 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_bf_inv_mask_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (BFC:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BFC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 165,
        GIR_Done,
      // Label 293: @11971
      GIM_Try, /*On fail goto*//*Label 294*/ 12020, // Rule ID 498 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_bf_inv_mask_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (t2BFC:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BFC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 498,
        GIR_Done,
      // Label 294: @12020
      GIM_Try, /*On fail goto*//*Label 295*/ 12065, // Rule ID 150 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ANDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ANDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 150,
        GIR_Done,
      // Label 295: @12065
      GIM_Try, /*On fail goto*//*Label 296*/ 12110, // Rule ID 487 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ANDrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ANDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 487,
        GIR_Done,
      // Label 296: @12110
      GIM_Reject,
    // Label 268: @12111
    GIM_Reject,
    // Label 262: @12112
    GIM_Try, /*On fail goto*//*Label 297*/ 12162, // Rule ID 1113 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (and:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VANDd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1113,
      GIR_Done,
    // Label 297: @12162
    GIM_Reject,
    // Label 263: @12163
    GIM_Try, /*On fail goto*//*Label 298*/ 12227, // Rule ID 2648 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (and:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$val1, MQPR:{ *:[v2i64] }:$val2)  =>  (MVE_VAND:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$val1, MQPR:{ *:[v2i64] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VAND,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2648,
      GIR_Done,
    // Label 298: @12227
    GIM_Reject,
    // Label 264: @12228
    GIM_Try, /*On fail goto*//*Label 299*/ 12337,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 300*/ 12280, // Rule ID 1114 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (and:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VANDq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1114,
        GIR_Done,
      // Label 300: @12280
      GIM_Try, /*On fail goto*//*Label 301*/ 12336, // Rule ID 2647 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (and:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)  =>  (MVE_VAND:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2647,
        GIR_Done,
      // Label 301: @12336
      GIM_Reject,
    // Label 299: @12337
    GIM_Reject,
    // Label 265: @12338
    GIM_Try, /*On fail goto*//*Label 302*/ 12402, // Rule ID 2646 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (and:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)  =>  (MVE_VAND:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VAND,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2646,
      GIR_Done,
    // Label 302: @12402
    GIM_Reject,
    // Label 266: @12403
    GIM_Try, /*On fail goto*//*Label 303*/ 12467, // Rule ID 2645 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (and:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)  =>  (MVE_VAND:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VAND,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2645,
      GIR_Done,
    // Label 303: @12467
    GIM_Reject,
    // Label 267: @12468
    GIM_Reject,
    // Label 6: @12469
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 13, /*)*//*default:*//*Label 310*/ 16911,
    /*GILLT_s32*//*Label 304*/ 12487, 0,
    /*GILLT_v2s32*//*Label 305*/ 16555,
    /*GILLT_v2s64*//*Label 306*/ 16606, 0, 0,
    /*GILLT_v4s32*//*Label 307*/ 16671, 0, 0,
    /*GILLT_v8s16*//*Label 308*/ 16781, 0,
    /*GILLT_v16s8*//*Label 309*/ 16846,
    // Label 304: @12487
    GIM_Try, /*On fail goto*//*Label 311*/ 16554,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 312*/ 12616, // Rule ID 3109 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3109,
        GIR_Done,
      // Label 312: @12616
      GIM_Try, /*On fail goto*//*Label 313*/ 12735, // Rule ID 3150 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3150,
        GIR_Done,
      // Label 313: @12735
      GIM_Try, /*On fail goto*//*Label 314*/ 12854, // Rule ID 1769 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1769,
        GIR_Done,
      // Label 314: @12854
      GIM_Try, /*On fail goto*//*Label 315*/ 12973, // Rule ID 2011 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2011,
        GIR_Done,
      // Label 315: @12973
      GIM_Try, /*On fail goto*//*Label 316*/ 13089, // Rule ID 2911 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2911,
        GIR_Done,
      // Label 316: @13089
      GIM_Try, /*On fail goto*//*Label 317*/ 13205, // Rule ID 2948 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2948,
        GIR_Done,
      // Label 317: @13205
      GIM_Try, /*On fail goto*//*Label 318*/ 13321, // Rule ID 3114 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3114,
        GIR_Done,
      // Label 318: @13321
      GIM_Try, /*On fail goto*//*Label 319*/ 13437, // Rule ID 3155 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3155,
        GIR_Done,
      // Label 319: @13437
      GIM_Try, /*On fail goto*//*Label 320*/ 13553, // Rule ID 2910 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2910,
        GIR_Done,
      // Label 320: @13553
      GIM_Try, /*On fail goto*//*Label 321*/ 13669, // Rule ID 2947 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2947,
        GIR_Done,
      // Label 321: @13669
      GIM_Try, /*On fail goto*//*Label 322*/ 13785, // Rule ID 205 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 205,
        GIR_Done,
      // Label 322: @13785
      GIM_Try, /*On fail goto*//*Label 323*/ 13901, // Rule ID 545 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 545,
        GIR_Done,
      // Label 323: @13901
      GIM_Try, /*On fail goto*//*Label 324*/ 14017, // Rule ID 1774 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1774,
        GIR_Done,
      // Label 324: @14017
      GIM_Try, /*On fail goto*//*Label 325*/ 14133, // Rule ID 2016 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2016,
        GIR_Done,
      // Label 325: @14133
      GIM_Try, /*On fail goto*//*Label 326*/ 14249, // Rule ID 204 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 204,
        GIR_Done,
      // Label 326: @14249
      GIM_Try, /*On fail goto*//*Label 327*/ 14365, // Rule ID 544 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 544,
        GIR_Done,
      // Label 327: @14365
      GIM_Try, /*On fail goto*//*Label 328*/ 14452, // Rule ID 1770 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1770,
        GIR_Done,
      // Label 328: @14452
      GIM_Try, /*On fail goto*//*Label 329*/ 14539, // Rule ID 2012 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2012,
        GIR_Done,
      // Label 329: @14539
      GIM_Try, /*On fail goto*//*Label 330*/ 14626, // Rule ID 3110 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3110,
        GIR_Done,
      // Label 330: @14626
      GIM_Try, /*On fail goto*//*Label 331*/ 14713, // Rule ID 3151 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3151,
        GIR_Done,
      // Label 331: @14713
      GIM_Try, /*On fail goto*//*Label 332*/ 14808, // Rule ID 1773 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1773,
        GIR_Done,
      // Label 332: @14808
      GIM_Try, /*On fail goto*//*Label 333*/ 14903, // Rule ID 2015 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2015,
        GIR_Done,
      // Label 333: @14903
      GIM_Try, /*On fail goto*//*Label 334*/ 14998, // Rule ID 1772 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1772,
        GIR_Done,
      // Label 334: @14998
      GIM_Try, /*On fail goto*//*Label 335*/ 15093, // Rule ID 2014 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2014,
        GIR_Done,
      // Label 335: @15093
      GIM_Try, /*On fail goto*//*Label 336*/ 15188, // Rule ID 1771 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1771,
        GIR_Done,
      // Label 336: @15188
      GIM_Try, /*On fail goto*//*Label 337*/ 15283, // Rule ID 2013 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2013,
        GIR_Done,
      // Label 337: @15283
      GIM_Try, /*On fail goto*//*Label 338*/ 15378, // Rule ID 3113 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3113,
        GIR_Done,
      // Label 338: @15378
      GIM_Try, /*On fail goto*//*Label 339*/ 15473, // Rule ID 3154 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3154,
        GIR_Done,
      // Label 339: @15473
      GIM_Try, /*On fail goto*//*Label 340*/ 15568, // Rule ID 3112 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3112,
        GIR_Done,
      // Label 340: @15568
      GIM_Try, /*On fail goto*//*Label 341*/ 15663, // Rule ID 3153 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3153,
        GIR_Done,
      // Label 341: @15663
      GIM_Try, /*On fail goto*//*Label 342*/ 15758, // Rule ID 3111 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3111,
        GIR_Done,
      // Label 342: @15758
      GIM_Try, /*On fail goto*//*Label 343*/ 15853, // Rule ID 3152 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3152,
        GIR_Done,
      // Label 343: @15853
      GIM_Try, /*On fail goto*//*Label 344*/ 15926, // Rule ID 2935 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2935,
        GIR_Done,
      // Label 344: @15926
      GIM_Try, /*On fail goto*//*Label 345*/ 15999, // Rule ID 2934 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2934,
        GIR_Done,
      // Label 345: @15999
      GIM_Try, /*On fail goto*//*Label 346*/ 16072, // Rule ID 2933 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2933,
        GIR_Done,
      // Label 346: @16072
      GIM_Try, /*On fail goto*//*Label 347*/ 16145, // Rule ID 501 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 501,
        GIR_Done,
      // Label 347: @16145
      GIM_Try, /*On fail goto*//*Label 348*/ 16211, // Rule ID 2936 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2936,
        GIR_Done,
      // Label 348: @16211
      GIM_Try, /*On fail goto*//*Label 349*/ 16277, // Rule ID 502 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 502,
        GIR_Done,
      // Label 349: @16277
      GIM_Try, /*On fail goto*//*Label 350*/ 16318, // Rule ID 1720 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294901760,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (MOVTi16:{ *:[i32] } GPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MOVTi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/65535,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1720,
        GIR_Done,
      // Label 350: @16318
      GIM_Try, /*On fail goto*//*Label 351*/ 16359, // Rule ID 1927 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294901760,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (t2MOVTi16:{ *:[i32] } rGPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MOVTi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/65535,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1927,
        GIR_Done,
      // Label 351: @16359
      GIM_Try, /*On fail goto*//*Label 352*/ 16411, // Rule ID 153 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ORRri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ORRri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 153,
        GIR_Done,
      // Label 352: @16411
      GIM_Try, /*On fail goto*//*Label 353*/ 16463, // Rule ID 489 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ORRri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORRri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 489,
        GIR_Done,
      // Label 353: @16463
      GIM_Try, /*On fail goto*//*Label 354*/ 16508, // Rule ID 154 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ORRrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ORRrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 154,
        GIR_Done,
      // Label 354: @16508
      GIM_Try, /*On fail goto*//*Label 355*/ 16553, // Rule ID 490 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ORRrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORRrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 490,
        GIR_Done,
      // Label 355: @16553
      GIM_Reject,
    // Label 311: @16554
    GIM_Reject,
    // Label 305: @16555
    GIM_Try, /*On fail goto*//*Label 356*/ 16605, // Rule ID 1117 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (or:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VORRd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1117,
      GIR_Done,
    // Label 356: @16605
    GIM_Reject,
    // Label 306: @16606
    GIM_Try, /*On fail goto*//*Label 357*/ 16670, // Rule ID 2652 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (or:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$val1, MQPR:{ *:[v2i64] }:$val2)  =>  (MVE_VORR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$val1, MQPR:{ *:[v2i64] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VORR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2652,
      GIR_Done,
    // Label 357: @16670
    GIM_Reject,
    // Label 307: @16671
    GIM_Try, /*On fail goto*//*Label 358*/ 16780,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 359*/ 16723, // Rule ID 1118 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (or:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VORRq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1118,
        GIR_Done,
      // Label 359: @16723
      GIM_Try, /*On fail goto*//*Label 360*/ 16779, // Rule ID 2651 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (or:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)  =>  (MVE_VORR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VORR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2651,
        GIR_Done,
      // Label 360: @16779
      GIM_Reject,
    // Label 358: @16780
    GIM_Reject,
    // Label 308: @16781
    GIM_Try, /*On fail goto*//*Label 361*/ 16845, // Rule ID 2650 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (or:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)  =>  (MVE_VORR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VORR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2650,
      GIR_Done,
    // Label 361: @16845
    GIM_Reject,
    // Label 309: @16846
    GIM_Try, /*On fail goto*//*Label 362*/ 16910, // Rule ID 2649 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (or:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)  =>  (MVE_VORR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VORR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2649,
      GIR_Done,
    // Label 362: @16910
    GIM_Reject,
    // Label 310: @16911
    GIM_Reject,
    // Label 7: @16912
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 13, /*)*//*default:*//*Label 369*/ 17670,
    /*GILLT_s32*//*Label 363*/ 16930, 0,
    /*GILLT_v2s32*//*Label 364*/ 17314,
    /*GILLT_v2s64*//*Label 365*/ 17365, 0, 0,
    /*GILLT_v4s32*//*Label 366*/ 17430, 0, 0,
    /*GILLT_v8s16*//*Label 367*/ 17540, 0,
    /*GILLT_v16s8*//*Label 368*/ 17605,
    // Label 363: @16930
    GIM_Try, /*On fail goto*//*Label 370*/ 17313,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 371*/ 16988, // Rule ID 2938 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2938,
        GIR_Done,
      // Label 371: @16988
      GIM_Try, /*On fail goto*//*Label 372*/ 17036, // Rule ID 504 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] })  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 372: @17036
      GIM_Try, /*On fail goto*//*Label 373*/ 17077, // Rule ID 505 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (t2MVNr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 505,
        GIR_Done,
      // Label 373: @17077
      GIM_Try, /*On fail goto*//*Label 374*/ 17118, // Rule ID 167 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (MVNr:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVNr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 167,
        GIR_Done,
      // Label 374: @17118
      GIM_Try, /*On fail goto*//*Label 375*/ 17170, // Rule ID 157 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (EORri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::EORri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 157,
        GIR_Done,
      // Label 375: @17170
      GIM_Try, /*On fail goto*//*Label 376*/ 17222, // Rule ID 492 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2EORri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2EORri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 492,
        GIR_Done,
      // Label 376: @17222
      GIM_Try, /*On fail goto*//*Label 377*/ 17267, // Rule ID 158 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (EORrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::EORrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 158,
        GIR_Done,
      // Label 377: @17267
      GIM_Try, /*On fail goto*//*Label 378*/ 17312, // Rule ID 493 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2EORrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2EORrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 493,
        GIR_Done,
      // Label 378: @17312
      GIM_Reject,
    // Label 370: @17313
    GIM_Reject,
    // Label 364: @17314
    GIM_Try, /*On fail goto*//*Label 379*/ 17364, // Rule ID 1115 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (xor:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VEORd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1115,
      GIR_Done,
    // Label 379: @17364
    GIM_Reject,
    // Label 365: @17365
    GIM_Try, /*On fail goto*//*Label 380*/ 17429, // Rule ID 2656 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (xor:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$val1, MQPR:{ *:[v2i64] }:$val2)  =>  (MVE_VEOR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$val1, MQPR:{ *:[v2i64] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VEOR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2656,
      GIR_Done,
    // Label 380: @17429
    GIM_Reject,
    // Label 366: @17430
    GIM_Try, /*On fail goto*//*Label 381*/ 17539,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 382*/ 17482, // Rule ID 1116 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (xor:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VEORq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1116,
        GIR_Done,
      // Label 382: @17482
      GIM_Try, /*On fail goto*//*Label 383*/ 17538, // Rule ID 2655 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (xor:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)  =>  (MVE_VEOR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val1, MQPR:{ *:[v4i32] }:$val2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VEOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2655,
        GIR_Done,
      // Label 383: @17538
      GIM_Reject,
    // Label 381: @17539
    GIM_Reject,
    // Label 367: @17540
    GIM_Try, /*On fail goto*//*Label 384*/ 17604, // Rule ID 2654 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (xor:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)  =>  (MVE_VEOR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val1, MQPR:{ *:[v8i16] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VEOR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2654,
      GIR_Done,
    // Label 384: @17604
    GIM_Reject,
    // Label 368: @17605
    GIM_Try, /*On fail goto*//*Label 385*/ 17669, // Rule ID 2653 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
      // (xor:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)  =>  (MVE_VEOR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val1, MQPR:{ *:[v16i8] }:$val2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VEOR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val2
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2653,
      GIR_Done,
    // Label 385: @17669
    GIM_Reject,
    // Label 369: @17670
    GIM_Reject,
    // Label 8: @17671
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 13, /*)*//*default:*//*Label 395*/ 24793,
    /*GILLT_s32*//*Label 386*/ 17689,
    /*GILLT_s64*//*Label 387*/ 17765,
    /*GILLT_v2s32*//*Label 388*/ 18554,
    /*GILLT_v2s64*//*Label 389*/ 19343, 0,
    /*GILLT_v4s16*//*Label 390*/ 20540,
    /*GILLT_v4s32*//*Label 391*/ 21329, 0,
    /*GILLT_v8s8*//*Label 392*/ 22526,
    /*GILLT_v8s16*//*Label 393*/ 22959, 0,
    /*GILLT_v16s8*//*Label 394*/ 24156,
    // Label 386: @17689
    GIM_Try, /*On fail goto*//*Label 396*/ 17764,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 397*/ 17729, // Rule ID 697 //
        GIM_CheckFeatures, GIFBS_HasFPRegs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::SPRRegClassID,
        // (bitconvert:{ *:[i32] } SPR:{ *:[f32] }:$Sn)  =>  (VMOVRS:{ *:[i32] } SPR:{ *:[f32] }:$Sn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMOVRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Sn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 697,
        GIR_Done,
      // Label 397: @17729
      GIM_Try, /*On fail goto*//*Label 398*/ 17763, // Rule ID 698 //
        GIM_CheckFeatures, GIFBS_HasFPRegs_UseVMOVSR,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$Rt)  =>  (VMOVSR:{ *:[f32] } GPR:{ *:[i32] }:$Rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMOVSR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rt
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 698,
        GIR_Done,
      // Label 398: @17763
      GIM_Reject,
    // Label 396: @17764
    GIM_Reject,
    // Label 387: @17765
    GIM_Try, /*On fail goto*//*Label 399*/ 17799, // Rule ID 2404 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2404,
      GIR_Done,
    // Label 399: @17799
    GIM_Try, /*On fail goto*//*Label 400*/ 17833, // Rule ID 2405 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2405,
      GIR_Done,
    // Label 400: @17833
    GIM_Try, /*On fail goto*//*Label 401*/ 17867, // Rule ID 2416 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2416,
      GIR_Done,
    // Label 401: @17867
    GIM_Try, /*On fail goto*//*Label 402*/ 17901, // Rule ID 2417 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2417,
      GIR_Done,
    // Label 402: @17901
    GIM_Try, /*On fail goto*//*Label 403*/ 17935, // Rule ID 2418 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2418,
      GIR_Done,
    // Label 403: @17935
    GIM_Try, /*On fail goto*//*Label 404*/ 17969, // Rule ID 2419 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2419,
      GIR_Done,
    // Label 404: @17969
    GIM_Try, /*On fail goto*//*Label 405*/ 18003, // Rule ID 2420 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2420,
      GIR_Done,
    // Label 405: @18003
    GIM_Try, /*On fail goto*//*Label 406*/ 18037, // Rule ID 2421 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2421,
      GIR_Done,
    // Label 406: @18037
    GIM_Try, /*On fail goto*//*Label 407*/ 18071, // Rule ID 2422 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2422,
      GIR_Done,
    // Label 407: @18071
    GIM_Try, /*On fail goto*//*Label 408*/ 18105, // Rule ID 2423 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2423,
      GIR_Done,
    // Label 408: @18105
    GIM_Try, /*On fail goto*//*Label 409*/ 18139, // Rule ID 2424 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2424,
      GIR_Done,
    // Label 409: @18139
    GIM_Try, /*On fail goto*//*Label 410*/ 18173, // Rule ID 2425 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2425,
      GIR_Done,
    // Label 410: @18173
    GIM_Try, /*On fail goto*//*Label 411*/ 18211, // Rule ID 2488 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2488,
      GIR_Done,
    // Label 411: @18211
    GIM_Try, /*On fail goto*//*Label 412*/ 18249, // Rule ID 2489 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2489,
      GIR_Done,
    // Label 412: @18249
    GIM_Try, /*On fail goto*//*Label 413*/ 18287, // Rule ID 2490 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2490,
      GIR_Done,
    // Label 413: @18287
    GIM_Try, /*On fail goto*//*Label 414*/ 18325, // Rule ID 2491 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2491,
      GIR_Done,
    // Label 414: @18325
    GIM_Try, /*On fail goto*//*Label 415*/ 18363, // Rule ID 2492 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[f64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2492,
      GIR_Done,
    // Label 415: @18363
    GIM_Try, /*On fail goto*//*Label 416*/ 18401, // Rule ID 2493 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2493,
      GIR_Done,
    // Label 416: @18401
    GIM_Try, /*On fail goto*//*Label 417*/ 18439, // Rule ID 2494 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2494,
      GIR_Done,
    // Label 417: @18439
    GIM_Try, /*On fail goto*//*Label 418*/ 18477, // Rule ID 2495 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2495,
      GIR_Done,
    // Label 418: @18477
    GIM_Try, /*On fail goto*//*Label 419*/ 18515, // Rule ID 2496 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2496,
      GIR_Done,
    // Label 419: @18515
    GIM_Try, /*On fail goto*//*Label 420*/ 18553, // Rule ID 2497 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2497,
      GIR_Done,
    // Label 420: @18553
    GIM_Reject,
    // Label 388: @18554
    GIM_Try, /*On fail goto*//*Label 421*/ 18588, // Rule ID 2406 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2406,
      GIR_Done,
    // Label 421: @18588
    GIM_Try, /*On fail goto*//*Label 422*/ 18622, // Rule ID 2407 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2407,
      GIR_Done,
    // Label 422: @18622
    GIM_Try, /*On fail goto*//*Label 423*/ 18656, // Rule ID 2426 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2426,
      GIR_Done,
    // Label 423: @18656
    GIM_Try, /*On fail goto*//*Label 424*/ 18690, // Rule ID 2427 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2427,
      GIR_Done,
    // Label 424: @18690
    GIM_Try, /*On fail goto*//*Label 425*/ 18724, // Rule ID 2428 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2428,
      GIR_Done,
    // Label 425: @18724
    GIM_Try, /*On fail goto*//*Label 426*/ 18758, // Rule ID 2429 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2429,
      GIR_Done,
    // Label 426: @18758
    GIM_Try, /*On fail goto*//*Label 427*/ 18792, // Rule ID 2430 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2430,
      GIR_Done,
    // Label 427: @18792
    GIM_Try, /*On fail goto*//*Label 428*/ 18826, // Rule ID 2431 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2431,
      GIR_Done,
    // Label 428: @18826
    GIM_Try, /*On fail goto*//*Label 429*/ 18860, // Rule ID 2432 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2432,
      GIR_Done,
    // Label 429: @18860
    GIM_Try, /*On fail goto*//*Label 430*/ 18894, // Rule ID 2433 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2433,
      GIR_Done,
    // Label 430: @18894
    GIM_Try, /*On fail goto*//*Label 431*/ 18928, // Rule ID 2434 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2434,
      GIR_Done,
    // Label 431: @18928
    GIM_Try, /*On fail goto*//*Label 432*/ 18962, // Rule ID 2435 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2435,
      GIR_Done,
    // Label 432: @18962
    GIM_Try, /*On fail goto*//*Label 433*/ 19000, // Rule ID 2498 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2498,
      GIR_Done,
    // Label 433: @19000
    GIM_Try, /*On fail goto*//*Label 434*/ 19038, // Rule ID 2499 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2499,
      GIR_Done,
    // Label 434: @19038
    GIM_Try, /*On fail goto*//*Label 435*/ 19076, // Rule ID 2500 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2500,
      GIR_Done,
    // Label 435: @19076
    GIM_Try, /*On fail goto*//*Label 436*/ 19114, // Rule ID 2501 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2501,
      GIR_Done,
    // Label 436: @19114
    GIM_Try, /*On fail goto*//*Label 437*/ 19152, // Rule ID 2502 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2502,
      GIR_Done,
    // Label 437: @19152
    GIM_Try, /*On fail goto*//*Label 438*/ 19190, // Rule ID 2503 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2503,
      GIR_Done,
    // Label 438: @19190
    GIM_Try, /*On fail goto*//*Label 439*/ 19228, // Rule ID 2504 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2504,
      GIR_Done,
    // Label 439: @19228
    GIM_Try, /*On fail goto*//*Label 440*/ 19266, // Rule ID 2505 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2505,
      GIR_Done,
    // Label 440: @19266
    GIM_Try, /*On fail goto*//*Label 441*/ 19304, // Rule ID 2506 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2506,
      GIR_Done,
    // Label 441: @19304
    GIM_Try, /*On fail goto*//*Label 442*/ 19342, // Rule ID 2507 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2507,
      GIR_Done,
    // Label 442: @19342
    GIM_Reject,
    // Label 389: @19343
    GIM_Try, /*On fail goto*//*Label 443*/ 19377, // Rule ID 2410 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2410,
      GIR_Done,
    // Label 443: @19377
    GIM_Try, /*On fail goto*//*Label 444*/ 19411, // Rule ID 2411 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2411,
      GIR_Done,
    // Label 444: @19411
    GIM_Try, /*On fail goto*//*Label 445*/ 19445, // Rule ID 2452 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2452,
      GIR_Done,
    // Label 445: @19445
    GIM_Try, /*On fail goto*//*Label 446*/ 19479, // Rule ID 2453 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2453,
      GIR_Done,
    // Label 446: @19479
    GIM_Try, /*On fail goto*//*Label 447*/ 19513, // Rule ID 2454 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2454,
      GIR_Done,
    // Label 447: @19513
    GIM_Try, /*On fail goto*//*Label 448*/ 19547, // Rule ID 2455 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2455,
      GIR_Done,
    // Label 448: @19547
    GIM_Try, /*On fail goto*//*Label 449*/ 19581, // Rule ID 2456 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2456,
      GIR_Done,
    // Label 449: @19581
    GIM_Try, /*On fail goto*//*Label 450*/ 19615, // Rule ID 2457 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2457,
      GIR_Done,
    // Label 450: @19615
    GIM_Try, /*On fail goto*//*Label 451*/ 19649, // Rule ID 2458 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2458,
      GIR_Done,
    // Label 451: @19649
    GIM_Try, /*On fail goto*//*Label 452*/ 19683, // Rule ID 2459 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2459,
      GIR_Done,
    // Label 452: @19683
    GIM_Try, /*On fail goto*//*Label 453*/ 19717, // Rule ID 2460 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2460,
      GIR_Done,
    // Label 453: @19717
    GIM_Try, /*On fail goto*//*Label 454*/ 19751, // Rule ID 2461 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2461,
      GIR_Done,
    // Label 454: @19751
    GIM_Try, /*On fail goto*//*Label 455*/ 19789, // Rule ID 2524 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2524,
      GIR_Done,
    // Label 455: @19789
    GIM_Try, /*On fail goto*//*Label 456*/ 19827, // Rule ID 2525 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2525,
      GIR_Done,
    // Label 456: @19827
    GIM_Try, /*On fail goto*//*Label 457*/ 19865, // Rule ID 2526 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2526,
      GIR_Done,
    // Label 457: @19865
    GIM_Try, /*On fail goto*//*Label 458*/ 19903, // Rule ID 2527 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2527,
      GIR_Done,
    // Label 458: @19903
    GIM_Try, /*On fail goto*//*Label 459*/ 19941, // Rule ID 2528 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2528,
      GIR_Done,
    // Label 459: @19941
    GIM_Try, /*On fail goto*//*Label 460*/ 19979, // Rule ID 2529 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2529,
      GIR_Done,
    // Label 460: @19979
    GIM_Try, /*On fail goto*//*Label 461*/ 20017, // Rule ID 2530 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2530,
      GIR_Done,
    // Label 461: @20017
    GIM_Try, /*On fail goto*//*Label 462*/ 20055, // Rule ID 2531 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2531,
      GIR_Done,
    // Label 462: @20055
    GIM_Try, /*On fail goto*//*Label 463*/ 20093, // Rule ID 2532 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2532,
      GIR_Done,
    // Label 463: @20093
    GIM_Try, /*On fail goto*//*Label 464*/ 20131, // Rule ID 2533 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2533,
      GIR_Done,
    // Label 464: @20131
    GIM_Try, /*On fail goto*//*Label 465*/ 20165, // Rule ID 2838 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2838,
      GIR_Done,
    // Label 465: @20165
    GIM_Try, /*On fail goto*//*Label 466*/ 20199, // Rule ID 2839 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2839,
      GIR_Done,
    // Label 466: @20199
    GIM_Try, /*On fail goto*//*Label 467*/ 20233, // Rule ID 2844 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2844,
      GIR_Done,
    // Label 467: @20233
    GIM_Try, /*On fail goto*//*Label 468*/ 20267, // Rule ID 2845 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2845,
      GIR_Done,
    // Label 468: @20267
    GIM_Try, /*On fail goto*//*Label 469*/ 20301, // Rule ID 2846 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2846,
      GIR_Done,
    // Label 469: @20301
    GIM_Try, /*On fail goto*//*Label 470*/ 20335, // Rule ID 2847 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2847,
      GIR_Done,
    // Label 470: @20335
    GIM_Try, /*On fail goto*//*Label 471*/ 20369, // Rule ID 2848 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2848,
      GIR_Done,
    // Label 471: @20369
    GIM_Try, /*On fail goto*//*Label 472*/ 20403, // Rule ID 2849 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2849,
      GIR_Done,
    // Label 472: @20403
    GIM_Try, /*On fail goto*//*Label 473*/ 20437, // Rule ID 2850 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2850,
      GIR_Done,
    // Label 473: @20437
    GIM_Try, /*On fail goto*//*Label 474*/ 20471, // Rule ID 2851 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2851,
      GIR_Done,
    // Label 474: @20471
    GIM_Try, /*On fail goto*//*Label 475*/ 20505, // Rule ID 2852 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2852,
      GIR_Done,
    // Label 475: @20505
    GIM_Try, /*On fail goto*//*Label 476*/ 20539, // Rule ID 2853 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2853,
      GIR_Done,
    // Label 476: @20539
    GIM_Reject,
    // Label 390: @20540
    GIM_Try, /*On fail goto*//*Label 477*/ 20574, // Rule ID 2408 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2408,
      GIR_Done,
    // Label 477: @20574
    GIM_Try, /*On fail goto*//*Label 478*/ 20608, // Rule ID 2409 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2409,
      GIR_Done,
    // Label 478: @20608
    GIM_Try, /*On fail goto*//*Label 479*/ 20642, // Rule ID 2436 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2436,
      GIR_Done,
    // Label 479: @20642
    GIM_Try, /*On fail goto*//*Label 480*/ 20676, // Rule ID 2437 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2437,
      GIR_Done,
    // Label 480: @20676
    GIM_Try, /*On fail goto*//*Label 481*/ 20710, // Rule ID 2438 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2438,
      GIR_Done,
    // Label 481: @20710
    GIM_Try, /*On fail goto*//*Label 482*/ 20744, // Rule ID 2439 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2439,
      GIR_Done,
    // Label 482: @20744
    GIM_Try, /*On fail goto*//*Label 483*/ 20778, // Rule ID 2440 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2440,
      GIR_Done,
    // Label 483: @20778
    GIM_Try, /*On fail goto*//*Label 484*/ 20812, // Rule ID 2441 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2441,
      GIR_Done,
    // Label 484: @20812
    GIM_Try, /*On fail goto*//*Label 485*/ 20846, // Rule ID 2442 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2442,
      GIR_Done,
    // Label 485: @20846
    GIM_Try, /*On fail goto*//*Label 486*/ 20880, // Rule ID 2443 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2443,
      GIR_Done,
    // Label 486: @20880
    GIM_Try, /*On fail goto*//*Label 487*/ 20914, // Rule ID 2444 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2444,
      GIR_Done,
    // Label 487: @20914
    GIM_Try, /*On fail goto*//*Label 488*/ 20948, // Rule ID 2445 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2445,
      GIR_Done,
    // Label 488: @20948
    GIM_Try, /*On fail goto*//*Label 489*/ 20986, // Rule ID 2508 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2508,
      GIR_Done,
    // Label 489: @20986
    GIM_Try, /*On fail goto*//*Label 490*/ 21024, // Rule ID 2509 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2509,
      GIR_Done,
    // Label 490: @21024
    GIM_Try, /*On fail goto*//*Label 491*/ 21062, // Rule ID 2510 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2510,
      GIR_Done,
    // Label 491: @21062
    GIM_Try, /*On fail goto*//*Label 492*/ 21100, // Rule ID 2511 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2511,
      GIR_Done,
    // Label 492: @21100
    GIM_Try, /*On fail goto*//*Label 493*/ 21138, // Rule ID 2512 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2512,
      GIR_Done,
    // Label 493: @21138
    GIM_Try, /*On fail goto*//*Label 494*/ 21176, // Rule ID 2513 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2513,
      GIR_Done,
    // Label 494: @21176
    GIM_Try, /*On fail goto*//*Label 495*/ 21214, // Rule ID 2514 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2514,
      GIR_Done,
    // Label 495: @21214
    GIM_Try, /*On fail goto*//*Label 496*/ 21252, // Rule ID 2515 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2515,
      GIR_Done,
    // Label 496: @21252
    GIM_Try, /*On fail goto*//*Label 497*/ 21290, // Rule ID 2516 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2516,
      GIR_Done,
    // Label 497: @21290
    GIM_Try, /*On fail goto*//*Label 498*/ 21328, // Rule ID 2517 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2517,
      GIR_Done,
    // Label 498: @21328
    GIM_Reject,
    // Label 391: @21329
    GIM_Try, /*On fail goto*//*Label 499*/ 21363, // Rule ID 2412 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2412,
      GIR_Done,
    // Label 499: @21363
    GIM_Try, /*On fail goto*//*Label 500*/ 21397, // Rule ID 2413 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2413,
      GIR_Done,
    // Label 500: @21397
    GIM_Try, /*On fail goto*//*Label 501*/ 21431, // Rule ID 2462 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2462,
      GIR_Done,
    // Label 501: @21431
    GIM_Try, /*On fail goto*//*Label 502*/ 21465, // Rule ID 2463 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2463,
      GIR_Done,
    // Label 502: @21465
    GIM_Try, /*On fail goto*//*Label 503*/ 21499, // Rule ID 2464 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2464,
      GIR_Done,
    // Label 503: @21499
    GIM_Try, /*On fail goto*//*Label 504*/ 21533, // Rule ID 2465 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2465,
      GIR_Done,
    // Label 504: @21533
    GIM_Try, /*On fail goto*//*Label 505*/ 21567, // Rule ID 2466 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2466,
      GIR_Done,
    // Label 505: @21567
    GIM_Try, /*On fail goto*//*Label 506*/ 21601, // Rule ID 2467 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2467,
      GIR_Done,
    // Label 506: @21601
    GIM_Try, /*On fail goto*//*Label 507*/ 21635, // Rule ID 2468 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2468,
      GIR_Done,
    // Label 507: @21635
    GIM_Try, /*On fail goto*//*Label 508*/ 21669, // Rule ID 2469 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2469,
      GIR_Done,
    // Label 508: @21669
    GIM_Try, /*On fail goto*//*Label 509*/ 21703, // Rule ID 2470 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2470,
      GIR_Done,
    // Label 509: @21703
    GIM_Try, /*On fail goto*//*Label 510*/ 21737, // Rule ID 2471 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2471,
      GIR_Done,
    // Label 510: @21737
    GIM_Try, /*On fail goto*//*Label 511*/ 21775, // Rule ID 2534 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2534,
      GIR_Done,
    // Label 511: @21775
    GIM_Try, /*On fail goto*//*Label 512*/ 21813, // Rule ID 2535 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2535,
      GIR_Done,
    // Label 512: @21813
    GIM_Try, /*On fail goto*//*Label 513*/ 21851, // Rule ID 2536 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2536,
      GIR_Done,
    // Label 513: @21851
    GIM_Try, /*On fail goto*//*Label 514*/ 21889, // Rule ID 2537 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2537,
      GIR_Done,
    // Label 514: @21889
    GIM_Try, /*On fail goto*//*Label 515*/ 21927, // Rule ID 2538 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2538,
      GIR_Done,
    // Label 515: @21927
    GIM_Try, /*On fail goto*//*Label 516*/ 21965, // Rule ID 2539 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2539,
      GIR_Done,
    // Label 516: @21965
    GIM_Try, /*On fail goto*//*Label 517*/ 22003, // Rule ID 2540 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2540,
      GIR_Done,
    // Label 517: @22003
    GIM_Try, /*On fail goto*//*Label 518*/ 22041, // Rule ID 2541 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2541,
      GIR_Done,
    // Label 518: @22041
    GIM_Try, /*On fail goto*//*Label 519*/ 22079, // Rule ID 2542 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2542,
      GIR_Done,
    // Label 519: @22079
    GIM_Try, /*On fail goto*//*Label 520*/ 22117, // Rule ID 2543 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2543,
      GIR_Done,
    // Label 520: @22117
    GIM_Try, /*On fail goto*//*Label 521*/ 22151, // Rule ID 2840 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2840,
      GIR_Done,
    // Label 521: @22151
    GIM_Try, /*On fail goto*//*Label 522*/ 22185, // Rule ID 2841 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2841,
      GIR_Done,
    // Label 522: @22185
    GIM_Try, /*On fail goto*//*Label 523*/ 22219, // Rule ID 2854 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2854,
      GIR_Done,
    // Label 523: @22219
    GIM_Try, /*On fail goto*//*Label 524*/ 22253, // Rule ID 2855 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2855,
      GIR_Done,
    // Label 524: @22253
    GIM_Try, /*On fail goto*//*Label 525*/ 22287, // Rule ID 2856 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2856,
      GIR_Done,
    // Label 525: @22287
    GIM_Try, /*On fail goto*//*Label 526*/ 22321, // Rule ID 2857 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2857,
      GIR_Done,
    // Label 526: @22321
    GIM_Try, /*On fail goto*//*Label 527*/ 22355, // Rule ID 2858 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2858,
      GIR_Done,
    // Label 527: @22355
    GIM_Try, /*On fail goto*//*Label 528*/ 22389, // Rule ID 2859 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2859,
      GIR_Done,
    // Label 528: @22389
    GIM_Try, /*On fail goto*//*Label 529*/ 22423, // Rule ID 2860 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2860,
      GIR_Done,
    // Label 529: @22423
    GIM_Try, /*On fail goto*//*Label 530*/ 22457, // Rule ID 2861 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2861,
      GIR_Done,
    // Label 530: @22457
    GIM_Try, /*On fail goto*//*Label 531*/ 22491, // Rule ID 2862 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2862,
      GIR_Done,
    // Label 531: @22491
    GIM_Try, /*On fail goto*//*Label 532*/ 22525, // Rule ID 2863 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2863,
      GIR_Done,
    // Label 532: @22525
    GIM_Reject,
    // Label 392: @22526
    GIM_Try, /*On fail goto*//*Label 533*/ 22560, // Rule ID 2446 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2446,
      GIR_Done,
    // Label 533: @22560
    GIM_Try, /*On fail goto*//*Label 534*/ 22594, // Rule ID 2447 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2447,
      GIR_Done,
    // Label 534: @22594
    GIM_Try, /*On fail goto*//*Label 535*/ 22628, // Rule ID 2448 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2448,
      GIR_Done,
    // Label 535: @22628
    GIM_Try, /*On fail goto*//*Label 536*/ 22662, // Rule ID 2449 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2449,
      GIR_Done,
    // Label 536: @22662
    GIM_Try, /*On fail goto*//*Label 537*/ 22696, // Rule ID 2450 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2450,
      GIR_Done,
    // Label 537: @22696
    GIM_Try, /*On fail goto*//*Label 538*/ 22730, // Rule ID 2451 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DPR*/36,
      // GIR_Coverage, 2451,
      GIR_Done,
    // Label 538: @22730
    GIM_Try, /*On fail goto*//*Label 539*/ 22768, // Rule ID 2518 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2518,
      GIR_Done,
    // Label 539: @22768
    GIM_Try, /*On fail goto*//*Label 540*/ 22806, // Rule ID 2519 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2519,
      GIR_Done,
    // Label 540: @22806
    GIM_Try, /*On fail goto*//*Label 541*/ 22844, // Rule ID 2520 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2520,
      GIR_Done,
    // Label 541: @22844
    GIM_Try, /*On fail goto*//*Label 542*/ 22882, // Rule ID 2521 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2521,
      GIR_Done,
    // Label 542: @22882
    GIM_Try, /*On fail goto*//*Label 543*/ 22920, // Rule ID 2522 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2522,
      GIR_Done,
    // Label 543: @22920
    GIM_Try, /*On fail goto*//*Label 544*/ 22958, // Rule ID 2523 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2523,
      GIR_Done,
    // Label 544: @22958
    GIM_Reject,
    // Label 393: @22959
    GIM_Try, /*On fail goto*//*Label 545*/ 22993, // Rule ID 2414 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2414,
      GIR_Done,
    // Label 545: @22993
    GIM_Try, /*On fail goto*//*Label 546*/ 23027, // Rule ID 2415 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2415,
      GIR_Done,
    // Label 546: @23027
    GIM_Try, /*On fail goto*//*Label 547*/ 23061, // Rule ID 2472 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2472,
      GIR_Done,
    // Label 547: @23061
    GIM_Try, /*On fail goto*//*Label 548*/ 23095, // Rule ID 2473 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2473,
      GIR_Done,
    // Label 548: @23095
    GIM_Try, /*On fail goto*//*Label 549*/ 23129, // Rule ID 2474 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2474,
      GIR_Done,
    // Label 549: @23129
    GIM_Try, /*On fail goto*//*Label 550*/ 23163, // Rule ID 2475 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2475,
      GIR_Done,
    // Label 550: @23163
    GIM_Try, /*On fail goto*//*Label 551*/ 23197, // Rule ID 2476 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2476,
      GIR_Done,
    // Label 551: @23197
    GIM_Try, /*On fail goto*//*Label 552*/ 23231, // Rule ID 2477 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2477,
      GIR_Done,
    // Label 552: @23231
    GIM_Try, /*On fail goto*//*Label 553*/ 23265, // Rule ID 2478 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2478,
      GIR_Done,
    // Label 553: @23265
    GIM_Try, /*On fail goto*//*Label 554*/ 23299, // Rule ID 2479 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2479,
      GIR_Done,
    // Label 554: @23299
    GIM_Try, /*On fail goto*//*Label 555*/ 23333, // Rule ID 2480 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2480,
      GIR_Done,
    // Label 555: @23333
    GIM_Try, /*On fail goto*//*Label 556*/ 23367, // Rule ID 2481 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2481,
      GIR_Done,
    // Label 556: @23367
    GIM_Try, /*On fail goto*//*Label 557*/ 23405, // Rule ID 2544 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2544,
      GIR_Done,
    // Label 557: @23405
    GIM_Try, /*On fail goto*//*Label 558*/ 23443, // Rule ID 2545 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2545,
      GIR_Done,
    // Label 558: @23443
    GIM_Try, /*On fail goto*//*Label 559*/ 23481, // Rule ID 2546 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2546,
      GIR_Done,
    // Label 559: @23481
    GIM_Try, /*On fail goto*//*Label 560*/ 23519, // Rule ID 2547 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2547,
      GIR_Done,
    // Label 560: @23519
    GIM_Try, /*On fail goto*//*Label 561*/ 23557, // Rule ID 2548 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2548,
      GIR_Done,
    // Label 561: @23557
    GIM_Try, /*On fail goto*//*Label 562*/ 23595, // Rule ID 2549 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2549,
      GIR_Done,
    // Label 562: @23595
    GIM_Try, /*On fail goto*//*Label 563*/ 23633, // Rule ID 2550 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2550,
      GIR_Done,
    // Label 563: @23633
    GIM_Try, /*On fail goto*//*Label 564*/ 23671, // Rule ID 2551 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2551,
      GIR_Done,
    // Label 564: @23671
    GIM_Try, /*On fail goto*//*Label 565*/ 23709, // Rule ID 2552 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2552,
      GIR_Done,
    // Label 565: @23709
    GIM_Try, /*On fail goto*//*Label 566*/ 23747, // Rule ID 2553 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2553,
      GIR_Done,
    // Label 566: @23747
    GIM_Try, /*On fail goto*//*Label 567*/ 23781, // Rule ID 2842 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2842,
      GIR_Done,
    // Label 567: @23781
    GIM_Try, /*On fail goto*//*Label 568*/ 23815, // Rule ID 2843 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2843,
      GIR_Done,
    // Label 568: @23815
    GIM_Try, /*On fail goto*//*Label 569*/ 23849, // Rule ID 2864 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2864,
      GIR_Done,
    // Label 569: @23849
    GIM_Try, /*On fail goto*//*Label 570*/ 23883, // Rule ID 2865 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2865,
      GIR_Done,
    // Label 570: @23883
    GIM_Try, /*On fail goto*//*Label 571*/ 23917, // Rule ID 2866 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2866,
      GIR_Done,
    // Label 571: @23917
    GIM_Try, /*On fail goto*//*Label 572*/ 23951, // Rule ID 2867 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2867,
      GIR_Done,
    // Label 572: @23951
    GIM_Try, /*On fail goto*//*Label 573*/ 23985, // Rule ID 2868 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2868,
      GIR_Done,
    // Label 573: @23985
    GIM_Try, /*On fail goto*//*Label 574*/ 24019, // Rule ID 2869 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2869,
      GIR_Done,
    // Label 574: @24019
    GIM_Try, /*On fail goto*//*Label 575*/ 24053, // Rule ID 2870 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2870,
      GIR_Done,
    // Label 575: @24053
    GIM_Try, /*On fail goto*//*Label 576*/ 24087, // Rule ID 2871 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2871,
      GIR_Done,
    // Label 576: @24087
    GIM_Try, /*On fail goto*//*Label 577*/ 24121, // Rule ID 2872 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2872,
      GIR_Done,
    // Label 577: @24121
    GIM_Try, /*On fail goto*//*Label 578*/ 24155, // Rule ID 2873 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2873,
      GIR_Done,
    // Label 578: @24155
    GIM_Reject,
    // Label 394: @24156
    GIM_Try, /*On fail goto*//*Label 579*/ 24190, // Rule ID 2482 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2482,
      GIR_Done,
    // Label 579: @24190
    GIM_Try, /*On fail goto*//*Label 580*/ 24224, // Rule ID 2483 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2483,
      GIR_Done,
    // Label 580: @24224
    GIM_Try, /*On fail goto*//*Label 581*/ 24258, // Rule ID 2484 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2484,
      GIR_Done,
    // Label 581: @24258
    GIM_Try, /*On fail goto*//*Label 582*/ 24292, // Rule ID 2485 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2485,
      GIR_Done,
    // Label 582: @24292
    GIM_Try, /*On fail goto*//*Label 583*/ 24326, // Rule ID 2486 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2486,
      GIR_Done,
    // Label 583: @24326
    GIM_Try, /*On fail goto*//*Label 584*/ 24360, // Rule ID 2487 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2487,
      GIR_Done,
    // Label 584: @24360
    GIM_Try, /*On fail goto*//*Label 585*/ 24398, // Rule ID 2554 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2554,
      GIR_Done,
    // Label 585: @24398
    GIM_Try, /*On fail goto*//*Label 586*/ 24436, // Rule ID 2555 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2555,
      GIR_Done,
    // Label 586: @24436
    GIM_Try, /*On fail goto*//*Label 587*/ 24474, // Rule ID 2556 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2556,
      GIR_Done,
    // Label 587: @24474
    GIM_Try, /*On fail goto*//*Label 588*/ 24512, // Rule ID 2557 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2557,
      GIR_Done,
    // Label 588: @24512
    GIM_Try, /*On fail goto*//*Label 589*/ 24550, // Rule ID 2558 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2558,
      GIR_Done,
    // Label 589: @24550
    GIM_Try, /*On fail goto*//*Label 590*/ 24588, // Rule ID 2559 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ::zero_reg,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2559,
      GIR_Done,
    // Label 590: @24588
    GIM_Try, /*On fail goto*//*Label 591*/ 24622, // Rule ID 2874 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2874,
      GIR_Done,
    // Label 591: @24622
    GIM_Try, /*On fail goto*//*Label 592*/ 24656, // Rule ID 2875 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2875,
      GIR_Done,
    // Label 592: @24656
    GIM_Try, /*On fail goto*//*Label 593*/ 24690, // Rule ID 2876 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2876,
      GIR_Done,
    // Label 593: @24690
    GIM_Try, /*On fail goto*//*Label 594*/ 24724, // Rule ID 2877 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2877,
      GIR_Done,
    // Label 594: @24724
    GIM_Try, /*On fail goto*//*Label 595*/ 24758, // Rule ID 2878 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2878,
      GIR_Done,
    // Label 595: @24758
    GIM_Try, /*On fail goto*//*Label 596*/ 24792, // Rule ID 2879 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC QPR*/54,
      // GIR_Coverage, 2879,
      GIR_Done,
    // Label 596: @24792
    GIM_Reject,
    // Label 395: @24793
    GIM_Reject,
    // Label 9: @24794
    GIM_Try, /*On fail goto*//*Label 597*/ 30058,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 598*/ 24848, // Rule ID 1728 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1376:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1728,
        GIR_Done,
      // Label 598: @24848
      GIM_Try, /*On fail goto*//*Label 599*/ 24897, // Rule ID 1943 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1376:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1943,
        GIR_Done,
      // Label 599: @24897
      GIM_Try, /*On fail goto*//*Label 600*/ 24937, // Rule ID 685 //
        GIM_CheckFeatures, GIFBS_HasFullFP16,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::HPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::HPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f16] } 1262:{ *:[iPTR] }, HPR:{ *:[f16] }:$Sm)  =>  (VRINTNH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 685,
        GIR_Done,
      // Label 600: @24937
      GIM_Try, /*On fail goto*//*Label 601*/ 24977, // Rule ID 686 //
        GIM_CheckFeatures, GIFBS_HasFPARMv8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1262:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VRINTNS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 686,
        GIR_Done,
      // Label 601: @24977
      GIM_Try, /*On fail goto*//*Label 602*/ 25017, // Rule ID 687 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasFPARMv8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 1262:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VRINTND:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Dd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 687,
        GIR_Done,
      // Label 602: @25017
      GIM_Try, /*On fail goto*//*Label 603*/ 25063, // Rule ID 703 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1377:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOSIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOSIRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 703,
        GIR_Done,
      // Label 603: @25063
      GIM_Try, /*On fail goto*//*Label 604*/ 25109, // Rule ID 704 //
        GIM_CheckFeatures, GIFBS_DontUseNEONForFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1377:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOSIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOSIRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 704,
        GIR_Done,
      // Label 604: @25109
      GIM_Try, /*On fail goto*//*Label 605*/ 25155, // Rule ID 705 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtru,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1378:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOUIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOUIRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 705,
        GIR_Done,
      // Label 605: @25155
      GIM_Try, /*On fail goto*//*Label 606*/ 25201, // Rule ID 706 //
        GIM_CheckFeatures, GIFBS_DontUseNEONForFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtru,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1378:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOUIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOUIRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 706,
        GIR_Done,
      // Label 606: @25201
      GIM_Try, /*On fail goto*//*Label 607*/ 25247, // Rule ID 1224 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1226:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLsv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1224,
        GIR_Done,
      // Label 607: @25247
      GIM_Try, /*On fail goto*//*Label 608*/ 25293, // Rule ID 1225 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1226:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLsv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1225,
        GIR_Done,
      // Label 608: @25293
      GIM_Try, /*On fail goto*//*Label 609*/ 25339, // Rule ID 1226 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1226:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLsv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1226,
        GIR_Done,
      // Label 609: @25339
      GIM_Try, /*On fail goto*//*Label 610*/ 25385, // Rule ID 1227 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1226:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLsv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1227,
        GIR_Done,
      // Label 610: @25385
      GIM_Try, /*On fail goto*//*Label 611*/ 25431, // Rule ID 1228 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1226:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLsv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1228,
        GIR_Done,
      // Label 611: @25431
      GIM_Try, /*On fail goto*//*Label 612*/ 25477, // Rule ID 1229 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1226:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLsv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1229,
        GIR_Done,
      // Label 612: @25477
      GIM_Try, /*On fail goto*//*Label 613*/ 25523, // Rule ID 1230 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1227:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLuv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1230,
        GIR_Done,
      // Label 613: @25523
      GIM_Try, /*On fail goto*//*Label 614*/ 25569, // Rule ID 1231 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1227:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLuv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1231,
        GIR_Done,
      // Label 614: @25569
      GIM_Try, /*On fail goto*//*Label 615*/ 25615, // Rule ID 1232 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1227:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLuv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1232,
        GIR_Done,
      // Label 615: @25615
      GIM_Try, /*On fail goto*//*Label 616*/ 25661, // Rule ID 1233 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1227:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLuv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1233,
        GIR_Done,
      // Label 616: @25661
      GIM_Try, /*On fail goto*//*Label 617*/ 25707, // Rule ID 1234 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1227:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLuv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1234,
        GIR_Done,
      // Label 617: @25707
      GIM_Try, /*On fail goto*//*Label 618*/ 25753, // Rule ID 1235 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1227:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLuv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1235,
        GIR_Done,
      // Label 618: @25753
      GIM_Try, /*On fail goto*//*Label 619*/ 25799, // Rule ID 1264 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1256:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRECPEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1264,
        GIR_Done,
      // Label 619: @25799
      GIM_Try, /*On fail goto*//*Label 620*/ 25845, // Rule ID 1265 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1256:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRECPEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1265,
        GIR_Done,
      // Label 620: @25845
      GIM_Try, /*On fail goto*//*Label 621*/ 25891, // Rule ID 1266 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1256:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRECPEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1266,
        GIR_Done,
      // Label 621: @25891
      GIM_Try, /*On fail goto*//*Label 622*/ 25937, // Rule ID 1267 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1256:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRECPEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1267,
        GIR_Done,
      // Label 622: @25937
      GIM_Try, /*On fail goto*//*Label 623*/ 25983, // Rule ID 1268 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1256:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRECPEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEhd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 623: @25983
      GIM_Try, /*On fail goto*//*Label 624*/ 26029, // Rule ID 1269 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1256:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRECPEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEhq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 624: @26029
      GIM_Try, /*On fail goto*//*Label 625*/ 26075, // Rule ID 1274 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1269:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRSQRTEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1274,
        GIR_Done,
      // Label 625: @26075
      GIM_Try, /*On fail goto*//*Label 626*/ 26121, // Rule ID 1275 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1269:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRSQRTEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1275,
        GIR_Done,
      // Label 626: @26121
      GIM_Try, /*On fail goto*//*Label 627*/ 26167, // Rule ID 1276 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1269:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRSQRTEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1276,
        GIR_Done,
      // Label 627: @26167
      GIM_Try, /*On fail goto*//*Label 628*/ 26213, // Rule ID 1277 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1269:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRSQRTEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1277,
        GIR_Done,
      // Label 628: @26213
      GIM_Try, /*On fail goto*//*Label 629*/ 26259, // Rule ID 1278 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1269:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRSQRTEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEhd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1278,
        GIR_Done,
      // Label 629: @26259
      GIM_Try, /*On fail goto*//*Label 630*/ 26305, // Rule ID 1279 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1269:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRSQRTEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEhq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1279,
        GIR_Done,
      // Label 630: @26305
      GIM_Try, /*On fail goto*//*Label 631*/ 26351, // Rule ID 1500 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1232:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQABSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1500,
        GIR_Done,
      // Label 631: @26351
      GIM_Try, /*On fail goto*//*Label 632*/ 26397, // Rule ID 1501 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1232:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQABSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1501,
        GIR_Done,
      // Label 632: @26397
      GIM_Try, /*On fail goto*//*Label 633*/ 26443, // Rule ID 1502 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1232:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQABSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1502,
        GIR_Done,
      // Label 633: @26443
      GIM_Try, /*On fail goto*//*Label 634*/ 26489, // Rule ID 1503 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1232:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQABSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1503,
        GIR_Done,
      // Label 634: @26489
      GIM_Try, /*On fail goto*//*Label 635*/ 26535, // Rule ID 1504 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1232:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQABSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1504,
        GIR_Done,
      // Label 635: @26535
      GIM_Try, /*On fail goto*//*Label 636*/ 26581, // Rule ID 1505 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1232:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQABSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1505,
        GIR_Done,
      // Label 636: @26581
      GIM_Try, /*On fail goto*//*Label 637*/ 26627, // Rule ID 1516 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1240:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQNEGv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1516,
        GIR_Done,
      // Label 637: @26627
      GIM_Try, /*On fail goto*//*Label 638*/ 26673, // Rule ID 1517 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1240:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQNEGv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1517,
        GIR_Done,
      // Label 638: @26673
      GIM_Try, /*On fail goto*//*Label 639*/ 26719, // Rule ID 1518 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1240:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQNEGv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1518,
        GIR_Done,
      // Label 639: @26719
      GIM_Try, /*On fail goto*//*Label 640*/ 26765, // Rule ID 1519 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1240:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQNEGv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1519,
        GIR_Done,
      // Label 640: @26765
      GIM_Try, /*On fail goto*//*Label 641*/ 26811, // Rule ID 1520 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1240:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQNEGv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1520,
        GIR_Done,
      // Label 641: @26811
      GIM_Try, /*On fail goto*//*Label 642*/ 26857, // Rule ID 1521 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1240:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQNEGv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1521,
        GIR_Done,
      // Label 642: @26857
      GIM_Try, /*On fail goto*//*Label 643*/ 26903, // Rule ID 1522 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1181:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VCLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1522,
        GIR_Done,
      // Label 643: @26903
      GIM_Try, /*On fail goto*//*Label 644*/ 26949, // Rule ID 1523 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1181:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1523,
        GIR_Done,
      // Label 644: @26949
      GIM_Try, /*On fail goto*//*Label 645*/ 26995, // Rule ID 1524 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1181:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VCLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1524,
        GIR_Done,
      // Label 645: @26995
      GIM_Try, /*On fail goto*//*Label 646*/ 27041, // Rule ID 1525 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1181:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VCLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1525,
        GIR_Done,
      // Label 646: @27041
      GIM_Try, /*On fail goto*//*Label 647*/ 27087, // Rule ID 1526 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1181:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VCLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1526,
        GIR_Done,
      // Label 647: @27087
      GIM_Try, /*On fail goto*//*Label 648*/ 27133, // Rule ID 1527 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1181:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VCLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1527,
        GIR_Done,
      // Label 648: @27133
      GIM_Try, /*On fail goto*//*Label 649*/ 27179, // Rule ID 1571 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1237:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1571,
        GIR_Done,
      // Label 649: @27179
      GIM_Try, /*On fail goto*//*Label 650*/ 27225, // Rule ID 1572 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1237:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1572,
        GIR_Done,
      // Label 650: @27225
      GIM_Try, /*On fail goto*//*Label 651*/ 27271, // Rule ID 1573 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1237:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1573,
        GIR_Done,
      // Label 651: @27271
      GIM_Try, /*On fail goto*//*Label 652*/ 27317, // Rule ID 1574 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1239:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1574,
        GIR_Done,
      // Label 652: @27317
      GIM_Try, /*On fail goto*//*Label 653*/ 27363, // Rule ID 1575 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1239:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1575,
        GIR_Done,
      // Label 653: @27363
      GIM_Try, /*On fail goto*//*Label 654*/ 27409, // Rule ID 1576 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1239:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1576,
        GIR_Done,
      // Label 654: @27409
      GIM_Try, /*On fail goto*//*Label 655*/ 27455, // Rule ID 1577 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1238:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1577,
        GIR_Done,
      // Label 655: @27455
      GIM_Try, /*On fail goto*//*Label 656*/ 27501, // Rule ID 1578 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1238:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1578,
        GIR_Done,
      // Label 656: @27501
      GIM_Try, /*On fail goto*//*Label 657*/ 27547, // Rule ID 1579 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1238:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1579,
        GIR_Done,
      // Label 657: @27547
      GIM_Try, /*On fail goto*//*Label 658*/ 27587, // Rule ID 1602 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1182:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1602,
        GIR_Done,
      // Label 658: @27587
      GIM_Try, /*On fail goto*//*Label 659*/ 27627, // Rule ID 1603 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1182:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1603,
        GIR_Done,
      // Label 659: @27627
      GIM_Try, /*On fail goto*//*Label 660*/ 27667, // Rule ID 1604 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1183:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1604,
        GIR_Done,
      // Label 660: @27667
      GIM_Try, /*On fail goto*//*Label 661*/ 27707, // Rule ID 1605 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1183:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1605,
        GIR_Done,
      // Label 661: @27707
      GIM_Try, /*On fail goto*//*Label 662*/ 27747, // Rule ID 1606 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1182:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1606,
        GIR_Done,
      // Label 662: @27747
      GIM_Try, /*On fail goto*//*Label 663*/ 27787, // Rule ID 1607 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1182:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1607,
        GIR_Done,
      // Label 663: @27787
      GIM_Try, /*On fail goto*//*Label 664*/ 27827, // Rule ID 1608 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1183:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1608,
        GIR_Done,
      // Label 664: @27827
      GIM_Try, /*On fail goto*//*Label 665*/ 27867, // Rule ID 1609 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1183:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1609,
        GIR_Done,
      // Label 665: @27867
      GIM_Try, /*On fail goto*//*Label 666*/ 27907, // Rule ID 1610 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1192:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1610,
        GIR_Done,
      // Label 666: @27907
      GIM_Try, /*On fail goto*//*Label 667*/ 27947, // Rule ID 1611 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1192:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1611,
        GIR_Done,
      // Label 667: @27947
      GIM_Try, /*On fail goto*//*Label 668*/ 27987, // Rule ID 1612 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1193:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1612,
        GIR_Done,
      // Label 668: @27987
      GIM_Try, /*On fail goto*//*Label 669*/ 28027, // Rule ID 1613 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1193:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1613,
        GIR_Done,
      // Label 669: @28027
      GIM_Try, /*On fail goto*//*Label 670*/ 28067, // Rule ID 1614 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1192:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1614,
        GIR_Done,
      // Label 670: @28067
      GIM_Try, /*On fail goto*//*Label 671*/ 28107, // Rule ID 1615 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1192:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1615,
        GIR_Done,
      // Label 671: @28107
      GIM_Try, /*On fail goto*//*Label 672*/ 28147, // Rule ID 1616 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1193:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1616,
        GIR_Done,
      // Label 672: @28147
      GIM_Try, /*On fail goto*//*Label 673*/ 28187, // Rule ID 1617 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1193:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1617,
        GIR_Done,
      // Label 673: @28187
      GIM_Try, /*On fail goto*//*Label 674*/ 28227, // Rule ID 1618 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1194:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1618,
        GIR_Done,
      // Label 674: @28227
      GIM_Try, /*On fail goto*//*Label 675*/ 28267, // Rule ID 1619 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1194:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1619,
        GIR_Done,
      // Label 675: @28267
      GIM_Try, /*On fail goto*//*Label 676*/ 28307, // Rule ID 1620 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1195:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1620,
        GIR_Done,
      // Label 676: @28307
      GIM_Try, /*On fail goto*//*Label 677*/ 28347, // Rule ID 1621 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1195:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1621,
        GIR_Done,
      // Label 677: @28347
      GIM_Try, /*On fail goto*//*Label 678*/ 28387, // Rule ID 1622 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1194:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1622,
        GIR_Done,
      // Label 678: @28387
      GIM_Try, /*On fail goto*//*Label 679*/ 28427, // Rule ID 1623 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1194:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1623,
        GIR_Done,
      // Label 679: @28427
      GIM_Try, /*On fail goto*//*Label 680*/ 28467, // Rule ID 1624 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1195:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1624,
        GIR_Done,
      // Label 680: @28467
      GIM_Try, /*On fail goto*//*Label 681*/ 28507, // Rule ID 1625 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1195:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1625,
        GIR_Done,
      // Label 681: @28507
      GIM_Try, /*On fail goto*//*Label 682*/ 28547, // Rule ID 1626 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1190:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1626,
        GIR_Done,
      // Label 682: @28547
      GIM_Try, /*On fail goto*//*Label 683*/ 28587, // Rule ID 1627 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1190:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1627,
        GIR_Done,
      // Label 683: @28587
      GIM_Try, /*On fail goto*//*Label 684*/ 28627, // Rule ID 1628 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1191:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1628,
        GIR_Done,
      // Label 684: @28627
      GIM_Try, /*On fail goto*//*Label 685*/ 28667, // Rule ID 1629 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1191:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1629,
        GIR_Done,
      // Label 685: @28667
      GIM_Try, /*On fail goto*//*Label 686*/ 28707, // Rule ID 1630 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1190:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1630,
        GIR_Done,
      // Label 686: @28707
      GIM_Try, /*On fail goto*//*Label 687*/ 28747, // Rule ID 1631 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1190:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1631,
        GIR_Done,
      // Label 687: @28747
      GIM_Try, /*On fail goto*//*Label 688*/ 28787, // Rule ID 1632 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1191:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1632,
        GIR_Done,
      // Label 688: @28787
      GIM_Try, /*On fail goto*//*Label 689*/ 28827, // Rule ID 1633 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1191:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1633,
        GIR_Done,
      // Label 689: @28827
      GIM_Try, /*On fail goto*//*Label 690*/ 28873, // Rule ID 1650 //
        GIM_CheckFeatures, GIFBS_HasFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2hf,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1186:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTf2h:{ *:[v4i16] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2h,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1650,
        GIR_Done,
      // Label 690: @28873
      GIM_Try, /*On fail goto*//*Label 691*/ 28919, // Rule ID 1651 //
        GIM_CheckFeatures, GIFBS_HasFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvthf2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1189:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCVTh2f:{ *:[v4f32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2f,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1651,
        GIR_Done,
      // Label 691: @28919
      GIM_Try, /*On fail goto*//*Label 692*/ 28959, // Rule ID 1673 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1262:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTNNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1673,
        GIR_Done,
      // Label 692: @28959
      GIM_Try, /*On fail goto*//*Label 693*/ 28999, // Rule ID 1674 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1262:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTNNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1674,
        GIR_Done,
      // Label 693: @28999
      GIM_Try, /*On fail goto*//*Label 694*/ 29039, // Rule ID 1675 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1262:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTNNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1675,
        GIR_Done,
      // Label 694: @29039
      GIM_Try, /*On fail goto*//*Label 695*/ 29079, // Rule ID 1676 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1262:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTNNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1676,
        GIR_Done,
      // Label 695: @29079
      GIM_Try, /*On fail goto*//*Label 696*/ 29119, // Rule ID 1677 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1264:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTXNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1677,
        GIR_Done,
      // Label 696: @29119
      GIM_Try, /*On fail goto*//*Label 697*/ 29159, // Rule ID 1678 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1264:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTXNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1678,
        GIR_Done,
      // Label 697: @29159
      GIM_Try, /*On fail goto*//*Label 698*/ 29199, // Rule ID 1679 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1264:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTXNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1679,
        GIR_Done,
      // Label 698: @29199
      GIM_Try, /*On fail goto*//*Label 699*/ 29239, // Rule ID 1680 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1264:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTXNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1680,
        GIR_Done,
      // Label 699: @29239
      GIM_Try, /*On fail goto*//*Label 700*/ 29279, // Rule ID 1681 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1260:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTANDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1681,
        GIR_Done,
      // Label 700: @29279
      GIM_Try, /*On fail goto*//*Label 701*/ 29319, // Rule ID 1682 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1260:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTANQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1682,
        GIR_Done,
      // Label 701: @29319
      GIM_Try, /*On fail goto*//*Label 702*/ 29359, // Rule ID 1683 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1260:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTANDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1683,
        GIR_Done,
      // Label 702: @29359
      GIM_Try, /*On fail goto*//*Label 703*/ 29399, // Rule ID 1684 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1260:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTANQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1684,
        GIR_Done,
      // Label 703: @29399
      GIM_Try, /*On fail goto*//*Label 704*/ 29439, // Rule ID 1685 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1265:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTZNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1685,
        GIR_Done,
      // Label 704: @29439
      GIM_Try, /*On fail goto*//*Label 705*/ 29479, // Rule ID 1686 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1265:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTZNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1686,
        GIR_Done,
      // Label 705: @29479
      GIM_Try, /*On fail goto*//*Label 706*/ 29519, // Rule ID 1687 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1265:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTZNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1687,
        GIR_Done,
      // Label 706: @29519
      GIM_Try, /*On fail goto*//*Label 707*/ 29559, // Rule ID 1688 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1265:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTZNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1688,
        GIR_Done,
      // Label 707: @29559
      GIM_Try, /*On fail goto*//*Label 708*/ 29599, // Rule ID 1689 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1261:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTMNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1689,
        GIR_Done,
      // Label 708: @29599
      GIM_Try, /*On fail goto*//*Label 709*/ 29639, // Rule ID 1690 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1261:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTMNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1690,
        GIR_Done,
      // Label 709: @29639
      GIM_Try, /*On fail goto*//*Label 710*/ 29679, // Rule ID 1691 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1261:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTMNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1691,
        GIR_Done,
      // Label 710: @29679
      GIM_Try, /*On fail goto*//*Label 711*/ 29719, // Rule ID 1692 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1261:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTMNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1692,
        GIR_Done,
      // Label 711: @29719
      GIM_Try, /*On fail goto*//*Label 712*/ 29759, // Rule ID 1693 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1263:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTPNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1693,
        GIR_Done,
      // Label 712: @29759
      GIM_Try, /*On fail goto*//*Label 713*/ 29799, // Rule ID 1694 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1263:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTPNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1694,
        GIR_Done,
      // Label 713: @29799
      GIM_Try, /*On fail goto*//*Label 714*/ 29839, // Rule ID 1695 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1263:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTPNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1695,
        GIR_Done,
      // Label 714: @29839
      GIM_Try, /*On fail goto*//*Label 715*/ 29879, // Rule ID 1696 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1263:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTPNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1696,
        GIR_Done,
      // Label 715: @29879
      GIM_Try, /*On fail goto*//*Label 716*/ 29919, // Rule ID 1699 //
        GIM_CheckFeatures, GIFBS_HasCrypto_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_aesimc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1161:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESIMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::AESIMC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1699,
        GIR_Done,
      // Label 716: @29919
      GIM_Try, /*On fail goto*//*Label 717*/ 29959, // Rule ID 1700 //
        GIM_CheckFeatures, GIFBS_HasCrypto_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_aesmc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1162:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::AESMC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1700,
        GIR_Done,
      // Label 717: @29959
      GIM_Try, /*On fail goto*//*Label 718*/ 30008, // Rule ID 1723 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_sxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1351:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (SXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1723,
        GIR_Done,
      // Label 718: @30008
      GIM_Try, /*On fail goto*//*Label 719*/ 30057, // Rule ID 1932 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_sxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1351:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1932,
        GIR_Done,
      // Label 719: @30057
      GIM_Reject,
    // Label 597: @30058
    GIM_Try, /*On fail goto*//*Label 720*/ 51388,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 721*/ 30124, // Rule ID 1950 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtab16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1375:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTAB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1950,
        GIR_Done,
      // Label 721: @30124
      GIM_Try, /*On fail goto*//*Label 722*/ 30214, // Rule ID 3187 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1233:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v4i16] } 1241:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VQRDMLAHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3187,
        GIR_Done,
      // Label 722: @30214
      GIM_Try, /*On fail goto*//*Label 723*/ 30304, // Rule ID 3188 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1233:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v2i32] } 1241:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VQRDMLAHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3188,
        GIR_Done,
      // Label 723: @30304
      GIM_Try, /*On fail goto*//*Label 724*/ 30394, // Rule ID 3189 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1233:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v8i16] } 1241:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VQRDMLAHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3189,
        GIR_Done,
      // Label 724: @30394
      GIM_Try, /*On fail goto*//*Label 725*/ 30484, // Rule ID 3190 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1233:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v4i32] } 1241:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VQRDMLAHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3190,
        GIR_Done,
      // Label 725: @30484
      GIM_Try, /*On fail goto*//*Label 726*/ 30574, // Rule ID 3207 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1233:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v4i32] } 1236:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VQDMLALv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLALv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3207,
        GIR_Done,
      // Label 726: @30574
      GIM_Try, /*On fail goto*//*Label 727*/ 30664, // Rule ID 3208 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1233:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[v2i64] } 1236:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$src1)  =>  (VQDMLALv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLALv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3208,
        GIR_Done,
      // Label 727: @30664
      GIM_Try, /*On fail goto*//*Label 728*/ 30747, // Rule ID 111 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rm
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Rn)  =>  (QDADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 111,
        GIR_Done,
      // Label 728: @30747
      GIM_Try, /*On fail goto*//*Label 729*/ 30830, // Rule ID 1968 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rm
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Rn)  =>  (t2QDADD:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1968,
        GIR_Done,
      // Label 729: @30830
      GIM_Try, /*On fail goto*//*Label 730*/ 30920, // Rule ID 2214 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1233:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 1241:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VQRDMLAHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2214,
        GIR_Done,
      // Label 730: @30920
      GIM_Try, /*On fail goto*//*Label 731*/ 31010, // Rule ID 2215 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1233:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 1241:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VQRDMLAHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2215,
        GIR_Done,
      // Label 731: @31010
      GIM_Try, /*On fail goto*//*Label 732*/ 31100, // Rule ID 2216 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1233:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 1241:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VQRDMLAHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2216,
        GIR_Done,
      // Label 732: @31100
      GIM_Try, /*On fail goto*//*Label 733*/ 31190, // Rule ID 2217 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1233:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1241:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VQRDMLAHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLAHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2217,
        GIR_Done,
      // Label 733: @31190
      GIM_Try, /*On fail goto*//*Label 734*/ 31280, // Rule ID 2222 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1253:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 1241:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VQRDMLSHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLSHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2222,
        GIR_Done,
      // Label 734: @31280
      GIM_Try, /*On fail goto*//*Label 735*/ 31370, // Rule ID 2223 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1253:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 1241:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VQRDMLSHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLSHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2223,
        GIR_Done,
      // Label 735: @31370
      GIM_Try, /*On fail goto*//*Label 736*/ 31460, // Rule ID 2224 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1253:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 1241:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VQRDMLSHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLSHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2224,
        GIR_Done,
      // Label 736: @31460
      GIM_Try, /*On fail goto*//*Label 737*/ 31550, // Rule ID 2225 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8_1a,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1253:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1241:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VQRDMLSHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMLSHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2225,
        GIR_Done,
      // Label 737: @31550
      GIM_Try, /*On fail goto*//*Label 738*/ 31640, // Rule ID 2230 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1233:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1236:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VQDMLALv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLALv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2230,
        GIR_Done,
      // Label 738: @31640
      GIM_Try, /*On fail goto*//*Label 739*/ 31730, // Rule ID 2231 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1233:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$src1, (intrinsic_wo_chain:{ *:[v2i64] } 1236:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VQDMLALv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLALv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2231,
        GIR_Done,
      // Label 739: @31730
      GIM_Try, /*On fail goto*//*Label 740*/ 31820, // Rule ID 2237 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1253:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 1236:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VQDMLSLv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLSLv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2237,
        GIR_Done,
      // Label 740: @31820
      GIM_Try, /*On fail goto*//*Label 741*/ 31910, // Rule ID 2238 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1253:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$src1, (intrinsic_wo_chain:{ *:[v2i64] } 1236:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VQDMLSLv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMLSLv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2238,
        GIR_Done,
      // Label 741: @31910
      GIM_Try, /*On fail goto*//*Label 742*/ 31993, // Rule ID 112 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1298:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rn))  =>  (QDSUB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 112,
        GIR_Done,
      // Label 742: @31993
      GIM_Try, /*On fail goto*//*Label 743*/ 32076, // Rule ID 1969 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1298:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rn))  =>  (t2QDSUB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1969,
        GIR_Done,
      // Label 743: @32076
      GIM_Try, /*On fail goto*//*Label 744*/ 32159, // Rule ID 2888 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rm
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rm))  =>  (QDADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2888,
        GIR_Done,
      // Label 744: @32159
      GIM_Try, /*On fail goto*//*Label 745*/ 32242, // Rule ID 3141 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rm
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rm))  =>  (t2QDADD:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3141,
        GIR_Done,
      // Label 745: @32242
      GIM_Try, /*On fail goto*//*Label 746*/ 32310, // Rule ID 1745 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_31,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1370:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPRnopc:{ *:[i32] }:$a, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::USAT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1745,
        GIR_Done,
      // Label 746: @32310
      GIM_Try, /*On fail goto*//*Label 747*/ 32375, // Rule ID 1749 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_15,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1371:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos)  =>  (USAT16:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos, GPRnopc:{ *:[i32] }:$a)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::USAT16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1749,
        GIR_Done,
      // Label 747: @32375
      GIM_Try, /*On fail goto*//*Label 748*/ 32443, // Rule ID 1973 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_31,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1370:{ *:[iPTR] }, GPR:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (t2USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPR:{ *:[i32] }:$a, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2USAT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1973,
        GIR_Done,
      // Label 748: @32443
      GIM_Try, /*On fail goto*//*Label 749*/ 32508, // Rule ID 1975 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_15,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 1371:{ *:[iPTR] }, GPR:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos)  =>  (t2USAT16:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos, GPR:{ *:[i32] }:$a)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2USAT16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1975,
        GIR_Done,
      // Label 749: @32508
      GIM_Try, /*On fail goto*//*Label 750*/ 32570, // Rule ID 1634 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1184:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xsd:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2xsd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1634,
        GIR_Done,
      // Label 750: @32570
      GIM_Try, /*On fail goto*//*Label 751*/ 32632, // Rule ID 1635 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1185:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xud:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2xud,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1635,
        GIR_Done,
      // Label 751: @32632
      GIM_Try, /*On fail goto*//*Label 752*/ 32694, // Rule ID 1636 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxs2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1187:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2fd:{ *:[v2f32] } DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxs2fd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1636,
        GIR_Done,
      // Label 752: @32694
      GIM_Try, /*On fail goto*//*Label 753*/ 32756, // Rule ID 1637 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxu2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2f32] } 1188:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2fd:{ *:[v2f32] } DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxu2fd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1637,
        GIR_Done,
      // Label 753: @32756
      GIM_Try, /*On fail goto*//*Label 754*/ 32818, // Rule ID 1638 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1184:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xsd:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2xsd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1638,
        GIR_Done,
      // Label 754: @32818
      GIM_Try, /*On fail goto*//*Label 755*/ 32880, // Rule ID 1639 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1185:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xud:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2xud,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1639,
        GIR_Done,
      // Label 755: @32880
      GIM_Try, /*On fail goto*//*Label 756*/ 32942, // Rule ID 1640 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxs2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1187:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2hd:{ *:[v4f16] } DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxs2hd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1640,
        GIR_Done,
      // Label 756: @32942
      GIM_Try, /*On fail goto*//*Label 757*/ 33004, // Rule ID 1641 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxu2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4f16] } 1188:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2hd:{ *:[v4f16] } DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxu2hd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1641,
        GIR_Done,
      // Label 757: @33004
      GIM_Try, /*On fail goto*//*Label 758*/ 33066, // Rule ID 1642 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1184:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xsq:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2xsq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1642,
        GIR_Done,
      // Label 758: @33066
      GIM_Try, /*On fail goto*//*Label 759*/ 33128, // Rule ID 1643 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1185:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xuq:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2xuq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1643,
        GIR_Done,
      // Label 759: @33128
      GIM_Try, /*On fail goto*//*Label 760*/ 33190, // Rule ID 1644 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxs2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1187:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2fq:{ *:[v4f32] } QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxs2fq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1644,
        GIR_Done,
      // Label 760: @33190
      GIM_Try, /*On fail goto*//*Label 761*/ 33252, // Rule ID 1645 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxu2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1188:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2fq:{ *:[v4f32] } QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxu2fq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1645,
        GIR_Done,
      // Label 761: @33252
      GIM_Try, /*On fail goto*//*Label 762*/ 33314, // Rule ID 1646 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1184:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xsq:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2xsq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1646,
        GIR_Done,
      // Label 762: @33314
      GIM_Try, /*On fail goto*//*Label 763*/ 33376, // Rule ID 1647 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2fxu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1185:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xuq:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2xuq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1647,
        GIR_Done,
      // Label 763: @33376
      GIM_Try, /*On fail goto*//*Label 764*/ 33438, // Rule ID 1648 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxs2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1187:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2hq:{ *:[v8f16] } QPR:{ *:[v8i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxs2hq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1648,
        GIR_Done,
      // Label 764: @33438
      GIM_Try, /*On fail goto*//*Label 765*/ 33500, // Rule ID 1649 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfxu2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8f16] } 1188:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2hq:{ *:[v8f16] } QPR:{ *:[v8i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTxu2hq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1649,
        GIR_Done,
      // Label 765: @33500
      GIM_Try, /*On fail goto*//*Label 766*/ 33558, // Rule ID 107 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1295:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QADD8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 107,
        GIR_Done,
      // Label 766: @33558
      GIM_Try, /*On fail goto*//*Label 767*/ 33616, // Rule ID 108 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1294:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QADD16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 108,
        GIR_Done,
      // Label 767: @33616
      GIM_Try, /*On fail goto*//*Label 768*/ 33674, // Rule ID 109 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1299:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QSUB16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 109,
        GIR_Done,
      // Label 768: @33674
      GIM_Try, /*On fail goto*//*Label 769*/ 33732, // Rule ID 110 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1300:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QSUB8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 110,
        GIR_Done,
      // Label 769: @33732
      GIM_Try, /*On fail goto*//*Label 770*/ 33790, // Rule ID 113 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1298:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (QSUB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 113,
        GIR_Done,
      // Label 770: @33790
      GIM_Try, /*On fail goto*//*Label 771*/ 33848, // Rule ID 114 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1293:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (QADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 114,
        GIR_Done,
      // Label 771: @33848
      GIM_Try, /*On fail goto*//*Label 772*/ 33906, // Rule ID 115 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1362:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQADD16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 115,
        GIR_Done,
      // Label 772: @33906
      GIM_Try, /*On fail goto*//*Label 773*/ 33964, // Rule ID 116 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1363:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQADD8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 116,
        GIR_Done,
      // Label 773: @33964
      GIM_Try, /*On fail goto*//*Label 774*/ 34022, // Rule ID 117 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1366:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQSUB16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 117,
        GIR_Done,
      // Label 774: @34022
      GIM_Try, /*On fail goto*//*Label 775*/ 34080, // Rule ID 118 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1367:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQSUB8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 118,
        GIR_Done,
      // Label 775: @34080
      GIM_Try, /*On fail goto*//*Label 776*/ 34138, // Rule ID 119 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1296:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QASX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 119,
        GIR_Done,
      // Label 776: @34138
      GIM_Try, /*On fail goto*//*Label 777*/ 34196, // Rule ID 120 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1297:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (QSAX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 120,
        GIR_Done,
      // Label 777: @34196
      GIM_Try, /*On fail goto*//*Label 778*/ 34254, // Rule ID 121 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1364:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQASX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 121,
        GIR_Done,
      // Label 778: @34254
      GIM_Try, /*On fail goto*//*Label 779*/ 34312, // Rule ID 122 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1365:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UQSAX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UQSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 122,
        GIR_Done,
      // Label 779: @34312
      GIM_Try, /*On fail goto*//*Label 780*/ 34370, // Rule ID 135 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1308:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHASX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 135,
        GIR_Done,
      // Label 780: @34370
      GIM_Try, /*On fail goto*//*Label 781*/ 34428, // Rule ID 136 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1306:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHADD16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 136,
        GIR_Done,
      // Label 781: @34428
      GIM_Try, /*On fail goto*//*Label 782*/ 34486, // Rule ID 137 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1307:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHADD8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 782: @34486
      GIM_Try, /*On fail goto*//*Label 783*/ 34544, // Rule ID 138 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1309:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHSAX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 138,
        GIR_Done,
      // Label 783: @34544
      GIM_Try, /*On fail goto*//*Label 784*/ 34602, // Rule ID 139 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1310:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHSUB16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 139,
        GIR_Done,
      // Label 784: @34602
      GIM_Try, /*On fail goto*//*Label 785*/ 34660, // Rule ID 140 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1311:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (SHSUB8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SHSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 140,
        GIR_Done,
      // Label 785: @34660
      GIM_Try, /*On fail goto*//*Label 786*/ 34718, // Rule ID 141 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1357:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHASX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 141,
        GIR_Done,
      // Label 786: @34718
      GIM_Try, /*On fail goto*//*Label 787*/ 34776, // Rule ID 142 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1355:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHADD16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 142,
        GIR_Done,
      // Label 787: @34776
      GIM_Try, /*On fail goto*//*Label 788*/ 34834, // Rule ID 143 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1356:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHADD8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 143,
        GIR_Done,
      // Label 788: @34834
      GIM_Try, /*On fail goto*//*Label 789*/ 34892, // Rule ID 144 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1358:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHSAX:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 144,
        GIR_Done,
      // Label 789: @34892
      GIM_Try, /*On fail goto*//*Label 790*/ 34950, // Rule ID 145 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1359:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHSUB16:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 790: @34950
      GIM_Try, /*On fail goto*//*Label 791*/ 35008, // Rule ID 146 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1360:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (UHSUB8:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UHSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 146,
        GIR_Done,
      // Label 791: @35008
      GIM_Try, /*On fail goto*//*Label 792*/ 35066, // Rule ID 147 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usad8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1368:{ *:[iPTR] }, GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (USAD8:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::USAD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 792: @35066
      GIM_Try, /*On fail goto*//*Label 793*/ 35118, // Rule ID 206 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1131:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32B:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 793: @35118
      GIM_Try, /*On fail goto*//*Label 794*/ 35170, // Rule ID 207 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32cb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1132:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32CB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32CB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 207,
        GIR_Done,
      // Label 794: @35170
      GIM_Try, /*On fail goto*//*Label 795*/ 35222, // Rule ID 208 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1135:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32H:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 795: @35222
      GIM_Try, /*On fail goto*//*Label 796*/ 35274, // Rule ID 209 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32ch,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1133:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32CH:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32CH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 209,
        GIR_Done,
      // Label 796: @35274
      GIM_Try, /*On fail goto*//*Label 797*/ 35326, // Rule ID 210 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1136:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32W:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 210,
        GIR_Done,
      // Label 797: @35326
      GIM_Try, /*On fail goto*//*Label 798*/ 35378, // Rule ID 211 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32cw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (CRC32CW:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::CRC32CW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 211,
        GIR_Done,
      // Label 798: @35378
      GIM_Try, /*On fail goto*//*Label 799*/ 35436, // Rule ID 437 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1294:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QADD16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 437,
        GIR_Done,
      // Label 799: @35436
      GIM_Try, /*On fail goto*//*Label 800*/ 35494, // Rule ID 438 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1295:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QADD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 438,
        GIR_Done,
      // Label 800: @35494
      GIM_Try, /*On fail goto*//*Label 801*/ 35552, // Rule ID 439 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1296:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QASX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 439,
        GIR_Done,
      // Label 801: @35552
      GIM_Try, /*On fail goto*//*Label 802*/ 35610, // Rule ID 440 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1367:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQSUB8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 440,
        GIR_Done,
      // Label 802: @35610
      GIM_Try, /*On fail goto*//*Label 803*/ 35668, // Rule ID 441 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1297:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QSAX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 441,
        GIR_Done,
      // Label 803: @35668
      GIM_Try, /*On fail goto*//*Label 804*/ 35726, // Rule ID 442 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1299:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QSUB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 442,
        GIR_Done,
      // Label 804: @35726
      GIM_Try, /*On fail goto*//*Label 805*/ 35784, // Rule ID 443 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1300:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2QSUB8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 443,
        GIR_Done,
      // Label 805: @35784
      GIM_Try, /*On fail goto*//*Label 806*/ 35842, // Rule ID 444 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1362:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQADD16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 444,
        GIR_Done,
      // Label 806: @35842
      GIM_Try, /*On fail goto*//*Label 807*/ 35900, // Rule ID 445 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1363:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQADD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 445,
        GIR_Done,
      // Label 807: @35900
      GIM_Try, /*On fail goto*//*Label 808*/ 35958, // Rule ID 446 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1364:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQASX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 446,
        GIR_Done,
      // Label 808: @35958
      GIM_Try, /*On fail goto*//*Label 809*/ 36016, // Rule ID 447 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1365:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQSAX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 447,
        GIR_Done,
      // Label 809: @36016
      GIM_Try, /*On fail goto*//*Label 810*/ 36074, // Rule ID 448 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uqsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1366:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UQSUB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UQSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 448,
        GIR_Done,
      // Label 810: @36074
      GIM_Try, /*On fail goto*//*Label 811*/ 36132, // Rule ID 461 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1308:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHASX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 461,
        GIR_Done,
      // Label 811: @36132
      GIM_Try, /*On fail goto*//*Label 812*/ 36190, // Rule ID 462 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1306:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHADD16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 462,
        GIR_Done,
      // Label 812: @36190
      GIM_Try, /*On fail goto*//*Label 813*/ 36248, // Rule ID 463 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1307:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHADD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 463,
        GIR_Done,
      // Label 813: @36248
      GIM_Try, /*On fail goto*//*Label 814*/ 36306, // Rule ID 464 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1309:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHSAX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 464,
        GIR_Done,
      // Label 814: @36306
      GIM_Try, /*On fail goto*//*Label 815*/ 36364, // Rule ID 465 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1310:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHSUB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 465,
        GIR_Done,
      // Label 815: @36364
      GIM_Try, /*On fail goto*//*Label 816*/ 36422, // Rule ID 466 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_shsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1311:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SHSUB8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SHSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 466,
        GIR_Done,
      // Label 816: @36422
      GIM_Try, /*On fail goto*//*Label 817*/ 36480, // Rule ID 467 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhasx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1357:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHASX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 467,
        GIR_Done,
      // Label 817: @36480
      GIM_Try, /*On fail goto*//*Label 818*/ 36538, // Rule ID 468 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhadd16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1355:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHADD16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHADD16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 468,
        GIR_Done,
      // Label 818: @36538
      GIM_Try, /*On fail goto*//*Label 819*/ 36596, // Rule ID 469 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhadd8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1356:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHADD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHADD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 469,
        GIR_Done,
      // Label 819: @36596
      GIM_Try, /*On fail goto*//*Label 820*/ 36654, // Rule ID 470 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsax,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1358:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHSAX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHSAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 470,
        GIR_Done,
      // Label 820: @36654
      GIM_Try, /*On fail goto*//*Label 821*/ 36712, // Rule ID 471 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsub16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1359:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHSUB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHSUB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 471,
        GIR_Done,
      // Label 821: @36712
      GIM_Try, /*On fail goto*//*Label 822*/ 36770, // Rule ID 472 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uhsub8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1360:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UHSUB8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UHSUB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 472,
        GIR_Done,
      // Label 822: @36770
      GIM_Try, /*On fail goto*//*Label 823*/ 36828, // Rule ID 473 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usad8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1368:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2USAD8:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2USAD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 473,
        GIR_Done,
      // Label 823: @36828
      GIM_Try, /*On fail goto*//*Label 824*/ 36886, // Rule ID 529 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_smuad,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1326:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SMUAD:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMUAD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 529,
        GIR_Done,
      // Label 824: @36886
      GIM_Try, /*On fail goto*//*Label 825*/ 36944, // Rule ID 530 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_smuadx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1327:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SMUADX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMUADX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 530,
        GIR_Done,
      // Label 825: @36944
      GIM_Try, /*On fail goto*//*Label 826*/ 37002, // Rule ID 531 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_smusd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1334:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SMUSD:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMUSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 531,
        GIR_Done,
      // Label 826: @37002
      GIM_Try, /*On fail goto*//*Label 827*/ 37060, // Rule ID 532 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_smusdx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1335:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SMUSDX:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMUSDX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 532,
        GIR_Done,
      // Label 827: @37060
      GIM_Try, /*On fail goto*//*Label 828*/ 37112, // Rule ID 546 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1131:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32B:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 546,
        GIR_Done,
      // Label 828: @37112
      GIM_Try, /*On fail goto*//*Label 829*/ 37164, // Rule ID 547 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32cb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1132:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32CB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32CB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 547,
        GIR_Done,
      // Label 829: @37164
      GIM_Try, /*On fail goto*//*Label 830*/ 37216, // Rule ID 548 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1135:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32H:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 548,
        GIR_Done,
      // Label 830: @37216
      GIM_Try, /*On fail goto*//*Label 831*/ 37268, // Rule ID 549 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32ch,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1133:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32CH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32CH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 549,
        GIR_Done,
      // Label 831: @37268
      GIM_Try, /*On fail goto*//*Label 832*/ 37320, // Rule ID 550 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1136:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32W:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 550,
        GIR_Done,
      // Label 832: @37320
      GIM_Try, /*On fail goto*//*Label 833*/ 37372, // Rule ID 551 //
        GIM_CheckFeatures, GIFBS_HasCRC_HasV8_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_crc32cw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1134:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2CRC32CW:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2CRC32CW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 551,
        GIR_Done,
      // Label 833: @37372
      GIM_Try, /*On fail goto*//*Label 834*/ 37430, // Rule ID 789 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1196:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VHADDsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 789,
        GIR_Done,
      // Label 834: @37430
      GIM_Try, /*On fail goto*//*Label 835*/ 37488, // Rule ID 790 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1196:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VHADDsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 790,
        GIR_Done,
      // Label 835: @37488
      GIM_Try, /*On fail goto*//*Label 836*/ 37546, // Rule ID 791 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1196:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VHADDsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 791,
        GIR_Done,
      // Label 836: @37546
      GIM_Try, /*On fail goto*//*Label 837*/ 37604, // Rule ID 792 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1196:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VHADDsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 792,
        GIR_Done,
      // Label 837: @37604
      GIM_Try, /*On fail goto*//*Label 838*/ 37662, // Rule ID 793 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1196:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VHADDsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 793,
        GIR_Done,
      // Label 838: @37662
      GIM_Try, /*On fail goto*//*Label 839*/ 37720, // Rule ID 794 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1196:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VHADDsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 794,
        GIR_Done,
      // Label 839: @37720
      GIM_Try, /*On fail goto*//*Label 840*/ 37778, // Rule ID 795 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1197:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VHADDuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 795,
        GIR_Done,
      // Label 840: @37778
      GIM_Try, /*On fail goto*//*Label 841*/ 37836, // Rule ID 796 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1197:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VHADDuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 796,
        GIR_Done,
      // Label 841: @37836
      GIM_Try, /*On fail goto*//*Label 842*/ 37894, // Rule ID 797 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1197:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VHADDuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 797,
        GIR_Done,
      // Label 842: @37894
      GIM_Try, /*On fail goto*//*Label 843*/ 37952, // Rule ID 798 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1197:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VHADDuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 798,
        GIR_Done,
      // Label 843: @37952
      GIM_Try, /*On fail goto*//*Label 844*/ 38010, // Rule ID 799 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1197:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VHADDuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 799,
        GIR_Done,
      // Label 844: @38010
      GIM_Try, /*On fail goto*//*Label 845*/ 38068, // Rule ID 800 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1197:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VHADDuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHADDuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 800,
        GIR_Done,
      // Label 845: @38068
      GIM_Try, /*On fail goto*//*Label 846*/ 38126, // Rule ID 801 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1258:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VRHADDsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 801,
        GIR_Done,
      // Label 846: @38126
      GIM_Try, /*On fail goto*//*Label 847*/ 38184, // Rule ID 802 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1258:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VRHADDsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 802,
        GIR_Done,
      // Label 847: @38184
      GIM_Try, /*On fail goto*//*Label 848*/ 38242, // Rule ID 803 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1258:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VRHADDsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 803,
        GIR_Done,
      // Label 848: @38242
      GIM_Try, /*On fail goto*//*Label 849*/ 38300, // Rule ID 804 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1258:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VRHADDsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 804,
        GIR_Done,
      // Label 849: @38300
      GIM_Try, /*On fail goto*//*Label 850*/ 38358, // Rule ID 805 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1258:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VRHADDsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 805,
        GIR_Done,
      // Label 850: @38358
      GIM_Try, /*On fail goto*//*Label 851*/ 38416, // Rule ID 806 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1258:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VRHADDsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 806,
        GIR_Done,
      // Label 851: @38416
      GIM_Try, /*On fail goto*//*Label 852*/ 38474, // Rule ID 807 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1259:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VRHADDuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 807,
        GIR_Done,
      // Label 852: @38474
      GIM_Try, /*On fail goto*//*Label 853*/ 38532, // Rule ID 808 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1259:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VRHADDuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 808,
        GIR_Done,
      // Label 853: @38532
      GIM_Try, /*On fail goto*//*Label 854*/ 38590, // Rule ID 809 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1259:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VRHADDuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 809,
        GIR_Done,
      // Label 854: @38590
      GIM_Try, /*On fail goto*//*Label 855*/ 38648, // Rule ID 810 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1259:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VRHADDuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 810,
        GIR_Done,
      // Label 855: @38648
      GIM_Try, /*On fail goto*//*Label 856*/ 38706, // Rule ID 811 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1259:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VRHADDuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 811,
        GIR_Done,
      // Label 856: @38706
      GIM_Try, /*On fail goto*//*Label 857*/ 38764, // Rule ID 812 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrhaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1259:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VRHADDuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRHADDuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 812,
        GIR_Done,
      // Label 857: @38764
      GIM_Try, /*On fail goto*//*Label 858*/ 38822, // Rule ID 813 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1233:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQADDsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 813,
        GIR_Done,
      // Label 858: @38822
      GIM_Try, /*On fail goto*//*Label 859*/ 38880, // Rule ID 814 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1233:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQADDsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 814,
        GIR_Done,
      // Label 859: @38880
      GIM_Try, /*On fail goto*//*Label 860*/ 38938, // Rule ID 815 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1233:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQADDsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 815,
        GIR_Done,
      // Label 860: @38938
      GIM_Try, /*On fail goto*//*Label 861*/ 38996, // Rule ID 816 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1233:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQADDsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 816,
        GIR_Done,
      // Label 861: @38996
      GIM_Try, /*On fail goto*//*Label 862*/ 39054, // Rule ID 817 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1233:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VQADDsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 817,
        GIR_Done,
      // Label 862: @39054
      GIM_Try, /*On fail goto*//*Label 863*/ 39112, // Rule ID 818 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1233:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VQADDsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 818,
        GIR_Done,
      // Label 863: @39112
      GIM_Try, /*On fail goto*//*Label 864*/ 39170, // Rule ID 819 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1233:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VQADDsv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 819,
        GIR_Done,
      // Label 864: @39170
      GIM_Try, /*On fail goto*//*Label 865*/ 39228, // Rule ID 820 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1233:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VQADDsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 820,
        GIR_Done,
      // Label 865: @39228
      GIM_Try, /*On fail goto*//*Label 866*/ 39286, // Rule ID 821 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1234:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQADDuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 821,
        GIR_Done,
      // Label 866: @39286
      GIM_Try, /*On fail goto*//*Label 867*/ 39344, // Rule ID 822 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1234:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQADDuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 822,
        GIR_Done,
      // Label 867: @39344
      GIM_Try, /*On fail goto*//*Label 868*/ 39402, // Rule ID 823 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1234:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQADDuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 823,
        GIR_Done,
      // Label 868: @39402
      GIM_Try, /*On fail goto*//*Label 869*/ 39460, // Rule ID 824 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1234:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQADDuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 824,
        GIR_Done,
      // Label 869: @39460
      GIM_Try, /*On fail goto*//*Label 870*/ 39518, // Rule ID 825 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1234:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VQADDuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 825,
        GIR_Done,
      // Label 870: @39518
      GIM_Try, /*On fail goto*//*Label 871*/ 39576, // Rule ID 826 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1234:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VQADDuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 826,
        GIR_Done,
      // Label 871: @39576
      GIM_Try, /*On fail goto*//*Label 872*/ 39634, // Rule ID 827 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1234:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VQADDuv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 827,
        GIR_Done,
      // Label 872: @39634
      GIM_Try, /*On fail goto*//*Label 873*/ 39692, // Rule ID 828 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqaddu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1234:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VQADDuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQADDuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 828,
        GIR_Done,
      // Label 873: @39692
      GIM_Try, /*On fail goto*//*Label 874*/ 39750, // Rule ID 829 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vraddhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1255:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VRADDHNv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRADDHNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 829,
        GIR_Done,
      // Label 874: @39750
      GIM_Try, /*On fail goto*//*Label 875*/ 39808, // Rule ID 830 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vraddhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1255:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VRADDHNv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRADDHNv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 830,
        GIR_Done,
      // Label 875: @39808
      GIM_Try, /*On fail goto*//*Label 876*/ 39866, // Rule ID 831 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vraddhn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1255:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VRADDHNv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRADDHNv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 831,
        GIR_Done,
      // Label 876: @39866
      GIM_Try, /*On fail goto*//*Label 877*/ 39924, // Rule ID 838 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vmulp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1222:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULpd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULpd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 838,
        GIR_Done,
      // Label 877: @39924
      GIM_Try, /*On fail goto*//*Label 878*/ 39982, // Rule ID 839 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vmulp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1222:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULpq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULpq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 839,
        GIR_Done,
      // Label 878: @39982
      GIM_Try, /*On fail goto*//*Label 879*/ 40040, // Rule ID 852 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1235:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQDMULHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 852,
        GIR_Done,
      // Label 879: @40040
      GIM_Try, /*On fail goto*//*Label 880*/ 40098, // Rule ID 853 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1235:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQDMULHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 853,
        GIR_Done,
      // Label 880: @40098
      GIM_Try, /*On fail goto*//*Label 881*/ 40156, // Rule ID 854 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1235:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQDMULHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 854,
        GIR_Done,
      // Label 881: @40156
      GIM_Try, /*On fail goto*//*Label 882*/ 40214, // Rule ID 855 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1235:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQDMULHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 855,
        GIR_Done,
      // Label 882: @40214
      GIM_Try, /*On fail goto*//*Label 883*/ 40272, // Rule ID 860 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1241:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQRDMULHv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMULHv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 860,
        GIR_Done,
      // Label 883: @40272
      GIM_Try, /*On fail goto*//*Label 884*/ 40330, // Rule ID 861 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1241:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQRDMULHv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMULHv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 861,
        GIR_Done,
      // Label 884: @40330
      GIM_Try, /*On fail goto*//*Label 885*/ 40388, // Rule ID 862 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1241:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQRDMULHv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMULHv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 862,
        GIR_Done,
      // Label 885: @40388
      GIM_Try, /*On fail goto*//*Label 886*/ 40446, // Rule ID 863 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqrdmulh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1241:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQRDMULHv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQRDMULHv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 863,
        GIR_Done,
      // Label 886: @40446
      GIM_Try, /*On fail goto*//*Label 887*/ 40504, // Rule ID 874 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vmullp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1219:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULLp8:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULLp8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 874,
        GIR_Done,
      // Label 887: @40504
      GIM_Try, /*On fail goto*//*Label 888*/ 40556, // Rule ID 875 //
        GIM_CheckFeatures, GIFBS_HasCrypto_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vmullp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1219:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VMULLp64:{ *:[v2i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULLp64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 875,
        GIR_Done,
      // Label 888: @40556
      GIM_Try, /*On fail goto*//*Label 889*/ 40614, // Rule ID 880 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1236:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQDMULLv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULLv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 880,
        GIR_Done,
      // Label 889: @40614
      GIM_Try, /*On fail goto*//*Label 890*/ 40672, // Rule ID 881 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqdmull,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1236:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQDMULLv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQDMULLv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 881,
        GIR_Done,
      // Label 890: @40672
      GIM_Try, /*On fail goto*//*Label 891*/ 40730, // Rule ID 976 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1198:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VHSUBsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 976,
        GIR_Done,
      // Label 891: @40730
      GIM_Try, /*On fail goto*//*Label 892*/ 40788, // Rule ID 977 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1198:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VHSUBsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 977,
        GIR_Done,
      // Label 892: @40788
      GIM_Try, /*On fail goto*//*Label 893*/ 40846, // Rule ID 978 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1198:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VHSUBsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 978,
        GIR_Done,
      // Label 893: @40846
      GIM_Try, /*On fail goto*//*Label 894*/ 40904, // Rule ID 979 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1198:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VHSUBsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 979,
        GIR_Done,
      // Label 894: @40904
      GIM_Try, /*On fail goto*//*Label 895*/ 40962, // Rule ID 980 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1198:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VHSUBsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 980,
        GIR_Done,
      // Label 895: @40962
      GIM_Try, /*On fail goto*//*Label 896*/ 41020, // Rule ID 981 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1198:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VHSUBsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 981,
        GIR_Done,
      // Label 896: @41020
      GIM_Try, /*On fail goto*//*Label 897*/ 41078, // Rule ID 982 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1199:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VHSUBuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 982,
        GIR_Done,
      // Label 897: @41078
      GIM_Try, /*On fail goto*//*Label 898*/ 41136, // Rule ID 983 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1199:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VHSUBuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 983,
        GIR_Done,
      // Label 898: @41136
      GIM_Try, /*On fail goto*//*Label 899*/ 41194, // Rule ID 984 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1199:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VHSUBuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 984,
        GIR_Done,
      // Label 899: @41194
      GIM_Try, /*On fail goto*//*Label 900*/ 41252, // Rule ID 985 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1199:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VHSUBuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 985,
        GIR_Done,
      // Label 900: @41252
      GIM_Try, /*On fail goto*//*Label 901*/ 41310, // Rule ID 986 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1199:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VHSUBuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 986,
        GIR_Done,
      // Label 901: @41310
      GIM_Try, /*On fail goto*//*Label 902*/ 41368, // Rule ID 987 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vhsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1199:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VHSUBuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VHSUBuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 987,
        GIR_Done,
      // Label 902: @41368
      GIM_Try, /*On fail goto*//*Label 903*/ 41426, // Rule ID 988 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1253:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQSUBsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 988,
        GIR_Done,
      // Label 903: @41426
      GIM_Try, /*On fail goto*//*Label 904*/ 41484, // Rule ID 989 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1253:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQSUBsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 989,
        GIR_Done,
      // Label 904: @41484
      GIM_Try, /*On fail goto*//*Label 905*/ 41542, // Rule ID 990 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1253:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQSUBsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 990,
        GIR_Done,
      // Label 905: @41542
      GIM_Try, /*On fail goto*//*Label 906*/ 41600, // Rule ID 991 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1253:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQSUBsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 991,
        GIR_Done,
      // Label 906: @41600
      GIM_Try, /*On fail goto*//*Label 907*/ 41658, // Rule ID 992 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 1253:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VQSUBsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 992,
        GIR_Done,
      // Label 907: @41658
      GIM_Try, /*On fail goto*//*Label 908*/ 41716, // Rule ID 993 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 1253:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VQSUBsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 993,
        GIR_Done,
      // Label 908: @41716
      GIM_Try, /*On fail goto*//*Label 909*/ 41774, // Rule ID 994 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 1253:{ *:[iPTR] }, DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VQSUBsv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 909: @41774
      GIM_Try, /*On fail goto*//*Label 910*/ 41832, // Rule ID 995 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 1253:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VQSUBsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 910: @41832
      GIM_Try, /*On fail goto*//*Label 911*/ 41890, // Rule ID 996 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 1254:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VQSUBuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 996,
        GIR_Done,
      // Label 911: @41890
      GIM_Try, /*On fail goto*//*Label 912*/ 41948, // Rule ID 997 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 1254:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VQSUBuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 997,
        GIR_Done,
      // Label 912: @41948
      GIM_Try, /*On fail goto*//*Label 913*/ 42006, // Rule ID 998 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 1254:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VQSUBuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 998,
        GIR_Done,
      // Label 913: @42006
      GIM_Try, /*On fail goto*//*Label 914*/ 42064, // Rule ID 999 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1254:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VQSUBuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQSUBuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ::zero_reg,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 999,
        GIR_Done,
      // Label 914: @42064
      GIM_Try, /*On fail goto*//*Label 915*/ 42122, // Rule ID 1000 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqsubu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::DPRReg