/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository;

import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.repository.Resource;

public final class TransferEvent
extends IvyEvent {
    private Resource resource;
    private int eventType;
    private long totalLength;
    private boolean isTotalLengthSet = false;
    private long[] timeTracking = new long[5];

    public TransferEvent(Resource resource, int n) {
        super("transfer-initiated");
        Resource resource2 = resource;
        TransferEvent transferEvent = this;
        this.resource = resource2;
        transferEvent.addAttribute("resource", transferEvent.resource.getName());
        this.setEventType(0);
        transferEvent = this;
        transferEvent.addAttribute("request-type", "get");
    }

    public final int getEventType() {
        return this.eventType;
    }

    protected final void setEventType(int n) {
        TransferEvent.checkEventType(n);
        if (this.eventType != n) {
            this.eventType = n;
            this.timeTracking[n] = System.currentTimeMillis();
            if (n > 0) {
                this.addAttribute("total-duration", String.valueOf(this.getElapsedTime(0, n)));
                if (n > 1) {
                    this.addAttribute("duration", String.valueOf(this.getElapsedTime(1, n)));
                }
            }
        }
    }

    public final long getTotalLength() {
        return this.totalLength;
    }

    protected final void setTotalLength(long l) {
        this.totalLength = l;
    }

    public final boolean isTotalLengthSet() {
        return this.isTotalLengthSet;
    }

    public final void setTotalLengthSet$1385ff() {
        this.isTotalLengthSet = true;
    }

    private long getElapsedTime(int n, int n2) {
        TransferEvent.checkEventType(n);
        TransferEvent.checkEventType(n2);
        long l = this.timeTracking[n];
        long l2 = this.timeTracking[n2];
        if (l == 0L || l2 == 0L) {
            return -1L;
        }
        if (l2 < l) {
            return 0L;
        }
        return l2 - l;
    }

    private static void checkEventType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid event type " + n);
        }
    }
}

