/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.DirectoryLister;
import com.swoval.files.SimpleFileTreeView;
import com.swoval.runtime.NativeLoader;
import com.swoval.runtime.Platform;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;

class NativeDirectoryLister
implements DirectoryLister {
    static final int UNKNOWN = 8;
    static final int DIRECTORY = 1;
    static final int FILE = 2;
    static final int LINK = 4;
    static final int EOF = 8;
    static final int ENOENT = -1;
    static final int EACCES = -2;
    static final int ENOTDIR = -3;
    static final int ESUCCESS = -4;
    private static final int MAX_ATTEMPTS = 100;

    @Override
    public SimpleFileTreeView.ListResults apply(String string, boolean bl) throws IOException {
        for (int i = 0; i < 100; ++i) {
            try {
                return this.fillResults(string);
            }
            catch (Retry retry) {
                try {
                    Thread.sleep(0L, 200);
                }
                catch (InterruptedException interruptedException) {
                    i = 100;
                }
                continue;
            }
        }
        throw new NoSuchFileException(string);
    }

    private native int errno(long var1);

    private native String strerror(int var1);

    private native long openDir(String var1);

    private native void closeDir(long var1);

    private native long nextFile(long var1);

    private native int getType(long var1);

    private native String getName(long var1);

    private void close(long l, IOException iOException) throws IOException {
        if (Platform.isWin()) {
            this.closeDir(l);
        }
        throw iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFileTreeView.ListResults fillResults(String string) throws IOException {
        SimpleFileTreeView.ListResults listResults = new SimpleFileTreeView.ListResults();
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = Platform.isWin() ? this.openDir(string + "\\*") : this.openDir(string);
        int n = this.errno(l);
        switch (n) {
            case -4: 
            case 8: {
                break;
            }
            case -1: {
                boolean bl = Platform.isWin() && Files.isDirectory(Paths.get(string, new String[0]), new LinkOption[0]);
                Object object = bl ? new Retry() : new NoSuchFileException(string);
                this.close(l, (IOException)object);
            }
            case -2: {
                this.close(l, new AccessDeniedException(string));
            }
            case -3: {
                this.close(l, new NotDirectoryException(string));
            }
            case 0: {
                break;
            }
            default: {
                boolean bl = Platform.isWin() && Files.isDirectory(Paths.get(string, new String[0]), new LinkOption[0]);
                Object object = bl ? new Retry() : new UnixException(n);
                this.close(l, (IOException)object);
            }
        }
        try {
            long l2 = this.nextFile(l);
            while (l2 != 0L) {
                int n2 = this.getType(l2);
                switch (n2) {
                    case 1: {
                        listResults.addDir(this.getName(l2));
                        break;
                    }
                    case 2: {
                        listResults.addFile(this.getName(l2));
                        break;
                    }
                    case 4: {
                        listResults.addSymlink(this.getName(l2));
                        break;
                    }
                    default: {
                        arrayList.add(this.getName(l2));
                    }
                }
                l2 = this.nextFile(l);
            }
        }
        finally {
            this.closeDir(l);
        }
        if (!arrayList.isEmpty()) {
            Path path = Paths.get(string, new String[0]);
            for (String string2 : arrayList) {
                Path path2 = path.resolve(string2);
                try {
                    BasicFileAttributes basicFileAttributes = Files.readAttributes(path2, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    if (basicFileAttributes.isDirectory()) {
                        listResults.addDir(string2);
                        continue;
                    }
                    if (basicFileAttributes.isSymbolicLink()) {
                        listResults.addSymlink(string2);
                        continue;
                    }
                    listResults.addFile(string2);
                }
                catch (IOException iOException) {}
            }
        }
        return listResults;
    }

    static {
        try {
            NativeLoader.loadPackaged();
        }
        catch (IOException | UnsatisfiedLinkError throwable) {
            throw new RuntimeException(throwable);
        }
    }

    class UnixException
    extends IOException {
        UnixException(int n) {
            super(NativeDirectoryLister.this.strerror(n));
        }
    }

    private static class Retry
    extends IOException {
        private Retry() {
        }
    }
}

