/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.ignore.cache.IgnorePatternsMatchedFilesCache;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002Rf\u0010\t\u001aZ\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r \f*,\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "fileManager", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/ProjectFileIndex;Lcom/intellij/openapi/vfs/VirtualFileManager;)V", "cache", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dispose", "", "doSearch", "Lgnu/trove/THashSet;", "pattern", "Ljava/util/regex/Pattern;", "getFilesForPattern", "runSearchRequest", "key", "Companion", "intellij.platform.vcs.impl"})
public final class IgnorePatternsMatchedFilesCache
implements Disposable {
    private final Cache<String, Collection<VirtualFile>> cache;
    private final MergingUpdateQueue updateQueue;
    private final Project project;
    private final ProjectFileIndex projectFileIndex;
    public static final Companion Companion = new Companion(null);

    public void dispose() {
        this.cache.invalidateAll();
        this.updateQueue.cancelAllUpdates();
    }

    @NotNull
    public final Collection<VirtualFile> getFilesForPattern(@NotNull Pattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        String string = pattern.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pattern.toString()");
        String key = string;
        Collection collection = (Collection)this.cache.getIfPresent((Object)key);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"cache.getIfPresent(key) ?: emptyList()");
        Collection files2 = collection;
        if (files2.isEmpty()) {
            this.runSearchRequest(key, pattern);
        }
        return files2;
    }

    private final void runSearchRequest(String key, Pattern pattern) {
        this.updateQueue.queue(new Update(this, key, pattern, key){
            final /* synthetic */ IgnorePatternsMatchedFilesCache this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ Pattern $pattern;

            public boolean canEat(@NotNull Update update) {
                Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
                return true;
            }

            public void run() {
                IgnorePatternsMatchedFilesCache.access$getCache$p(this.this$0).put((Object)this.$key, (Object)IgnorePatternsMatchedFilesCache.access$doSearch(this.this$0, this.$pattern));
            }
            {
                this.this$0 = $outer;
                this.$key = $captured_local_variable$1;
                this.$pattern = $captured_local_variable$2;
                super($super_call_param$3);
            }
        });
    }

    private final THashSet<VirtualFile> doSearch(Pattern pattern) {
        String[] parts;
        THashSet files2 = new THashSet(1000);
        String[] stringArray = RegexUtil.getParts(pattern);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"RegexUtil.getParts(pattern)");
        String[] stringArray2 = parts = stringArray;
        boolean bl = false;
        if (stringArray2.length == 0) {
            return files2;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
        GlobalSearchScope projectScope = globalSearchScope;
        this.projectFileIndex.iterateContent(new ContentIterator(this, parts, projectScope, files2){
            final /* synthetic */ IgnorePatternsMatchedFilesCache this$0;
            final /* synthetic */ String[] $parts;
            final /* synthetic */ GlobalSearchScope $projectScope;
            final /* synthetic */ THashSet $files;

            public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                Intrinsics.checkParameterIsNotNull((Object)fileOrDir, (String)"fileOrDir");
                String string = fileOrDir.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileOrDir.name");
                String name = string;
                if (RegexUtil.matchAnyPart(this.$parts, name)) {
                    boolean $i$f$runReadAction = false;
                    Iterator<E> iterator = ((Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this, name){
                        final /* synthetic */ doSearch.1 this$0;
                        final /* synthetic */ String $name$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$name$inlined = string;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)FilenameIndex.getVirtualFilesByName((Project)IgnorePatternsMatchedFilesCache.access$getProject$p(this.this$0.this$0), (String)this.$name$inlined, (GlobalSearchScope)this.this$0.$projectScope);
                        }
                    })).iterator();
                    while (iterator.hasNext()) {
                        VirtualFile file;
                        VirtualFile virtualFile = file = (VirtualFile)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                        if (!virtualFile.isValid() || !RegexUtil.matchAllParts(this.$parts, file.getPath())) continue;
                        this.$files.add((Object)file);
                    }
                }
                return true;
            }
            {
                this.this$0 = ignorePatternsMatchedFilesCache;
                this.$parts = stringArray;
                this.$projectScope = globalSearchScope;
                this.$files = tHashSet;
            }
        });
        return files2;
    }

    public IgnorePatternsMatchedFilesCache(@NotNull Project project, @NotNull ProjectFileIndex projectFileIndex, @NotNull VirtualFileManager fileManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectFileIndex, (String)"projectFileIndex");
        Intrinsics.checkParameterIsNotNull((Object)fileManager, (String)"fileManager");
        this.project = project;
        this.projectFileIndex = projectFileIndex;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        this.updateQueue = new MergingUpdateQueue("IgnorePatternsMatchedFilesCacheUpdateQueue", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        fileManager.addVirtualFileListener(new VirtualFileListener(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.cleanupCache(event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.cleanupCache(event);
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.cleanupCache((VirtualFileEvent)event);
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.cleanupCache((VirtualFileEvent)event);
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.cleanupCache((VirtualFileEvent)event);
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.isRename()) {
                    this.cleanupCache((VirtualFileEvent)event);
                }
            }

            private final void cleanupCache(VirtualFileEvent event) {
                ConcurrentMap cacheMap = cache.asMap();
                PatternCache globCache = PatternCache.getInstance(project);
                for (String key : cacheMap.keySet()) {
                    String[] parts;
                    Pattern pattern;
                    if (globCache.getPattern(key) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"globCache.getPattern(key) ?: continue");
                    Intrinsics.checkExpressionValueIsNotNull((Object)RegexUtil.getParts(pattern), (String)"RegexUtil.getParts(pattern)");
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                    if (!RegexUtil.matchAnyPart(parts, virtualFile.getPath())) continue;
                    cacheMap.remove(key);
                }
            }
        }, (Disposable)this);
    }

    public static final /* synthetic */ THashSet access$doSearch(IgnorePatternsMatchedFilesCache $this, Pattern pattern) {
        return $this.doSearch(pattern);
    }

    @JvmStatic
    @NotNull
    public static final IgnorePatternsMatchedFilesCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IgnorePatternsMatchedFilesCache getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, IgnorePatternsMatchedFilesCache.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026edFilesCache::class.java)");
            return (IgnorePatternsMatchedFilesCache)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

