/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;

@Deprecated
public abstract class Timer
implements Disposable,
Runnable {
    private final int mySpan;
    private final String myName;
    private volatile boolean myTakeInitialDelay = true;
    private Exception myInterruptedException;
    private final Object LOCK = new Object();
    private ScheduledFuture<?> myFuture;
    private TimerState myState = TimerState.startup;
    private int myPauseTime;

    public Timer(@NonNls String name, int span) {
        this.myName = name;
        this.mySpan = span;
    }

    public void setTakeInitialDelay(boolean take) {
        this.myTakeInitialDelay = take;
    }

    public final int getSpan() {
        return this.mySpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isRunning() || this.isDisposed()) {
                return;
            }
            this.myState = TimerState.startup;
            Timer.queue(this, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.LOCK;
        synchronized (object) {
            switch (this.myState) {
                case startup: {
                    this.startup();
                    break;
                }
                case restarting: {
                    this.startup();
                    break;
                }
                case initialSleep: {
                    this.myState = TimerState.running;
                    this.fireAndReschedule();
                    break;
                }
                case running: {
                    this.fireAndReschedule();
                    break;
                }
                case suspended: {
                    break;
                }
                case pausing: {
                    this.myState = TimerState.running;
                    Timer.queue(this, this.myPauseTime);
                    break;
                }
            }
        }
    }

    private void startup() {
        this.myState = TimerState.initialSleep;
        if (this.myTakeInitialDelay) {
            Timer.queue(this, this.mySpan);
        } else {
            this.fireAndReschedule();
        }
    }

    private void fireAndReschedule() {
        try {
            this.onTimer();
        }
        catch (InterruptedException e) {
            this.myInterruptedException = e;
            this.suspend();
            return;
        }
        Timer.queue(this, this.getSpan());
    }

    protected abstract void onTimer() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed() || !this.isRunning()) {
                return;
            }
            this.myState = TimerState.suspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed() || this.isRunning()) {
                return;
            }
            this.myState = TimerState.running;
            Timer.queue(this, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myState = TimerState.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myState = TimerState.restarting;
            Timer.queue(this, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myState == TimerState.running || this.myState == TimerState.initialSleep || this.myState == TimerState.restarting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myState == TimerState.disposed;
        }
    }

    public String toString() {
        return "Timer=" + this.myName;
    }

    private void setFuture(ScheduledFuture<?> schedule) {
        this.myFuture = schedule;
    }

    private static void queue(Timer timer, int span) {
        ScheduledFuture<?> future = timer.myFuture;
        if (future != null) {
            future.cancel(true);
        }
        timer.setFuture(JobScheduler.getScheduler().schedule(timer, (long)span, TimeUnit.MILLISECONDS));
    }

    private static enum TimerState {
        startup,
        initialSleep,
        running,
        suspended,
        restarting,
        pausing,
        disposed;

    }
}

