/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.update;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdateSessionAdapter;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.provider.update.HgRegularUpdater;
import org.zmlx.hg4idea.provider.update.HgUpdateConfigurationSettings;
import org.zmlx.hg4idea.ui.HgUpdateDialog;

public class HgUpdateEnvironment
implements UpdateEnvironment {
    private final Project project;
    @NotNull
    private final HgUpdateConfigurationSettings updateConfiguration;

    public HgUpdateEnvironment(Project project) {
        this.project = project;
        this.updateConfiguration = (HgUpdateConfigurationSettings)ServiceManager.getService((Project)project, HgUpdateConfigurationSettings.class);
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, UpdatedFiles updatedFiles, ProgressIndicator indicator, @NotNull Ref<SequentialUpdatesContext> context) {
        if (contentRoots == null) {
            HgUpdateEnvironment.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HgUpdateEnvironment.$$$reportNull$$$0(1);
        }
        LinkedList exceptions = new LinkedList();
        boolean[] result = new boolean[]{true};
        for (FilePath contentRoot : contentRoots) {
            VirtualFile repository;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if ((repository = ProjectLevelVcsManager.getInstance((Project)this.project).getVcsRootFor(contentRoot)) == null) continue;
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                try {
                    HgRegularUpdater updater = new HgRegularUpdater(this.project, repository, this.updateConfiguration);
                    result[0] = result[0] & updater.update(updatedFiles, indicator, exceptions);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            });
        }
        UpdateSessionAdapter updateSessionAdapter = new UpdateSessionAdapter(exceptions, !result[0]);
        if (updateSessionAdapter == null) {
            HgUpdateEnvironment.$$$reportNull$$$0(2);
        }
        return updateSessionAdapter;
    }

    public Configurable createConfigurable(Collection<FilePath> contentRoots) {
        return new UpdateConfigurable(this.updateConfiguration);
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/provider/update/HgUpdateEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/provider/update/HgUpdateEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UpdateConfigurable
    implements Configurable {
        private final HgUpdateConfigurationSettings updateConfiguration;
        protected HgUpdateDialog updateDialog;

        public UpdateConfigurable(@NotNull HgUpdateConfigurationSettings updateConfiguration) {
            if (updateConfiguration == null) {
                UpdateConfigurable.$$$reportNull$$$0(0);
            }
            this.updateConfiguration = updateConfiguration;
        }

        @Nls
        public String getDisplayName() {
            return "Update";
        }

        public String getHelpTopic() {
            return "reference.VersionControl.Mercurial.UpdateProject";
        }

        public JComponent createComponent() {
            this.updateDialog = new HgUpdateDialog();
            return this.updateDialog.getContentPanel();
        }

        public boolean isModified() {
            return true;
        }

        public void apply() {
            this.updateDialog.applyTo(this.updateConfiguration);
        }

        public void reset() {
            this.updateDialog.updateFrom(this.updateConfiguration);
        }

        public void disposeUIResources() {
            this.updateDialog = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateConfiguration", "org/zmlx/hg4idea/provider/update/HgUpdateEnvironment$UpdateConfigurable", "<init>"));
        }
    }
}

