/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.branch.ShowDiffWithBranchDialog;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBrancherImpl
implements GitBrancher {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;

    GitBrancherImpl(@NotNull Project project, @NotNull Git git) {
        if (project == null) {
            GitBrancherImpl.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBrancherImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myGit = git;
    }

    @Override
    public void checkoutNewBranch(final @NotNull String name, final @NotNull List<? extends GitRepository> repositories) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(3);
        }
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranch(name, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$1", "execute"));
            }
        }.runInBackground();
    }

    @NotNull
    private GitBranchWorker newWorker(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GitBrancherImpl.$$$reportNull$$$0(4);
        }
        GitBranchWorker gitBranchWorker = new GitBranchWorker(this.myProject, this.myGit, new GitBranchUiHandlerImpl(this.myProject, this.myGit, indicator));
        if (gitBranchWorker == null) {
            GitBrancherImpl.$$$reportNull$$$0(5);
        }
        return gitBranchWorker;
    }

    @Override
    public void createBranch(final @NotNull String name, final @NotNull Map<GitRepository, String> startPoints) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(6);
        }
        if (startPoints == null) {
            GitBrancherImpl.$$$reportNull$$$0(7);
        }
        new CommonBackgroundTask(this.myProject, "Creating branch " + name, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).createBranch(name, startPoints);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$2", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void createNewTag(final @NotNull String name, final @NotNull String reference, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(8);
        }
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(9);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(10);
        }
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).createNewTag(name, reference, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$3", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void checkout(final @NotNull String reference, final boolean detach, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(11);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(12);
        }
        new CommonBackgroundTask(this.myProject, "Checking out " + reference, callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkout(reference, detach, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$4", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void checkoutNewBranchStartingFrom(final @NotNull String newBranchName, final @NotNull String startPoint, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (newBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(13);
        }
        if (startPoint == null) {
            GitBrancherImpl.$$$reportNull$$$0(14);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(15);
        }
        new CommonBackgroundTask(this.myProject, String.format("Checking out %s from %s", newBranchName, startPoint), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranchStartingFrom(newBranchName, startPoint, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$5", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteBranch(final @NotNull String branchName, final @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(16);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(17);
        }
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteBranch(branchName, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$6", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteBranch(final @NotNull String branchName, final @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(18);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(19);
        }
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteBranch(branchName, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$7", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void compare(final @NotNull String branchName, final @NotNull List<? extends GitRepository> repositories, final @NotNull GitRepository selectedRepository) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(20);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(21);
        }
        if (selectedRepository == null) {
            GitBrancherImpl.$$$reportNull$$$0(22);
        }
        if (Registry.is((String)"git.compare.branches.as.tab")) {
            VcsLogContentUtil.runWhenLogIsReady((Project)this.myProject, (log, logManager) -> {
                VcsLogRangeFilter range = VcsLogFilterObject.fromRange((String)"HEAD", (String)branchName);
                VcsLogRootFilter roots = repositories.size() == 1 ? VcsLogFilterObject.fromRoot((VirtualFile)selectedRepository.getRoot()) : null;
                log.getTabsManager().openAnotherLogTab(logManager, VcsLogFilterObject.collection((VcsLogFilter[])new VcsLogFilter[]{range, roots}));
            });
        } else {
            new CommonBackgroundTask(this.myProject, "Comparing with " + branchName, null){

                @Override
                public void execute(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    GitBrancherImpl.this.newWorker(indicator).compare(branchName, repositories, selectedRepository);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$8", "execute"));
                }
            }.runInBackground();
        }
    }

    @Override
    public void showDiffWithLocal(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(23);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(24);
        }
        new ShowDiffWithBranchDialog(this.myProject, branchName, repositories, GitBranchUtil.getCurrentBranchOrRev(repositories)).show();
    }

    @Override
    public void merge(final @NotNull String branchName, final @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, final @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(25);
        }
        if (deleteOnMerge == null) {
            GitBrancherImpl.$$$reportNull$$$0(26);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(27);
        }
        new CommonBackgroundTask(this.myProject, "Merging " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    9.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).merge(branchName, deleteOnMerge, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$9", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void rebase(final @NotNull List<? extends GitRepository> repositories, final @NotNull String branchName) {
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(28);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(29);
        }
        new CommonBackgroundTask(this.myProject, "Rebasing onto " + branchName, null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    10.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories, branchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$10", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void rebaseOnCurrent(final @NotNull List<? extends GitRepository> repositories, final @NotNull String branchName) {
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(30);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(31);
        }
        new CommonBackgroundTask(this.myProject, "Rebasing " + branchName + "...", null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    11.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).rebaseOnCurrent(repositories, branchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$11", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void renameBranch(final @NotNull String currentName, final @NotNull String newName, final @NotNull List<? extends GitRepository> repositories) {
        if (currentName == null) {
            GitBrancherImpl.$$$reportNull$$$0(32);
        }
        if (newName == null) {
            GitBrancherImpl.$$$reportNull$$$0(33);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(34);
        }
        new CommonBackgroundTask(this.myProject, "Renaming " + currentName + " to " + newName + "...", null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    12.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).renameBranch(currentName, newName, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$12", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteTag(final @NotNull String name, final @NotNull List<? extends GitRepository> repositories) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(35);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(36);
        }
        new CommonBackgroundTask(this.myProject, "Deleting tag " + name, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    13.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteTag(name, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$13", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteTag(final @NotNull String name, final @NotNull Map<GitRepository, String> repositories) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(37);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(38);
        }
        new CommonBackgroundTask(this.myProject, "Deleting tag " + name + " on remote", null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    14.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteTag(name, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$14", "execute"));
            }
        }.runInBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBrancherImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoints";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranchName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteOnMerge";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBrancherImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newWorker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newWorker";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBranch";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNewTag";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranchStartingFrom";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deleteBranch";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteBranch";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showDiffWithLocal";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "rebaseOnCurrent";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "renameBranch";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "deleteTag";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class CommonBackgroundTask
    extends Task.Backgroundable {
        @Nullable
        private final Runnable myCallInAwtAfterExecution;

        private CommonBackgroundTask(@Nullable Project project, @NotNull String title, @Nullable Runnable callInAwtAfterExecution) {
            if (title == null) {
                CommonBackgroundTask.$$$reportNull$$$0(0);
            }
            super(project, title);
            this.myCallInAwtAfterExecution = callInAwtAfterExecution;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CommonBackgroundTask.$$$reportNull$$$0(1);
            }
            this.execute(indicator);
            if (this.myCallInAwtAfterExecution != null) {
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode()) {
                    this.myCallInAwtAfterExecution.run();
                } else {
                    application.invokeLater(this.myCallInAwtAfterExecution, application.getDefaultModalityState());
                }
            }
        }

        abstract void execute(@NotNull ProgressIndicator var1);

        void runInBackground() {
            GitVcs.runInBackground(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "git4idea/branch/GitBrancherImpl$CommonBackgroundTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

