/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileLoadingTracker;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.impl.PsiCachedValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private static final Logger LOG = Logger.getInstance(VirtualDirectoryImpl.class);
    private static final boolean CHECK = ApplicationManager.getApplication().isUnitTestMode();
    private final VfsData.DirectoryData myData;
    private final NewVirtualFileSystem myFs;

    public VirtualDirectoryImpl(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data, @Nullable VirtualDirectoryImpl parent, @NotNull NewVirtualFileSystem fs) {
        if (segment == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(0);
        }
        if (data == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(1);
        }
        if (fs == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(2);
        }
        super(id, segment, parent);
        this.myData = data;
        this.myFs = fs;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.myFs;
        if (newVirtualFileSystem == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(3);
        }
        return newVirtualFileSystem;
    }

    @Nullable
    private VirtualFileSystemEntry findChild(@NotNull String name, boolean doRefresh, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate) {
        boolean caseSensitive;
        VirtualFileSystemEntry result2;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(4);
        }
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(5);
        }
        if ((result2 = this.doFindChild(name, ensureCanonicalName, delegate, caseSensitive = delegate.isCaseSensitive())) == NULL_VIRTUAL_FILE) {
            result2 = doRefresh ? this.createAndFindChildWithEventFire(name, delegate) : null;
        } else if (result2 != null && doRefresh && delegate.isDirectory((VirtualFile)result2) != result2.isDirectory()) {
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{result2});
            result2 = this.findChild(name, false, ensureCanonicalName, delegate);
        }
        return result2;
    }

    @Nullable
    private VirtualFileSystemEntry doFindChildInArray(@NotNull String name, boolean caseSensitive) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(6);
        }
        if (this.myData.isAdoptedName(name)) {
            return NULL_VIRTUAL_FILE;
        }
        int[] array = this.myData.myChildrenIds;
        int indexInReal = this.findIndex(array, name, caseSensitive);
        if (indexInReal >= 0) {
            return this.mySegment.vfsData.getFileById(array[indexInReal], this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry doFindChild(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate, boolean caseSensitive) {
        VirtualFileSystemEntry child2;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(7);
        }
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(8);
        }
        if (name.isEmpty()) {
            return null;
        }
        if (!this.isValid()) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        VirtualFileSystemEntry found = this.doFindChildInArray(name, caseSensitive);
        if (found != null) {
            return found;
        }
        if (ensureCanonicalName) {
            String trimmedName = VirtualDirectoryImpl.deSlash(name);
            if (trimmedName == null) {
                return null;
            }
            if (!trimmedName.equals(name)) {
                found = this.doFindChildInArray(trimmedName, caseSensitive);
                if (found != null) {
                    return found;
                }
                name = trimmedName;
            }
        }
        if (this.allChildrenLoaded()) {
            return NULL_VIRTUAL_FILE;
        }
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            CharSequence persistedName;
            child2 = this.doFindChildInArray(name, caseSensitive);
            if (child2 != null) {
                return child2;
            }
            if (this.allChildrenLoaded()) {
                return null;
            }
            int id = ourPersistence.getId((VirtualFile)this, name, delegate);
            if (id <= 0) {
                this.myData.addAdoptedName(name, caseSensitive);
                return null;
            }
            int nameId = FSRecords.getNameId(id);
            if (ensureCanonicalName && !Comparing.equal((CharSequence)name, (CharSequence)(persistedName = FileNameCache.getVFileName(nameId))) && (child2 = this.doFindChildInArray(name = persistedName.toString(), caseSensitive)) != null) {
                return child2;
            }
            FileAttributes attributes = PersistentFS.toFileAttributes(ourPersistence.getFileAttributes(id));
            boolean isEmptyDirectory = attributes.isDirectory() && !ourPersistence.mayHaveChildren(id);
            child2 = this.createChild(nameId, id, delegate, attributes, isEmptyDirectory);
            this.addChild(child2);
        }
        if (!child2.isDirectory()) {
            VfsRootAccess.assertAccessInTests(child2, this.getFileSystem());
        }
        return child2;
    }

    private static String deSlash(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(9);
        }
        int startTrimmed = -1;
        int endTrimmed = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c2 = name.charAt(i);
            if (startTrimmed == -1) {
                if (VirtualDirectoryImpl.isFileSeparator(c2)) continue;
                startTrimmed = i;
                continue;
            }
            if (endTrimmed == -1) {
                if (!VirtualDirectoryImpl.isFileSeparator(c2)) continue;
                endTrimmed = i;
                continue;
            }
            if (VirtualDirectoryImpl.isFileSeparator(c2)) continue;
            return null;
        }
        if (startTrimmed == -1) {
            return null;
        }
        if (endTrimmed == -1) {
            return name.substring(startTrimmed);
        }
        if (startTrimmed == endTrimmed) {
            return null;
        }
        return name.substring(startTrimmed, endTrimmed);
    }

    private static boolean isFileSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    @NotNull
    private VirtualFileSystemEntry[] getArraySafely() {
        if (this.myId < 0) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.myData.getFileChildren(this);
        if (virtualFileSystemEntryArray == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(10);
        }
        return virtualFileSystemEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public VirtualFileSystemEntry createChild(@NotNull String name, int id, @NotNull NewVirtualFileSystem delegate, @NotNull FileAttributes attributes, boolean isEmptyDirectory) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(11);
        }
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(12);
        }
        if (attributes == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(13);
        }
        int nameId = FileNameCache.storeName(name);
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        VirtualFileSystemEntry virtualFileSystemEntry = this.createChild(nameId, id, delegate, attributes, isEmptyDirectory);
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntry != null) return virtualFileSystemEntry;
        VirtualDirectoryImpl.$$$reportNull$$$0(14);
        return virtualFileSystemEntry;
    }

    @NotNull
    private VirtualFileSystemEntry createChild(int nameId, int id, @NotNull NewVirtualFileSystem delegate, @NotNull FileAttributes attributes, boolean isEmptyDirectory) {
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(15);
        }
        if (attributes == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(16);
        }
        FileLoadingTracker.fileLoaded(this, nameId);
        VfsData.Segment segment = this.mySegment.vfsData.getSegment(id, true);
        try {
            VfsData.initFile(id, segment, nameId, attributes.isDirectory() ? new VfsData.DirectoryData() : KeyFMap.EMPTY_MAP);
        }
        catch (VfsData.FileAlreadyCreatedException e) {
            throw new RuntimeException("dir=" + this.myId + "; dir.children=" + Arrays.toString(FSRecords.listAll(this.myId)), e);
        }
        LOG.assertTrue(!(this.getFileSystem() instanceof Win32LocalFileSystem));
        VirtualFileSystemEntry child2 = this.mySegment.vfsData.getFileById(id, this);
        assert (child2 != null);
        segment.setFlag(id, 0x20000000, attributes.isSymLink());
        segment.setFlag(id, Integer.MIN_VALUE, attributes.isSpecial());
        segment.setFlag(id, 0x1000000, attributes.isWritable());
        segment.setFlag(id, 0x2000000, attributes.isHidden());
        child2.updateLinkStatus();
        if (delegate.markNewFilesAsDirty()) {
            child2.markDirty();
        }
        if (attributes.isDirectory() && child2 instanceof VirtualDirectoryImpl && isEmptyDirectory) {
            ((VirtualDirectoryImpl)child2).setChildrenLoaded();
        }
        VirtualFileSystemEntry virtualFileSystemEntry = child2;
        if (virtualFileSystemEntry == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(17);
        }
        return virtualFileSystemEntry;
    }

    @Nullable
    private VirtualFileSystemEntry createAndFindChildWithEventFire(@NotNull String name, @NotNull NewVirtualFileSystem delegate) {
        FakeVirtualFile fake;
        FileAttributes attributes;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(18);
        }
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(19);
        }
        if ((attributes = delegate.getAttributes((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)this, name)))) == null) {
            return null;
        }
        String realName = delegate.getCanonicallyCasedName((VirtualFile)fake);
        boolean isDirectory = attributes.isDirectory();
        boolean isEmptyDirectory = isDirectory && !delegate.hasChildren((VirtualFile)fake);
        String symlinkTarget = attributes.isSymLink() ? delegate.resolveSymLink((VirtualFile)fake) : null;
        ChildInfo[] children2 = isEmptyDirectory ? ChildInfo.EMPTY_ARRAY : null;
        VFileCreateEvent event = new VFileCreateEvent(null, (VirtualFile)this, realName, isDirectory, attributes, symlinkTarget, true, children2);
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)event);
        return this.findChild(realName);
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(20);
        }
        return this.findChild(name, true, true, this.getFileSystem());
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        boolean caseSensitive;
        VirtualFileSystemEntry found;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(21);
        }
        return (found = this.doFindChildInArray(name, caseSensitive = this.getFileSystem().isCaseSensitive())) == NULL_VIRTUAL_FILE ? null : found;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(22);
            }
            return list2;
        }
        if (ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            List<VirtualFile> list3 = Arrays.asList(this.getChildren());
            if (list3 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(23);
            }
            return list3;
        }
        this.loadPersistedChildren();
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildrenWithoutLoadingVfsFromOtherProjects() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(25);
            }
            return list2;
        }
        if (!ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            this.loadPersistedChildren();
        }
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(26);
        }
        return collection;
    }

    private void loadPersistedChildren() {
        String[] names2 = ourPersistence.listPersisted((VirtualFile)this);
        NewVirtualFileSystem delegate = PersistentFS.replaceWithNativeFS(this.getFileSystem());
        for (String name : names2) {
            this.findChild(name, false, false, delegate);
        }
    }

    @NotNull
    public VirtualFile[] getChildren() {
        if (!this.isValid()) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        if (this.allChildrenLoaded()) {
            VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.getArraySafely();
            if (virtualFileSystemEntryArray == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(27);
            }
            return virtualFileSystemEntryArray;
        }
        VirtualFile[] virtualFileArray = this.loadAllChildren();
        if (virtualFileArray == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(28);
        }
        return virtualFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private VirtualFile[] loadAllChildren() {
        VirtualFile[] files2;
        NewVirtualFileSystem delegate = this.getFileSystem();
        boolean caseSensitive = delegate.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        boolean wasChildrenLoaded = ourPersistence.areChildrenLoaded((VirtualFile)this);
        FSRecords.NameId[] childrenIds = ourPersistence.listAll((VirtualFile)this);
        int[] result2 = ArrayUtil.newIntArray((int)childrenIds.length);
        VirtualFile[] virtualFileArray = files2 = childrenIds.length == 0 ? VirtualFile.EMPTY_ARRAY : new VirtualFile[childrenIds.length];
        if (childrenIds.length != 0) {
            Arrays.sort(childrenIds, (o1, o2) -> {
                CharSequence name1 = o1.name;
                CharSequence name2 = o2.name;
                int cmp = VirtualDirectoryImpl.compareNames(name1, name2, caseSensitive);
                if (cmp == 0 && name1 != name2) {
                    LOG.error((Object)((Object)ourPersistence) + " returned duplicate file names(" + name1 + "," + name2 + ") caseSensitive: " + caseSensitive + " SystemInfo.isFileSystemCaseSensitive: " + SystemInfo.isFileSystemCaseSensitive + " SystemInfo.OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " wasChildrenLoaded: " + wasChildrenLoaded + " in the dir: " + (Object)((Object)this) + "; children: " + Arrays.toString(childrenIds));
                }
                return cmp;
            });
            TIntHashSet prevChildren = new TIntHashSet(this.myData.myChildrenIds);
            for (int i = 0; i < childrenIds.length; ++i) {
                FSRecords.NameId child2 = childrenIds[i];
                result2[i] = child2.id;
                assert (child2.id > 0) : child2;
                prevChildren.remove(child2.id);
                VirtualFileSystemEntry file2 = this.mySegment.vfsData.getFileById(child2.id, this);
                if (file2 == null) {
                    FileAttributes attributes = PersistentFS.toFileAttributes(ourPersistence.getFileAttributes(child2.id));
                    boolean isEmptyDirectory = attributes.isDirectory() && !ourPersistence.mayHaveChildren(child2.id);
                    file2 = this.createChild(child2.nameId, child2.id, delegate, attributes, isEmptyDirectory);
                }
                files2[i] = file2;
            }
            if (!prevChildren.isEmpty()) {
                LOG.error("Loaded child disappeared: parent=" + VirtualDirectoryImpl.verboseToString(this) + "; child=" + VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(prevChildren.toArray()[0], this)));
            }
        }
        this.myData.clearAdoptedNames();
        this.myData.myChildrenIds = result2;
        this.setChildrenLoaded();
        if (CHECK) {
            this.assertConsistency(caseSensitive, Arrays.asList(childrenIds));
        }
        // MONITOREXIT : directoryData
        if (files2 != null) return files2;
        VirtualDirectoryImpl.$$$reportNull$$$0(29);
        return files2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertConsistency(boolean caseSensitive, @NotNull Object details) {
        if (details == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(30);
        }
        if (!CHECK || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        int[] childrenIds = this.myData.myChildrenIds;
        if (childrenIds.length == 0) {
            return;
        }
        CharSequence prevName = this.mySegment.vfsData.getNameByFileId(childrenIds[0]);
        for (int i = 1; i < childrenIds.length; ++i) {
            int id = childrenIds[i];
            int prev = childrenIds[i - 1];
            CharSequence name = this.mySegment.vfsData.getNameByFileId(id);
            int cmp = VirtualDirectoryImpl.compareNames(name, prevName, caseSensitive);
            prevName = name;
            if (cmp <= 0) {
                VirtualDirectoryImpl.error(VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(prev, this)) + " is wrongly placed before " + VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(id, this)), this.getArraySafely(), details);
            }
            VfsData.DirectoryData directoryData = this.myData;
            synchronized (directoryData) {
                if (this.myData.isAdoptedName(name)) {
                    try {
                        VirtualDirectoryImpl.error("In " + VirtualDirectoryImpl.verboseToString(this) + " file '" + name + "' is both child and adopted", this.getArraySafely(), "Adopted: " + this.myData.getAdoptedNames() + ";\n " + details);
                    }
                    finally {
                        this.myData.removeAdoptedName(name);
                    }
                }
                continue;
            }
        }
    }

    @NotNull
    private static String verboseToString(VirtualFileSystemEntry file2) {
        if (file2 == null) {
            if ("null" == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(31);
            }
            return "null";
        }
        String string = (Object)((Object)file2) + " (name: '" + file2.getName() + "', " + ((Object)((Object)file2)).getClass() + ", parent: " + (Object)((Object)file2.getParent()) + "; id: " + file2.getId() + "; FS: " + file2.getFileSystem() + "; delegate.attrs: " + file2.getFileSystem().getAttributes((VirtualFile)file2) + "; caseSensitive: " + file2.getFileSystem().isCaseSensitive() + "; canonical: " + file2.getFileSystem().getCanonicallyCasedName((VirtualFile)file2) + ") ";
        if (string == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static void error(String message, VirtualFileSystemEntry[] array, Object ... details) {
        String children2 = StringUtil.join((Object[])array, VirtualDirectoryImpl::verboseToString, (String)"\n");
        String detailsStr = StringUtil.join((Iterable)ContainerUtil.map((Object[])details, o -> o instanceof Object[] ? Arrays.toString((Object[])o) : o), (String)"\n");
        throw new AssertionError((Object)(message + "; children: " + children2 + "\nDetails: " + detailsStr));
    }

    @Nullable
    public VirtualFileSystemEntry findChild(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(33);
        }
        return this.findChild(name, false, true, this.getFileSystem());
    }

    public VirtualFileSystemEntry doFindChildById(int id) {
        int i = ArrayUtil.indexOf((int[])this.myData.myChildrenIds, (int)id);
        if (i >= 0) {
            return this.mySegment.vfsData.getFileById(id, this);
        }
        String name = ourPersistence.getName(id);
        return this.findChild(name, false, false, this.getFileSystem());
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of directory: " + (Object)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndAddChildren(@NotNull List<? extends ChildInfo> added, boolean markAllChildrenLoaded, @NotNull PairConsumer<? super VirtualFile, ? super ChildInfo> fileCreated2) {
        if (added == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(34);
        }
        if (fileCreated2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(35);
        }
        if (added.size() <= 1) {
            for (int i = 0; i < added.size(); ++i) {
                VirtualFileSystemEntry file2;
                ChildInfo info = added.get(i);
                assert (info.getId() > 0) : info;
                FileAttributes attributes = info.getFileAttributes();
                boolean isEmptyDirectory = info.getChildren() != null && info.getChildren().length == 0;
                VfsData.DirectoryData directoryData = this.myData;
                synchronized (directoryData) {
                    file2 = this.createChild(info.getNameId(), info.getId(), this.getFileSystem(), attributes, isEmptyDirectory);
                }
                this.addChild(file2);
                fileCreated2.consume((Object)file2, (Object)info);
            }
            if (markAllChildrenLoaded) {
                this.setChildrenLoaded();
            }
            return;
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        Comparator pairComparator = (p1, p2) -> VirtualDirectoryImpl.compareNames(p1.getName(), p2.getName(), caseSensitive);
        added.sort(pairComparator);
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            final int[] oldIds = this.myData.myChildrenIds;
            TIntArrayList mergedIds = new TIntArrayList(oldIds.length + added.size());
            for (int i = 0; i < added.size(); ++i) {
                ChildInfo info = added.get(i);
                assert (info.getId() > 0) : info;
                FileAttributes attributes = info.getFileAttributes();
                boolean isEmptyDirectory = info.getChildren() != null && info.getChildren().length == 0;
                this.myData.removeAdoptedName(info.getName());
                VirtualFileSystemEntry file3 = this.createChild(info.getNameId(), info.getId(), this.getFileSystem(), attributes, isEmptyDirectory);
                fileCreated2.consume((Object)file3, (Object)info);
            }
            AbstractList<ChildInfo> existingChildren = new AbstractList<ChildInfo>(){

                @Override
                public ChildInfo get(int index) {
                    int id = oldIds[index];
                    int nameId = VirtualDirectoryImpl.this.mySegment.vfsData.getNameId(id);
                    return new ChildInfoImpl(id, nameId, null, null, null);
                }

                @Override
                public int size() {
                    return oldIds.length;
                }
            };
            ContainerUtil.processSortedListsInOrder(added, (List)existingChildren, (Comparator)pairComparator, (boolean)true, nextInfo -> mergedIds.add(nextInfo.getId()));
            this.myData.myChildrenIds = mergedIds.toNativeArray();
            if (markAllChildrenLoaded) {
                this.setChildrenLoaded();
            }
            this.assertConsistency(caseSensitive, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull VirtualFileSystemEntry child2) {
        if (child2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(36);
        }
        CharSequence childName = child2.getNameSequence();
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            this.myData.removeAdoptedName(childName);
            int indexInReal = this.findIndex(this.myData.myChildrenIds, childName, caseSensitive);
            if (indexInReal < 0) {
                this.insertChildAt(child2, indexInReal);
            }
            this.assertConsistency(caseSensitive, (Object)child2);
        }
    }

    private void insertChildAt(@NotNull VirtualFileSystemEntry file2, int negativeIndex) {
        if (file2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(37);
        }
        int i = -negativeIndex - 1;
        int id = file2.getId();
        assert (id > 0) : file2;
        this.myData.myChildrenIds = ArrayUtil.insert((int[])this.myData.myChildrenIds, (int)i, (int)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(38);
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        String name = file2.getName();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int indexInReal = this.findIndex(this.myData.myChildrenIds, name, caseSensitive);
            if (indexInReal >= 0) {
                this.myData.myChildrenIds = ArrayUtil.remove((int[])this.myData.myChildrenIds, (int)indexInReal);
            }
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedName(name, caseSensitive);
            }
            this.assertConsistency(caseSensitive, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(@NotNull TIntHashSet idsToRemove, @NotNull List<? extends CharSequence> namesToRemove) {
        if (idsToRemove == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(39);
        }
        if (namesToRemove == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(40);
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int[] newIds = new int[this.myData.myChildrenIds.length];
            int[] oldIds = this.myData.myChildrenIds;
            int o = 0;
            for (int oldId : oldIds) {
                if (idsToRemove.contains(oldId)) continue;
                newIds[o++] = oldId;
            }
            if (o != newIds.length) {
                newIds = o == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : Arrays.copyOf(newIds, o);
            }
            this.myData.myChildrenIds = newIds;
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedNames(namesToRemove, caseSensitive);
            }
            this.assertConsistency(caseSensitive, namesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateChildrenToCreate(@NotNull List<? extends VFileCreateEvent> childrenToCreate) {
        if (childrenToCreate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(41);
        }
        if (childrenToCreate.size() <= 1) {
            for (int i = childrenToCreate.size() - 1; i >= 0; --i) {
                VFileCreateEvent event = childrenToCreate.get(i);
                if (event.isValid()) continue;
                childrenToCreate.remove(i);
            }
            return;
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        CharSequenceHashingStrategy strategy = caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE;
        THashSet existingNames = new THashSet(this.myData.myChildrenIds.length, (TObjectHashingStrategy)strategy);
        for (int id : this.myData.myChildrenIds) {
            existingNames.add(this.mySegment.vfsData.getNameByFileId(id));
        }
        int id = this.getId();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            if (id >= 0) {
                FSRecords.NameId[] persistentIds;
                for (FSRecords.NameId nameId : persistentIds = FSRecords.listAll(id)) {
                    existingNames.add(nameId.name);
                }
            }
            this.validateAgainst(childrenToCreate, (Set<CharSequence>)existingNames);
            if (!childrenToCreate.isEmpty() && !this.allChildrenLoaded()) {
                int beforeSize = existingNames.size();
                String[] names2 = this.getFileSystem().list((VirtualFile)this);
                existingNames.addAll(Arrays.asList(names2));
                if (beforeSize != existingNames.size()) {
                    this.validateAgainst(childrenToCreate, (Set<CharSequence>)existingNames);
                }
            }
        }
    }

    private void validateAgainst(@NotNull List<? extends VFileCreateEvent> childrenToCreate, @NotNull Set<CharSequence> existingNames) {
        if (childrenToCreate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(42);
        }
        if (existingNames == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(43);
        }
        for (int i = childrenToCreate.size() - 1; i >= 0; --i) {
            boolean childExists;
            VFileCreateEvent event = childrenToCreate.get(i);
            String childName = event.getChildName();
            boolean bl = childExists = !this.myData.isAdoptedName(childName) && existingNames.contains(childName);
            if (!childExists) continue;
            childrenToCreate.remove(i);
        }
    }

    public boolean allChildrenLoaded() {
        return this.getFlagInt(0x8000000);
    }

    private void setChildrenLoaded() {
        this.setFlagInt(0x8000000, true);
    }

    @NotNull
    public List<String> getSuspiciousNames() {
        List<String> list2 = this.myData.getAdoptedNames();
        if (list2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(44);
        }
        return list2;
    }

    private int findIndex(@NotNull int[] ids, @NotNull CharSequence name, boolean caseSensitive) {
        if (ids == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(45);
        }
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(46);
        }
        return ObjectUtils.binarySearch((int)0, (int)ids.length, mid -> VirtualDirectoryImpl.compareNames(this.mySegment.vfsData.getNameByFileId(ids[mid]), name, caseSensitive));
    }

    private static int compareNames(@NotNull CharSequence name1, @NotNull CharSequence name2, boolean caseSensitive) {
        int d;
        if (name1 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(47);
        }
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(48);
        }
        if ((d = name1.length() - name2.length()) != 0) {
            return d;
        }
        for (int i = 0; i < name1.length(); ++i) {
            d = StringUtil.compare((char)name1.charAt(i), (char)name2.charAt(i), (!caseSensitive ? 1 : 0) != 0);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public List<VirtualFile> getCachedChildren() {
        List<VirtualFileSystemEntry> list2 = Arrays.asList(this.getArraySafely());
        if (list2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(49);
        }
        return list2;
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }

    @Override
    public void markDirtyRecursively() {
        this.markDirty();
        this.markDirtyRecursivelyInternal();
    }

    private void markDirtyRecursivelyInternal() {
        for (VirtualFileSystemEntry child2 : this.getArraySafely()) {
            child2.markDirtyInternal();
            if (!(child2 instanceof VirtualDirectoryImpl)) continue;
            ((VirtualDirectoryImpl)child2).markDirtyRecursivelyInternal();
        }
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        if (map2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(50);
        }
        this.myData.myUserMap = map2;
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = this.myData.myUserMap;
        if (keyFMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(51);
        }
        return keyFMap;
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.myData.changeUserMap(oldMap, UserDataInterner.internUserData(newMap));
    }

    static void checkLeaks(KeyFMap newMap) {
        for (Key key : newMap.getKeys()) {
            if (key != null && newMap.get(key) instanceof PsiCachedValue) {
                throw new AssertionError((Object)"Don't store CachedValue in VFS user data, since it leads to memory leaks");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 18: 
            case 20: 
            case 21: 
            case 33: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCreated";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idsToRemove";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToRemove";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenToCreate";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArraySafely";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildren";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildrenWithoutLoadingVfsFromOtherProjects";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAllChildren";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "verboseToString";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspiciousNames";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedChildren";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 51: {
                break;
            }
            case 4: 
            case 5: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFindChildInArray";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doFindChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deSlash";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createAndFindChildWithEventFire";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindChild";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findChildIfCached";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "assertConsistency";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddChildren";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "insertChildAt";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeChildren";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "validateChildrenToCreate";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "validateAgainst";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findIndex";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "compareNames";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

