/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectStoreFactory;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.TimedReference;
import java.util.List;
import javax.swing.JFrame;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;
import org.picocontainer.MutablePicoContainer;

public class ProjectImpl
extends PlatformComponentManagerImpl
implements ProjectEx,
ProjectStoreOwner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.project.impl.ProjectImpl");
    public static final String NAME_FILE = ".name";
    public static final Key<Long> CREATION_TIME = Key.create((String)"ProjectImpl.CREATION_TIME");
    @Deprecated
    public static final Key<String> CREATION_TRACE = Key.create((String)"ProjectImpl.CREATION_TRACE");
    public static final String LIGHT_PROJECT_NAME = "light_temp";
    private String myName;
    private final boolean myLight;
    static boolean ourClassesAreLoaded;
    private final String creationTrace;
    private final AtomicNotNullLazyValue<IComponentStore> myComponentStore;
    static final String TEMPLATE_PROJECT_NAME = "Default (Template) Project";
    private volatile boolean temporarilyDisposed;

    protected ProjectImpl(@NotNull String filePath, @Nullable String projectName) {
        if (filePath == null) {
            ProjectImpl.$$$reportNull$$$0(0);
        }
        super((ComponentManager)ApplicationManager.getApplication(), "Project " + (projectName == null ? filePath : projectName));
        this.myComponentStore = AtomicNotNullLazyValue.createValue(() -> ((ProjectStoreFactory)ServiceManager.getService(ProjectStoreFactory.class)).createStore(this));
        this.putUserData(CREATION_TIME, System.nanoTime());
        this.creationTrace = ApplicationManager.getApplication().isUnitTestMode() ? DebugUtil.currentStackTrace() : null;
        this.getPicoContainer().registerComponentInstance(Project.class, (Object)this);
        this.myName = projectName;
        this.myLight = ApplicationManager.getApplication().isUnitTestMode() && filePath.contains(LIGHT_PROJECT_NAME);
    }

    ProjectImpl() {
        super((ComponentManager)ApplicationManager.getApplication(), TEMPLATE_PROJECT_NAME);
        this.myComponentStore = AtomicNotNullLazyValue.createValue(() -> ((ProjectStoreFactory)ServiceManager.getService(ProjectStoreFactory.class)).createStore(this));
        this.putUserData(CREATION_TIME, System.nanoTime());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.putUserData(CREATION_TRACE, DebugUtil.currentStackTrace());
        }
        this.creationTrace = ApplicationManager.getApplication().isUnitTestMode() ? DebugUtil.currentStackTrace() : null;
        this.myName = TEMPLATE_PROJECT_NAME;
        this.myLight = false;
    }

    @Override
    public boolean isDisposed() {
        return super.isDisposed() || this.temporarilyDisposed;
    }

    public boolean isLight() {
        return this.myLight;
    }

    void setTemporarilyDisposed(boolean disposed) {
        this.temporarilyDisposed = disposed;
    }

    boolean isTemporarilyDisposed() {
        return this.temporarilyDisposed;
    }

    @Override
    public void setProjectName(@NotNull String projectName) {
        if (projectName == null) {
            ProjectImpl.$$$reportNull$$$0(1);
        }
        if (!projectName.equals(this.myName)) {
            this.myName = projectName;
            StartupManager.getInstance((Project)this).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
                if (this.isDisposed()) {
                    return;
                }
                JFrame frame = WindowManager.getInstance().getFrame((Project)this);
                String title = FrameTitleBuilder.getInstance().getProjectTitle(this);
                if (frame != null && title != null) {
                    frame.setTitle(title);
                }
            }));
        }
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            ProjectImpl.$$$reportNull$$$0(2);
        }
        Extensions.instantiateArea((String)"IDEA_PROJECT", (AreaInstance)this, null);
        super.bootstrapPicoContainer(name);
        this.getPicoContainer().registerComponentImplementation(PathMacroManager.class, ProjectPathMacroManager.class);
    }

    @NotNull
    public final IProjectStore getStateStore() {
        IProjectStore iProjectStore = (IProjectStore)this.getComponentStore();
        if (iProjectStore == null) {
            ProjectImpl.$$$reportNull$$$0(3);
        }
        return iProjectStore;
    }

    @Override
    @NotNull
    public IComponentStore getComponentStore() {
        IComponentStore iComponentStore = (IComponentStore)this.myComponentStore.getValue();
        if (iComponentStore == null) {
            ProjectImpl.$$$reportNull$$$0(4);
        }
        return iComponentStore;
    }

    public boolean isOpen() {
        return ProjectManagerEx.getInstanceEx().isProjectOpened(this);
    }

    public boolean isInitialized() {
        return !this.isDisposed() && this.isOpen() && StartupManagerEx.getInstanceEx(this).startupActivityPassed();
    }

    @Override
    @NotNull
    public List<ComponentConfig> getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            ProjectImpl.$$$reportNull$$$0(5);
        }
        List list2 = plugin.getProjectComponents();
        if (list2 == null) {
            ProjectImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<ServiceDescriptor> getServices(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            ProjectImpl.$$$reportNull$$$0(7);
        }
        List<ServiceDescriptor> list2 = ((IdeaPluginDescriptorImpl)pluginDescriptor).getProjectServices();
        if (list2 == null) {
            ProjectImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Nullable
    public @SystemIndependent String getProjectFilePath() {
        return this.getStateStore().getProjectFilePath();
    }

    public VirtualFile getProjectFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.getStateStore().getProjectFilePath());
    }

    public VirtualFile getBaseDir() {
        return LocalFileSystem.getInstance().findFileByPath(this.getStateStore().getProjectBasePath());
    }

    @Nullable
    public @SystemIndependent String getBasePath() {
        return this.getStateStore().getProjectBasePath();
    }

    @NotNull
    public String getName() {
        if (this.myName == null) {
            String string = this.getStateStore().getProjectName();
            if (string == null) {
                ProjectImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            ProjectImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public @SystemDependent String getPresentableUrl() {
        IProjectStore store = this.getStateStore();
        return PathUtil.toSystemDependentName((String)(store.getStorageScheme() == StorageScheme.DIRECTORY_BASED ? store.getProjectBasePath() : store.getProjectFilePath()));
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        String str = this.getPresentableUrl();
        if (str == null) {
            str = this.getName();
        }
        String prefix = this.getStateStore().getStorageScheme() == StorageScheme.DIRECTORY_BASED ? "" : this.getName();
        String string = prefix + Integer.toHexString(str.hashCode());
        if (string == null) {
            ProjectImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public VirtualFile getWorkspaceFile() {
        String workspaceFilePath = this.getStateStore().getWorkspaceFilePath();
        return workspaceFilePath == null ? null : LocalFileSystem.getInstance().findFileByPath(workspaceFilePath);
    }

    public void registerComponents() {
        Application app;
        String activityNamePrefix = this.activityNamePrefix();
        Activity activity = activityNamePrefix == null ? null : StartUpMeasurer.start((String)(activityNamePrefix + "component registration"));
        this.registerComponents(PluginManagerCore.getLoadedPlugins());
        if (activity != null) {
            activity.end();
        }
        if ((app = ApplicationManager.getApplication()).isUnitTestMode()) {
            ((ProjectLifecycleListener)app.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsRegistered((Project)this);
        }
    }

    public void init(@Nullable ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        this.createComponents(indicator);
        if (indicator != null && !application.isHeadlessEnvironment()) {
            this.distributeProgress(indicator);
        }
        if (this.myName == null) {
            this.myName = this.getStateStore().getProjectName();
        }
        ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsInitialized((Project)this);
    }

    @Override
    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProjectImpl.$$$reportNull$$$0(12);
        }
        indicator.setFraction(this.getPercentageOfComponentsLoaded() / (double)(ourClassesAreLoaded ? 10 : 2));
    }

    private void distributeProgress(@NotNull ProgressIndicator indicator) {
        double modulesPart;
        ModuleManager moduleManager;
        if (indicator == null) {
            ProjectImpl.$$$reportNull$$$0(13);
        }
        if (!((moduleManager = ModuleManager.getInstance((Project)this)) instanceof ModuleManagerImpl)) {
            return;
        }
        double toDistribute = 1.0 - indicator.getFraction();
        int modulesCount = ((ModuleManagerImpl)moduleManager).getModulePathsCount();
        EditorsSplitters splitters = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)this)).getMainSplitters();
        int editors = splitters.getEditorsCount();
        double d = modulesPart = ourClassesAreLoaded || editors == 0 ? toDistribute : toDistribute * 0.5;
        if (modulesCount != 0) {
            double step = modulesPart / (double)modulesCount;
            ((ModuleManagerImpl)moduleManager).setProgressStep(step);
        }
        if (editors != 0) {
            splitters.setProgressStep(toDistribute - modulesPart / (double)editors);
        }
    }

    public void save() {
        if (!ApplicationManagerEx.getApplicationEx().isSaveAllowed()) {
            return;
        }
        if (!this.isInitialized()) {
            LOG.debug("Skip save for " + this.getName() + ": not initialized");
            return;
        }
        StoreUtil.saveSettings(this, false);
    }

    @Override
    public synchronized void dispose() {
        Application application = ApplicationManager.getApplication();
        application.assertWriteAccessAllowed();
        if (ProjectManagerEx.getInstanceEx().isProjectOpened(this)) {
            throw new IllegalStateException("Must call .dispose() for a closed project only. See ProjectManager.closeProject() or ProjectUtil.closeAndDispose().");
        }
        LOG.assertTrue(!super.isDisposed(), (Object)(this + " is disposed already"));
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        super.dispose();
        if (!application.isDisposed()) {
            ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).afterProjectClosed((Project)this);
        }
        ((ProjectManagerImpl)ProjectManager.getInstance()).updateTheOnlyProjectField();
        TimedReference.disposeTimed();
        LaterInvocator.purgeExpiredItems();
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ProjectImpl.$$$reportNull$$$0(14);
        }
        Object[] objectArray = Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            ProjectImpl.$$$reportNull$$$0(15);
        }
        return objectArray;
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        MutablePicoContainer mutablePicoContainer = Extensions.getArea((AreaInstance)this).getPicoContainer();
        if (mutablePicoContainer == null) {
            ProjectImpl.$$$reportNull$$$0(16);
        }
        return mutablePicoContainer;
    }

    public boolean isDefault() {
        return false;
    }

    @NonNls
    public String toString() {
        return "Project" + (this.isDisposed() ? " (Disposed" + (this.temporarilyDisposed ? " temporarily" : "") + ")" : " '" + this.getPresentableUrl() + "'") + " " + this.myName;
    }

    public String getCreationTrace() {
        return this.creationTrace;
    }

    @Override
    @Nullable
    protected String activityNamePrefix() {
        return "project ";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ProjectImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ProjectImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateStore";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentStore";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyComponentConfigsFromDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationHash";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createPicoContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProjectName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bootstrapPicoContainer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMyComponentConfigsFromDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDuringInit";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "distributeProgress";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

