/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/FontSizeInfoUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "getData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "getGroupId", "", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "intellij.platform.ide.impl"})
public final class FontSizeInfoUsageCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        String quickDocFontSize;
        boolean bl;
        Object appPrefs;
        boolean bl2;
        Iterable iterable;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        EditorColorsScheme scheme = editorColorsScheme;
        UISettings ui = UISettings.Companion.getShadowInstance();
        Set usages = SetsKt.mutableSetOf((Object[])new UsageDescriptor[]{new UsageDescriptor("UI.font.size[" + ui.getFontSize() + ']'), new UsageDescriptor(UsageDescriptorKeyValidator.ensureProperKey("UI.font.name[" + ui.getFontFace() + ']')), new UsageDescriptor("Presentation.mode.font.size[" + ui.getPresentationModeFontSize() + ']')});
        if (!scheme.isUseAppFontPreferencesInEditor()) {
            Collection collection = usages;
            iterable = SetsKt.setOf((Object[])new UsageDescriptor[]{new UsageDescriptor("Editor.font.size[" + scheme.getEditorFontSize() + ']'), new UsageDescriptor(UsageDescriptorKeyValidator.ensureProperKey("Editor.font.name[" + scheme.getEditorFontName() + ']'))});
            bl2 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        } else {
            AppEditorFontOptions appEditorFontOptions = AppEditorFontOptions.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)appEditorFontOptions, (String)"AppEditorFontOptions.getInstance()");
            FontPreferences fontPreferences = appEditorFontOptions.getFontPreferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)fontPreferences, (String)"AppEditorFontOptions.getInstance().fontPreferences");
            appPrefs = fontPreferences;
            iterable = usages;
            Iterable iterable2 = SetsKt.setOf((Object[])new UsageDescriptor[]{new UsageDescriptor("IDE.editor.font.size[" + appPrefs.getSize(appPrefs.getFontFamily()) + ']'), new UsageDescriptor(UsageDescriptorKeyValidator.ensureProperKey("IDE.editor.font.name[" + appPrefs.getFontFamily() + ']'))});
            bl = false;
            CollectionsKt.addAll((Collection)iterable, (Iterable)iterable2);
        }
        if (!scheme.isUseEditorFontPreferencesInConsole()) {
            appPrefs = usages;
            iterable = SetsKt.setOf((Object[])new UsageDescriptor[]{new UsageDescriptor("Console.font.size[" + scheme.getConsoleFontSize() + ']'), new UsageDescriptor(UsageDescriptorKeyValidator.ensureProperKey("Console.font.name[" + scheme.getConsoleFontName() + ']'))});
            bl2 = false;
            CollectionsKt.addAll((Collection)appPrefs, (Iterable)iterable);
        }
        if ((quickDocFontSize = PropertiesComponent.getInstance().getValue("quick.doc.font.size")) != null) {
            iterable = usages;
            Iterable iterable3 = SetsKt.setOf((Object)new UsageDescriptor("QuickDoc.font.size[" + quickDocFontSize + ']'));
            bl = false;
            CollectionsKt.addAll((Collection)iterable, (Iterable)iterable3);
        }
        EditorColorsManager editorColorsManager2 = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager2, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme2 = editorColorsManager2.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme2, (String)"EditorColorsManager.getInstance().globalScheme");
        float lineSpacing = editorColorsScheme2.getLineSpacing();
        FeatureUsageData usageData = new FeatureUsageData();
        usageData.addData("value", lineSpacing);
        usages.add(new UsageDescriptor("editor.lineSpacing", usageData));
        return usages;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "ui.fonts";
    }

    @Override
    @Nullable
    public FeatureUsageData getData() {
        return new FeatureUsageData().addOS();
    }
}

