/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QuickChangeLookAndFeel;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.ColorBlindnessPanel;
import com.intellij.ide.ui.LCDRenderingScope;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Window;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class AppearanceConfigurable
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.AppearanceConfigurable");
    private MyComponent myComponent;

    public String getDisplayName() {
        return IdeBundle.message((String)"title.appearance", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            AppearanceConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        UISettings settings = UISettings.getInstance();
        if (this.myComponent == null) {
            this.myComponent = new MyComponent();
        }
        this.myComponent.myFontSizeCombo.setModel(new DefaultComboBoxModel<String>(UIUtil.getStandardFontSizes()));
        this.myComponent.myPresentationModeFontSize.setModel(new DefaultComboBoxModel<String>(UIUtil.getStandardFontSizes()));
        this.myComponent.myFontSizeCombo.setEditable(true);
        this.myComponent.myPresentationModeFontSize.setEditable(true);
        this.myComponent.myLafComboBox.setModel(new DefaultComboBoxModel<UIManager.LookAndFeelInfo>(LafManager.getInstance().getInstalledLookAndFeels()));
        this.myComponent.myLafComboBox.setRenderer(SimpleListCellRenderer.create((String)"", UIManager.LookAndFeelInfo::getName));
        this.myComponent.myAntialiasingInIDE.setModel(new DefaultComboBoxModel<AntialiasingType>(AntialiasingType.values()));
        this.myComponent.myAntialiasingInEditor.setModel(new DefaultComboBoxModel<AntialiasingType>(AntialiasingType.values()));
        this.myComponent.myAntialiasingInIDE.setSelectedItem(settings.getIdeAAType());
        this.myComponent.myAntialiasingInEditor.setSelectedItem(settings.getEditorAAType());
        this.myComponent.myAntialiasingInIDE.setRenderer(new AAListCellRenderer(false));
        this.myComponent.myAntialiasingInEditor.setRenderer(new AAListCellRenderer(true));
        Hashtable<Integer, JLabel> delayDictionary = new Hashtable<Integer, JLabel>();
        ((Dictionary)delayDictionary).put(0, new JLabel("0"));
        ((Dictionary)delayDictionary).put(1200, new JLabel("1200"));
        this.myComponent.myInitialTooltipDelaySlider.setLabelTable(delayDictionary);
        UIUtil.setSliderIsFilled((JSlider)this.myComponent.myInitialTooltipDelaySlider, (boolean)Boolean.TRUE);
        this.myComponent.myInitialTooltipDelaySlider.setMinimum(0);
        this.myComponent.myInitialTooltipDelaySlider.setMaximum(1200);
        this.myComponent.myInitialTooltipDelaySlider.setPaintLabels(true);
        this.myComponent.myInitialTooltipDelaySlider.setPaintTicks(true);
        this.myComponent.myInitialTooltipDelaySlider.setPaintTrack(true);
        this.myComponent.myInitialTooltipDelaySlider.setMajorTickSpacing(1200);
        this.myComponent.myInitialTooltipDelaySlider.setMinorTickSpacing(100);
        this.myComponent.myEnableAlphaModeCheckBox.addActionListener(__ -> {
            boolean state = this.myComponent.myEnableAlphaModeCheckBox.isSelected();
            this.myComponent.myAlphaModeDelayTextField.setEnabled(state);
            this.myComponent.myAlphaModeRatioSlider.setEnabled(state);
        });
        this.myComponent.myAlphaModeRatioSlider.setSize(100, 50);
        Hashtable<Integer, JLabel> dictionary = new Hashtable<Integer, JLabel>();
        ((Dictionary)dictionary).put(0, new JLabel("0%"));
        ((Dictionary)dictionary).put(50, new JLabel("50%"));
        ((Dictionary)dictionary).put(100, new JLabel("100%"));
        this.myComponent.myAlphaModeRatioSlider.setLabelTable(dictionary);
        UIUtil.setSliderIsFilled((JSlider)this.myComponent.myAlphaModeRatioSlider, (boolean)Boolean.TRUE);
        this.myComponent.myAlphaModeRatioSlider.setPaintLabels(true);
        this.myComponent.myAlphaModeRatioSlider.setPaintTicks(true);
        this.myComponent.myAlphaModeRatioSlider.setPaintTrack(true);
        this.myComponent.myAlphaModeRatioSlider.setMajorTickSpacing(50);
        this.myComponent.myAlphaModeRatioSlider.setMinorTickSpacing(10);
        this.myComponent.myAlphaModeRatioSlider.addChangeListener(__ -> this.myComponent.myAlphaModeRatioSlider.setToolTipText(this.myComponent.myAlphaModeRatioSlider.getValue() + "%"));
        this.myComponent.myTransparencyPanel.setVisible(WindowManagerEx.getInstanceEx().isAlphaModeSupported());
        this.myComponent.myBackgroundImageButton.setEnabled(ProjectManager.getInstance().getOpenProjects().length > 0);
        this.myComponent.myBackgroundImageButton.addActionListener(ActionUtil.createActionListener((String)"Images.SetBackgroundImage", (Component)this.myComponent.myPanel, (String)"unknown"));
        this.myComponent.myDarkWindowHeaders.setSelected(Registry.is((String)"ide.mac.allowDarkWindowDecorations"));
        this.updateDarkWindowHeaderVisibility();
        this.myComponent.myLafComboBox.addItemListener(x -> this.updateDarkWindowHeaderVisibility());
        return this.myComponent.myPanel;
    }

    private void updateDarkWindowHeaderVisibility() {
        Object item = this.myComponent.myLafComboBox.getSelectedItem();
        boolean isDarkLaf = item instanceof UIManager.LookAndFeelInfo && ((UIManager.LookAndFeelInfo)item).getClassName().endsWith("DarculaLaf");
        this.myComponent.myDarkWindowHeaders.setVisible(SystemInfo.isMac && isDarkLaf);
    }

    public void apply() {
        int tooltipDelay;
        if (this.myComponent == null) {
            return;
        }
        UISettings settingsManager = UISettings.getInstance();
        UISettingsState settings = settingsManager.getState();
        int _fontSize = AppearanceConfigurable.getIntValue(this.myComponent.myFontSizeCombo, settingsManager.getFontSize());
        int _presentationFontSize = AppearanceConfigurable.getIntValue((JComboBox)this.myComponent.myPresentationModeFontSize, settingsManager.getPresentationModeFontSize());
        boolean update2 = false;
        boolean shouldUpdateUI = false;
        String _fontFace = this.myComponent.myFontCombo.getFontName();
        LafManager lafManager = LafManager.getInstance();
        if (_fontSize != settingsManager.getFontSize() || !Comparing.equal((String)settingsManager.getFontFace(), (String)_fontFace)) {
            settingsManager.setFontSize(_fontSize);
            settingsManager.setFontFace(_fontFace);
            shouldUpdateUI = true;
            update2 = true;
        }
        if (_presentationFontSize != settingsManager.getPresentationModeFontSize()) {
            settings.setPresentationModeFontSize(_presentationFontSize);
            shouldUpdateUI = true;
        }
        if (this.myComponent.myAntialiasingInIDE.getSelectedItem() != settingsManager.getIdeAAType()) {
            settingsManager.setIdeAAType((AntialiasingType)this.myComponent.myAntialiasingInIDE.getSelectedItem());
            for (Window w : Window.getWindows()) {
                for (JComponent c2 : UIUtil.uiTraverser((Component)w).filter(JComponent.class)) {
                    GraphicsUtil.setAntialiasingType((JComponent)c2, (Object)AntialiasingType.getAAHintForSwingComponent());
                }
            }
            shouldUpdateUI = true;
        }
        if (this.myComponent.myAntialiasingInEditor.getSelectedItem() != settingsManager.getEditorAAType()) {
            settingsManager.setEditorAAType((AntialiasingType)this.myComponent.myAntialiasingInEditor.getSelectedItem());
            shouldUpdateUI = true;
        }
        settings.setAnimateWindows(this.myComponent.myAnimateWindowsCheckBox.isSelected());
        update2 |= settings.getShowToolWindowsNumbers() != this.myComponent.myWindowShortcutsCheckBox.isSelected();
        settings.setShowToolWindowsNumbers(this.myComponent.myWindowShortcutsCheckBox.isSelected());
        update2 |= settings.getHideToolStripes() == this.myComponent.myShowToolStripesCheckBox.isSelected();
        settings.setHideToolStripes(!this.myComponent.myShowToolStripesCheckBox.isSelected());
        update2 |= settings.getShowIconsInMenus() != this.myComponent.myCbDisplayIconsInMenu.isSelected();
        settings.setShowIconsInMenus(this.myComponent.myCbDisplayIconsInMenu.isSelected());
        update2 |= settings.getShowMemoryIndicator() != this.myComponent.myShowMemoryIndicatorCheckBox.isSelected();
        settings.setShowMemoryIndicator(this.myComponent.myShowMemoryIndicatorCheckBox.isSelected());
        update2 |= settings.getAllowMergeButtons() != this.myComponent.myAllowMergeButtons.isSelected();
        settings.setAllowMergeButtons(this.myComponent.myAllowMergeButtons.isSelected());
        update2 |= settings.getCycleScrolling() != this.myComponent.myCycleScrollingCheckBox.isSelected();
        settings.setCycleScrolling(this.myComponent.myCycleScrollingCheckBox.isSelected());
        if (settings.getOverrideLafFonts() != this.myComponent.myOverrideLAFFonts.isSelected()) {
            shouldUpdateUI = true;
            update2 = true;
        }
        settings.setOverrideLafFonts(this.myComponent.myOverrideLAFFonts.isSelected());
        settings.setMoveMouseOnDefaultButton(this.myComponent.myMoveMouseOnDefaultButtonCheckBox.isSelected());
        settings.setHideNavigationOnFocusLoss(this.myComponent.myHideNavigationPopupsCheckBox.isSelected());
        settings.setDndWithPressedAltOnly(this.myComponent.myAltDNDCheckBox.isSelected());
        update2 |= settings.getDisableMnemonics() != this.myComponent.myDisableMnemonics.isSelected();
        settings.setDisableMnemonics(this.myComponent.myDisableMnemonics.isSelected());
        update2 |= settings.getUseSmallLabelsOnTabs() != this.myComponent.myUseSmallLabelsOnTabs.isSelected();
        settings.setUseSmallLabelsOnTabs(this.myComponent.myUseSmallLabelsOnTabs.isSelected());
        update2 |= settings.getWideScreenSupport() != this.myComponent.myWidescreenLayoutCheckBox.isSelected();
        settings.setWideScreenSupport(this.myComponent.myWidescreenLayoutCheckBox.isSelected());
        update2 |= settings.getLeftHorizontalSplit() != this.myComponent.myLeftLayoutCheckBox.isSelected();
        settings.setLeftHorizontalSplit(this.myComponent.myLeftLayoutCheckBox.isSelected());
        update2 |= settings.getRightHorizontalSplit() != this.myComponent.myRightLayoutCheckBox.isSelected();
        settings.setRightHorizontalSplit(this.myComponent.myRightLayoutCheckBox.isSelected());
        update2 |= settings.getSmoothScrolling() != this.myComponent.mySmoothScrollingCheckBox.isSelected();
        settings.setSmoothScrolling(this.myComponent.mySmoothScrollingCheckBox.isSelected());
        update2 |= settings.getNavigateToPreview() != (this.myComponent.myNavigateToPreviewCheckBox.isVisible() && this.myComponent.myNavigateToPreviewCheckBox.isSelected());
        settings.setNavigateToPreview(this.myComponent.myNavigateToPreviewCheckBox.isSelected());
        boolean updateSupportScreenReaders = this.myComponent.isSupportScreenReadersModified();
        if (updateSupportScreenReaders) {
            GeneralSettings.getInstance().setSupportScreenReaders(this.myComponent.mySupportScreenReadersCheckBox.isSelected());
        }
        ColorBlindness blindness = this.myComponent.myColorBlindnessPanel.getColorBlindness();
        boolean updateEditorScheme = false;
        if (settings.getColorBlindness() != blindness) {
            settings.setColorBlindness(blindness);
            update2 = true;
            ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).reloadState(DefaultColorSchemesManager.class);
            updateEditorScheme = true;
        }
        update2 |= settings.getUseContrastScrollBars() != this.myComponent.myUseContrastScrollBarsCheckBox.isSelected();
        settings.setUseContrastScrollBars(this.myComponent.myUseContrastScrollBarsCheckBox.isSelected());
        update2 |= settings.getDisableMnemonicsInControls() != this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected();
        settings.setDisableMnemonicsInControls(this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected());
        update2 |= settings.getShowIconInQuickNavigation() != this.myComponent.myHideIconsInQuickNavigation.isSelected();
        settings.setShowIconInQuickNavigation(this.myComponent.myHideIconsInQuickNavigation.isSelected());
        update2 |= settings.getShowTreeIndentGuides() != this.myComponent.myShowTreeIndentGuides.isSelected();
        settings.setShowTreeIndentGuides(this.myComponent.myShowTreeIndentGuides.isSelected());
        if (this.isModified((JToggleButton)this.myComponent.myDarkWindowHeaders, Registry.is((String)"ide.mac.allowDarkWindowDecorations"))) {
            Registry.get((String)"ide.mac.allowDarkWindowDecorations").setValue(this.myComponent.myDarkWindowHeaders.isSelected());
            update2 = true;
            shouldUpdateUI = true;
        }
        if (!Comparing.equal((Object)this.myComponent.myLafComboBox.getSelectedItem(), (Object)lafManager.getCurrentLookAndFeel())) {
            UIManager.LookAndFeelInfo lafInfo = (UIManager.LookAndFeelInfo)this.myComponent.myLafComboBox.getSelectedItem();
            update2 = true;
            shouldUpdateUI = false;
            QuickChangeLookAndFeel.switchLafAndUpdateUI(lafManager, lafInfo, true);
        }
        if (shouldUpdateUI) {
            lafManager.updateUI();
            shouldUpdateUI = false;
        }
        if (!this.myComponent.myOverrideLAFFonts.isSelected()) {
            assert (!shouldUpdateUI);
            int defSize = JBFont.label().getSize();
            settingsManager.setFontSize(defSize);
            this.myComponent.myFontSizeCombo.getModel().setSelectedItem(String.valueOf(defSize));
            String defName = JBFont.label().getFontName();
            settingsManager.setFontFace(defName);
            this.myComponent.myFontCombo.setFontName(defName);
        }
        if (WindowManagerEx.getInstanceEx().isAlphaModeSupported()) {
            int delay = -1;
            try {
                delay = Integer.parseInt(this.myComponent.myAlphaModeDelayTextField.getText());
            }
            catch (NumberFormatException defName) {
                // empty catch block
            }
            float ratio = (float)this.myComponent.myAlphaModeRatioSlider.getValue() / 100.0f;
            if (this.myComponent.myEnableAlphaModeCheckBox.isSelected() != settings.getEnableAlphaMode() || delay != -1 && delay != settings.getAlphaModeDelay() || ratio != settings.getAlphaModeRatio()) {
                update2 = true;
                settings.setEnableAlphaMode(this.myComponent.myEnableAlphaModeCheckBox.isSelected());
                settings.setAlphaModeDelay(delay);
                settings.setAlphaModeRatio(ratio);
            }
        }
        if ((tooltipDelay = Math.min(this.myComponent.myInitialTooltipDelaySlider.getValue(), 5000)) != Registry.intValue((String)"ide.tooltip.initialDelay")) {
            update2 = true;
            Registry.get((String)"ide.tooltip.initialDelay").setValue(tooltipDelay);
        }
        if (update2) {
            settingsManager.fireUISettingsChanged();
        }
        this.myComponent.updateCombo();
        if (updateEditorScheme) {
            ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        } else {
            EditorFactory.getInstance().refreshAllEditors();
        }
    }

    private static int getIntValue(JComboBox combo, int defaultValue) {
        String temp = (String)combo.getEditor().getItem();
        int value = -1;
        if (temp != null && !temp.trim().isEmpty()) {
            try {
                value = Integer.parseInt(temp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value <= 0) {
                value = defaultValue;
            }
        } else {
            value = defaultValue;
        }
        return value;
    }

    public void reset() {
        if (this.myComponent == null) {
            return;
        }
        UISettings settingsManager = UISettings.getInstance();
        UISettingsState settings = settingsManager.getState();
        if (settings.getOverrideLafFonts()) {
            this.myComponent.myFontCombo.setFontName(settingsManager.getFontFace());
        } else {
            this.myComponent.myFontCombo.setFontName(UIUtil.getLabelFont().getFamily());
        }
        this.myComponent.myAntialiasingInIDE.setSelectedItem(settingsManager.getIdeAAType());
        this.myComponent.myAntialiasingInEditor.setSelectedItem(settingsManager.getEditorAAType());
        this.myComponent.myFontSizeCombo.setSelectedItem(Integer.toString(settingsManager.getFontSize()));
        this.myComponent.myPresentationModeFontSize.setSelectedItem((Object)Integer.toString(settings.getPresentationModeFontSize()));
        this.myComponent.myAnimateWindowsCheckBox.setSelected(settings.getAnimateWindows());
        this.myComponent.myWindowShortcutsCheckBox.setSelected(settings.getShowToolWindowsNumbers());
        this.myComponent.myShowToolStripesCheckBox.setSelected(!settings.getHideToolStripes());
        this.myComponent.myCbDisplayIconsInMenu.setSelected(settings.getShowIconsInMenus());
        this.myComponent.myShowMemoryIndicatorCheckBox.setSelected(settings.getShowMemoryIndicator());
        this.myComponent.myAllowMergeButtons.setSelected(settings.getAllowMergeButtons());
        this.myComponent.myCycleScrollingCheckBox.setSelected(settings.getCycleScrolling());
        this.myComponent.myHideIconsInQuickNavigation.setSelected(settings.getShowIconInQuickNavigation());
        this.myComponent.myShowTreeIndentGuides.setSelected(settings.getShowTreeIndentGuides());
        this.myComponent.myMoveMouseOnDefaultButtonCheckBox.setSelected(settings.getMoveMouseOnDefaultButton());
        this.myComponent.myHideNavigationPopupsCheckBox.setSelected(settings.getHideNavigationOnFocusLoss());
        this.myComponent.myAltDNDCheckBox.setSelected(settings.getDndWithPressedAltOnly());
        this.myComponent.myLafComboBox.setSelectedItem(LafManager.getInstance().getCurrentLookAndFeel());
        this.myComponent.myDarkWindowHeaders.setSelected(Registry.is((String)"ide.mac.allowDarkWindowDecorations"));
        this.myComponent.myOverrideLAFFonts.setSelected(settings.getOverrideLafFonts());
        this.myComponent.myDisableMnemonics.setSelected(settings.getDisableMnemonics());
        this.myComponent.myUseSmallLabelsOnTabs.setSelected(settings.getUseSmallLabelsOnTabs());
        this.myComponent.myWidescreenLayoutCheckBox.setSelected(settings.getWideScreenSupport());
        this.myComponent.myLeftLayoutCheckBox.setSelected(settings.getLeftHorizontalSplit());
        this.myComponent.myRightLayoutCheckBox.setSelected(settings.getRightHorizontalSplit());
        this.myComponent.mySmoothScrollingCheckBox.setSelected(settings.getSmoothScrolling());
        this.myComponent.myNavigateToPreviewCheckBox.setSelected(settings.getNavigateToPreview());
        this.myComponent.myNavigateToPreviewCheckBox.setVisible(false);
        this.myComponent.mySupportScreenReadersCheckBox.setSelected(GeneralSettings.getInstance().isSupportScreenReaders());
        this.myComponent.mySupportScreenReadersCheckBox.setEnabled(!GeneralSettings.isSupportScreenReadersOverridden());
        this.myComponent.mySupportScreenReadersCheckBox.setToolTipText(GeneralSettings.isSupportScreenReadersOverridden() ? "The option is overridden by the JVM property: \"ide.support.screenreaders.enabled\"" : null);
        this.myComponent.myColorBlindnessPanel.setColorBlindness(settings.getColorBlindness());
        this.myComponent.myUseContrastScrollBarsCheckBox.setSelected(settings.getUseContrastScrollBars());
        this.myComponent.myDisableMnemonicInControlsCheckBox.setSelected(settings.getDisableMnemonicsInControls());
        boolean alphaModeEnabled = WindowManagerEx.getInstanceEx().isAlphaModeSupported();
        if (alphaModeEnabled) {
            this.myComponent.myEnableAlphaModeCheckBox.setSelected(settings.getEnableAlphaMode());
        } else {
            this.myComponent.myEnableAlphaModeCheckBox.setSelected(false);
        }
        this.myComponent.myEnableAlphaModeCheckBox.setEnabled(alphaModeEnabled);
        this.myComponent.myAlphaModeDelayTextField.setText(Integer.toString(settings.getAlphaModeDelay()));
        this.myComponent.myAlphaModeDelayTextField.setEnabled(alphaModeEnabled && settings.getEnableAlphaMode());
        int ratio = (int)(settings.getAlphaModeRatio() * 100.0f);
        this.myComponent.myAlphaModeRatioSlider.setValue(ratio);
        this.myComponent.myAlphaModeRatioSlider.setToolTipText(ratio + "%");
        this.myComponent.myAlphaModeRatioSlider.setEnabled(alphaModeEnabled && settings.getEnableAlphaMode());
        this.myComponent.myInitialTooltipDelaySlider.setValue(Registry.intValue((String)"ide.tooltip.initialDelay"));
        this.myComponent.updateCombo();
    }

    public static String antialiasingTypeInEditorAsString(boolean antialiased, LCDRenderingScope scope) {
        if (!antialiased) {
            return "No antialiasing";
        }
        switch (scope) {
            case IDE: {
                return "Subpixel";
            }
            case OFF: 
            case EXCLUDING_EDITOR: {
                return "Greyscale";
            }
        }
        LOG.info("Wrong antialiasing state");
        return "No antialiasing";
    }

    public boolean isModified() {
        int tooltipDelay;
        if (this.myComponent == null) {
            return false;
        }
        UISettings settingsManager = UISettings.getInstance();
        UISettingsState settings = settingsManager.getState();
        boolean isModified = false;
        isModified |= !Comparing.equal((String)this.myComponent.myFontCombo.getFontName(), (String)settingsManager.getFontFace()) && this.myComponent.myOverrideLAFFonts.isSelected();
        isModified |= !Comparing.equal((Object)this.myComponent.myFontSizeCombo.getEditor().getItem(), (Object)Integer.toString(settingsManager.getFontSize()));
        isModified |= this.myComponent.myAntialiasingInIDE.getSelectedItem() != settingsManager.getIdeAAType();
        isModified |= this.myComponent.myAntialiasingInEditor.getSelectedItem() != settingsManager.getEditorAAType();
        isModified |= this.myComponent.myAnimateWindowsCheckBox.isSelected() != settingsManager.getAnimateWindows();
        isModified |= this.myComponent.myWindowShortcutsCheckBox.isSelected() != settings.getShowToolWindowsNumbers();
        isModified |= this.myComponent.myShowToolStripesCheckBox.isSelected() == settings.getHideToolStripes();
        isModified |= this.myComponent.myCbDisplayIconsInMenu.isSelected() != settings.getShowIconsInMenus();
        isModified |= this.myComponent.myShowMemoryIndicatorCheckBox.isSelected() != settings.getShowMemoryIndicator();
        isModified |= this.myComponent.myAllowMergeButtons.isSelected() != settings.getAllowMergeButtons();
        isModified |= this.myComponent.myCycleScrollingCheckBox.isSelected() != settings.getCycleScrolling();
        isModified |= this.myComponent.myOverrideLAFFonts.isSelected() != settings.getOverrideLafFonts();
        isModified |= this.myComponent.myDisableMnemonics.isSelected() != settings.getDisableMnemonics();
        isModified |= this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected() != settings.getDisableMnemonicsInControls();
        isModified |= this.myComponent.myUseSmallLabelsOnTabs.isSelected() != settings.getUseSmallLabelsOnTabs();
        isModified |= this.myComponent.myWidescreenLayoutCheckBox.isSelected() != settings.getWideScreenSupport();
        isModified |= this.myComponent.myLeftLayoutCheckBox.isSelected() != settings.getLeftHorizontalSplit();
        isModified |= this.myComponent.myRightLayoutCheckBox.isSelected() != settings.getRightHorizontalSplit();
        isModified |= this.myComponent.mySmoothScrollingCheckBox.isSelected() != settings.getSmoothScrolling();
        isModified |= this.myComponent.myNavigateToPreviewCheckBox.isSelected() != settings.getNavigateToPreview();
        isModified |= this.myComponent.isSupportScreenReadersModified();
        isModified |= this.myComponent.myColorBlindnessPanel.getColorBlindness() != settings.getColorBlindness();
        isModified |= this.myComponent.myUseContrastScrollBarsCheckBox.isSelected() != settings.getUseContrastScrollBars();
        isModified |= this.myComponent.myHideIconsInQuickNavigation.isSelected() != settings.getShowIconInQuickNavigation();
        isModified |= this.myComponent.myShowTreeIndentGuides.isSelected() != settings.getShowTreeIndentGuides();
        isModified |= !Comparing.equal((Object)this.myComponent.myPresentationModeFontSize.getEditor().getItem(), (Object)Integer.toString(settings.getPresentationModeFontSize()));
        isModified |= this.myComponent.myMoveMouseOnDefaultButtonCheckBox.isSelected() != settings.getMoveMouseOnDefaultButton();
        isModified |= this.myComponent.myHideNavigationPopupsCheckBox.isSelected() != settings.getHideNavigationOnFocusLoss();
        isModified |= this.myComponent.myAltDNDCheckBox.isSelected() != settings.getDndWithPressedAltOnly();
        isModified |= !Comparing.equal((Object)this.myComponent.myLafComboBox.getSelectedItem(), (Object)LafManager.getInstance().getCurrentLookAndFeel());
        isModified |= this.isModified((JToggleButton)this.myComponent.myDarkWindowHeaders, Registry.is((String)"ide.mac.allowDarkWindowDecorations"));
        if (WindowManagerEx.getInstanceEx().isAlphaModeSupported()) {
            float ratio;
            isModified |= this.myComponent.myEnableAlphaModeCheckBox.isSelected() != settings.getEnableAlphaMode();
            int delay = -1;
            try {
                delay = Integer.parseInt(this.myComponent.myAlphaModeDelayTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (delay != -1) {
                isModified |= delay != settings.getAlphaModeDelay();
            }
            isModified |= (ratio = (float)this.myComponent.myAlphaModeRatioSlider.getValue() / 100.0f) != settings.getAlphaModeRatio();
        }
        return isModified |= (tooltipDelay = this.myComponent.myInitialTooltipDelaySlider.getValue()) != Registry.intValue((String)"ide.tooltip.initialDelay");
    }

    public void disposeUIResources() {
        this.myComponent = null;
    }

    public String getHelpTopic() {
        return "preferences.lookFeel";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/AppearanceConfigurable", "getId"));
    }

    private static class AAListCellRenderer
    extends SimpleListCellRenderer<AntialiasingType> {
        private static final Object SUBPIXEL_HINT = GraphicsUtil.createAATextInfo((Object)RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        private static final Object GREYSCALE_HINT = GraphicsUtil.createAATextInfo((Object)RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        private final boolean myUseEditorFont;

        AAListCellRenderer(boolean useEditorFont) {
            this.myUseEditorFont = useEditorFont;
        }

        public void customize(JList<? extends AntialiasingType> list2, AntialiasingType value, int index, boolean selected2, boolean hasFocus) {
            if (value == AntialiasingType.SUBPIXEL) {
                GraphicsUtil.setAntialiasingType((JComponent)((Object)this), (Object)SUBPIXEL_HINT);
            } else if (value == AntialiasingType.GREYSCALE) {
                GraphicsUtil.setAntialiasingType((JComponent)((Object)this), (Object)GREYSCALE_HINT);
            } else if (value == AntialiasingType.OFF) {
                GraphicsUtil.setAntialiasingType((JComponent)((Object)this), null);
            }
            if (this.myUseEditorFont) {
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                this.setFont(new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize()));
            }
            this.setText(String.valueOf(value));
        }
    }

    private static class MyComponent {
        private JPanel myPanel;
        private FontComboBox myFontCombo;
        private JComboBox myFontSizeCombo;
        private JCheckBox myAnimateWindowsCheckBox;
        private JCheckBox myWindowShortcutsCheckBox;
        private JCheckBox myShowToolStripesCheckBox;
        private JCheckBox myShowMemoryIndicatorCheckBox;
        private JComboBox<UIManager.LookAndFeelInfo> myLafComboBox;
        private JCheckBox myCycleScrollingCheckBox;
        private JCheckBox myMoveMouseOnDefaultButtonCheckBox;
        private JCheckBox myEnableAlphaModeCheckBox;
        private JTextField myAlphaModeDelayTextField;
        private JSlider myAlphaModeRatioSlider;
        private JLabel myFontSizeLabel;
        private JPanel myTransparencyPanel;
        private JCheckBox myOverrideLAFFonts;
        private JCheckBox myHideIconsInQuickNavigation;
        private JCheckBox myShowTreeIndentGuides;
        private JCheckBox myCbDisplayIconsInMenu;
        private JCheckBox myDisableMnemonics;
        private JCheckBox myDisableMnemonicInControlsCheckBox;
        private JCheckBox myHideNavigationPopupsCheckBox;
        private JCheckBox myAltDNDCheckBox;
        private JCheckBox myAllowMergeButtons;
        private JBCheckBox myUseSmallLabelsOnTabs;
        private JBCheckBox myWidescreenLayoutCheckBox;
        private JCheckBox myLeftLayoutCheckBox;
        private JCheckBox myRightLayoutCheckBox;
        private JSlider myInitialTooltipDelaySlider;
        private ComboBox myPresentationModeFontSize;
        private JCheckBox mySmoothScrollingCheckBox;
        private JCheckBox myNavigateToPreviewCheckBox;
        private JCheckBox mySupportScreenReadersCheckBox;
        private ColorBlindnessPanel myColorBlindnessPanel;
        private JComboBox myAntialiasingInIDE;
        private JComboBox myAntialiasingInEditor;
        private JButton myBackgroundImageButton;
        private JBCheckBox myDarkWindowHeaders;
        private JBCheckBox myUseContrastScrollBarsCheckBox;

        MyComponent() {
            this.$$$setupUI$$$();
            this.myOverrideLAFFonts.addActionListener(__ -> this.updateCombo());
            if (!Registry.is((String)"ide.transparency.mode.for.windows")) {
                this.myTransparencyPanel.getParent().remove(this.myTransparencyPanel);
            }
        }

        void updateCombo() {
            boolean enableChooser = this.myOverrideLAFFonts.isSelected();
            this.myFontCombo.setEnabled(enableChooser);
            this.myFontSizeCombo.setEnabled(enableChooser);
            this.myFontSizeLabel.setEnabled(enableChooser);
        }

        boolean isSupportScreenReadersModified() {
            return this.mySupportScreenReadersCheckBox.isEnabled() && this.mySupportScreenReadersCheckBox.isSelected() != GeneralSettings.getInstance().isSupportScreenReaders();
        }

        private void createUIComponents() {
            this.myFontSizeCombo = new ComboBox();
            this.myPresentationModeFontSize = new ComboBox();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JLabel jLabel;
            FontComboBox fontComboBox;
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JCheckBox jCheckBox2;
            ColorBlindnessPanel colorBlindnessPanel;
            JComboBox jComboBox;
            JComboBox jComboBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JBCheckBox jBCheckBox3;
            JBCheckBox jBCheckBox4;
            JCheckBox jCheckBox7;
            JCheckBox jCheckBox8;
            JCheckBox jCheckBox9;
            JCheckBox jCheckBox10;
            JCheckBox jCheckBox11;
            JCheckBox jCheckBox12;
            JCheckBox jCheckBox13;
            JCheckBox jCheckBox14;
            JTextField jTextField;
            JSlider jSlider;
            JCheckBox jCheckBox15;
            JPanel jPanel;
            JButton jButton;
            JCheckBox jCheckBox16;
            JSlider jSlider2;
            JCheckBox jCheckBox17;
            JCheckBox jCheckBox18;
            JCheckBox jCheckBox19;
            JCheckBox jCheckBox20;
            JCheckBox jCheckBox21;
            JPanel jPanel2;
            this.createUIComponents();
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 1, 3, 3, 3, null, null, null));
            jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.ui.options"), (int)0, (int)0, null, null));
            this.myMoveMouseOnDefaultButtonCheckBox = jCheckBox21 = new JCheckBox();
            jCheckBox21.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox21, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.position.cursor.on.default.button"));
            jPanel4.add((Component)jCheckBox21, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCycleScrollingCheckBox = jCheckBox20 = new JCheckBox();
            jCheckBox20.setMargin(new Insets(2, 0, 2, 2));
            jCheckBox20.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox20, ResourceBundle.getBundle("messages/IdeBundle").getString("checkboox.cyclic.scrolling.in.lists"));
            jPanel4.add((Component)jCheckBox20, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myHideIconsInQuickNavigation = jCheckBox19 = new JCheckBox();
            jCheckBox19.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox19, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.icons.in.quick.navigation"));
            jPanel4.add((Component)jCheckBox19, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myShowTreeIndentGuides = jCheckBox18 = new JCheckBox();
            jCheckBox18.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox18, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tree.indent.guides"));
            jPanel4.add((Component)jCheckBox18, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myHideNavigationPopupsCheckBox = jCheckBox17 = new JCheckBox();
            jCheckBox17.setMargin(new Insets(2, 0, 2, 2));
            jCheckBox17.setText("Hide navigation popups on focus loss");
            jPanel4.add((Component)jCheckBox17, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Tooltip initial delay (ms):");
            jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myInitialTooltipDelaySlider = jSlider2 = new JSlider();
            jSlider2.setPaintTrack(true);
            jSlider2.setValue(100);
            jPanel5.add((Component)jSlider2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
            this.myAltDNDCheckBox = jCheckBox16 = new JCheckBox();
            jCheckBox16.setText("Drag-n-Drop with ALT pressed only");
            jPanel4.add((Component)jCheckBox16, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myBackgroundImageButton = jButton = new JButton();
            jButton.setText("Background Image...");
            jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myTransparencyPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 1, 3, 3, 3, null, null, null));
            jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.transparency"), (int)0, (int)0, null, null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/IdeBundle").getString("label.transparency.delay.ms"));
            jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/IdeBundle").getString("label.transparency.ratio"));
            jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myEnableAlphaModeCheckBox = jCheckBox15 = new JCheckBox();
            jCheckBox15.setMargin(new Insets(0, 0, 0, 0));
            this.$$$loadButtonText$$$(jCheckBox15, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.use.transparent.mode.for.floating.windows"));
            jPanel.add((Component)jCheckBox15, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.myAlphaModeRatioSlider = jSlider = new JSlider();
            jPanel.add((Component)jSlider, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myAlphaModeDelayTextField = jTextField = new JTextField();
            jTextField.setHorizontalAlignment(2);
            jTextField.setMargin(new Insets(1, 5, 1, 5));
            jTextField.setText("1500");
            jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(50, -1), null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel6, new GridConstraints(5, 0, 1, 1, 1, 3, 0, 0, null, null, null));
            jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.window.options"), (int)0, (int)0, null, null));
            this.myShowToolStripesCheckBox = jCheckBox14 = new JCheckBox();
            jCheckBox14.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox14.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox14, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tool.window.bars"));
            jPanel6.add((Component)jCheckBox14, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCbDisplayIconsInMenu = jCheckBox13 = new JCheckBox();
            jCheckBox13.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox13.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox13, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.icons.in.menu.items"));
            jPanel6.add((Component)jCheckBox13, new GridConstraints(4, 0, 1, 1, 9, 0, 3, 0, null, new Dimension(153, 20), null));
            this.myDisableMnemonics = jCheckBox12 = new JCheckBox();
            jCheckBox12.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("messages/KeyMapBundle").getString("disable.mnemonic.in.menu.check.box"));
            jPanel6.add((Component)jCheckBox12, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDisableMnemonicInControlsCheckBox = jCheckBox11 = new JCheckBox();
            jCheckBox11.setMargin(new Insets(2, 2, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/KeyMapBundle").getString("disable.mnemonic.in.controls.check.box"));
            jPanel6.add((Component)jCheckBox11, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myWindowShortcutsCheckBox = jCheckBox10 = new JCheckBox();
            jCheckBox10.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox10.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tool.window.numbers"));
            jPanel6.add((Component)jCheckBox10, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myShowMemoryIndicatorCheckBox = jCheckBox9 = new JCheckBox();
            jCheckBox9.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox9.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.memory.indicator"));
            jPanel6.add((Component)jCheckBox9, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAnimateWindowsCheckBox = jCheckBox8 = new JCheckBox();
            jCheckBox8.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox8.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.animate.windows"));
            jPanel6.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAllowMergeButtons = jCheckBox7 = new JCheckBox();
            jCheckBox7.setSelected(true);
            jCheckBox7.setText("Allow merging buttons on dialogs");
            jPanel6.add((Component)jCheckBox7, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myUseSmallLabelsOnTabs = jBCheckBox4 = new JBCheckBox();
            jBCheckBox4.setText("Small labels in editor tabs");
            jPanel6.add((Component)jBCheckBox4, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myWidescreenLayoutCheckBox = jBCheckBox3 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.widescreen.tool.window.layout"));
            jPanel6.add((Component)jBCheckBox3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(175, 20), null));
            this.myLeftLayoutCheckBox = jCheckBox6 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.left.toolwindow.layout"));
            jPanel6.add((Component)jCheckBox6, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(171, 20), null));
            this.myRightLayoutCheckBox = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.right.toolwindow.layout"));
            jPanel6.add((Component)jCheckBox5, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(177, 20), null));
            this.myNavigateToPreviewCheckBox = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.use.preview.window"));
            jPanel6.add((Component)jCheckBox4, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.mySmoothScrollingCheckBox = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.smooth.scrolling"));
            jPanel6.add((Component)jCheckBox3, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel7, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.presentation.mode"), (int)0, (int)0, null, null));
            Spacer spacer = new Spacer();
            jPanel7.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel7.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JBLabel jBLabel = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("presentation.mode.fon.size"));
            jPanel7.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            ComboBox comboBox2 = this.myPresentationModeFontSize;
            jPanel7.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel8.putClientProperty("html.disable", Boolean.FALSE);
            jPanel3.add((Component)jPanel8, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.antialiasing.mode"), (int)0, (int)0, null, null));
            this.myAntialiasingInIDE = jComboBox2 = new JComboBox();
            jPanel8.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myAntialiasingInEditor = jComboBox = new JComboBox();
            jPanel8.add(jComboBox, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("label.text.antialiasing.scope.ide"));
            jPanel8.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("label.text.antialiasing.scope.editor"));
            jPanel8.add((Component)jLabel6, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel9.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("title.accessibility"), (int)0, (int)0, null, null));
            this.myColorBlindnessPanel = colorBlindnessPanel = new ColorBlindnessPanel();
            jPanel9.add((Component)colorBlindnessPanel, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
            this.mySupportScreenReadersCheckBox = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.support.screen.readers"));
            jPanel9.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myUseContrastScrollBarsCheckBox = jBCheckBox2 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.acessibility.contrast.scrollbars"));
            jPanel9.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
            JPanel jPanel11 = new JPanel();
            jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel10.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
            JLabel jLabel7 = new JLabel();
            jLabel7.setHorizontalAlignment(2);
            jLabel7.setHorizontalTextPosition(2);
            this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/IdeBundle").getString("combobox.look.and.feel"));
            jLabel7.setVerifyInputWhenFocusTarget(false);
            jPanel11.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JComboBox jComboBox3 = new JComboBox();
            this.myLafComboBox = jComboBox3;
            jPanel11.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
            this.myDarkWindowHeaders = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkboox.dark.window.headers"));
            jPanel11.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
            JPanel jPanel12 = new JPanel();
            jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(5, 0, 5, 0), -1, -1, false, false));
            jPanel10.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 8, 2, 3, 3, null, null, null));
            this.myFontCombo = fontComboBox = new FontComboBox();
            ((JComponent)((Object)fontComboBox)).setAutoscrolls(true);
            ((JComponent)((Object)fontComboBox)).setDoubleBuffered(false);
            ((JComboBox)((Object)fontComboBox)).setEditable(false);
            ((Component)((Object)fontComboBox)).setEnabled(true);
            ((Component)((Object)fontComboBox)).setName("");
            ((JComboBox)((Object)fontComboBox)).setPopupVisible(false);
            ((JComponent)((Object)fontComboBox)).setRequestFocusEnabled(true);
            jPanel12.add((Component)((Object)fontComboBox), new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myFontSizeLabel = jLabel = new JLabel();
            jLabel.setHorizontalAlignment(10);
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("label.font.size"));
            jPanel12.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 1, 0, 0, null, null, null));
            JComboBox jComboBox4 = this.myFontSizeCombo;
            jComboBox4.setEditable(true);
            jPanel12.add((Component)jComboBox4, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, new Dimension(40, -1), null));
            this.myOverrideLAFFonts = jCheckBox = new JCheckBox();
            jCheckBox.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.override.default.laf.fonts"));
            jPanel12.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            jLabel5.setLabelFor(jComboBox2);
            jLabel6.setLabelFor(jComboBox);
            jLabel7.setLabelFor(jComboBox3);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c2 = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c2 = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c2);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c2 = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c2 = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c2);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

