/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PinActiveTabAction
extends DumbAwareAction
implements Toggleable {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Handler handler2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(0);
        }
        if ((handler2 = this.getHandler(e)) == null) {
            return;
        }
        boolean selected2 = !handler2.isPinned;
        handler2.setPinned(selected2);
        e.getPresentation().putClientProperty("selected", (Object)selected2);
    }

    public void update(@NotNull AnActionEvent e) {
        Handler handler2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (handler2 = this.getHandler(e)) != null;
        boolean selected2 = enabled && handler2.isPinned;
        e.getPresentation().setIcon(e.isFromActionToolbar() ? AllIcons.General.Pin_tab : null);
        e.getPresentation().putClientProperty("selected", (Object)selected2);
        String text2 = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || handler2 != null && !handler2.isActiveTab ? (selected2 ? IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0])) : (selected2 ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
        e.getPresentation().setText(text2);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    protected Handler getHandler(@NotNull AnActionEvent e) {
        VirtualFile selectedFile;
        Content content2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        EditorWindow currentWindow = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
        Content content3 = content2 = currentWindow != null ? null : this.getContentFromEvent(e);
        if (content2 != null && content2.isPinnable()) {
            return PinActiveTabAction.createHandler(content2);
        }
        EditorWindow window = currentWindow != null ? currentWindow : (project != null ? FileEditorManagerEx.getInstanceEx(project).getCurrentWindow() : null);
        VirtualFile virtualFile = selectedFile = window == null ? null : this.getFileFromEvent(e, window);
        if (selectedFile != null) {
            return PinActiveTabAction.createHandler(window, selectedFile);
        }
        return null;
    }

    @Nullable
    protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(3);
        }
        if (window == null) {
            PinActiveTabAction.$$$reportNull$$$0(4);
        }
        return PinActiveTabAction.getFileInWindow(e, window);
    }

    @Nullable
    protected Content getContentFromEvent(@NotNull AnActionEvent e) {
        Content content2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(5);
        }
        if ((content2 = PinActiveTabAction.getNonToolWindowContent(e)) == null) {
            content2 = PinActiveTabAction.getToolWindowContent(e);
        }
        return content2 != null && content2.isValid() ? content2 : null;
    }

    @NotNull
    private static Handler createHandler(final Content content2) {
        Handler handler2 = new Handler(content2.isPinned(), Objects.requireNonNull(content2.getManager()).getSelectedContent() == content2){

            @Override
            void setPinned(boolean value) {
                content2.setPinned(value);
            }
        };
        if (handler2 == null) {
            PinActiveTabAction.$$$reportNull$$$0(6);
        }
        return handler2;
    }

    @NotNull
    private static Handler createHandler(final EditorWindow window, final VirtualFile selectedFile) {
        Handler handler2 = new Handler(window.isFilePinned(selectedFile), selectedFile.equals(window.getSelectedFile())){

            @Override
            void setPinned(boolean value) {
                window.setFilePinned(selectedFile, value);
            }
        };
        if (handler2 == null) {
            PinActiveTabAction.$$$reportNull$$$0(7);
        }
        return handler2;
    }

    @Nullable
    private static Content getNonToolWindowContent(@NotNull AnActionEvent e) {
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(8);
        }
        Content result2 = null;
        Content[] contents = (Content[])e.getData(ViewContext.CONTENT_KEY);
        if (contents != null && contents.length == 1) {
            result2 = contents[0];
        }
        if (result2 != null && result2.isPinnable()) {
            return result2;
        }
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(e.getDataContext(), true);
        Content content2 = result2 = contentManager != null ? contentManager.getSelectedContent() : null;
        if (result2 != null && result2.isPinnable()) {
            return result2;
        }
        return null;
    }

    @Nullable
    private static Content getToolWindowContent(@NotNull AnActionEvent e) {
        ToolWindow window;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(9);
        }
        Content result2 = (window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW)) != null ? window.getContentManager().getSelectedContent() : null;
        return result2 != null && result2.isPinnable() ? result2 : null;
    }

    @Nullable
    private static VirtualFile getFileInWindow(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
        VirtualFile file2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(10);
        }
        if (window == null) {
            PinActiveTabAction.$$$reportNull$$$0(11);
        }
        if ((file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) == null) {
            file2 = window.getSelectedFile();
        }
        if (file2 != null && window.isFileOpen(file2)) {
            return file2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/PinActiveTabAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileFromEvent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromEvent";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNonToolWindowContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowContent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileInWindow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
            if (e == null) {
                EW.$$$reportNull$$$0(0);
            }
            if (window == null) {
                EW.$$$reportNull$$$0(1);
            }
            return window.getSelectedFile();
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                EW.$$$reportNull$$$0(2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction$EW";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFileFromEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentFromEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
            if (e == null) {
                TW.$$$reportNull$$$0(0);
            }
            if (window == null) {
                TW.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                TW.$$$reportNull$$$0(2);
            }
            return PinActiveTabAction.getToolWindowContent(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction$TW";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFileFromEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentFromEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Handler {
        public final boolean isPinned;
        public final boolean isActiveTab;

        abstract void setPinned(boolean var1);

        public Handler(boolean isPinned, boolean isActiveTab) {
            this.isPinned = isPinned;
            this.isActiveTab = isActiveTab;
        }
    }
}

