/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.Key;
import com.intellij.util.DocumentUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsUpdater {
    private static final Key<Boolean> HINT_REMOVAL_DELAYED = Key.create((String)"hint.removal.delayed");
    private static final Key<Boolean> REPEATED_PASS = Key.create((String)"RepeatedParameterHintsPass");
    private final ParameterHintsPresentationManager myHintsManager;
    private final TIntObjectHashMap<Caret> myCaretMap;
    private final TIntObjectHashMap<List<ParameterHintsPass.HintData>> myNewHints;
    private final TIntObjectHashMap<String> myHintsToPreserve;
    private final boolean myForceImmediateUpdate;
    private final Editor myEditor;
    private final List<Inlay> myEditorInlays;
    private List<InlayUpdateInfo> myUpdateList;

    public ParameterHintsUpdater(@NotNull Editor editor, @NotNull List<Inlay> editorInlays, @NotNull TIntObjectHashMap<List<ParameterHintsPass.HintData>> newHints, @NotNull TIntObjectHashMap<String> hintsToPreserve, boolean forceImmediateUpdate) {
        if (editor == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(0);
        }
        if (editorInlays == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(1);
        }
        if (newHints == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(2);
        }
        if (hintsToPreserve == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(3);
        }
        this.myHintsManager = ParameterHintsPresentationManager.getInstance();
        this.myEditor = editor;
        this.myNewHints = newHints;
        this.myHintsToPreserve = hintsToPreserve;
        this.myForceImmediateUpdate = forceImmediateUpdate;
        this.myCaretMap = new TIntObjectHashMap();
        List allCarets = this.myEditor.getCaretModel().getAllCarets();
        allCarets.forEach(caret -> {
            Caret cfr_ignored_0 = (Caret)this.myCaretMap.put(caret.getOffset(), caret);
        });
        this.myEditorInlays = editorInlays;
    }

    private List<InlayUpdateInfo> getInlayUpdates(List<Inlay> editorHints) {
        this.myEditor.putUserData(HINT_REMOVAL_DELAYED, (Object)Boolean.FALSE);
        ArrayList<InlayUpdateInfo> updates = new ArrayList<InlayUpdateInfo>();
        editorHints.forEach(editorHint -> {
            String newText;
            int offset = editorHint.getOffset();
            ParameterHintsPass.HintData newHint = ParameterHintsUpdater.findAndRemoveMatchingHint(offset, editorHint.isRelatedToPrecedingText(), this.myNewHints);
            if (!this.myForceImmediateUpdate && this.delayRemoval((Inlay)editorHint)) {
                this.myEditor.putUserData(HINT_REMOVAL_DELAYED, (Object)Boolean.TRUE);
                return;
            }
            String string = newText = newHint == null ? null : newHint.presentationText;
            if (this.isPreserveHint((Inlay)editorHint, newText)) {
                return;
            }
            updates.add(new InlayUpdateInfo(offset, (Inlay)editorHint, newHint));
        });
        Arrays.stream(this.myNewHints.keys()).forEach(offset -> {
            for (ParameterHintsPass.HintData hint : (List)this.myNewHints.get(offset)) {
                updates.add(new InlayUpdateInfo(offset, null, hint));
            }
        });
        updates.sort(Comparator.comparing(update2 -> update2.offset));
        return updates;
    }

    public static boolean hintRemovalDelayed(@NotNull Editor editor) {
        if (editor == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(4);
        }
        return editor.getUserData(HINT_REMOVAL_DELAYED) == Boolean.TRUE;
    }

    @Nullable
    private static ParameterHintsPass.HintData findAndRemoveMatchingHint(int offset, boolean relatesToPrecedingText, TIntObjectHashMap<List<ParameterHintsPass.HintData>> data) {
        List newHintList = (List)data.get(offset);
        ParameterHintsPass.HintData newHint = null;
        if (newHintList != null) {
            Iterator iterator = newHintList.iterator();
            while (iterator.hasNext()) {
                ParameterHintsPass.HintData hint = (ParameterHintsPass.HintData)iterator.next();
                if (hint.relatesToPrecedingText != relatesToPrecedingText) continue;
                newHint = hint;
                iterator.remove();
                break;
            }
            if (newHintList.isEmpty()) {
                data.remove(offset);
            }
        }
        return newHint;
    }

    private boolean isPreserveHint(@NotNull Inlay inlay, @Nullable String newText) {
        if (inlay == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(5);
        }
        if (newText == null) {
            newText = (String)this.myHintsToPreserve.get(inlay.getOffset());
        }
        String oldText = this.myHintsManager.getHintText(inlay);
        return Objects.equals(newText, oldText);
    }

    public void update() {
        this.myUpdateList = this.getInlayUpdates(this.myEditorInlays);
        boolean firstTime = this.myEditor.getUserData(REPEATED_PASS) == null;
        boolean isUpdateInBulkMode = this.myUpdateList.size() > 1000;
        DocumentUtil.executeInBulk(this.myEditor.getDocument(), isUpdateInBulkMode, () -> this.performHintsUpdate(firstTime, isUpdateInBulkMode));
        this.myEditor.putUserData(REPEATED_PASS, (Object)Boolean.TRUE);
    }

    private void performHintsUpdate(boolean firstTime, boolean isInBulkMode) {
        for (int infoIndex = 0; infoIndex < this.myUpdateList.size(); ++infoIndex) {
            boolean useAnimation;
            InlayUpdateInfo info = this.myUpdateList.get(infoIndex);
            String oldText = info.oldText;
            String newText = info.newText;
            InlayUpdateInfo.Action action2 = info.action();
            if (action2 == InlayUpdateInfo.Action.ADD) {
                useAnimation = !this.myForceImmediateUpdate && !firstTime && !this.isSameHintRemovedNear(newText, infoIndex) && !isInBulkMode;
                Inlay inlay = this.myHintsManager.addHint(this.myEditor, info.offset, info.relatesToPrecedingText, newText, info.widthAdjustment, useAnimation);
                if (inlay == null || ((DocumentEx)this.myEditor.getDocument()).isInBulkUpdate()) continue;
                VisualPosition inlayPosition = inlay.getVisualPosition();
                VisualPosition visualPosition = new VisualPosition(inlayPosition.line, inlayPosition.column + (info.relatesToPrecedingText ? 1 : 0));
                Caret caret = this.myEditor.getCaretModel().getCaretAt(visualPosition);
                if (caret == null) continue;
                caret.moveToVisualPosition(new VisualPosition(inlayPosition.line, inlayPosition.column + (info.relatesToPrecedingText ? 0 : 1)));
                continue;
            }
            if (action2 == InlayUpdateInfo.Action.DELETE) {
                useAnimation = !this.myForceImmediateUpdate && oldText != null && !this.isSameHintAddedNear(oldText, infoIndex) && !isInBulkMode;
                this.myHintsManager.deleteHint(this.myEditor, info.inlay, useAnimation);
                continue;
            }
            if (action2 != InlayUpdateInfo.Action.REPLACE) continue;
            this.myHintsManager.replaceHint(this.myEditor, info.inlay, newText, info.widthAdjustment, !this.myForceImmediateUpdate);
        }
    }

    private boolean isSameHintRemovedNear(@NotNull String text2, int index) {
        if (text2 == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(6);
        }
        return this.getInfosNear(index).anyMatch(info -> text2.equals(info.oldText));
    }

    private boolean isSameHintAddedNear(@NotNull String text2, int index) {
        if (text2 == null) {
            ParameterHintsUpdater.$$$reportNull$$$0(7);
        }
        return this.getInfosNear(index).anyMatch(info -> text2.equals(info.newText));
    }

    private Stream<InlayUpdateInfo> getInfosNear(int index) {
        ArrayList<InlayUpdateInfo> result2 = new ArrayList<InlayUpdateInfo>();
        if (index > 0) {
            result2.add(this.myUpdateList.get(index - 1));
        }
        if (index + 1 < this.myUpdateList.size()) {
            result2.add(this.myUpdateList.get(index + 1));
        }
        return result2.stream();
    }

    private boolean delayRemoval(Inlay inlay) {
        int offset = inlay.getOffset();
        Caret caret = (Caret)this.myCaretMap.get(offset);
        if (caret == null) {
            return false;
        }
        CharSequence text2 = this.myEditor.getDocument().getImmutableCharSequence();
        if (offset >= text2.length()) {
            return false;
        }
        char afterCaret = text2.charAt(offset);
        if (afterCaret != ',' && afterCaret != ')') {
            return false;
        }
        VisualPosition afterInlayPosition = this.myEditor.offsetToVisualPosition(offset, true, false);
        return caret.getVisualPosition().equals((Object)afterInlayPosition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInlays";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintsToPreserve";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hints/ParameterHintsUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hintRemovalDelayed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPreserveHint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSameHintRemovedNear";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isSameHintAddedNear";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InlayUpdateInfo {
        public final int offset;
        public final Inlay inlay;
        public final String newText;
        public final String oldText;
        public final boolean relatesToPrecedingText;
        public final HintWidthAdjustment widthAdjustment;

        InlayUpdateInfo(int offset, @Nullable Inlay current, @Nullable ParameterHintsPass.HintData newHintData) {
            this.offset = offset;
            this.inlay = current;
            String string = this.oldText = this.inlay == null ? null : ParameterHintsPresentationManager.getInstance().getHintText(this.inlay);
            if (newHintData == null) {
                this.newText = null;
                this.relatesToPrecedingText = false;
                this.widthAdjustment = null;
            } else {
                this.newText = newHintData.presentationText;
                this.relatesToPrecedingText = newHintData.relatesToPrecedingText;
                this.widthAdjustment = newHintData.widthAdjustment;
            }
        }

        public Action action() {
            if (this.inlay == null) {
                return this.newText != null ? Action.ADD : Action.SKIP;
            }
            return this.newText != null ? Action.REPLACE : Action.DELETE;
        }

        public static enum Action {
            ADD,
            DELETE,
            REPLACE,
            SKIP;

        }
    }
}

