/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShRunConfigurationEditor;
import com.intellij.sh.run.ShRunConfigurationProfileState;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShRunConfiguration
extends LocatableConfigurationBase
implements RefactoringListenerProvider {
    private static final String SCRIPT_PATH_TAG = "SCRIPT_PATH";
    private static final String SCRIPT_OPTIONS_TAG = "SCRIPT_OPTIONS";
    private static final String INTERPRETER_PATH_TAG = "INTERPRETER_PATH";
    private static final String INTERPRETER_OPTIONS_TAG = "INTERPRETER_OPTIONS";
    private String myScriptPath;
    private String myScriptOptions;
    private String myInterpreterPath;
    private String myInterpreterOptions;

    ShRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            ShRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            ShRunConfiguration.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ShRunConfiguration.$$$reportNull$$$0(2);
        }
        super(project, factory, name);
        this.myScriptPath = "";
        this.myScriptOptions = "";
        this.myInterpreterPath = "";
        this.myInterpreterOptions = "";
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        ShRunConfigurationEditor shRunConfigurationEditor = new ShRunConfigurationEditor(this.getProject());
        if (shRunConfigurationEditor == null) {
            ShRunConfiguration.$$$reportNull$$$0(3);
        }
        return shRunConfigurationEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!FileUtil.exists((String)this.myScriptPath)) {
            throw new RuntimeConfigurationError("Shell script not found");
        }
        if (StringUtil.isNotEmpty((String)this.myInterpreterPath) || !new File(this.myScriptPath).canExecute()) {
            if (!FileUtil.exists((String)this.myInterpreterPath)) {
                throw new RuntimeConfigurationError("Interpreter not found");
            }
            if (!new File(this.myInterpreterPath).canExecute()) {
                throw new RuntimeConfigurationError("Interpreter should be executable file");
            }
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            ShRunConfiguration.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            ShRunConfiguration.$$$reportNull$$$0(5);
        }
        return new ShRunConfigurationProfileState(this.getProject(), this);
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(6);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_PATH_TAG, (String)this.myScriptPath);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_OPTIONS_TAG, (String)this.myScriptOptions);
        JDOMExternalizerUtil.writeField((Element)element, (String)INTERPRETER_PATH_TAG, (String)this.myInterpreterPath);
        JDOMExternalizerUtil.writeField((Element)element, (String)INTERPRETER_OPTIONS_TAG, (String)this.myInterpreterOptions);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(7);
        }
        super.readExternal(element);
        this.myScriptPath = StringUtilRt.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)SCRIPT_PATH_TAG), (String)"");
        this.myScriptOptions = StringUtilRt.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)SCRIPT_OPTIONS_TAG), (String)"");
        this.myInterpreterPath = StringUtilRt.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)INTERPRETER_PATH_TAG), (String)"");
        this.myInterpreterOptions = StringUtilRt.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)INTERPRETER_OPTIONS_TAG), (String)"");
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (StringUtil.isEmpty((String)this.myScriptPath) || !(element instanceof ShFile) || !this.myScriptPath.equals(ShRunConfiguration.getPathByElement(element))) {
            return null;
        }
        return new RefactoringElementAdapter(){

            protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                if (newElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newElement instanceof ShFile) {
                    ShRunConfiguration.this.setScriptPath(((ShFile)newElement).getVirtualFile().getPath());
                }
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                if (newElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (oldQualifiedName == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.elementRenamedOrMoved(newElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldQualifiedName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sh/run/ShRunConfiguration$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementRenamedOrMoved";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "undoElementMovedOrRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static String getPathByElement(@NotNull PsiElement element) {
        VirtualFile vfile;
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(8);
        }
        if ((vfile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        return vfile.getPath();
    }

    String getScriptPath() {
        return this.myScriptPath;
    }

    void setScriptPath(@NotNull String scriptPath) {
        if (scriptPath == null) {
            ShRunConfiguration.$$$reportNull$$$0(9);
        }
        this.myScriptPath = scriptPath.trim();
    }

    String getScriptOptions() {
        return this.myScriptOptions;
    }

    void setScriptOptions(@NotNull String scriptOptions) {
        if (scriptOptions == null) {
            ShRunConfiguration.$$$reportNull$$$0(10);
        }
        this.myScriptOptions = scriptOptions.trim();
    }

    String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    void setInterpreterPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            ShRunConfiguration.$$$reportNull$$$0(11);
        }
        this.myInterpreterPath = interpreterPath.trim();
    }

    String getInterpreterOptions() {
        return this.myInterpreterOptions;
    }

    void setInterpreterOptions(@NotNull String interpreterOptions) {
        if (interpreterOptions == null) {
            ShRunConfiguration.$$$reportNull$$$0(12);
        }
        this.myInterpreterOptions = interpreterOptions.trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptOptions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathByElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setScriptPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setScriptOptions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

