/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.finder;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigFinder {
    private EditorConfigFinder() {
    }

    public static void searchParentEditorConfigs(@NotNull VirtualFile root, @NotNull Callback callback) {
        if (root == null) {
            EditorConfigFinder.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            EditorConfigFinder.$$$reportNull$$$0(1);
        }
        for (VirtualFile parentDir = root.getParent(); parentDir != null; parentDir = parentDir.getParent()) {
            VirtualFile editorConfig = EditorConfigFinder.getEditorConfigUnder(parentDir);
            if (editorConfig == null || callback.found(editorConfig) != Callback.Result.Stop) continue;
            return;
        }
    }

    @Nullable
    private static VirtualFile getEditorConfigUnder(@NotNull VirtualFile dir) {
        if (dir == null) {
            EditorConfigFinder.$$$reportNull$$$0(2);
        }
        for (VirtualFile file : dir.getChildren()) {
            if (!EditorConfigFinder.isEditorConfig(file)) continue;
            return file;
        }
        return null;
    }

    private static boolean isEditorConfig(@NotNull VirtualFile file) {
        if (file == null) {
            EditorConfigFinder.$$$reportNull$$$0(3);
        }
        return ".editorconfig".equals(file.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/finder/EditorConfigFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "searchParentEditorConfigs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorConfigUnder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEditorConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Callback {
        public Result found(@NotNull VirtualFile var1);

        public void done();

        public static enum Result {
            Stop,
            Continue;

        }
    }
}

