/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.modules;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.pdfsam.module.Module;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.pdf.BaseFilesDroppedEvent;
import org.pdfsam.pdf.MultipleFilesDroppedEvent;
import org.pdfsam.pdf.SingleFileDroppedEvent;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.pdfsam.ui.commons.UrlButton;
import org.pdfsam.ui.dashboard.modules.DashboardTile;
import org.sejda.eventstudio.StaticStudio;

class ModulesDashboardTile
extends DashboardTile {
    private VBox toolButtons = new VBox(5.0);
    private String id;

    ModulesDashboardTile(Module module) {
        super(module.descriptor().getName(), module.descriptor().getDescription(), module.graphic());
        this.id = module.id();
        this.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> StaticStudio.eventStudio().broadcast((Object)SetActiveModuleRequest.activeteModule((String)this.id))));
        module.descriptor().getSupportURL().ifPresent(url -> {
            UrlButton helpButton = UrlButton.urlButton(null, (String)url, null, (String[])new String[]{"pdfsam-toolbar-button"});
            helpButton.setGraphic((Node)MaterialDesignIconFactory.get().createIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, "1.4em"));
            this.toolButtons.getChildren().add((Object)helpButton);
            this.toolButtons.getStyleClass().add((Object)"dashboard-modules-toolbar");
            this.addBottomPanel((Region)this.toolButtons);
        });
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        if (module.descriptor().hasInputType(ModuleInputOutputType.MULTIPLE_PDF)) {
            this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped(files -> new MultipleFilesDroppedEvent(this.id, files))));
        } else if (module.descriptor().hasInputType(ModuleInputOutputType.SINGLE_PDF)) {
            this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped(files -> new SingleFileDroppedEvent(this.id, files))));
        }
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        if (e.getDragboard().hasFiles()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragDropped(Function<List<File>, ? extends BaseFilesDroppedEvent> provider) {
        return e -> {
            StaticStudio.eventStudio().broadcast((Object)SetActiveModuleRequest.activeteModule((String)this.id));
            StaticStudio.eventStudio().broadcast(provider.apply(e.getDragboard().getFiles()));
            e.setDropCompleted(true);
        };
    }
}

