/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.List;
import org.jruby.util.StringSupport;

public class TimeZoneConverter {
    public static final int INVALID_ZONE = Integer.MIN_VALUE;

    private static int getOffsetFromZonesSource(String z) {
        switch (z) {
            case "ut": {
                return 0;
            }
            case "gmt": {
                return 0;
            }
            case "est": {
                return -18000;
            }
            case "edt": {
                return -14400;
            }
            case "cst": {
                return -21600;
            }
            case "cdt": {
                return -18000;
            }
            case "mst": {
                return -25200;
            }
            case "mdt": {
                return -21600;
            }
            case "pst": {
                return -28800;
            }
            case "pdt": {
                return -25200;
            }
            case "a": {
                return 3600;
            }
            case "b": {
                return 7200;
            }
            case "c": {
                return 10800;
            }
            case "d": {
                return 14400;
            }
            case "e": {
                return 18000;
            }
            case "f": {
                return 21600;
            }
            case "g": {
                return 25200;
            }
            case "h": {
                return 28800;
            }
            case "i": {
                return 32400;
            }
            case "k": {
                return 36000;
            }
            case "l": {
                return 39600;
            }
            case "m": {
                return 43200;
            }
            case "n": {
                return -3600;
            }
            case "o": {
                return -7200;
            }
            case "p": {
                return -10800;
            }
            case "q": {
                return -14400;
            }
            case "r": {
                return -18000;
            }
            case "s": {
                return -21600;
            }
            case "t": {
                return -25200;
            }
            case "u": {
                return -28800;
            }
            case "v": {
                return -32400;
            }
            case "w": {
                return -36000;
            }
            case "x": {
                return -39600;
            }
            case "y": {
                return -43200;
            }
            case "z": {
                return 0;
            }
            case "utc": {
                return 0;
            }
            case "wet": {
                return 0;
            }
            case "at": {
                return -7200;
            }
            case "brst": {
                return -7200;
            }
            case "ndt": {
                return -9000;
            }
            case "art": {
                return -10800;
            }
            case "adt": {
                return -10800;
            }
            case "brt": {
                return -10800;
            }
            case "clst": {
                return -10800;
            }
            case "nst": {
                return -12600;
            }
            case "ast": {
                return -14400;
            }
            case "clt": {
                return -14400;
            }
            case "akdt": {
                return -28800;
            }
            case "ydt": {
                return -28800;
            }
            case "akst": {
                return -32400;
            }
            case "hadt": {
                return -32400;
            }
            case "hdt": {
                return -32400;
            }
            case "yst": {
                return -32400;
            }
            case "ahst": {
                return -36000;
            }
            case "cat": {
                return -36000;
            }
            case "hast": {
                return -36000;
            }
            case "hst": {
                return -36000;
            }
            case "nt": {
                return -39600;
            }
            case "idlw": {
                return -43200;
            }
            case "bst": {
                return 3600;
            }
            case "cet": {
                return 3600;
            }
            case "fwt": {
                return 3600;
            }
            case "met": {
                return 3600;
            }
            case "mewt": {
                return 3600;
            }
            case "mez": {
                return 3600;
            }
            case "swt": {
                return 3600;
            }
            case "wat": {
                return 3600;
            }
            case "west": {
                return 3600;
            }
            case "cest": {
                return 7200;
            }
            case "eet": {
                return 7200;
            }
            case "fst": {
                return 7200;
            }
            case "mest": {
                return 7200;
            }
            case "mesz": {
                return 7200;
            }
            case "sast": {
                return 7200;
            }
            case "sst": {
                return 7200;
            }
            case "bt": {
                return 10800;
            }
            case "eat": {
                return 10800;
            }
            case "eest": {
                return 10800;
            }
            case "msk": {
                return 10800;
            }
            case "msd": {
                return 14400;
            }
            case "zp4": {
                return 14400;
            }
            case "zp5": {
                return 18000;
            }
            case "ist": {
                return 19800;
            }
            case "zp6": {
                return 21600;
            }
            case "wast": {
                return 25200;
            }
            case "cct": {
                return 28800;
            }
            case "sgt": {
                return 28800;
            }
            case "wadt": {
                return 28800;
            }
            case "jst": {
                return 32400;
            }
            case "kst": {
                return 32400;
            }
            case "east": {
                return 36000;
            }
            case "gst": {
                return 36000;
            }
            case "eadt": {
                return 39600;
            }
            case "idle": {
                return 43200;
            }
            case "nzst": {
                return 43200;
            }
            case "nzt": {
                return 43200;
            }
            case "nzdt": {
                return 46800;
            }
            case "afghanistan": {
                return 16200;
            }
            case "alaskan": {
                return -32400;
            }
            case "arab": {
                return 10800;
            }
            case "arabian": {
                return 14400;
            }
            case "arabic": {
                return 10800;
            }
            case "atlantic": {
                return -14400;
            }
            case "aus central": {
                return 34200;
            }
            case "aus eastern": {
                return 36000;
            }
            case "azores": {
                return -3600;
            }
            case "canada central": {
                return -21600;
            }
            case "cape verde": {
                return -3600;
            }
            case "caucasus": {
                return 14400;
            }
            case "cen. australia": {
                return 34200;
            }
            case "central america": {
                return -21600;
            }
            case "central asia": {
                return 21600;
            }
            case "central europe": {
                return 3600;
            }
            case "central european": {
                return 3600;
            }
            case "central pacific": {
                return 39600;
            }
            case "central": {
                return -21600;
            }
            case "china": {
                return 28800;
            }
            case "dateline": {
                return -43200;
            }
            case "e. africa": {
                return 10800;
            }
            case "e. australia": {
                return 36000;
            }
            case "e. europe": {
                return 7200;
            }
            case "e. south america": {
                return -10800;
            }
            case "eastern": {
                return -18000;
            }
            case "egypt": {
                return 7200;
            }
            case "ekaterinburg": {
                return 18000;
            }
            case "fiji": {
                return 43200;
            }
            case "fle": {
                return 7200;
            }
            case "greenland": {
                return -10800;
            }
            case "greenwich": {
                return 0;
            }
            case "gtb": {
                return 7200;
            }
            case "hawaiian": {
                return -36000;
            }
            case "india": {
                return 19800;
            }
            case "iran": {
                return 12600;
            }
            case "jerusalem": {
                return 7200;
            }
            case "korea": {
                return 32400;
            }
            case "mexico": {
                return -21600;
            }
            case "mid-atlantic": {
                return -7200;
            }
            case "mountain": {
                return -25200;
            }
            case "myanmar": {
                return 23400;
            }
            case "n. central asia": {
                return 21600;
            }
            case "nepal": {
                return 20700;
            }
            case "new zealand": {
                return 43200;
            }
            case "newfoundland": {
                return -12600;
            }
            case "north asia east": {
                return 28800;
            }
            case "north asia": {
                return 25200;
            }
            case "pacific sa": {
                return -14400;
            }
            case "pacific": {
                return -28800;
            }
            case "romance": {
                return 3600;
            }
            case "russian": {
                return 10800;
            }
            case "sa eastern": {
                return -10800;
            }
            case "sa pacific": {
                return -18000;
            }
            case "sa western": {
                return -14400;
            }
            case "samoa": {
                return -39600;
            }
            case "se asia": {
                return 25200;
            }
            case "malay peninsula": {
                return 28800;
            }
            case "south africa": {
                return 7200;
            }
            case "sri lanka": {
                return 21600;
            }
            case "taipei": {
                return 28800;
            }
            case "tasmania": {
                return 36000;
            }
            case "tokyo": {
                return 32400;
            }
            case "tonga": {
                return 46800;
            }
            case "us eastern": {
                return -18000;
            }
            case "us mountain": {
                return -25200;
            }
            case "vladivostok": {
                return 36000;
            }
            case "w. australia": {
                return 28800;
            }
            case "w. central africa": {
                return 3600;
            }
            case "w. europe": {
                return 3600;
            }
            case "west asia": {
                return 18000;
            }
            case "west pacific": {
                return 36000;
            }
            case "yakutsk": {
                return 32400;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static int dateZoneToDiff(String zone2) {
        boolean sign2;
        boolean dst;
        String z = zone2.toLowerCase();
        if (z.endsWith(" daylight time")) {
            z = z.substring(0, z.length() - " daylight time".length());
            dst = true;
        } else if (z.endsWith(" standard time")) {
            z = z.substring(0, z.length() - " standard time".length());
            dst = false;
        } else if (z.endsWith(" dst")) {
            z = z.substring(0, z.length() - " dst".length());
            dst = true;
        } else {
            dst = false;
        }
        int offsetFromZonesSource = TimeZoneConverter.getOffsetFromZonesSource(z);
        if (offsetFromZonesSource != Integer.MIN_VALUE) {
            if (dst) {
                offsetFromZonesSource += 3600;
            }
            return offsetFromZonesSource;
        }
        if (z.startsWith("gmt") || z.startsWith("utc")) {
            z = z.substring(3, z.length());
        }
        if (z.charAt(0) == '+') {
            sign2 = true;
        } else if (z.charAt(0) == '-') {
            sign2 = false;
        } else {
            return Integer.MIN_VALUE;
        }
        z = z.substring(1);
        int hour2 = 0;
        int min2 = 0;
        int sec2 = 0;
        if (z.indexOf(58) != -1) {
            List<String> splited = StringSupport.split(z, ':');
            if (splited.size() == 2) {
                hour2 = Integer.parseInt(splited.get(0));
                min2 = Integer.parseInt(splited.get(1));
            } else {
                hour2 = Integer.parseInt(splited.get(0));
                min2 = Integer.parseInt(splited.get(1));
                sec2 = Integer.parseInt(splited.get(2));
            }
        } else if (z.indexOf(44) != -1 || z.indexOf(46) != -1) {
            String[] splited = z.split("[\\.,]");
            hour2 = Integer.parseInt(splited[0]);
            min2 = (int)((double)(Integer.parseInt(splited[1]) * 60) / Math.pow(10.0, splited[1].length()));
        } else {
            int len = z.length();
            if (len % 2 != 0) {
                if (len >= 1) {
                    hour2 = Integer.parseInt(z.substring(0, 1));
                }
                if (len >= 3) {
                    min2 = Integer.parseInt(z.substring(1, 3));
                }
                if (len >= 5) {
                    sec2 = Integer.parseInt(z.substring(3, 5));
                }
            } else {
                if (len >= 2) {
                    hour2 = Integer.parseInt(z.substring(0, 2));
                }
                if (len >= 4) {
                    min2 = Integer.parseInt(z.substring(2, 4));
                }
                if (len >= 6) {
                    sec2 = Integer.parseInt(z.substring(4, 6));
                }
            }
        }
        int offset2 = hour2 * 3600 + min2 * 60 + sec2;
        return sign2 ? offset2 : -offset2;
    }

    private TimeZoneConverter() {
    }
}

