/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class AliasNode
extends Node {
    private Node oldName;
    private Node newName;

    public AliasNode(ISourcePosition position, Node newName, Node oldName) {
        super(position, newName.containsVariableAssignment() || oldName.containsVariableAssignment());
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ALIASNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitAliasNode(this);
    }

    public Node getNewName() {
        return this.newName;
    }

    public Node getOldName() {
        return this.oldName;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.newName, this.oldName);
    }
}

