"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var specs_parser_1 = require("../specs/specs_parser");
var chart_state_1 = require("../chart_types/xy_chart/store/chart_state");
var annotation_tooltips_1 = require("./annotation_tooltips");
var chart_resizer_1 = require("./chart_resizer");
var crosshair_1 = require("./crosshair");
var highlighter_1 = require("./highlighter");
var legend_1 = require("./legend/legend");
var chart_container_1 = require("./react_canvas/chart_container");
var tooltips_1 = require("./tooltips");
var axis_utils_1 = require("../chart_types/xy_chart/utils/axis_utils");
var chart_size_1 = require("../utils/chart_size");
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart(props) {
        var _this = _super.call(this, props) || this;
        _this.chartSpecStore = new chart_state_1.ChartStore(props.id);
        _this.state = {
            legendPosition: _this.chartSpecStore.legendPosition.get(),
        };
        // value is set to chart_store in settings so need to watch the value
        _this.chartSpecStore.legendPosition.observe(function (_a) {
            var legendPosition = _a.newValue;
            _this.setState({
                legendPosition: legendPosition,
            });
        });
        return _this;
    }
    Chart.prototype.dispatchExternalCursorEvent = function (event) {
        this.chartSpecStore.setActiveChartId(event && event.chartId);
        var isActiveChart = this.chartSpecStore.isActiveChart.get();
        if (!event) {
            this.chartSpecStore.externalCursorShown.set(false);
            this.chartSpecStore.isCursorOnChart.set(false);
        }
        else {
            if (!isActiveChart &&
                this.chartSpecStore.xScale.type === event.scale &&
                (event.unit === undefined || event.unit === this.chartSpecStore.xScale.unit)) {
                this.chartSpecStore.setCursorValue(event.value);
            }
        }
    };
    Chart.prototype.render = function () {
        var _a = this.props, renderer = _a.renderer, size = _a.size, className = _a.className;
        var containerStyle = Chart.getContainerStyle(size);
        var horizontal = axis_utils_1.isHorizontalAxis(this.state.legendPosition);
        var chartClassNames = classnames_1.default('echChart', className, {
            'echChart--column': horizontal,
        });
        return (react_1.default.createElement(mobx_react_1.Provider, { chartStore: this.chartSpecStore },
            react_1.default.createElement("div", { style: containerStyle, className: chartClassNames },
                react_1.default.createElement(legend_1.Legend, null),
                react_1.default.createElement(specs_parser_1.SpecsParser, null, this.props.children),
                react_1.default.createElement("div", { className: "echContainer" },
                    react_1.default.createElement(chart_resizer_1.ChartResizer, null),
                    react_1.default.createElement(crosshair_1.Crosshair, null),
                    renderer === 'svg' && react_1.default.createElement(chart_container_1.ChartContainer, null),
                    renderer === 'canvas' && react_1.default.createElement(chart_container_1.ChartContainer, null),
                    react_1.default.createElement(tooltips_1.Tooltips, null),
                    react_1.default.createElement(annotation_tooltips_1.AnnotationTooltip, null),
                    react_1.default.createElement(highlighter_1.Highlighter, null)))));
    };
    Chart.defaultProps = {
        renderer: 'canvas',
    };
    Chart.getContainerStyle = function (size) {
        if (size) {
            return __assign({ position: 'relative' }, chart_size_1.getChartSize(size));
        }
        return {};
    };
    return Chart;
}(react_1.default.Component));
exports.Chart = Chart;
//# sourceMappingURL=chart.js.map