"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var specs_1 = require("../chart_types/xy_chart/utils/specs");
var AnnotationTooltipComponent = /** @class */ (function (_super) {
    __extends(AnnotationTooltipComponent, _super);
    function AnnotationTooltipComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnnotationTooltipComponent.prototype.renderTooltip = function () {
        var annotationTooltipState = this.props.chartStore.annotationTooltipState;
        var tooltipState = annotationTooltipState.get();
        if (!tooltipState || !tooltipState.isVisible) {
            return react_1.default.createElement("div", { className: "echAnnotation__tooltip echAnnotation__tooltip--hidden" });
        }
        var transform = tooltipState.transform, details = tooltipState.details, header = tooltipState.header;
        var chartDimensions = this.props.chartStore.chartDimensions;
        var tooltipTop = tooltipState.top;
        var tooltipLeft = tooltipState.left;
        var top = tooltipTop == null ? chartDimensions.top : chartDimensions.top + tooltipTop;
        var left = tooltipLeft == null ? chartDimensions.left : chartDimensions.left + tooltipLeft;
        var position = {
            transform: transform,
            top: top,
            left: left,
        };
        switch (tooltipState.annotationType) {
            case 'line': {
                var props = { position: position, details: details, header: header };
                return react_1.default.createElement(LineAnnotationTooltip, __assign({}, props));
            }
            case 'rectangle': {
                var props = { details: details, position: position, customTooltip: tooltipState.renderTooltip };
                return react_1.default.createElement(RectAnnotationTooltip, __assign({}, props));
            }
            default:
                return null;
        }
    };
    AnnotationTooltipComponent.prototype.renderAnnotationLineMarkers = function (annotationLines, id) {
        var chartDimensions = this.props.chartStore.chartDimensions;
        var markers = [];
        annotationLines.forEach(function (line, index) {
            if (!line.marker) {
                return;
            }
            var _a = line.marker, transform = _a.transform, icon = _a.icon, color = _a.color;
            var style = {
                color: color,
                transform: transform,
                top: chartDimensions.top,
                left: chartDimensions.left,
            };
            var markerElement = (react_1.default.createElement("div", { className: "echAnnotation", style: __assign({}, style), key: "annotation-" + id + "-" + index }, icon));
            markers.push(markerElement);
        });
        return markers;
    };
    AnnotationTooltipComponent.prototype.renderAnnotationMarkers = function () {
        var _this = this;
        var _a = this.props.chartStore, annotationDimensions = _a.annotationDimensions, annotationSpecs = _a.annotationSpecs;
        var markers = [];
        annotationDimensions.forEach(function (dimensions, id) {
            var annotationSpec = annotationSpecs.get(id);
            if (!annotationSpec) {
                return;
            }
            if (specs_1.isLineAnnotation(annotationSpec)) {
                var annotationLines = dimensions;
                var lineMarkers = _this.renderAnnotationLineMarkers(annotationLines, id);
                markers.push.apply(markers, __spread(lineMarkers));
            }
        });
        return markers;
    };
    AnnotationTooltipComponent.prototype.render = function () {
        var chartStore = this.props.chartStore;
        if (chartStore.isChartEmpty.get()) {
            return null;
        }
        return (react_1.default.createElement(react_1.default.Fragment, null,
            this.renderAnnotationMarkers(),
            this.renderTooltip()));
    };
    AnnotationTooltipComponent.displayName = 'AnnotationTooltip';
    return AnnotationTooltipComponent;
}(react_1.default.Component));
exports.AnnotationTooltip = mobx_react_1.inject('chartStore')(mobx_react_1.observer(AnnotationTooltipComponent));
function RectAnnotationTooltip(props) {
    var details = props.details, position = props.position, customTooltip = props.customTooltip;
    var tooltipContent = customTooltip ? customTooltip(details) : details;
    if (!tooltipContent) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "echAnnotation__tooltip", style: __assign({}, position) },
        react_1.default.createElement("div", { className: "echAnnotation__details" },
            react_1.default.createElement("div", { className: "echAnnotation__detailsText" }, tooltipContent))));
}
function LineAnnotationTooltip(props) {
    var details = props.details, position = props.position, header = props.header;
    return (react_1.default.createElement("div", { className: "echAnnotation__tooltip", style: __assign({}, position) },
        react_1.default.createElement("p", { className: "echAnnotation__header" }, header),
        react_1.default.createElement("div", { className: "echAnnotation__details" }, details)));
}
//# sourceMappingURL=annotation_tooltips.js.map