/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class LuceneBackendTaskStreamer {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final LuceneBackendResources resources;
    private final Lock modificationLock;
    private final AbstractWorkspaceImpl workspace;

    public LuceneBackendTaskStreamer(LuceneBackendResources resources) {
        this.workspace = resources.getWorkspace();
        this.modificationLock = resources.getParallelModificationLock();
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(LuceneWork work, IndexingMonitor monitor) {
        this.modificationLock.lock();
        try {
            IndexWriterDelegate delegate = this.workspace.getIndexWriterDelegate();
            if (delegate == null) {
                log.cannotOpenIndexWriterCausePreviousError();
                return;
            }
            boolean errors = true;
            try {
                LuceneWorkExecutor executor = work.acceptIndexWorkVisitor(this.resources.getWorkVisitor(), null);
                executor.performWork(work, delegate, monitor);
                errors = false;
            }
            finally {
                this.workspace.afterTransactionApplied(errors, true);
            }
        }
        finally {
            this.modificationLock.unlock();
        }
    }
}

