/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.instagram;

import com.fasterxml.jackson.databind.JsonNode;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.models.KeycloakSession;

public class InstagramIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://api.instagram.com/oauth/authorize";
    public static final String TOKEN_URL = "https://api.instagram.com/oauth/access_token";
    public static final String PROFILE_URL = "https://api.instagram.com/v1/users/self";
    public static final String DEFAULT_SCOPE = "basic";

    public InstagramIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode raw = SimpleHttp.doGet((String)PROFILE_URL, (KeycloakSession)this.session).param("access_token", accessToken).asJson();
            JsonNode profile = raw.get("data");
            logger.debug((Object)profile.toString());
            String id = this.getJsonProperty(profile, "id");
            BrokeredIdentityContext user = new BrokeredIdentityContext(id);
            String username = this.getJsonProperty(profile, "username");
            user.setUsername(username);
            String full_name = this.getJsonProperty(profile, "full_name");
            user.setName(full_name);
            user.setIdpConfig(this.getConfig());
            user.setIdp((IdentityProvider)this);
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from instagram.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

