/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class OpeningHourTest
extends Test.TagTest {
    public static final ScriptEngine ENGINE = Utils.getJavaScriptEngine();

    public OpeningHourTest() {
        super(I18n.tr("Opening hours syntax", new Object[0]), I18n.tr("This test checks the correct usage of the opening hours syntax.", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        block12: {
            super.initialize();
            if (ENGINE != null) {
                try (CachedFile cf = new CachedFile("resource://data/validator/opening_hours.js");
                     BufferedReader reader = cf.getContentReader();){
                    ENGINE.eval("var console={};console.debug=print;console.log=print;console.warn=print;console.error=print;");
                    ENGINE.eval(reader);
                    ENGINE.eval("var opening_hours = require('opening_hours');");
                    ENGINE.eval("var nominatimJSON = {address: {state: 'Bayern', country_code: 'de'}};");
                    ENGINE.eval("var oh = function (value, tag_key, mode, locale) { try {    var conf = {tag_key: tag_key, locale: locale};    if (mode > -1) {      conf.mode = mode;    }    var r = new opening_hours(value, nominatimJSON, conf);    r.getErrors = function() {return [];};    return r;  } catch (err) {    return {      prettifyValue: function() {return null;},      getWarnings: function() {return [];},      getErrors: function() {return [err.toString()]}    };  }};");
                    break block12;
                }
            }
            Logging.warn("Unable to initialize OpeningHourTest because no JavaScript engine has been found");
        }
    }

    public Object parse(String value, String tagKey, CheckMode mode, String locale) throws ScriptException, NoSuchMethodException {
        return ((Invocable)((Object)ENGINE)).invokeFunction("oh", value, tagKey, mode != null ? mode.code : -1, locale);
    }

    protected List<Object> getList(Object obj) throws ScriptException, NoSuchMethodException {
        if (obj == null || "".equals(obj)) {
            return Arrays.asList(new Object[0]);
        }
        if (obj instanceof String) {
            String[] strings = ((String)obj).split("\\\\n");
            return Arrays.asList(strings);
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        return this.getList(((Invocable)((Object)ENGINE)).invokeMethod(obj, "join", "\\n"));
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String key, String value) {
        return this.checkOpeningHourSyntax(key, value, null, false, LanguageInfo.getJOSMLocaleCode());
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String key, String value, CheckMode mode, boolean ignoreOtherSeverity, String locale) {
        if (ENGINE == null || value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OpeningHoursTestError> errors = new ArrayList<OpeningHoursTestError>();
        try {
            Object r = this.parse(value, key, mode, locale);
            String prettifiedValue = null;
            try {
                prettifiedValue = this.getOpeningHoursPrettifiedValues(r);
            }
            catch (NoSuchMethodException | ScriptException e) {
                Logging.warn(e);
            }
            for (Object i : this.getOpeningHoursErrors(r)) {
                errors.add(new OpeningHoursTestError(OpeningHourTest.getErrorMessage(key, i), Severity.ERROR, prettifiedValue));
            }
            for (Object i : this.getOpeningHoursWarnings(r)) {
                errors.add(new OpeningHoursTestError(OpeningHourTest.getErrorMessage(key, i), Severity.WARNING, prettifiedValue));
            }
            if (!ignoreOtherSeverity && errors.isEmpty() && prettifiedValue != null && !value.equals(prettifiedValue)) {
                errors.add(new OpeningHoursTestError(I18n.tr("opening_hours value can be prettified", new Object[0]), Severity.OTHER, prettifiedValue));
            }
        }
        catch (NoSuchMethodException | ScriptException ex) {
            Logging.error(ex);
            GuiHelper.runInEDT(() -> new Notification(Utils.getRootCause(ex).getMessage()).setIcon(0).show());
        }
        return errors;
    }

    public final String getOpeningHoursPrettifiedValues(Object r) throws NoSuchMethodException, ScriptException {
        return (String)((Invocable)((Object)ENGINE)).invokeMethod(r, "prettifyValue", new Object[0]);
    }

    public final List<Object> getOpeningHoursErrors(Object r) throws NoSuchMethodException, ScriptException {
        return this.getList(((Invocable)((Object)ENGINE)).invokeMethod(r, "getErrors", new Object[0]));
    }

    public final List<Object> getOpeningHoursWarnings(Object r) throws NoSuchMethodException, ScriptException {
        return this.getList(((Invocable)((Object)ENGINE)).invokeMethod(r, "getWarnings", new Object[0]));
    }

    public static String getErrorMessage(Object o) {
        return o.toString().trim().replace("Unexpected token:", I18n.tr("Unexpected token:", new Object[0])).replace("Unexpected token (school holiday parser):", I18n.tr("Unexpected token (school holiday parser):", new Object[0])).replace("Unexpected token in number range:", I18n.tr("Unexpected token in number range:", new Object[0])).replace("Unexpected token in week range:", I18n.tr("Unexpected token in week range:", new Object[0])).replace("Unexpected token in weekday range:", I18n.tr("Unexpected token in weekday range:", new Object[0])).replace("Unexpected token in month range:", I18n.tr("Unexpected token in month range:", new Object[0])).replace("Unexpected token in year range:", I18n.tr("Unexpected token in year range:", new Object[0])).replace("This means that the syntax is not valid at that point or it is currently not supported.", I18n.tr("Invalid/unsupported syntax.", new Object[0]));
    }

    static String getErrorMessage(String key, Object o) {
        return key + " - " + OpeningHourTest.getErrorMessage(o);
    }

    protected void check(OsmPrimitive p, String key) {
        for (OpeningHoursTestError e : this.checkOpeningHourSyntax(key, p.get(key))) {
            this.errors.add(e.getTestError(p, key));
        }
    }

    @Override
    public void check(OsmPrimitive p) {
        if (p.isTagged()) {
            this.check(p, "opening_hours");
            this.check(p, "collection_times");
            this.check(p, "service_times");
        }
    }

    public class OpeningHoursTestError {
        private final Severity severity;
        private final String message;
        private final String prettifiedValue;

        public OpeningHoursTestError(String message, Severity severity, String prettifiedValue) {
            this.message = message;
            this.severity = severity;
            this.prettifiedValue = prettifiedValue;
        }

        public TestError getTestError(OsmPrimitive p, String key) {
            TestError.Builder error = TestError.builder(OpeningHourTest.this, this.severity, 2901).message(I18n.tr("Opening hours syntax", new Object[0]), this.message, new Object[0]).primitives(p);
            if (this.prettifiedValue == null || this.prettifiedValue.equals(p.get(key))) {
                return error.build();
            }
            return error.fix(() -> new ChangePropertyCommand(p, key, this.prettifiedValue)).build();
        }

        public String getMessage() {
            return this.message;
        }

        public String getPrettifiedValue() {
            return this.prettifiedValue;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return this.getMessage() + " => " + this.getPrettifiedValue();
        }
    }

    public static enum CheckMode {
        TIME_RANGE(0),
        POINTS_IN_TIME(1),
        BOTH(2);

        private final int code;

        private CheckMode(int code) {
            this.code = code;
        }
    }
}

