/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.EventListenerList;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class JMapViewer
extends JPanel
implements TileLoaderListener {
    private static final long serialVersionUID = 1L;
    public static boolean debug;
    public static boolean zoomReverseWheel;
    private static final Point[] move;
    public static final int MAX_ZOOM = 24;
    public static final int MIN_ZOOM = 0;
    protected transient List<MapMarker> mapMarkerList;
    protected transient List<MapRectangle> mapRectangleList;
    protected transient List<MapPolygon> mapPolygonList;
    protected boolean mapMarkersVisible;
    protected boolean mapRectanglesVisible;
    protected boolean mapPolygonsVisible;
    protected boolean tileGridVisible;
    protected boolean scrollWrapEnabled;
    protected transient TileController tileController;
    protected Point center;
    protected int zoom;
    protected JSlider zoomSlider;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected ZOOM_BUTTON_STYLE zoomButtonStyle;
    protected transient TileSource tileSource;
    protected transient AttributionSupport attribution = new AttributionSupport();
    protected EventListenerList evtListenerList = new EventListenerList();

    public JMapViewer() {
        this(new MemoryTileCache());
        new DefaultMapController(this);
    }

    @Deprecated
    public JMapViewer(TileCache tileCache, int downloadThreadCount) {
        this(tileCache);
    }

    public JMapViewer(TileCache tileCache) {
        this.tileSource = new OsmTileSource.Mapnik();
        this.tileController = new TileController(this.tileSource, tileCache, this);
        this.mapMarkerList = Collections.synchronizedList(new ArrayList());
        this.mapPolygonList = Collections.synchronizedList(new ArrayList());
        this.mapRectangleList = Collections.synchronizedList(new ArrayList());
        this.mapMarkersVisible = true;
        this.mapRectanglesVisible = true;
        this.mapPolygonsVisible = true;
        this.tileGridVisible = false;
        this.setLayout(null);
        this.initializeZoomSlider();
        this.setMinimumSize(new Dimension(this.tileSource.getTileSize(), this.tileSource.getTileSize()));
        this.setPreferredSize(new Dimension(400, 400));
        this.setDisplayPosition(new Coordinate(50.0, 9.0), 3);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return super.getToolTipText(event);
    }

    protected void initializeZoomSlider() {
        this.zoomSlider = new JSlider(0, this.tileController.getTileSource().getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.addChangeListener(e -> this.setZoom(this.zoomSlider.getValue()));
        this.zoomSlider.setFocusable(false);
        this.add(this.zoomSlider);
        int size = 18;
        ImageIcon icon = JMapViewer.getImageIcon("images/plus.png");
        if (icon != null) {
            this.zoomInButton = new JButton(icon);
        } else {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setBounds(4, 155, size, size);
        this.zoomInButton.addActionListener(e -> this.zoomIn());
        this.zoomInButton.setFocusable(false);
        this.add(this.zoomInButton);
        icon = JMapViewer.getImageIcon("images/minus.png");
        if (icon != null) {
            this.zoomOutButton = new JButton(icon);
        } else {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setBounds(8 + size, 155, size, size);
        this.zoomOutButton.addActionListener(e -> this.zoomOut());
        this.zoomOutButton.setFocusable(false);
        this.add(this.zoomOutButton);
    }

    private static ImageIcon getImageIcon(String name) {
        URL url = JMapViewer.class.getResource(name);
        if (url != null) {
            try {
                return new ImageIcon(FeatureAdapter.readImage(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDisplayPosition(ICoordinate to, int zoom) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), to, zoom);
    }

    public void setDisplayPosition(Point mapPoint, ICoordinate to, int zoom) {
        Point p = this.tileSource.latLonToXY(to, zoom);
        this.setDisplayPosition(mapPoint, p.x, p.y, zoom);
    }

    public void setDisplayPosition(int x, int y, int zoom) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), x, y, zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point mapPoint, int x, int y, int zoom) {
        if (zoom > this.tileController.getTileSource().getMaxZoom() || zoom < 0) {
            return;
        }
        Point p = new Point();
        p.x = x - mapPoint.x + this.getWidth() / 2;
        p.y = y - mapPoint.y + this.getHeight() / 2;
        this.center = p;
        this.setIgnoreRepaint(true);
        try {
            int oldZoom = this.zoom;
            this.zoom = zoom;
            if (oldZoom != zoom) {
                this.zoomChanged(oldZoom);
            }
            if (this.zoomSlider.getValue() != zoom) {
                this.zoomSlider.setValue(zoom);
            }
        }
        finally {
            this.setIgnoreRepaint(false);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setDisplayToFitMapElements(boolean markers, boolean rectangles, boolean polygons) {
        void var14_23;
        int x;
        JMapViewer jMapViewer;
        int nbElemToCheck = 0;
        if (markers && this.mapMarkerList != null) {
            nbElemToCheck += this.mapMarkerList.size();
        }
        if (rectangles && this.mapRectangleList != null) {
            nbElemToCheck += this.mapRectangleList.size();
        }
        if (polygons && this.mapPolygonList != null) {
            nbElemToCheck += this.mapPolygonList.size();
        }
        if (nbElemToCheck == 0) {
            return;
        }
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        int mapZoomMax = this.tileController.getTileSource().getMaxZoom();
        if (markers && this.mapMarkerList != null) {
            jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapMarker marker : this.mapMarkerList) {
                    if (!marker.isVisible()) continue;
                    Point p = this.tileSource.latLonToXY(marker.getCoordinate(), mapZoomMax);
                    xMax = Math.max(xMax, p.x);
                    yMax = Math.max(yMax, p.y);
                    xMin = Math.min(xMin, p.x);
                    yMin = Math.min(yMin, p.y);
                }
            }
        }
        if (rectangles && this.mapRectangleList != null) {
            jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapRectangle rectangle : this.mapRectangleList) {
                    if (!rectangle.isVisible()) continue;
                    Point bottomRight = this.tileSource.latLonToXY(rectangle.getBottomRight(), mapZoomMax);
                    Point point = this.tileSource.latLonToXY(rectangle.getTopLeft(), mapZoomMax);
                    xMax = Math.max(xMax, bottomRight.x);
                    yMax = Math.max(yMax, point.y);
                    xMin = Math.min(xMin, point.x);
                    yMin = Math.min(yMin, bottomRight.y);
                }
            }
        }
        if (polygons && this.mapPolygonList != null) {
            jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapPolygon polygon : this.mapPolygonList) {
                    if (!polygon.isVisible()) continue;
                    for (ICoordinate iCoordinate : polygon.getPoints()) {
                        Point p = this.tileSource.latLonToXY(iCoordinate, mapZoomMax);
                        xMax = Math.max(xMax, p.x);
                        yMax = Math.max(yMax, p.y);
                        xMin = Math.min(xMin, p.x);
                        yMin = Math.min(yMin, p.y);
                    }
                }
            }
        }
        int height = Math.max(0, this.getHeight());
        int width = Math.max(0, this.getWidth());
        int newZoom = mapZoomMax;
        int n = yMax - yMin;
        for (x = xMax - xMin; x > width || var14_23 > height; x >>= 1, var14_23 >>= 1) {
            --newZoom;
        }
        x = xMin + (xMax - xMin) / 2;
        int n2 = yMin + (yMax - yMin) / 2;
        int z = 1 << mapZoomMax - newZoom;
        int n3 = n2 / z;
        this.setDisplayPosition(x /= z, n3, newZoom);
    }

    public void setDisplayToFitMapMarkers() {
        this.setDisplayToFitMapElements(true, false, false);
    }

    public void setDisplayToFitMapRectangles() {
        this.setDisplayToFitMapElements(false, true, false);
    }

    public void setDisplayToFitMapPolygons() {
        this.setDisplayToFitMapElements(false, false, true);
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public ICoordinate getPosition() {
        return this.tileSource.xyToLatLon(this.center, this.zoom);
    }

    public ICoordinate getPosition(Point mapPoint) {
        return this.getPosition(mapPoint.x, mapPoint.y);
    }

    public ICoordinate getPosition(int mapPointX, int mapPointY) {
        int x = this.center.x + mapPointX - this.getWidth() / 2;
        int y = this.center.y + mapPointY - this.getHeight() / 2;
        return this.tileSource.xyToLatLon(x, y, this.zoom);
    }

    public Point getMapPosition(double lat, double lon, boolean checkOutside) {
        Point p = this.tileSource.latLonToXY(lat, lon, this.zoom);
        p.translate(-(this.center.x - this.getWidth() / 2), -(this.center.y - this.getHeight() / 2));
        if (checkOutside && (p.x < 0 || p.y < 0 || p.x > this.getWidth() || p.y > this.getHeight())) {
            return null;
        }
        return p;
    }

    public Point getMapPosition(double lat, double lon) {
        return this.getMapPosition(lat, lon, true);
    }

    public Integer getLatOffset(double lat, double lon, double offset, boolean checkOutside) {
        Point p = this.tileSource.latLonToXY(lat + offset, lon, this.zoom);
        int y = p.y - (this.center.y - this.getHeight() / 2);
        if (checkOutside && (y < 0 || y > this.getHeight())) {
            return null;
        }
        return y;
    }

    public Integer getRadius(MapMarker marker, Point p) {
        if (marker.getMarkerStyle() == MapMarker.STYLE.FIXED) {
            return (int)marker.getRadius();
        }
        if (p != null) {
            Integer radius = this.getLatOffset(marker.getLat(), marker.getLon(), marker.getRadius(), false);
            radius = radius == null ? null : Integer.valueOf(p.y - radius);
            return radius;
        }
        return null;
    }

    public Point getMapPosition(Coordinate coord) {
        if (coord != null) {
            return this.getMapPosition(coord.getLat(), coord.getLon());
        }
        return null;
    }

    public Point getMapPosition(ICoordinate coord, boolean checkOutside) {
        if (coord != null) {
            return this.getMapPosition(coord.getLat(), coord.getLon(), checkOutside);
        }
        return null;
    }

    public double getMeterPerPixel() {
        Point origin = new Point(5, 5);
        Point center = new Point(this.getWidth() / 2, this.getHeight() / 2);
        double pDistance = center.distance(origin);
        ICoordinate originCoord = this.getPosition(origin);
        ICoordinate centerCoord = this.getPosition(center);
        double mDistance = this.tileSource.getDistance(originCoord.getLat(), originCoord.getLon(), centerCoord.getLat(), centerCoord.getLon());
        return mDistance / pDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        boolean startTop;
        super.paintComponent(g);
        int iMove = 0;
        int tilesize = this.tileSource.getTileSize();
        int tilex = this.center.x / tilesize;
        int tiley = this.center.y / tilesize;
        int offsx = this.center.x % tilesize;
        int offsy = this.center.y % tilesize;
        int w2 = this.getWidth() / 2;
        int h2 = this.getHeight() / 2;
        int posx = w2 - offsx;
        int posy = h2 - offsy;
        int diffLeft = offsx;
        int diffRight = tilesize - offsx;
        int diffTop = offsy;
        int diffBottom = tilesize - offsy;
        boolean startLeft = diffLeft < diffRight;
        boolean bl = startTop = diffTop < diffBottom;
        iMove = startTop ? (startLeft ? 2 : 3) : (startLeft ? 1 : 0);
        int xMin = -tilesize;
        int yMin = -tilesize;
        int xMax = this.getWidth();
        int yMax = this.getHeight();
        int gridLength = 1 << this.zoom;
        boolean painted = true;
        int x = 0;
        while (painted) {
            painted = false;
            for (int i = 0; i < 4; ++i) {
                if (i % 2 == 0) {
                    ++x;
                }
                for (int j = 0; j < x; ++j) {
                    if (xMin <= posx && posx <= xMax && yMin <= posy && posy <= yMax) {
                        Tile tile;
                        if (this.scrollWrapEnabled) {
                            int tilexWrap = (tilex % gridLength + gridLength) % gridLength;
                            tile = this.tileController.getTile(tilexWrap, tiley, this.zoom);
                        } else {
                            tile = this.tileController.getTile(tilex, tiley, this.zoom);
                        }
                        if (tile != null) {
                            tile.paint(g, posx, posy, tilesize, tilesize);
                            if (this.tileGridVisible) {
                                g.drawRect(posx, posy, tilesize, tilesize);
                            }
                        }
                        painted = true;
                    }
                    Point p = move[iMove];
                    posx += p.x * tilesize;
                    posy += p.y * tilesize;
                    tilex += p.x;
                    tiley += p.y;
                }
                iMove = (iMove + 1) % move.length;
            }
        }
        int mapSize = tilesize << this.zoom;
        if (this.scrollWrapEnabled) {
            g.drawLine(0, h2 - this.center.y, this.getWidth(), h2 - this.center.y);
            g.drawLine(0, h2 - this.center.y + mapSize, this.getWidth(), h2 - this.center.y + mapSize);
        } else {
            g.drawRect(w2 - this.center.x, h2 - this.center.y, mapSize, mapSize);
        }
        if (this.scrollWrapEnabled) {
            this.center.x %= mapSize;
        }
        if (this.mapPolygonsVisible && this.mapPolygonList != null) {
            JMapViewer jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapPolygon polygon : this.mapPolygonList) {
                    if (!polygon.isVisible()) continue;
                    this.paintPolygon(g, polygon);
                }
            }
        }
        if (this.mapRectanglesVisible && this.mapRectangleList != null) {
            JMapViewer jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapRectangle rectangle : this.mapRectangleList) {
                    if (!rectangle.isVisible()) continue;
                    this.paintRectangle(g, rectangle);
                }
            }
        }
        if (this.mapMarkersVisible && this.mapMarkerList != null) {
            JMapViewer jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapMarker marker : this.mapMarkerList) {
                    if (!marker.isVisible()) continue;
                    this.paintMarker(g, marker);
                }
            }
        }
        this.attribution.paintAttribution(g, this.getWidth(), this.getHeight(), this.getPosition(0, 0), this.getPosition(this.getWidth(), this.getHeight()), this.zoom, this);
    }

    protected void paintMarker(Graphics g, MapMarker marker) {
        Point p = this.getMapPosition(marker.getLat(), marker.getLon(), marker.getMarkerStyle() == MapMarker.STYLE.FIXED);
        Integer radius = this.getRadius(marker, p);
        if (this.scrollWrapEnabled) {
            int xSave;
            int tilesize = this.tileSource.getTileSize();
            int mapSize = tilesize << this.zoom;
            if (p == null) {
                p = this.getMapPosition(marker.getLat(), marker.getLon(), false);
                radius = this.getRadius(marker, p);
            }
            marker.paint(g, p, radius);
            int xWrap = xSave = p.x;
            while ((xWrap -= mapSize) >= -15) {
                p.x = xWrap;
                marker.paint(g, p, radius);
            }
            xWrap = xSave;
            while ((xWrap += mapSize) <= this.getWidth() + 15) {
                p.x = xWrap;
                marker.paint(g, p, radius);
            }
        } else if (p != null) {
            marker.paint(g, p, radius);
        }
    }

    protected void paintRectangle(Graphics g, MapRectangle rectangle) {
        Coordinate topLeft = rectangle.getTopLeft();
        Coordinate bottomRight = rectangle.getBottomRight();
        if (topLeft != null && bottomRight != null) {
            Point pTopLeft = this.getMapPosition(topLeft, false);
            Point pBottomRight = this.getMapPosition(bottomRight, false);
            if (pTopLeft != null && pBottomRight != null) {
                rectangle.paint(g, pTopLeft, pBottomRight);
                if (this.scrollWrapEnabled) {
                    int xBottomRightSave;
                    int xTopLeftSave;
                    int tilesize = this.tileSource.getTileSize();
                    int mapSize = tilesize << this.zoom;
                    int xTopLeftWrap = xTopLeftSave = pTopLeft.x;
                    int xBottomRightWrap = xBottomRightSave = pBottomRight.x;
                    while ((xBottomRightWrap -= mapSize) >= 0) {
                        pTopLeft.x = xTopLeftWrap -= mapSize;
                        pBottomRight.x = xBottomRightWrap;
                        rectangle.paint(g, pTopLeft, pBottomRight);
                    }
                    xTopLeftWrap = xTopLeftSave;
                    xBottomRightWrap = xBottomRightSave;
                    while ((xTopLeftWrap += mapSize) <= this.getWidth()) {
                        pTopLeft.x = xTopLeftWrap;
                        pBottomRight.x = xBottomRightWrap += mapSize;
                        rectangle.paint(g, pTopLeft, pBottomRight);
                    }
                }
            }
        }
    }

    protected void paintPolygon(Graphics g, MapPolygon polygon) {
        List<? extends ICoordinate> coords = polygon.getPoints();
        if (coords != null && coords.size() >= 3) {
            ArrayList<Point> points = new ArrayList<Point>();
            for (ICoordinate iCoordinate : coords) {
                Point p = this.getMapPosition(iCoordinate, false);
                if (p == null) {
                    return;
                }
                points.add(p);
            }
            polygon.paint(g, points);
            if (this.scrollWrapEnabled) {
                int tilesize = this.tileSource.getTileSize();
                int n = tilesize << this.zoom;
                ArrayList<Point> pointsWrapped = new ArrayList<Point>(points);
                boolean keepWrapping = true;
                while (keepWrapping) {
                    for (Point p : pointsWrapped) {
                        p.x -= n;
                        if (p.x >= 0) continue;
                        keepWrapping = false;
                    }
                    polygon.paint(g, pointsWrapped);
                }
                pointsWrapped = new ArrayList<Point>(points);
                keepWrapping = true;
                while (keepWrapping) {
                    for (Point p : pointsWrapped) {
                        p.x += n;
                        if (p.x <= this.getWidth()) continue;
                        keepWrapping = false;
                    }
                    polygon.paint(g, pointsWrapped);
                }
            }
        }
    }

    public void moveMap(int x, int y) {
        this.tileController.cancelOutstandingJobs();
        this.center.x += x;
        this.center.y += y;
        this.repaint();
        this.fireJMVEvent(new JMVCommandEvent(JMVCommandEvent.COMMAND.MOVE, this));
    }

    public int getZoom() {
        return this.zoom;
    }

    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    public void zoomIn(Point mapPoint) {
        this.setZoom(this.zoom + 1, mapPoint);
    }

    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void zoomOut(Point mapPoint) {
        this.setZoom(this.zoom - 1, mapPoint);
    }

    public void setZoom(int zoom, Point mapPoint) {
        if (zoom > this.tileController.getTileSource().getMaxZoom() || zoom < this.tileController.getTileSource().getMinZoom() || zoom == this.zoom) {
            return;
        }
        ICoordinate zoomPos = this.getPosition(mapPoint);
        this.tileController.cancelOutstandingJobs();
        this.setDisplayPosition(mapPoint, zoomPos, zoom);
        this.fireJMVEvent(new JMVCommandEvent(JMVCommandEvent.COMMAND.ZOOM, this));
    }

    public void setZoom(int zoom) {
        this.setZoom(zoom, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    protected void zoomChanged(int oldZoom) {
        this.zoomSlider.setToolTipText("Zoom level " + this.zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (this.zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (this.zoom - 1));
        this.zoomOutButton.setEnabled(this.zoom > this.tileController.getTileSource().getMinZoom());
        this.zoomInButton.setEnabled(this.zoom < this.tileController.getTileSource().getMaxZoom());
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean tileGridVisible) {
        this.tileGridVisible = tileGridVisible;
        this.repaint();
    }

    public boolean getMapMarkersVisible() {
        return this.mapMarkersVisible;
    }

    public void setMapMarkerVisible(boolean mapMarkersVisible) {
        this.mapMarkersVisible = mapMarkersVisible;
        this.repaint();
    }

    public void setMapMarkerList(List<MapMarker> mapMarkerList) {
        this.mapMarkerList = mapMarkerList;
        this.repaint();
    }

    public List<MapMarker> getMapMarkerList() {
        return this.mapMarkerList;
    }

    public void setMapRectangleList(List<MapRectangle> mapRectangleList) {
        this.mapRectangleList = mapRectangleList;
        this.repaint();
    }

    public List<MapRectangle> getMapRectangleList() {
        return this.mapRectangleList;
    }

    public void setMapPolygonList(List<MapPolygon> mapPolygonList) {
        this.mapPolygonList = mapPolygonList;
        this.repaint();
    }

    public List<MapPolygon> getMapPolygonList() {
        return this.mapPolygonList;
    }

    public void addMapMarker(MapMarker marker) {
        this.mapMarkerList.add(marker);
        this.repaint();
    }

    public void removeMapMarker(MapMarker marker) {
        this.mapMarkerList.remove(marker);
        this.repaint();
    }

    public void removeAllMapMarkers() {
        this.mapMarkerList.clear();
        this.repaint();
    }

    public void addMapRectangle(MapRectangle rectangle) {
        this.mapRectangleList.add(rectangle);
        this.repaint();
    }

    public void removeMapRectangle(MapRectangle rectangle) {
        this.mapRectangleList.remove(rectangle);
        this.repaint();
    }

    public void removeAllMapRectangles() {
        this.mapRectangleList.clear();
        this.repaint();
    }

    public void addMapPolygon(MapPolygon polygon) {
        this.mapPolygonList.add(polygon);
        this.repaint();
    }

    public void removeMapPolygon(MapPolygon polygon) {
        this.mapPolygonList.remove(polygon);
        this.repaint();
    }

    public void removeAllMapPolygons() {
        this.mapPolygonList.clear();
        this.repaint();
    }

    @Deprecated
    public void setZoomContolsVisible(boolean visible) {
        this.setZoomControlsVisible(visible);
    }

    public void setZoomControlsVisible(boolean visible) {
        this.zoomSlider.setVisible(visible);
        this.zoomInButton.setVisible(visible);
        this.zoomOutButton.setVisible(visible);
    }

    public boolean getZoomControlsVisible() {
        return this.zoomSlider.isVisible();
    }

    public void setTileSource(TileSource tileSource) {
        if (tileSource.getMaxZoom() > 24) {
            throw new RuntimeException("Maximum zoom level too high");
        }
        if (tileSource.getMinZoom() < 0) {
            throw new RuntimeException("Minimum zoom level too low");
        }
        ICoordinate position = this.getPosition();
        this.tileSource = tileSource;
        this.tileController.setTileSource(tileSource);
        this.zoomSlider.setMinimum(tileSource.getMinZoom());
        this.zoomSlider.setMaximum(tileSource.getMaxZoom());
        this.tileController.cancelOutstandingJobs();
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        this.attribution.initialize(tileSource);
        this.setDisplayPosition(position, this.zoom);
        this.repaint();
    }

    @Override
    public void tileLoadingFinished(Tile tile, boolean success) {
        tile.setLoaded(success);
        this.repaint();
    }

    public boolean isMapRectanglesVisible() {
        return this.mapRectanglesVisible;
    }

    public void setMapRectanglesVisible(boolean mapRectanglesVisible) {
        this.mapRectanglesVisible = mapRectanglesVisible;
        this.repaint();
    }

    public boolean isMapPolygonsVisible() {
        return this.mapPolygonsVisible;
    }

    public void setMapPolygonsVisible(boolean mapPolygonsVisible) {
        this.mapPolygonsVisible = mapPolygonsVisible;
        this.repaint();
    }

    public boolean isScrollWrapEnabled() {
        return this.scrollWrapEnabled;
    }

    public void setScrollWrapEnabled(boolean scrollWrapEnabled) {
        this.scrollWrapEnabled = scrollWrapEnabled;
        this.repaint();
    }

    public ZOOM_BUTTON_STYLE getZoomButtonStyle() {
        return this.zoomButtonStyle;
    }

    public void setZoomButtonStyle(ZOOM_BUTTON_STYLE style) {
        this.zoomButtonStyle = style;
        if (this.zoomSlider == null || this.zoomInButton == null || this.zoomOutButton == null) {
            return;
        }
        switch (style) {
            case VERTICAL: {
                this.zoomSlider.setBounds(10, 27, 30, 150);
                this.zoomInButton.setBounds(14, 8, 20, 20);
                this.zoomOutButton.setBounds(14, 176, 20, 20);
                break;
            }
            default: {
                this.zoomSlider.setBounds(10, 10, 30, 150);
                this.zoomInButton.setBounds(4, 155, 18, 18);
                this.zoomOutButton.setBounds(26, 155, 18, 18);
            }
        }
        this.repaint();
    }

    public TileController getTileController() {
        return this.tileController;
    }

    public TileCache getTileCache() {
        return this.tileController.getTileCache();
    }

    public void setTileLoader(TileLoader loader) {
        this.tileController.setTileLoader(loader);
    }

    public AttributionSupport getAttribution() {
        return this.attribution;
    }

    public void addJMVListener(JMapViewerEventListener listener) {
        this.evtListenerList.add(JMapViewerEventListener.class, listener);
    }

    public void removeJMVListener(JMapViewerEventListener listener) {
        this.evtListenerList.remove(JMapViewerEventListener.class, listener);
    }

    private void fireJMVEvent(JMVCommandEvent evt) {
        Object[] listeners = this.evtListenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != JMapViewerEventListener.class) continue;
            ((JMapViewerEventListener)listeners[i + 1]).processCommand(evt);
        }
    }

    static {
        move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    }

    public static enum ZOOM_BUTTON_STYLE {
        HORIZONTAL,
        VERTICAL;

    }
}

