/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.core.IPositionConverter;
import org.eclipse.cdt.core.IPositionTrackerManager;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.PositionTrackerChain;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class PositionTrackerManager
implements IPositionTrackerManager,
IFileBufferListener {
    private static final int HASHMAP_ENTRY_SIZE = 56;
    private static final int MAX_MEMORY = 524288;
    private static final int MAX_MEMORY_AFTER_CLEANUP = 367001;
    private static PositionTrackerManager sManager = new PositionTrackerManager();
    private int fMemoryCounter = 0;
    private int fInstalled = 0;
    private HashMap<Object, PositionTrackerChain> fPositionTrackerMap = new HashMap();

    public static PositionTrackerManager getInstance() {
        return sManager;
    }

    private PositionTrackerManager() {
    }

    public synchronized void install() {
        if (++this.fInstalled == 1) {
            ITextFileBufferManager mgr = FileBuffers.getTextFileBufferManager();
            mgr.addFileBufferListener((IFileBufferListener)this);
        }
    }

    public synchronized void uninstall() {
        if (--this.fInstalled == 0) {
            FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this);
            this.fPositionTrackerMap.clear();
            this.fMemoryCounter = 0;
        }
    }

    public void bufferCreated(IFileBuffer buffer) {
        if (buffer instanceof ITextFileBuffer) {
            this.createCheckpoint((ITextFileBuffer)buffer);
        }
    }

    public void bufferDisposed(IFileBuffer buffer) {
        if (buffer instanceof ITextFileBuffer) {
            this.resetToLastCheckpoint((ITextFileBuffer)buffer);
        }
    }

    public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        if (!isDirty && buffer instanceof ITextFileBuffer) {
            this.createCheckpoint((ITextFileBuffer)buffer);
        }
    }

    public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        if (isStateValidated && !buffer.isDirty()) {
            this.bufferCreated(buffer);
        }
    }

    public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
    }

    public void bufferContentReplaced(IFileBuffer buffer) {
    }

    public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
    }

    public void underlyingFileDeleted(IFileBuffer buffer) {
    }

    public void stateChangeFailed(IFileBuffer buffer) {
    }

    public void stateChanging(IFileBuffer buffer) {
    }

    private synchronized void createCheckpoint(ITextFileBuffer buffer) {
        Object bufferKey = this.getKey(buffer);
        PositionTrackerChain chain = this.fPositionTrackerMap.get(bufferKey);
        if (chain == null) {
            chain = new PositionTrackerChain(buffer.getModificationStamp());
            this.fPositionTrackerMap.put(bufferKey, chain);
            this.fMemoryCounter += PositionTrackerChain.MEMORY_SIZE + 56;
        } else {
            chain.stopTracking();
            this.fMemoryCounter += chain.createCheckpoint(buffer.getModificationStamp());
        }
        chain.startTracking(buffer.getDocument());
        if (this.fMemoryCounter > 524288) {
            this.runCleanup();
        }
    }

    private Object getKey(ITextFileBuffer buffer) {
        URI uri;
        Object key = buffer.getLocation();
        if (key == null && (key = URIUtil.toPath((URI)(uri = buffer.getFileStore().toURI()))) == null) {
            key = uri;
        }
        return key;
    }

    private synchronized void resetToLastCheckpoint(ITextFileBuffer buffer) {
        Object bufferKey = this.getKey(buffer);
        PositionTrackerChain chain = this.fPositionTrackerMap.get(bufferKey);
        if (chain != null) {
            chain.stopTracking();
            chain.getActiveTracker().clear();
            if (!chain.isModified()) {
                this.fPositionTrackerMap.remove(bufferKey);
                chain.dispose();
            }
        }
    }

    private synchronized void runCleanup() {
        this.fMemoryCounter = 0;
        for (PositionTrackerChain chain : this.fPositionTrackerMap.values()) {
            this.fMemoryCounter += 56;
            this.fMemoryCounter += chain.getMemorySize();
        }
        if (this.fMemoryCounter > 367001) {
            TreeMap<Long, List<PositionTrackerChain>> map = new TreeMap<Long, List<PositionTrackerChain>>();
            for (PositionTrackerChain chain : this.fPositionTrackerMap.values()) {
                this.addChain(map, chain);
            }
            while (!map.isEmpty()) {
                Long key = (Long)map.firstKey();
                List list = (List)map.remove(key);
                for (PositionTrackerChain chain : list) {
                    this.fMemoryCounter += chain.removeOldest();
                    this.addChain(map, chain);
                }
                if (this.fMemoryCounter <= 367001) break;
            }
        }
    }

    private synchronized void addChain(SortedMap<Long, List<PositionTrackerChain>> map, PositionTrackerChain chain) {
        long or = chain.getOldestRetirement();
        if (or != Long.MAX_VALUE) {
            Long lor = or;
            LinkedList<PositionTrackerChain> list = (LinkedList<PositionTrackerChain>)map.get(lor);
            if (list == null) {
                list = new LinkedList<PositionTrackerChain>();
                map.put(lor, list);
            }
            list.add(chain);
        }
    }

    @Override
    public synchronized IPositionConverter findPositionConverter(IFile file, long timestamp) {
        PositionTrackerChain chain = this.fPositionTrackerMap.get(file.getFullPath());
        if (chain != null) {
            return chain.findTrackerAt(timestamp);
        }
        return null;
    }

    @Override
    public synchronized IPositionConverter findPositionConverter(IPath externalLocation, long timestamp) {
        PositionTrackerChain chain = this.fPositionTrackerMap.get(externalLocation);
        if (chain != null) {
            return chain.findTrackerAt(timestamp);
        }
        return null;
    }

    @Override
    public synchronized IPositionConverter findPositionConverter(ITranslationUnit tu, long timestamp) {
        IFile file = (IFile)tu.getResource();
        if (file != null) {
            return this.findPositionConverter(file, timestamp);
        }
        IPath location = tu.getLocation();
        if (location != null) {
            return this.findPositionConverter(location, timestamp);
        }
        URI locationURI = tu.getLocationURI();
        if (locationURI != null) {
            return this.findPositionConverter(locationURI, timestamp);
        }
        return null;
    }

    @Override
    public synchronized IPositionConverter findPositionConverter(URI locationURI, long timestamp) {
        IPath path;
        PositionTrackerChain chain = this.fPositionTrackerMap.get(locationURI);
        if (chain == null && (path = URIUtil.toPath((URI)locationURI)) != null) {
            chain = this.fPositionTrackerMap.get(path);
        }
        if (chain != null) {
            return chain.findTrackerAt(timestamp);
        }
        return null;
    }
}

