/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.internal.theme;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.util.impl.resources.FileResourcesLocatorImpl;
import org.eclipse.e4.ui.css.core.util.impl.resources.OSGiResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.swt.helpers.EclipsePreferencesHelper;
import org.eclipse.e4.ui.css.swt.internal.theme.Theme;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngineManager;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class ThemeEngine
implements IThemeEngine {
    private List<Theme> themes = new ArrayList<Theme>();
    private Map<String, List<String>> themesToVarients = new HashMap<String, List<String>>();
    private List<CSSEngine> cssEngines = new ArrayList<CSSEngine>();
    private Display display;
    private ITheme currentTheme;
    private List<String> globalStyles = new ArrayList<String>();
    private List<IResourceLocator> globalSourceLocators = new ArrayList<IResourceLocator>();
    private HashMap<String, List<String>> stylesheets = new HashMap();
    private HashMap<String, List<String>> modifiedStylesheets = new HashMap();
    private HashMap<String, List<IResourceLocator>> sourceLocators = new HashMap();
    private static final String THEMEID_KEY = "themeid";
    public static final String THEME_PLUGIN_ID = "org.eclipse.e4.ui.css.swt.theme";
    public static final String E4_DARK_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_dark";

    public ThemeEngine(Display display) {
        IConfigurationElement ce;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension e;
        this.display = display;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(THEME_PLUGIN_ID);
        Location configLocation = Platform.getConfigurationLocation();
        String e4CSSPath = null;
        try {
            URL locationURL = new URL(configLocation.getDataArea(THEME_PLUGIN_ID).toString());
            File locationFile = new File(locationURL.getFile());
            e4CSSPath = locationFile.getPath();
        }
        catch (IOException iOException) {}
        Path path = new Path(String.valueOf(e4CSSPath) + File.separator);
        File modDir = new File(path.toFile().toURI());
        if (!modDir.exists()) {
            modDir.mkdirs();
        }
        File[] modifiedFiles = modDir.listFiles();
        String currentOS = Platform.getOS();
        String currentWS = Platform.getWS();
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            e = iExtensionArray[n4];
            iConfigurationElementArray = e.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                block29: {
                    ce = iConfigurationElementArray[n];
                    if (ce.getName().equals("theme")) {
                        try {
                            int slash;
                            String originalCSSFile;
                            String basestylesheeturi;
                            String themeBaseId;
                            String id = ce.getAttribute("id");
                            String os = ce.getAttribute("os");
                            String version = ce.getAttribute("os_version");
                            if (version == null) {
                                version = "";
                            } else if (E4_DARK_THEME_ID.equals(id) && "macosx".equals(currentOS) && os != null && os.equals(currentOS)) {
                                if (!this.isOsVersionMatch(version)) break block29;
                                version = "";
                            }
                            String themeId = themeBaseId = String.valueOf(id) + version;
                            String label = ce.getAttribute("label");
                            String ws = ce.getAttribute("ws");
                            if (os != null && !os.equals(currentOS) || ws != null && !ws.equals(currentWS)) {
                                if (!this.themesToVarients.containsKey(themeBaseId)) {
                                    this.themesToVarients.put(themeBaseId, new ArrayList());
                                }
                                themeId = this.getVarientThemeId(themeBaseId, os, ws);
                                this.themesToVarients.get(themeBaseId).add(themeId);
                                label = this.getVarientThemeLabel(label, os, ws);
                            }
                            if (!(basestylesheeturi = (originalCSSFile = ce.getAttribute("basestylesheeturi"))).startsWith("platform:/plugin/")) {
                                basestylesheeturi = "platform:/plugin/" + ce.getContributor().getName() + "/" + basestylesheeturi;
                            }
                            this.registerTheme(themeId, label, basestylesheeturi, version);
                            if (modifiedFiles != null && (slash = originalCSSFile.lastIndexOf(47)) != -1) {
                                originalCSSFile = originalCSSFile.substring(slash + 1);
                                File[] fileArray = modifiedFiles;
                                int n5 = modifiedFiles.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    File modifiedFile = fileArray[n6];
                                    String modifiedFileName = modifiedFile.getName();
                                    if (modifiedFileName.contains(".css") && modifiedFileName.equals(originalCSSFile)) {
                                        ArrayList<String> styleSheets = new ArrayList<String>();
                                        styleSheets.add(modifiedFile.toURI().toString());
                                        this.modifiedStylesheets.put(themeId, styleSheets);
                                    }
                                    ++n6;
                                }
                            }
                        }
                        catch (IllegalArgumentException e1) {
                            ThemeEngineManager.logError(e1.getMessage(), e1);
                        }
                    }
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extPoint.getExtensions();
        n3 = iExtensionArray.length;
        n4 = 0;
        while (n4 < n3) {
            e = iExtensionArray[n4];
            iConfigurationElementArray = e.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                ce = iConfigurationElementArray[n];
                if (ce.getName().equals("stylesheet")) {
                    int n7;
                    IConfigurationElement[] cces = ce.getChildren(THEMEID_KEY);
                    if (cces.length == 0) {
                        this.registerStylesheet("platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("uri"), new String[0]);
                        IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren("osgiresourcelocator");
                        n7 = iConfigurationElementArray2.length;
                        int version = 0;
                        while (version < n7) {
                            IConfigurationElement resourceEl = iConfigurationElementArray2[version];
                            String uri = resourceEl.getAttribute("uri");
                            if (uri != null) {
                                this.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(uri), new String[0]);
                            }
                            ++version;
                        }
                    } else {
                        ArrayList<String> themes = new ArrayList<String>();
                        IConfigurationElement[] iConfigurationElementArray3 = cces;
                        int n8 = cces.length;
                        n7 = 0;
                        while (n7 < n8) {
                            IConfigurationElement cce = iConfigurationElementArray3[n7];
                            String refid = cce.getAttribute("refid");
                            List<String> varientOSList = this.themesToVarients.get(refid);
                            if (varientOSList != null) {
                                themes.addAll(varientOSList);
                            }
                            themes.add(refid);
                            ++n7;
                        }
                        this.registerStylesheet("platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("uri"), themes.toArray(new String[themes.size()]));
                        iConfigurationElementArray3 = ce.getChildren("osgiresourcelocator");
                        n8 = iConfigurationElementArray3.length;
                        n7 = 0;
                        while (n7 < n8) {
                            IConfigurationElement resourceEl = iConfigurationElementArray3[n7];
                            String uri = resourceEl.getAttribute("uri");
                            if (uri != null) {
                                this.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(uri), new String[0]);
                            }
                            ++n7;
                        }
                    }
                }
                ++n;
            }
            ++n4;
        }
        this.registerResourceLocator((IResourceLocator)new OSGiResourceLocator("platform:/plugin/org.eclipse.ui.themes/css/"), new String[0]);
        this.registerResourceLocator((IResourceLocator)new FileResourcesLocatorImpl(), new String[0]);
    }

    private String getVarientThemeId(String id, String os, String ws) {
        if (os != null) {
            id = String.valueOf(id) + '_' + os;
        }
        if (ws != null) {
            id = String.valueOf(id) + '-' + ws;
        }
        return id;
    }

    private String getVarientThemeLabel(String label, String os, String ws) {
        String currentOS;
        block29: {
            String wsName;
            String currentWS;
            block27: {
                String osName;
                currentOS = Platform.getOS();
                currentWS = Platform.getWS();
                if (os == null || os.equals(currentOS)) break block27;
                switch (os) {
                    case "linux": {
                        osName = "Linux";
                        break;
                    }
                    case "macosx": {
                        osName = "Mac OS X";
                        break;
                    }
                    case "win32": {
                        osName = "Windows";
                        break;
                    }
                    default: {
                        osName = os;
                    }
                }
                label = String.valueOf(label) + " [" + osName;
            }
            if (ws == null || ws.equals(currentWS)) break block29;
            switch (ws) {
                case "cocoa": {
                    wsName = "Cocoa";
                    break;
                }
                case "gtk": {
                    wsName = "GTK";
                    break;
                }
                case "wpf": {
                    wsName = "WPF";
                    break;
                }
                default: {
                    wsName = ws;
                }
            }
            label = String.valueOf(label) + " - " + wsName;
        }
        if (os != null && !os.equals(currentOS)) {
            label = String.valueOf(label) + "]";
        }
        return label;
    }

    private boolean isOsVersionMatch(String osVersionList) {
        boolean found = false;
        String osVersion = System.getProperty("os.version");
        if (osVersion != null && osVersionList != null) {
            String[] osVersions;
            String[] stringArray = osVersions = osVersionList.split(",");
            int n = osVersions.length;
            int n2 = 0;
            while (n2 < n) {
                String osVersionFromTheme = stringArray[n2];
                if (osVersionFromTheme != null && osVersion.contains(osVersionFromTheme)) {
                    found = true;
                    break;
                }
                ++n2;
            }
        }
        return found;
    }

    @Override
    public synchronized ITheme registerTheme(String id, String label, String basestylesheetURI) throws IllegalArgumentException {
        return this.registerTheme(id, label, basestylesheetURI, "");
    }

    public synchronized ITheme registerTheme(String id, String label, String basestylesheetURI, String osVersion) throws IllegalArgumentException {
        for (Theme t : this.themes) {
            if (!t.getId().equals(id)) continue;
            throw new IllegalArgumentException("A theme with the id '" + id + "' is already registered");
        }
        Theme theme = new Theme(id, label);
        if (osVersion != "") {
            theme.setOsVersion(osVersion);
        }
        this.themes.add(theme);
        this.registerStyle(id, basestylesheetURI);
        return theme;
    }

    @Override
    public synchronized void registerStylesheet(String uri, String ... themes) {
        Bundle bundle = FrameworkUtil.getBundle(ThemeEngine.class);
        String osname = bundle.getBundleContext().getProperty("osgi.os");
        String wsname = bundle.getBundleContext().getProperty("osgi.ws");
        uri = uri.replaceAll("\\$os\\$", osname).replaceAll("\\$ws\\$", wsname);
        if (themes.length == 0) {
            this.globalStyles.add(uri);
        } else {
            String[] stringArray = themes;
            int n = themes.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                this.registerStyle(t, uri);
                ++n2;
            }
        }
    }

    @Override
    public synchronized void registerResourceLocator(IResourceLocator locator, String ... themes) {
        if (themes.length == 0) {
            this.globalSourceLocators.add(locator);
        } else {
            String[] stringArray = themes;
            int n = themes.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                List<IResourceLocator> list = this.sourceLocators.get(t);
                if (list == null) {
                    list = new ArrayList<IResourceLocator>();
                    this.sourceLocators.put(t, list);
                }
                list.add(locator);
                ++n2;
            }
        }
    }

    private void registerStyle(String id, String stylesheet) {
        List<String> s = this.stylesheets.get(id);
        if (s == null) {
            s = new ArrayList<String>();
            this.stylesheets.put(id, s);
        }
        s.add(stylesheet);
    }

    private List<String> getAllStyles(String id) {
        List<String> m = this.modifiedStylesheets.get(id);
        if (m != null) {
            m = new ArrayList<String>(m);
            m.addAll(this.globalStyles);
            return m;
        }
        List<String> s = this.stylesheets.get(id);
        if (s == null) {
            s = Collections.emptyList();
        }
        s = new ArrayList<String>(s);
        s.addAll(this.globalStyles);
        return s;
    }

    private List<IResourceLocator> getResourceLocators(String id) {
        ArrayList<IResourceLocator> list = new ArrayList<IResourceLocator>(this.globalSourceLocators);
        List<IResourceLocator> s = this.sourceLocators.get(id);
        if (s != null) {
            list.addAll(s);
        }
        return list;
    }

    @Override
    public void setTheme(String themeId, boolean restore) {
        String osVersion = System.getProperty("os.version");
        if (osVersion != null) {
            boolean found = false;
            block0: for (Theme t : this.themes) {
                String[] osVersions;
                String osVersionList = t.getOsVersion();
                if (osVersionList == null) continue;
                String[] stringArray = osVersions = osVersionList.split(",");
                int n = osVersions.length;
                int n2 = 0;
                while (n2 < n) {
                    String osVersionFromTheme = stringArray[n2];
                    if (osVersionFromTheme != null && osVersion.contains(osVersionFromTheme)) {
                        String themeVersion = String.valueOf(themeId) + osVersionList;
                        if (t.getId().equals(themeVersion)) {
                            this.setTheme(t, restore);
                            found = true;
                            continue block0;
                        }
                    }
                    ++n2;
                }
            }
            if (found) {
                return;
            }
        }
        for (Theme t : this.themes) {
            if (!t.getId().equals(themeId)) continue;
            this.setTheme(t, restore);
            break;
        }
    }

    @Override
    public void setTheme(ITheme theme, boolean restore) {
        this.setTheme(theme, restore, false);
    }

    public void setTheme(ITheme theme, boolean restore, boolean force) {
        Assert.isNotNull((Object)theme, (String)"The theme must not be null");
        if (this.currentTheme != theme || force) {
            if (this.currentTheme != null) {
                for (IResourceLocator l : this.getResourceLocators(this.currentTheme.getId())) {
                    for (CSSEngine engine : this.cssEngines) {
                        engine.getResourcesLocatorManager().unregisterResourceLocator(l);
                    }
                }
            }
            this.currentTheme = theme;
            for (CSSEngine engine : this.cssEngines) {
                engine.reset();
            }
            for (IResourceLocator l : this.getResourceLocators(theme.getId())) {
                for (CSSEngine engine : this.cssEngines) {
                    engine.getResourcesLocatorManager().registerResourceLocator(l);
                }
            }
            for (String stylesheet : this.getAllStyles(theme.getId())) {
                InputStream stream = null;
                try {
                    URL url = FileLocator.resolve((URL)new URL(stylesheet));
                    for (CSSEngine engine : this.cssEngines) {
                        try {
                            try {
                                stream = url.openStream();
                                InputSource source = new InputSource();
                                source.setByteStream(stream);
                                source.setURI(url.toString());
                                engine.parseStyleSheet(source);
                            }
                            catch (IOException e) {
                                ThemeEngineManager.logError(e.getMessage(), e);
                                if (stream == null) continue;
                                try {
                                    stream.close();
                                }
                                catch (IOException e2) {
                                    ThemeEngineManager.logError(e2.getMessage(), e2);
                                }
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    ThemeEngineManager.logError(e.getMessage(), e);
                                }
                            }
                            throw throwable;
                        }
                        if (stream == null) continue;
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            ThemeEngineManager.logError(e.getMessage(), e);
                        }
                    }
                }
                catch (IOException e) {
                    ThemeEngineManager.logError(e.getMessage(), e);
                }
            }
        }
        if (restore) {
            IEclipsePreferences pref = this.getPreferences();
            EclipsePreferencesHelper.setPreviousThemeId((String)pref.get(THEMEID_KEY, null));
            EclipsePreferencesHelper.setCurrentThemeId((String)theme.getId());
            pref.put(THEMEID_KEY, theme.getId());
            try {
                pref.flush();
            }
            catch (BackingStoreException e) {
                ThemeEngineManager.logError(e.getMessage(), e);
            }
        }
        this.sendThemeChangeEvent(restore);
        for (CSSEngine engine : this.cssEngines) {
            engine.reapply();
        }
    }

    private void sendThemeChangeEvent(boolean restore) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin == null) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("themeEngine", this);
        data.put("theme", this.currentTheme);
        data.put("device", this.display);
        data.put("restore", restore);
        Event event = new Event("org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged", data);
        eventAdmin.sendEvent(event);
    }

    public List<IResourceLocator> getCurrentResourceLocators() {
        if (this.currentTheme == null) {
            return Collections.emptyList();
        }
        return this.getResourceLocators(this.currentTheme.getId());
    }

    private EventAdmin getEventAdmin() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return null;
        }
        BundleContext context = bundle.getBundleContext();
        ServiceReference eventAdminRef = context.getServiceReference(EventAdmin.class);
        return (EventAdmin)context.getService(eventAdminRef);
    }

    @Override
    public synchronized List<ITheme> getThemes() {
        return Collections.unmodifiableList(new ArrayList<Theme>(this.themes));
    }

    @Override
    public void applyStyles(Object widget, boolean applyStylesToChildNodes) {
        for (CSSEngine engine : this.cssEngines) {
            Element element = engine.getElement(widget);
            if (element == null) continue;
            engine.applyStyles((Object)element, applyStylesToChildNodes);
        }
    }

    private String getPreferenceThemeId() {
        return this.getPreferences().get(THEMEID_KEY, null);
    }

    private IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(FrameworkUtil.getBundle(ThemeEngine.class).getSymbolicName());
    }

    void copyFile(String from, String to) throws IOException {
        FileInputStream fStream = null;
        FilterOutputStream outputStream = null;
        try {
            int c;
            fStream = new FileInputStream(from);
            outputStream = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buffer = new byte[4096];
            while ((c = fStream.read(buffer)) != -1) {
                ((BufferedOutputStream)outputStream).write(buffer, 0, c);
            }
        }
        finally {
            if (fStream != null) {
                fStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @Override
    public void restore(String alternateTheme) {
        String themeToRestore;
        String prefThemeId = this.getPreferenceThemeId();
        boolean flag = true;
        if (prefThemeId != null) {
            for (ITheme t2 : this.getThemes()) {
                if (!prefThemeId.equals(t2.getId())) continue;
                this.setTheme(t2, false);
                flag = false;
                break;
            }
        }
        boolean hasDarkTheme = this.getThemes().stream().anyMatch(t -> t.getId().startsWith(E4_DARK_THEME_ID));
        String os = Platform.getOS();
        String string = themeToRestore = ("linux".equals(os) || "macosx".equals(os)) && Display.isSystemDarkTheme() && hasDarkTheme ? E4_DARK_THEME_ID : alternateTheme;
        if (themeToRestore != null && flag) {
            this.setTheme(themeToRestore, false);
        }
    }

    @Override
    public ITheme getActiveTheme() {
        return this.currentTheme;
    }

    @Override
    public CSSStyleDeclaration getStyle(Object widget) {
        for (CSSEngine engine : this.cssEngines) {
            Element e;
            CSSElementContext context = engine.getCSSElementContext(widget);
            if (context == null || (e = context.getElement()) == null) continue;
            return engine.getViewCSS().getComputedStyle(e, null);
        }
        return null;
    }

    public List<String> getStylesheets(ITheme selection) {
        ArrayList ss = this.stylesheets.get(selection.getId());
        return ss == null ? new ArrayList() : ss;
    }

    public void themeModified(ITheme theme, List<String> paths) {
        this.modifiedStylesheets.put(theme.getId(), paths);
        this.setTheme(theme, false, true);
    }

    public void resetCurrentTheme() {
        if (this.currentTheme != null) {
            this.setTheme(this.currentTheme, false, true);
        }
    }

    public List<String> getModifiedStylesheets(ITheme selection) {
        ArrayList ss = this.modifiedStylesheets.get(selection.getId());
        return ss == null ? new ArrayList() : ss;
    }

    public void resetModifiedStylesheets(ITheme selection) {
        this.modifiedStylesheets.remove(selection.getId());
    }

    @Override
    public void addCSSEngine(CSSEngine cssEngine) {
        this.cssEngines.add(cssEngine);
        this.resetCurrentTheme();
    }

    public Collection<CSSEngine> getCSSEngines() {
        return this.cssEngines;
    }

    @Override
    public void removeCSSEngine(CSSEngine cssEngine) {
        this.cssEngines.remove(cssEngine);
    }
}

