/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.tools.javac.code.Symbol;
import javax.annotation.Nullable;

public final class FieldMatchers {
    private FieldMatchers() {
    }

    public static Matcher<ExpressionTree> anyFieldInClass(final String className) {
        return new FieldReferenceMatcher(){

            @Override
            boolean classIsAppropriate(Symbol.ClassSymbol classSymbol) {
                return classSymbol.getQualifiedName().contentEquals(className);
            }

            @Override
            boolean fieldSymbolIsAppropriate(Symbol symbol) {
                return true;
            }
        };
    }

    public static Matcher<ExpressionTree> staticField(final String className, final String fieldName) {
        return new FieldReferenceMatcher(){

            @Override
            boolean classIsAppropriate(Symbol.ClassSymbol classSymbol) {
                return classSymbol.getQualifiedName().contentEquals(className);
            }

            @Override
            boolean fieldSymbolIsAppropriate(Symbol symbol) {
                return symbol.isStatic() && symbol.getSimpleName().contentEquals(fieldName);
            }
        };
    }

    public static Matcher<ExpressionTree> instanceField(final String className, final String fieldName) {
        return new FieldReferenceMatcher(){

            @Override
            boolean classIsAppropriate(Symbol.ClassSymbol classSymbol) {
                return classSymbol.getQualifiedName().contentEquals(className);
            }

            @Override
            boolean fieldSymbolIsAppropriate(Symbol symbol) {
                return !symbol.isStatic() && symbol.getSimpleName().contentEquals(fieldName);
            }
        };
    }

    private static abstract class FieldReferenceMatcher
    implements Matcher<ExpressionTree> {
        private FieldReferenceMatcher() {
        }

        @Override
        public boolean matches(ExpressionTree expressionTree, VisitorState state) {
            return this.isSymbolFieldInAppropriateClass(ASTHelpers.getSymbol(expressionTree)) && ASTHelpers.findEnclosingNode(state.getPath(), ImportTree.class) == null;
        }

        private boolean isSymbolFieldInAppropriateClass(@Nullable Symbol symbol) {
            if (symbol == null) {
                return false;
            }
            return symbol.getKind().isField() && this.fieldSymbolIsAppropriate(symbol) && this.classIsAppropriate(symbol.owner.enclClass());
        }

        abstract boolean fieldSymbolIsAppropriate(Symbol var1);

        abstract boolean classIsAppropriate(Symbol.ClassSymbol var1);
    }
}

