/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;

@BugPattern(name="ReturnValueIgnored", altNames={"ResultOfMethodCallIgnored", "CheckReturnValue"}, summary="Return value of this method must be used", severity=BugPattern.SeverityLevel.ERROR)
public class ReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Set<String> typesToCheck = new HashSet<String>(Arrays.asList("java.lang.String", "java.math.BigInteger", "java.math.BigDecimal", "java.nio.file.Path"));
    private static final Matcher<ExpressionTree> RETURNS_SAME_TYPE = Matchers.allOf((Matcher[])new Matcher[]{ReturnValueIgnored.methodReceiverHasType(typesToCheck), ReturnValueIgnored.methodReturnsSameTypeAsReceiver()});
    private static final Matcher<ExpressionTree> ALLOWED_JAVA_TIME_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().anyClass().named("parse"), MethodMatchers.instanceMethod().anyClass().named("parse"), MethodMatchers.staticMethod().anyClass().named("of"), MethodMatchers.staticMethod().anyClass().named("from"), MethodMatchers.staticMethod().onClass("java.time.ZoneId").named("ofOffset"), MethodMatchers.instanceMethod().onExactClass("java.time.format.DateTimeFormatterBuilder").withNameMatching(Pattern.compile("^append.*")), MethodMatchers.instanceMethod().onExactClass("java.time.temporal.ChronoField").named("checkValidIntValue"), MethodMatchers.instanceMethod().onExactClass("java.time.temporal.ChronoField").named("checkValidValue")});
    private static final Matcher<ExpressionTree> JAVA_TIME_TYPES = (Matcher & Serializable)(tree, state) -> {
        if (Matchers.packageStartsWith((String)"java.time").matches(tree, state)) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            if (methodSymbol.owner.packge().getQualifiedName().toString().startsWith("java.time") && methodSymbol.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return !ALLOWED_JAVA_TIME_METHODS.matches(tree, state);
            }
        }
        return false;
    };
    private static final Matcher<ExpressionTree> FUNCTIONAL_METHOD = (Matcher & Serializable)(tree, state) -> {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)symbol).owner.packge().getQualifiedName().contentEquals("java.util.function");
    };
    private static final Matcher<ExpressionTree> STREAM_METHOD = MethodMatchers.instanceMethod().onDescendantOf("java.util.stream.BaseStream");
    private static final Matcher<ExpressionTree> ARRAYS_METHODS = MethodMatchers.staticMethod().onClass("java.util.Arrays");

    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return Matchers.anyOf((Matcher[])new Matcher[]{RETURNS_SAME_TYPE, FUNCTIONAL_METHOD, STREAM_METHOD, ARRAYS_METHODS, JAVA_TIME_TYPES});
    }

    private static Matcher<ExpressionTree> methodReturnsSameTypeAsReceiver() {
        return new Matcher<ExpressionTree>(){

            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                return ASTHelpers.isSameType((Type)ASTHelpers.getReceiverType((ExpressionTree)expressionTree), (Type)ASTHelpers.getReturnType((ExpressionTree)expressionTree), (VisitorState)state);
            }
        };
    }

    private static Matcher<ExpressionTree> methodReceiverHasType(final Set<String> typeSet) {
        return new Matcher<ExpressionTree>(){

            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)expressionTree);
                return typeSet.contains(receiverType.toString());
            }
        };
    }
}

