/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;

public class MemoryCallGraphBuilder
extends BaseCallGraphBuilder
implements MemoryProfilingResultsListener,
MemoryCCTProvider {
    private ObjIdToCCTNodeMap objMap;
    private final TransactionalSupport transaction = new TransactionalSupport();
    private float[] avgObjectAge;
    private int[] maxSurvGen;
    private long[] nTrackedAllocObjects;
    private int[] nTrackedLiveObjects;
    private long[] objectsSizePerClass;
    private RuntimeMemoryCCTNode[] stacksForClasses;
    private boolean[] unprofiledClass;
    private int currentEpoch;
    private int nProfiledClasses;

    @Override
    public long[] getAllocObjectNumbers() {
        this.transaction.beginTrans(false);
        try {
            long[] lArray = new long[this.nProfiledClasses];
            System.arraycopy(this.objectsSizePerClass, 0, lArray, 0, lArray.length);
            long[] lArray2 = lArray;
            return lArray2;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public int getCurrentEpoch() {
        this.transaction.beginTrans(false);
        try {
            int n = this.currentEpoch;
            return n;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public MemoryCCTProvider.ObjectNumbersContainer getLivenessObjectNumbers() {
        this.transaction.beginTrans(false);
        try {
            MemoryCCTProvider.ObjectNumbersContainer objectNumbersContainer;
            if (this.getClient().getCurrentInstrType() != 6) {
                throw new IllegalStateException("MemoryCallGraphBuilder must be running in TRACKING_LIVENESS mode in order to provide liveness statistics");
            }
            this.updateNumberOfClasses();
            this.calculateAverageObjectAges();
            this.calculateTotalNumberOfSurvGens();
            MemoryCCTProvider.ObjectNumbersContainer objectNumbersContainer2 = objectNumbersContainer = new MemoryCCTProvider.ObjectNumbersContainer(this.nTrackedAllocObjects, this.nTrackedLiveObjects, this.objectsSizePerClass, this.avgObjectAge, this.maxSurvGen, this.unprofiledClass, this.nProfiledClasses);
            return objectNumbersContainer2;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public int getNProfiledClasses() {
        this.transaction.beginTrans(false);
        try {
            this.updateNumberOfClasses();
            int n = this.nProfiledClasses;
            return n;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public long[] getObjectsSizePerClass() {
        this.transaction.beginTrans(false);
        try {
            long[] lArray = this.objectsSizePerClass;
            return lArray;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public RuntimeMemoryCCTNode[] getStacksForClasses() {
        this.transaction.beginTrans(false);
        try {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = this.stacksForClasses;
            return runtimeMemoryCCTNodeArray;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public void beginTrans(boolean bl) {
        this.transaction.beginTrans(bl);
    }

    @Override
    public boolean classMarkedUnprofiled(int n) {
        this.transaction.beginTrans(false);
        try {
            boolean bl = this.unprofiledClass[n];
            return bl;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PresoObjAllocCCTNode createPresentationCCT(int n, boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        this.transaction.beginTrans(false);
        try {
            PresoObjAllocCCTNode presoObjAllocCCTNode = null;
            RuntimeMemoryCCTNode runtimeMemoryCCTNode = this.getClassNode(n);
            String string = this.getClassName(n);
            if (runtimeMemoryCCTNode == null || string == null) {
                PresoObjAllocCCTNode presoObjAllocCCTNode2 = null;
                return presoObjAllocCCTNode2;
            }
            switch (this.getClient().getCurrentInstrType()) {
                case 6: {
                    presoObjAllocCCTNode = PresoObjLivenessCCTNode.createPresentationCCTFromVM(this.getClient(), runtimeMemoryCCTNode, string, this.currentEpoch, bl);
                    break;
                }
                case 5: {
                    presoObjAllocCCTNode = PresoObjAllocCCTNode.createPresentationCCTFromVM(this.getClient(), runtimeMemoryCCTNode, string);
                    break;
                }
                default: {
                    throw new IllegalStateException("MemoryCallGraphBuilder runs in an illegal mode");
                }
            }
            PresoObjAllocCCTNode presoObjAllocCCTNode3 = presoObjAllocCCTNode;
            return presoObjAllocCCTNode3;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public void endTrans() {
        this.transaction.endTrans();
    }

    @Override
    public void markClassUnprofiled(int n) {
        this.transaction.beginTrans(true);
        try {
            this.unprofiledClass[n] = true;
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    public void onAllocStackTrace(char c, long l, int[] nArray) {
        RuntimeObjAllocTermCCTNode runtimeObjAllocTermCCTNode = (RuntimeObjAllocTermCCTNode)this.processStackTrace(c, nArray, false);
        if (runtimeObjAllocTermCCTNode != null) {
            runtimeObjAllocTermCCTNode.updateForNewObject(l);
            char c2 = c;
            this.objectsSizePerClass[c2] = this.objectsSizePerClass[c2] + l;
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void onGcPerformed(char c, long l, int n) {
        if (this.currentEpoch < n) {
            this.currentEpoch = n;
        }
        RuntimeObjLivenessTermCCTNode runtimeObjLivenessTermCCTNode = this.objMap.getNode(l);
        long l2 = this.objMap.getLastRemovedObjSize();
        if (runtimeObjLivenessTermCCTNode == null) {
            return;
        }
        runtimeObjLivenessTermCCTNode.updateForRemovedObject(l2);
        runtimeObjLivenessTermCCTNode.removeLiveObjectForEpoch(n);
        char c2 = c;
        this.nTrackedLiveObjects[c2] = this.nTrackedLiveObjects[c2] - 1;
        char c3 = c;
        this.objectsSizePerClass[c3] = this.objectsSizePerClass[c3] - l2;
        this.batchNotEmpty = true;
    }

    @Override
    public void onLivenessStackTrace(char c, long l, int n, long l2, int[] nArray) {
        if (this.getClient().getCurrentInstrType() != 6) {
            return;
        }
        if (this.currentEpoch < n) {
            this.currentEpoch = n;
        }
        try {
            RuntimeObjLivenessTermCCTNode runtimeObjLivenessTermCCTNode = (RuntimeObjLivenessTermCCTNode)this.processStackTrace(c, nArray, true);
            if (runtimeObjLivenessTermCCTNode != null) {
                runtimeObjLivenessTermCCTNode.updateForNewObject(l2);
                runtimeObjLivenessTermCCTNode.addLiveObjectForEpoch(n);
                this.objMap.put(l, runtimeObjLivenessTermCCTNode, l2);
                char c2 = c;
                this.nTrackedAllocObjects[c2] = this.nTrackedAllocObjects[c2] + 1L;
                char c3 = c;
                this.nTrackedLiveObjects[c3] = this.nTrackedLiveObjects[c3] + 1;
                char c4 = c;
                this.objectsSizePerClass[c4] = this.objectsSizePerClass[c4] + l2;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ProfilerLogger.warning("OOME, resetting collectors!!!");
            this.reset();
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void profilingPoint(final int n, final int n2, final long l) {
        ProfilerClient profilerClient = this.getClient();
        if (profilerClient == null) {
            return;
        }
        final ProfilingPointsProcessor profilingPointsProcessor = TargetAppRunner.getDefault().getProfilingPointsProcessor();
        this.afterBatchCommands.add(new Runnable(){

            @Override
            public void run() {
                profilingPointsProcessor.profilingPointHit(new RuntimeProfilingPoint.HitEvent(n2, l, n));
            }
        });
    }

    @Override
    public void monitorEntry(int n, long l, long l2, int n2, int n3) {
    }

    @Override
    public void monitorExit(int n, long l, long l2, int n2) {
    }

    @Override
    public void newThread(int n, String string, String string2) {
    }

    @Override
    public void newMonitor(int n, String string) {
    }

    @Override
    public void timeAdjust(int n, long l, long l2) {
    }

    @Override
    public void updateInternals() {
        this.loadNamesForJMethodIds();
    }

    @Override
    protected RuntimeCCTNode getAppRootNode() {
        return new RuntimeMemoryCCTNode();
    }

    @Override
    protected void doBatchStart() {
        this.transaction.beginTrans(true);
        this.updateNumberOfClasses();
    }

    @Override
    protected void doBatchStop() {
        this.transaction.endTrans();
    }

    @Override
    protected void doReset() {
        this.transaction.beginTrans(true);
        try {
            int n;
            if (this.stacksForClasses != null) {
                for (n = 0; n < this.stacksForClasses.length; ++n) {
                    this.stacksForClasses[n] = null;
                    this.objectsSizePerClass[n] = 0L;
                }
            }
            if (this.objMap != null) {
                this.objMap.clear();
            }
            if (this.nTrackedAllocObjects != null) {
                for (n = 0; n < this.nTrackedAllocObjects.length; ++n) {
                    this.nTrackedAllocObjects[n] = 0L;
                    this.objectsSizePerClass[n] = 0L;
                }
            }
            if (this.nTrackedLiveObjects != null) {
                for (n = 0; n < this.nTrackedLiveObjects.length; ++n) {
                    this.nTrackedLiveObjects[n] = 0;
                }
            }
            if (this.objectsSizePerClass != null) {
                for (n = 0; n < this.objectsSizePerClass.length; ++n) {
                    this.objectsSizePerClass[n] = 0L;
                }
            }
        }
        finally {
            this.transaction.endTrans();
        }
    }

    @Override
    protected void doShutdown() {
        this.resetInternalState();
    }

    @Override
    protected void doStartup(ProfilerClient profilerClient) {
        this.resetInternalState();
        profilerClient.registerMemoryCCTProvider(this);
    }

    private void resetInternalState() {
        this.objMap = new ObjIdToCCTNodeMap();
        this.currentEpoch = 0;
        this.nProfiledClasses = 0;
        this.stacksForClasses = null;
        this.objectsSizePerClass = null;
        this.nTrackedAllocObjects = null;
        this.nTrackedLiveObjects = null;
        this.maxSurvGen = null;
        this.avgObjectAge = null;
        this.unprofiledClass = null;
        this.currentEpoch = -1;
    }

    private String getClassName(int n) {
        this.status.beginTrans(false);
        try {
            String string = this.status.getClassNames()[n];
            return string;
        }
        finally {
            this.status.endTrans();
        }
    }

    private RuntimeMemoryCCTNode getClassNode(int n) {
        return this.stacksForClasses[n];
    }

    private boolean isInitialized() {
        return this.unprofiledClass != null && this.stacksForClasses != null;
    }

    private RuntimeMemoryCCTNode getNewTerminalNode(int n, boolean bl) {
        return bl ? new RuntimeObjLivenessTermCCTNode(n) : new RuntimeObjAllocTermCCTNode(n);
    }

    private void calculateAverageObjectAges() {
        if (!this.isInitialized()) {
            return;
        }
        int n = this.nProfiledClasses;
        this.avgObjectAge = new float[n];
        for (int i = 0; i < n; ++i) {
            RuntimeMemoryCCTNode runtimeMemoryCCTNode;
            if (this.unprofiledClass[i] || (runtimeMemoryCCTNode = this.stacksForClasses[i]) == null) continue;
            float f = RuntimeObjLivenessTermCCTNode.calculateAvgObjectAgeForAllPaths(runtimeMemoryCCTNode, this.currentEpoch);
            if (f < 0.0f) {
                f = 0.0f;
            }
            this.avgObjectAge[i] = f;
        }
    }

    private void calculateTotalNumberOfSurvGens() {
        if (!this.isInitialized()) {
            return;
        }
        this.maxSurvGen = new int[this.nProfiledClasses];
        for (int i = 0; i < this.maxSurvGen.length; ++i) {
            RuntimeMemoryCCTNode runtimeMemoryCCTNode;
            if (this.unprofiledClass[i] || (runtimeMemoryCCTNode = this.stacksForClasses[i]) == null) continue;
            this.maxSurvGen[i] = RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGensForAllPaths(runtimeMemoryCCTNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNamesForJMethodIds() {
        ProfilerClient profilerClient = this.getClient();
        if (profilerClient != null) {
            ProfilerClient profilerClient2 = profilerClient;
            synchronized (profilerClient2) {
                this.transaction.beginTrans(false);
                try {
                    PresoObjAllocCCTNode.getNamesForMethodIdsFromVM(profilerClient, this.stacksForClasses);
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    ProfilerLogger.log(targetAppOrVMTerminated.getMessage());
                }
                finally {
                    this.transaction.endTrans();
                }
            }
        }
    }

    private RuntimeMemoryCCTNode processStackTrace(char c, int[] nArray, boolean bl) {
        int n;
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray;
        if (c >= this.stacksForClasses.length) {
            ProfilerLogger.severe("Received stack for non existent class Id: " + c + ", current length: " + this.stacksForClasses.length);
            this.updateNumberOfClasses();
            ProfilerLogger.severe("Received stack for non existent class Id: " + c + ", current length after updateNumberOfClasses: " + this.stacksForClasses.length);
            if (c >= this.stacksForClasses.length) {
                return null;
            }
        }
        Object object = this.stacksForClasses[c];
        Object object2 = null;
        if (object == null) {
            object = new RuntimeMemoryCCTNode(0);
            this.stacksForClasses[c] = object;
        }
        int n2 = nArray.length;
        int n3 = n2 - 1;
        for (int i = 0; i < n2; ++i) {
            Object object3;
            int n4;
            block15: {
                block16: {
                    n4 = nArray[i];
                    object2 = object;
                    runtimeMemoryCCTNodeArray = object.children;
                    n = 0;
                    if (runtimeMemoryCCTNodeArray == null) break block15;
                    if (!(runtimeMemoryCCTNodeArray instanceof RuntimeMemoryCCTNode)) break block16;
                    if (((RuntimeMemoryCCTNode)runtimeMemoryCCTNodeArray).methodId != n4) break block15;
                    object = (RuntimeMemoryCCTNode)runtimeMemoryCCTNodeArray;
                    n = 1;
                    break block15;
                }
                object3 = runtimeMemoryCCTNodeArray;
                for (int j = 0; j < ((RuntimeMemoryCCTNode[])object3).length; ++j) {
                    if (object3[j].methodId != n4) continue;
                    object = object3[j];
                    n = 1;
                    break;
                }
            }
            if (n != 0) continue;
            if (i < n3) {
                object = object.addNewChild(n4);
                continue;
            }
            object3 = this.getNewTerminalNode(n4, bl);
            object.attachNodeAsChild((RuntimeMemoryCCTNode)object3);
            object = object3;
        }
        if (object.getClass() == RuntimeMemoryCCTNode.class) {
            RuntimeMemoryCCTNode runtimeMemoryCCTNode = this.getNewTerminalNode(object.methodId, bl);
            runtimeMemoryCCTNode.children = object.children;
            if (object2 != null) {
                Object object4 = object2.children;
                assert (object4 != null);
                if (object4 instanceof RuntimeMemoryCCTNode) {
                    if (object4 == object) {
                        object2.children = runtimeMemoryCCTNode;
                    }
                } else {
                    runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])object4;
                    for (n = 0; n < runtimeMemoryCCTNodeArray.length; ++n) {
                        if (runtimeMemoryCCTNodeArray[n] != object) continue;
                        runtimeMemoryCCTNodeArray[n] = runtimeMemoryCCTNode;
                        break;
                    }
                }
            } else {
                this.stacksForClasses[c] = runtimeMemoryCCTNode;
            }
            object = runtimeMemoryCCTNode;
        }
        return object;
    }

    private void updateNumberOfClasses() {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        this.status.beginTrans(false);
        try {
            this.nProfiledClasses = this.status.getNInstrClasses();
        }
        finally {
            this.status.endTrans();
        }
        if (this.stacksForClasses == null || this.stacksForClasses.length < this.nProfiledClasses) {
            n = this.nProfiledClasses * 3 / 2;
            objectArray2 = new RuntimeMemoryCCTNode[n];
            if (this.stacksForClasses != null) {
                System.arraycopy(this.stacksForClasses, 0, objectArray2, 0, this.stacksForClasses.length);
            }
            this.stacksForClasses = objectArray2;
            objectArray = new long[n];
            if (this.objectsSizePerClass != null) {
                System.arraycopy(this.objectsSizePerClass, 0, objectArray, 0, this.objectsSizePerClass.length);
            }
            this.objectsSizePerClass = objectArray;
        }
        if (this.getClient().getCurrentInstrType() == 6 && (this.nTrackedLiveObjects == null || this.nTrackedLiveObjects.length < this.nProfiledClasses)) {
            n = this.nProfiledClasses * 3 / 2;
            objectArray2 = this.nTrackedLiveObjects;
            objectArray = null;
            long[] lArray = this.nTrackedAllocObjects;
            long[] lArray2 = null;
            boolean[] blArray = this.unprofiledClass;
            boolean[] blArray2 = null;
            objectArray = new int[n];
            if (objectArray2 != null) {
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            }
            lArray2 = new long[n];
            if (lArray != null) {
                System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
            }
            blArray2 = new boolean[n];
            if (blArray != null) {
                System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
            }
            this.nTrackedLiveObjects = (int[])objectArray;
            this.nTrackedAllocObjects = lArray2;
            this.unprofiledClass = blArray2;
        }
    }

    private static class ObjIdToCCTNodeMap {
        private long[] keys;
        private long[] objSize;
        private RuntimeObjLivenessTermCCTNode[] values;
        private int capacity;
        private int k;
        private int nObjects;
        private int threshold;
        private long a = 5700357409661599241L;
        private long lastRemovedObjSize;

        ObjIdToCCTNodeMap() {
            this.init();
        }

        public long getLastRemovedObjSize() {
            return this.lastRemovedObjSize;
        }

        public RuntimeObjLivenessTermCCTNode getNode(long l) {
            int n;
            int n2 = this.hash(l);
            long l2 = this.keys[n2];
            for (n = this.capacity >> 2; l2 != l && n > 0; --n) {
                n2 = (n2 + 1) % this.capacity;
                l2 = this.keys[n2];
            }
            if (n == 0) {
                return null;
            }
            this.keys[n2] = -1L;
            RuntimeObjLivenessTermCCTNode runtimeObjLivenessTermCCTNode = this.values[n2];
            this.values[n2] = null;
            this.lastRemovedObjSize = this.objSize[n2];
            --this.nObjects;
            return runtimeObjLivenessTermCCTNode;
        }

        public void clear() {
            this.keys = null;
            this.values = null;
            this.init();
        }

        public void put(long l, RuntimeObjLivenessTermCCTNode runtimeObjLivenessTermCCTNode, long l2) {
            if (this.nObjects > this.threshold) {
                this.rehash();
            }
            int n = this.hash(l);
            while (this.keys[n] != -1L) {
                n = (n + 1) % this.capacity;
            }
            this.keys[n] = l;
            this.values[n] = runtimeObjLivenessTermCCTNode;
            this.objSize[n] = l2;
            ++this.nObjects;
        }

        public int sizeInBytes() {
            return this.keys.length * 8 + this.values.length * 4 + this.objSize.length * 8;
        }

        private void setThreshold() {
            this.threshold = this.capacity * 3 / 4;
        }

        private int hash(long l) {
            return (int)(l * this.a >>> 64 - this.k);
        }

        private void init() {
            this.capacity = 1024;
            this.k = 10;
            this.nObjects = 0;
            this.setThreshold();
            this.keys = new long[this.capacity];
            for (int i = 0; i < this.capacity; ++i) {
                this.keys[i] = -1L;
            }
            this.values = new RuntimeObjLivenessTermCCTNode[this.capacity];
            this.objSize = new long[this.capacity];
        }

        private void rehash() {
            int n;
            long[] lArray = this.keys;
            RuntimeObjLivenessTermCCTNode[] runtimeObjLivenessTermCCTNodeArray = this.values;
            long[] lArray2 = this.objSize;
            int n2 = this.capacity;
            this.capacity *= 2;
            ++this.k;
            this.keys = new long[this.capacity];
            for (n = 0; n < this.capacity; ++n) {
                this.keys[n] = -1L;
            }
            this.values = new RuntimeObjLivenessTermCCTNode[this.capacity];
            this.objSize = new long[this.capacity];
            for (n = 0; n < n2; ++n) {
                if (lArray[n] == -1L) continue;
                int n3 = this.hash(lArray[n]);
                while (this.keys[n3] != -1L) {
                    n3 = (n3 + 1) % this.capacity;
                }
                this.keys[n3] = lArray[n];
                this.values[n3] = runtimeObjLivenessTermCCTNodeArray[n];
                this.objSize[n3] = lArray2[n];
            }
            this.setThreshold();
        }
    }
}

