/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.locks.AbstractLockDataFrameProcessor;

public class LockDataFrameProcessor
extends AbstractLockDataFrameProcessor {
    @Override
    public void doProcessDataFrame(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Command start offset " + byteBuffer.position());
            }
            byte by = byteBuffer.get();
            switch (by) {
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    break;
                }
                case 29: {
                    char c = byteBuffer.getChar();
                    long l = LockDataFrameProcessor.getTimeStamp(byteBuffer);
                    char c2 = byteBuffer.getChar();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profile Point Hit " + c + ", threadId=" + c + ", timeStamp=" + l);
                    }
                    this.fireProfilingPoint(c2, c, l);
                    break;
                }
                case 13: {
                    this.currentThreadId = byteBuffer.getChar();
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.log(Level.FINEST, "Change current thread , tId={0}", this.currentThreadId);
                    break;
                }
                case 11: {
                    char c = byteBuffer.getChar();
                    String string = LockDataFrameProcessor.getString(byteBuffer);
                    String string2 = LockDataFrameProcessor.getString(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new thread , tId={0}", c);
                    }
                    this.fireNewThread(c, string, string2);
                    this.currentThreadId = c;
                    break;
                }
                case 28: {
                    int n = byteBuffer.getInt();
                    String string = LockDataFrameProcessor.getString(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new monitor , monitorId={0} , className={1}", new Object[]{Integer.toHexString(n), string});
                    }
                    this.fireNewMonitor(n, string);
                    break;
                }
                case 22: 
                case 23: {
                    long l = LockDataFrameProcessor.getTimeStamp(byteBuffer);
                    long l2 = -1L;
                    int n = byteBuffer.getInt();
                    if (by == 22) {
                        int n2 = byteBuffer.getInt();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Monitor entry , tId={0} , monitorId={1} , ownerId={2}", new Object[]{this.currentThreadId, Integer.toHexString(n), n2});
                        }
                        this.fireMonitorEntry(this.currentThreadId, l, l2, n, n2);
                    }
                    if (by != 23) break;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Monitor exit , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, Integer.toHexString(n)});
                    }
                    this.fireMonitorExit(this.currentThreadId, l, l2, n);
                    break;
                }
                case 5: {
                    long l;
                    long l3 = LockDataFrameProcessor.getTimeStamp(byteBuffer);
                    long l4 = l = this.collectingTwoTimeStamps ? LockDataFrameProcessor.getTimeStamp(byteBuffer) : 0L;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Adjust time , tId={0}", this.currentThreadId);
                    }
                    this.fireAdjustTime(this.currentThreadId, l3, l);
                    break;
                }
                default: {
                    LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in LockDataFrameProcessor: " + by + " at " + byteBuffer.position());
                }
            }
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.finest("Command end offset " + byteBuffer.position());
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Buffer end offset " + byteBuffer.position());
        }
    }
}

