#ifndef _EFL_PACK_TABLE_EO_H_
#define _EFL_PACK_TABLE_EO_H_

#ifndef _EFL_PACK_TABLE_EO_CLASS_TYPE
#define _EFL_PACK_TABLE_EO_CLASS_TYPE

typedef Eo Efl_Pack_Table;

#endif

#ifndef _EFL_PACK_TABLE_EO_TYPES
#define _EFL_PACK_TABLE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** 2D containers aligned on a table with rows and columns
 *
 * @ingroup Efl_Pack_Table
 */
#define EFL_PACK_TABLE_INTERFACE efl_pack_table_interface_get()

EWAPI const Efl_Class *efl_pack_table_interface_get(void);

/**
 * @brief Pack object at a given location in the table.
 *
 * When this container is deleted, it will request deletion of the given
 * @c subobj. Use @ref efl_pack_unpack to remove @c subobj from this container
 * without deleting it.
 *
 * @param[in] obj The object.
 * @param[in] subobj A child object to pack in this table.
 * @param[in] col Column number
 * @param[in] row Row number
 * @param[in] colspan 0 means 1, -1 means @ref efl_pack_table_columns_get
 * @param[in] rowspan 0 means 1, -1 means @ref efl_pack_table_rows_get
 *
 * @return @c true on success, @c false otherwise
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI Eina_Bool efl_pack_table(Eo *obj, Efl_Gfx_Entity *subobj, int col, int row, int colspan, int rowspan);

/**
 * @brief Returns all objects at a given position in this table.
 *
 * @param[in] obj The object.
 * @param[in] col Column number
 * @param[in] row Row number
 * @param[in] below If @c true get objects spanning over this cell.
 *
 * @return Iterator to table contents
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI Eina_Iterator *efl_pack_table_contents_get(Eo *obj, int col, int row, Eina_Bool below);

/**
 * @brief Returns a child at a given position, see
 * @ref efl_pack_table_contents_get.
 *
 * @param[in] obj The object.
 * @param[in] col Column number
 * @param[in] row Row number
 *
 * @return Child object
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI Efl_Gfx_Entity *efl_pack_table_content_get(Eo *obj, int col, int row);

/**
 * @brief Position and span of the @c subobj in this container, may be modified
 * to move the @c subobj
 *
 * @param[in] obj The object.
 * @param[in] subobj Child object
 * @param[out] col Column number
 * @param[out] row Row number
 * @param[out] colspan Column span
 * @param[out] rowspan Row span
 *
 * @return Returns false if item is not a child
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI Eina_Bool efl_pack_table_position_get(const Eo *obj, Efl_Gfx_Entity *subobj, int *col, int *row, int *colspan, int *rowspan);

/**
 * @brief Combines @ref efl_pack_table_columns_get and
 * @ref efl_pack_table_rows_get
 *
 * @param[in] obj The object.
 * @param[in] cols Number of columns
 * @param[in] rows Number of rows
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI void efl_pack_table_size_set(Eo *obj, int cols, int rows);

/**
 * @brief Combines @ref efl_pack_table_columns_get and
 * @ref efl_pack_table_rows_get
 *
 * @param[in] obj The object.
 * @param[out] cols Number of columns
 * @param[out] rows Number of rows
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI void efl_pack_table_size_get(const Eo *obj, int *cols, int *rows);

/**
 * @brief Gird columns property
 *
 * Specifies limit for linear adds - if direction is horizontal
 *
 * @param[in] obj The object.
 * @param[in] cols Number of columns
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI void efl_pack_table_columns_set(Eo *obj, int cols);

/**
 * @brief Gird columns property
 *
 * @param[in] obj The object.
 *
 * @return Number of columns
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI int efl_pack_table_columns_get(const Eo *obj);

/**
 * @brief Table rows property
 *
 * Specifies limit for linear adds - if direction is vertical
 *
 * @param[in] obj The object.
 * @param[in] rows Number of rows
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI void efl_pack_table_rows_set(Eo *obj, int rows);

/**
 * @brief Table rows property
 *
 * @param[in] obj The object.
 *
 * @return Number of rows
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI int efl_pack_table_rows_get(const Eo *obj);

/**
 * @brief Primary and secondary up/left/right/down directions for linear apis.
 *
 * Default is horizontal and vertical. This overrides
 * @ref efl_ui_direction_get.
 *
 * @param[in] obj The object.
 * @param[in] primary Primary direction
 * @param[in] secondary Secondary direction
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI void efl_pack_table_direction_set(Eo *obj, Efl_Ui_Dir primary, Efl_Ui_Dir secondary);

/**
 * @brief Primary and secondary up/left/right/down directions for linear apis.
 *
 * Default is horizontal and vertical. This overrides
 * @ref efl_ui_direction_get.
 *
 * @param[in] obj The object.
 * @param[out] primary Primary direction
 * @param[out] secondary Secondary direction
 *
 * @ingroup Efl_Pack_Table
 */
EOAPI void efl_pack_table_direction_get(const Eo *obj, Efl_Ui_Dir *primary, Efl_Ui_Dir *secondary);
#endif /* EFL_BETA_API_SUPPORT */

#endif
