/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.views.overview;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshot;
import com.sun.tools.visualvm.application.views.overview.ApplicationOverviewModel;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.snapshot.RegisteredSnapshotCategories;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.NotSupportedDisplayer;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.uisupport.HTMLTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

class OverviewViewSupport {
    OverviewViewSupport() {
    }

    static class SystemPropertiesViewSupport
    extends JPanel {
        public SystemPropertiesViewSupport(String properties) {
            this.initComponents(properties);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_System_properties"), null, 20, (JComponent)this, null);
        }

        private void initComponents(String properties) {
            NotSupportedDisplayer contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (properties != null) {
                HTMLTextArea area = new HTMLTextArea("<nobr>" + properties + "</nobr>");
                area.setCaretPosition(0);
                area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contents = area;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)new ScrollableContainer((JComponent)contents), "Center");
        }
    }

    static class JVMArgumentsViewSupport
    extends JPanel {
        public JVMArgumentsViewSupport(String jvmargs) {
            this.initComponents(jvmargs);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM_arguments"), null, 10, (JComponent)this, null);
        }

        private void initComponents(String jvmargs) {
            NotSupportedDisplayer contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (jvmargs != null) {
                HTMLTextArea area = new HTMLTextArea("<nobr>" + jvmargs + "</nobr>");
                area.setCaretPosition(0);
                area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contents = area;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)new ScrollableContainer((JComponent)contents), "Center");
        }
    }

    static class SnapshotsViewSupport
    extends JPanel
    implements DataChangeListener<Snapshot> {
        private static final String LINK_TOGGLE_CATEGORY = "file:/toggle_category";
        private static final String LINK_OPEN_SNAPSHOT = "file:/open_snapshot";
        private DataSource dataSource;
        private HTMLTextArea area;
        private final Map<Integer, Snapshot> snapshotsMap = new HashMap<Integer, Snapshot>();
        private final Map<String, Boolean> expansionMap = new HashMap<String, Boolean>();
        private boolean standaloneAppSnapshot;

        public SnapshotsViewSupport(DataSource dataSource) {
            this.dataSource = dataSource;
            this.initComponents();
            dataSource.getRepository().addDataChangeListener((DataChangeListener)this, Snapshot.class);
            boolean bl = this.standaloneAppSnapshot = dataSource.getOwner() == null && dataSource instanceof ApplicationSnapshot;
            if (this.standaloneAppSnapshot) {
                dataSource.setVisible(false);
                DataSource.ROOT.getRepository().addDataSource(dataSource);
            }
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Saved_data"), null, 10, (JComponent)this, null);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea(){

                protected void showURL(URL url) {
                    String link = url.toString();
                    if (link.startsWith(SnapshotsViewSupport.LINK_TOGGLE_CATEGORY)) {
                        link = link.substring(SnapshotsViewSupport.LINK_TOGGLE_CATEGORY.length());
                        this.toggleExpanded(link);
                        this.updateSavedData();
                    } else if (link.startsWith(SnapshotsViewSupport.LINK_OPEN_SNAPSHOT)) {
                        link = link.substring(SnapshotsViewSupport.LINK_OPEN_SNAPSHOT.length());
                        Snapshot s = (Snapshot)snapshotsMap.get(Integer.parseInt(link));
                        if (s != null) {
                            DataSourceWindowManager.sharedInstance().openDataSource((DataSource)s);
                        }
                    }
                }
            };
            this.updateSavedData();
            this.area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.updateSavedData();
                }
            });
        }

        void removed() {
            this.dataSource.getRepository().removeDataChangeListener((DataChangeListener)this);
            if (this.standaloneAppSnapshot) {
                DataSource.ROOT.getRepository().removeDataSource(this.dataSource);
            }
        }

        private void updateSavedData() {
            this.snapshotsMap.clear();
            StringBuilder data = new StringBuilder();
            List snapshotCategories = RegisteredSnapshotCategories.sharedInstance().getVisibleCategories();
            for (SnapshotCategory category : snapshotCategories) {
                DataSourceDescriptor dsd;
                Set snapshots = this.dataSource.getRepository().getDataSources(category.getType());
                if (snapshots.isEmpty()) {
                    data.append("<b>" + category.getName() + ":</b> " + snapshots.size() + "<br>");
                    continue;
                }
                String categoryName = category.getName();
                data.append("<b>" + categoryName + ":</b> <a href='" + LINK_TOGGLE_CATEGORY + categoryName + "'>" + snapshots.size() + "</a><br>");
                if (!this.isExpanded(categoryName)) continue;
                ArrayList<DataSourceDescriptor> descriptors = new ArrayList<DataSourceDescriptor>();
                HashMap<DataSourceDescriptor, Snapshot> dataSources = new HashMap<DataSourceDescriptor, Snapshot>();
                for (Snapshot s : snapshots) {
                    dsd = DataSourceDescriptorFactory.getDescriptor((DataSource)s);
                    descriptors.add(dsd);
                    dataSources.put(dsd, s);
                }
                Collections.sort(descriptors, Positionable.STRONG_COMPARATOR);
                int size = this.snapshotsMap.size();
                for (int i = 0; i < descriptors.size(); ++i) {
                    dsd = (DataSourceDescriptor)descriptors.get(i);
                    Snapshot s = (Snapshot)dataSources.get(dsd);
                    this.snapshotsMap.put(i + size, s);
                    data.append("&nbsp;&nbsp;&nbsp;<a href='file:/open_snapshot" + (i + size) + "'>" + dsd.getName() + "</a><br>");
                }
                data.append("<br>");
            }
            this.area.setText("<nobr>" + data.toString() + "</nobr>");
        }

        private boolean isExpanded(String categoryName) {
            Boolean expanded = this.expansionMap.get(categoryName);
            if (expanded == null) {
                expanded = this.standaloneAppSnapshot;
                this.expansionMap.put(categoryName, expanded);
            }
            return expanded;
        }

        private void toggleExpanded(String categoryName) {
            this.expansionMap.put(categoryName, !this.isExpanded(categoryName));
        }
    }

    static class MasterViewSupport
    extends JPanel {
        private PropertyChangeListener oomeListener;

        public MasterViewSupport(ApplicationOverviewModel model) {
            this.initComponents(model);
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Overview"), null, (JComponent)this);
        }

        private void initComponents(final ApplicationOverviewModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            final HTMLTextArea area = new HTMLTextArea("<nobr>" + this.getGeneralProperties(model) + "</nobr>");
            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            DataSource source = model.getSource();
            if (source instanceof Application) {
                this.oomeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("prop_oome".equals(evt.getPropertyName())) {
                            int selStart = area.getSelectionStart();
                            int selEnd = area.getSelectionEnd();
                            area.setText("<nobr>" + this.getGeneralProperties(model) + "</nobr>");
                            area.select(selStart, selEnd);
                        }
                    }
                };
                Jvm jvm = JvmFactory.getJVMFor((Application)((Application)source));
                jvm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.oomeListener, (Object)jvm));
            }
            this.add((Component)area, "Center");
        }

        private String getGeneralProperties(ApplicationOverviewModel model) {
            StringBuilder data = new StringBuilder();
            String PID = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_PID");
            String HOST = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Host");
            data.append("<b>" + PID + ":</b> " + model.getPid() + "<br>");
            data.append("<b>" + HOST + ":</b> " + model.getHostName() + "<br>");
            if (model.basicInfoSupported()) {
                String MAIN_CLASS = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Main_class");
                String ARGS = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Arguments");
                String JVM = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM");
                String JAVA_HOME = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Java_Home");
                String JAVA = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Java");
                String JAVA_VERSION = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Java_Version");
                String JAVA_VENDOR = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Java_Vendor");
                String JVM_FLAGS = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM_Flags");
                String HEAP_DUMP_OOME = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Heap_dump_on_OOME");
                data.append("<b>" + MAIN_CLASS + ":</b> " + model.getMainClass() + "<br>");
                data.append("<b>" + ARGS + ":</b> " + model.getMainArgs() + "<br>");
                data.append("<br>");
                data.append("<b>" + JVM + ":</b> " + model.getVmId() + "<br>");
                String javaVersion = model.getJavaVersion();
                String javaVendor = model.getJavaVendor();
                if (javaVersion != null || javaVendor != null) {
                    data.append("<b>" + JAVA + ":</b>");
                    if (javaVersion != null) {
                        data.append(" " + JAVA_VERSION + " " + javaVersion);
                    }
                    if (javaVendor != null) {
                        if (javaVersion != null) {
                            data.append(",");
                        }
                        data.append(" " + JAVA_VENDOR + " " + javaVendor);
                    }
                    data.append("<br>");
                }
                data.append("<b>" + JAVA_HOME + ":</b> " + model.getJavaHome() + "<br>");
                data.append("<b>" + JVM_FLAGS + ":</b> " + model.getJvmFlags() + "<br><br>");
                data.append("<b>" + HEAP_DUMP_OOME + ":</b> " + model.oomeEnabled() + "<br>");
            }
            return data.toString();
        }
    }
}

