/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class DialogDisplayer {
    protected DialogDisplayer() {
    }

    public static DialogDisplayer getDefault() {
        DialogDisplayer dialogDisplayer = (DialogDisplayer)Lookup.getDefault().lookup(DialogDisplayer.class);
        if (dialogDisplayer == null) {
            dialogDisplayer = new Trivial();
        }
        return dialogDisplayer;
    }

    public abstract Object notify(NotifyDescriptor var1);

    public void notifyLater(final NotifyDescriptor notifyDescriptor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogDisplayer.this.notify(notifyDescriptor);
            }
        });
    }

    public abstract Dialog createDialog(DialogDescriptor var1);

    public Dialog createDialog(DialogDescriptor dialogDescriptor, Frame frame) {
        return this.createDialog(dialogDescriptor);
    }

    private static final class Trivial
    extends DialogDisplayer {
        private Trivial() {
        }

        @Override
        public Object notify(NotifyDescriptor notifyDescriptor) {
            StandardDialog standardDialog = new StandardDialog(notifyDescriptor.getTitle(), true, notifyDescriptor, null, null);
            standardDialog.setVisible(true);
            return notifyDescriptor.getValue() != null ? notifyDescriptor.getValue() : NotifyDescriptor.CLOSED_OPTION;
        }

        @Override
        public Dialog createDialog(DialogDescriptor dialogDescriptor) {
            StandardDialog standardDialog = new StandardDialog(dialogDescriptor.getTitle(), dialogDescriptor.isModal(), dialogDescriptor, dialogDescriptor.getClosingOptions(), dialogDescriptor.getButtonListener());
            dialogDescriptor.addPropertyChangeListener(new DialogUpdater(standardDialog, dialogDescriptor));
            return standardDialog;
        }

        private static Component message2Component(Object object) {
            if (object instanceof Component) {
                return (Component)object;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                for (int i = 0; i < objectArray.length; ++i) {
                    jPanel.add(Trivial.message2Component(objectArray[i]));
                }
                return jPanel;
            }
            if (object instanceof Icon) {
                return new JLabel((Icon)object);
            }
            String string = object.toString();
            JTextArea jTextArea = new JTextArea(string);
            Color color = UIManager.getColor("Label.background");
            if (color != null) {
                jTextArea.setBackground(color);
            }
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setTabSize(4);
            jTextArea.setColumns(40);
            if (string.indexOf(10) != -1) {
                return new JScrollPane(jTextArea);
            }
            return jTextArea;
        }

        private static Component option2Button(Object object, NotifyDescriptor notifyDescriptor, ActionListener actionListener, JRootPane jRootPane) {
            boolean bl;
            String string;
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                Trivial.removeOldListeners(abstractButton);
                abstractButton.addActionListener(actionListener);
                return abstractButton;
            }
            if (object instanceof Component) {
                return (Component)object;
            }
            if (object instanceof Icon) {
                return new JLabel((Icon)object);
            }
            if (object == NotifyDescriptor.OK_OPTION) {
                string = NbBundle.getMessage(DialogDisplayer.class, (String)"CTL_OK");
                bl = true;
            } else if (object == NotifyDescriptor.CANCEL_OPTION) {
                string = NbBundle.getMessage(DialogDisplayer.class, (String)"CTL_CANCEL");
                bl = false;
            } else if (object == NotifyDescriptor.YES_OPTION) {
                string = NbBundle.getMessage(DialogDisplayer.class, (String)"CTL_YES");
                bl = true;
            } else if (object == NotifyDescriptor.NO_OPTION) {
                string = NbBundle.getMessage(DialogDisplayer.class, (String)"CTL_NO");
                bl = false;
            } else {
                if (object == NotifyDescriptor.CLOSED_OPTION) {
                    throw new IllegalArgumentException();
                }
                string = object.toString();
                bl = false;
            }
            JButton jButton = new JButton(string);
            if (bl && jRootPane.getDefaultButton() == null) {
                jRootPane.setDefaultButton(jButton);
            }
            jButton.getAccessibleContext().setAccessibleName(string);
            jButton.addActionListener(actionListener);
            return jButton;
        }

        private static void removeOldListeners(AbstractButton abstractButton) {
            ArrayList<ActionListener> arrayList = new ArrayList<ActionListener>();
            for (ActionListener actionListener : abstractButton.getActionListeners()) {
                if (!(actionListener instanceof StandardDialog.ButtonListener)) continue;
                arrayList.add(actionListener);
            }
            for (ActionListener actionListener : arrayList) {
                abstractButton.removeActionListener(actionListener);
            }
        }

        private static void updateNotificationLine(StandardDialog standardDialog, int n, Object object) {
            String string;
            String string2 = string = object == null ? null : object.toString();
            if (string != null && string.trim().length() > 0) {
                switch (n) {
                    case 1: {
                        Trivial.prepareMessage(standardDialog.notificationLine, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/error.gif", (boolean)false), standardDialog.nbErrorForeground);
                        break;
                    }
                    case 2: {
                        Trivial.prepareMessage(standardDialog.notificationLine, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/warning.gif", (boolean)false), standardDialog.nbWarningForeground);
                        break;
                    }
                    case 3: {
                        Trivial.prepareMessage(standardDialog.notificationLine, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/info.png", (boolean)false), standardDialog.nbInfoForeground);
                        break;
                    }
                }
                standardDialog.notificationLine.setToolTipText(string);
            } else {
                Trivial.prepareMessage(standardDialog.notificationLine, null, null);
                standardDialog.notificationLine.setToolTipText(null);
            }
            standardDialog.notificationLine.setText(string);
        }

        private static void prepareMessage(JLabel jLabel, ImageIcon imageIcon, Color color) {
            jLabel.setIcon(imageIcon);
            jLabel.setForeground(color);
        }

        private static final class FixedHeightLabel
        extends JLabel {
            private static final int ESTIMATED_HEIGHT = 16;

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                assert (16 == ImageUtilities.loadImage((String)"org/netbeans/modules/dialogs/warning.gif").getHeight(null)) : "Use only 16px icon.";
                dimension.height = Math.max(16, dimension.height);
                return dimension;
            }
        }

        private static class DialogUpdater
        implements PropertyChangeListener {
            private StandardDialog dialog;
            private DialogDescriptor dd;

            public DialogUpdater(StandardDialog standardDialog, DialogDescriptor dialogDescriptor) {
                this.dialog = standardDialog;
                this.dd = dialogDescriptor;
            }

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogUpdater.this.propertyChange(propertyChangeEvent);
                        }
                    });
                    return;
                }
                String string = propertyChangeEvent.getPropertyName();
                if ("title".equals(string)) {
                    this.dialog.setTitle(this.dd.getTitle());
                } else if ("noDefaultClose".equals(string)) {
                    this.dialog.setDefaultCloseOperation(this.dd.isNoDefaultClose() ? 0 : 2);
                } else if ("message".equals(string)) {
                    this.dialog.updateMessage();
                    this.dialog.validate();
                    this.dialog.repaint();
                } else if ("options".equals(string) || "optionType".equals(string)) {
                    this.dialog.updateOptions();
                    this.dialog.validate();
                    this.dialog.repaint();
                } else if ("infoNotification".equals(propertyChangeEvent.getPropertyName())) {
                    Trivial.updateNotificationLine(this.dialog, 3, propertyChangeEvent.getNewValue());
                } else if ("warningNotification".equals(propertyChangeEvent.getPropertyName())) {
                    Trivial.updateNotificationLine(this.dialog, 2, propertyChangeEvent.getNewValue());
                } else if ("errorNotification".equals(propertyChangeEvent.getPropertyName())) {
                    Trivial.updateNotificationLine(this.dialog, 1, propertyChangeEvent.getNewValue());
                }
            }
        }

        private static final class StandardDialog
        extends JDialog {
            final NotifyDescriptor nd;
            private Component messageComponent;
            private final JPanel buttonPanel;
            private final Object[] closingOptions;
            private final ActionListener buttonListener;
            private boolean haveFinalValue = false;
            private Color nbErrorForeground;
            private Color nbWarningForeground;
            private Color nbInfoForeground;
            private JLabel notificationLine;
            private static final int MSG_TYPE_ERROR = 1;
            private static final int MSG_TYPE_WARNING = 2;
            private static final int MSG_TYPE_INFO = 3;

            public StandardDialog(String string, boolean bl, NotifyDescriptor notifyDescriptor, Object[] objectArray, ActionListener actionListener) {
                super((Frame)null, string, bl);
                this.nd = notifyDescriptor;
                this.closingOptions = objectArray;
                this.buttonListener = actionListener;
                this.getContentPane().setLayout(new BorderLayout());
                this.setDefaultCloseOperation(notifyDescriptor.isNoDefaultClose() ? 0 : 2);
                this.updateMessage();
                this.buttonPanel = new JPanel();
                this.buttonPanel.setLayout(new FlowLayout(2));
                this.updateOptions();
                this.getContentPane().add(this.buttonPanel, "South", 1);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
                String string2 = "cancel";
                this.getRootPane().getInputMap(1).put(keyStroke, string2);
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!StandardDialog.this.nd.isNoDefaultClose()) {
                            StandardDialog.this.cancel();
                        }
                    }
                };
                this.getRootPane().getActionMap().put(string2, abstractAction);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        if (!StandardDialog.this.haveFinalValue) {
                            StandardDialog.this.nd.setValue(NotifyDescriptor.CLOSED_OPTION);
                        }
                    }
                });
                this.pack();
                Rectangle rectangle = Utilities.getUsableScreenBounds();
                int n = rectangle.width * 9 / 10;
                int n2 = rectangle.height * 9 / 10;
                Dimension dimension = this.getPreferredSize();
                dimension.width = Math.min(dimension.width, n);
                dimension.height = Math.min(dimension.height, n2);
                this.setBounds(Utilities.findCenterBounds((Dimension)dimension));
            }

            private void cancel() {
                this.nd.setValue(NotifyDescriptor.CANCEL_OPTION);
                this.haveFinalValue = true;
                this.dispose();
            }

            public void updateMessage() {
                if (this.messageComponent != null) {
                    this.getContentPane().remove(this.messageComponent);
                }
                this.messageComponent = Trivial.message2Component(this.nd.getMessage());
                if (!(this.nd instanceof WizardDescriptor) && this.nd.getNotificationLineSupport() != null) {
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add(this.messageComponent, "Center");
                    this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
                    if (this.nbErrorForeground == null) {
                        this.nbErrorForeground = new Color(255, 0, 0);
                    }
                    this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
                    if (this.nbWarningForeground == null) {
                        this.nbWarningForeground = new Color(51, 51, 51);
                    }
                    this.nbInfoForeground = UIManager.getColor("nb.warningForeground");
                    if (this.nbInfoForeground == null) {
                        this.nbInfoForeground = UIManager.getColor("Label.foreground");
                    }
                    this.notificationLine = new FixedHeightLabel();
                    NotificationLineSupport notificationLineSupport = this.nd.getNotificationLineSupport();
                    if (notificationLineSupport.getInformationMessage() != null) {
                        Trivial.updateNotificationLine(this, 3, notificationLineSupport.getInformationMessage());
                    } else if (notificationLineSupport.getWarningMessage() != null) {
                        Trivial.updateNotificationLine(this, 2, notificationLineSupport.getWarningMessage());
                    } else if (notificationLineSupport.getErrorMessage() != null) {
                        Trivial.updateNotificationLine(this, 1, notificationLineSupport.getErrorMessage());
                    }
                    jPanel.add((Component)this.notificationLine, "South");
                    this.messageComponent = jPanel;
                }
                this.getContentPane().add(this.messageComponent, "Center");
            }

            public void updateOptions() {
                int n;
                HashSet<Object> hashSet = new HashSet<Object>(5);
                Object[] objectArray = this.nd.getOptions();
                if (objectArray == null) {
                    switch (this.nd.getOptionType()) {
                        case -1: 
                        case 2: {
                            if (!Utilities.isMac()) {
                                objectArray = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
                                break;
                            }
                            objectArray = new Object[]{NotifyDescriptor.CANCEL_OPTION, NotifyDescriptor.OK_OPTION};
                            break;
                        }
                        case 0: {
                            if (!Utilities.isMac()) {
                                objectArray = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION};
                                break;
                            }
                            objectArray = new Object[]{NotifyDescriptor.NO_OPTION, NotifyDescriptor.YES_OPTION};
                            break;
                        }
                        case 1: {
                            if (!Utilities.isMac()) {
                                objectArray = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, NotifyDescriptor.CANCEL_OPTION};
                                break;
                            }
                            objectArray = new Object[]{NotifyDescriptor.NO_OPTION, NotifyDescriptor.CANCEL_OPTION, NotifyDescriptor.YES_OPTION};
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                this.buttonPanel.removeAll();
                JRootPane jRootPane = this.getRootPane();
                for (n = 0; n < objectArray.length; ++n) {
                    hashSet.add(objectArray[n]);
                    this.buttonPanel.add(Trivial.option2Button(objectArray[n], this.nd, this.makeListener(objectArray[n]), jRootPane));
                }
                objectArray = this.nd.getAdditionalOptions();
                if (objectArray != null) {
                    for (n = 0; n < objectArray.length; ++n) {
                        hashSet.add(objectArray[n]);
                        this.buttonPanel.add(Trivial.option2Button(objectArray[n], this.nd, this.makeListener(objectArray[n]), jRootPane));
                    }
                }
                if (this.closingOptions != null) {
                    for (n = 0; n < this.closingOptions.length; ++n) {
                        if (!hashSet.add(this.closingOptions[n])) continue;
                        ActionListener actionListener = this.makeListener(this.closingOptions[n]);
                        this.attachActionListener(this.closingOptions[n], actionListener);
                    }
                }
            }

            private void attachActionListener(Object object, ActionListener actionListener) {
                Method method;
                if (object instanceof JButton) {
                    JButton jButton = (JButton)object;
                    jButton.addActionListener(actionListener);
                    return;
                }
                try {
                    method = object.getClass().getMethod("addActionListener", ActionListener.class);
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = null;
                }
                catch (SecurityException securityException) {
                    method = null;
                }
                if (method != null) {
                    try {
                        method.invoke(object, actionListener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            private ActionListener makeListener(Object object) {
                return new ButtonListener(object);
            }

            private class ButtonListener
            implements ActionListener {
                private final Object option;

                public ButtonListener(Object object) {
                    this.option = object;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StandardDialog.this.nd.setValue(this.option);
                    if (StandardDialog.this.buttonListener != null) {
                        ActionEvent actionEvent2 = new ActionEvent(this.option, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
                        StandardDialog.this.buttonListener.actionPerformed(actionEvent2);
                    }
                    if (StandardDialog.this.closingOptions == null || Arrays.asList(StandardDialog.this.closingOptions).contains(this.option)) {
                        StandardDialog.this.haveFinalValue = true;
                        StandardDialog.this.setVisible(false);
                    }
                }
            }
        }
    }
}

