/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.BitData;
import sun.jvm.hotspot.oops.BranchData;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CounterData;
import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.JumpData;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.MultiBranchData;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.ProfileData;
import sun.jvm.hotspot.oops.ReceiverTypeData;
import sun.jvm.hotspot.oops.RetData;
import sun.jvm.hotspot.oops.VirtualCallData;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class MethodData
extends Oop {
    static int TypeProfileWidth = 2;
    static int BciProfileWidth = 2;
    static int CompileThreshold;
    static int Reason_many;
    static int Reason_none;
    static int Reason_LIMIT;
    static int Reason_RECORDED_LIMIT;
    private static String[] trapReasonName;
    static final int dsReasonMask;
    static final int dsRecompileBit;
    private static long baseOffset;
    private static CIntField size;
    private static OopField method;
    private static CIntField dataSize;
    private static AddressField data;
    public static int sizeofMethodDataOopDesc;
    public static int cellSize;

    static String trapReasonName(int reason) {
        if (reason == Reason_many) {
            return "many";
        }
        if (reason < Reason_LIMIT) {
            return trapReasonName[reason];
        }
        return "reason" + reason;
    }

    static int trapStateReason(int trapState) {
        int recompileBit;
        if ((trapState -= (recompileBit = trapState & dsRecompileBit)) == dsReasonMask) {
            return Reason_many;
        }
        return trapState;
    }

    static boolean trapStateIsRecompiled(int trapState) {
        return (trapState & dsRecompileBit) != 0;
    }

    static boolean reasonIsRecordedPerBytecode(int reason) {
        return reason > Reason_none && reason < Reason_RECORDED_LIMIT;
    }

    static int trapStateAddReason(int trapState, int reason) {
        int recompileBit;
        if ((trapState -= (recompileBit = trapState & dsRecompileBit)) == dsReasonMask) {
            return trapState + recompileBit;
        }
        if (trapState == reason) {
            return trapState + recompileBit;
        }
        if (trapState == 0) {
            return reason + recompileBit;
        }
        return dsReasonMask + recompileBit;
    }

    static int trapStateSetRecompiled(int trapState, boolean z) {
        if (z) {
            return trapState | dsRecompileBit;
        }
        return trapState & ~dsRecompileBit;
    }

    static String formatTrapState(int trapState) {
        int reason = MethodData.trapStateReason(trapState);
        boolean recompFlag = MethodData.trapStateIsRecompiled(trapState);
        int decodedState = 0;
        if (MethodData.reasonIsRecordedPerBytecode(reason) || reason == Reason_many) {
            decodedState = MethodData.trapStateAddReason(decodedState, reason);
        }
        if (recompFlag) {
            decodedState = MethodData.trapStateSetRecompiled(decodedState, recompFlag);
        }
        if (decodedState != trapState) {
            return "#" + trapState;
        }
        return MethodData.trapReasonName(reason) + (recompFlag ? " recompiled" : "");
    }

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("methodDataOopDesc");
        baseOffset = type.getSize();
        size = new CIntField(type.getCIntegerField("_size"), 0L);
        method = new OopField(type.getOopField("_method"), 0L);
        VM.Flag[] flags = VM.getVM().getCommandLineFlags();
        for (int f = 0; f < flags.length; ++f) {
            VM.Flag flag = flags[f];
            if (flag.getName().equals("TypeProfileWidth")) {
                TypeProfileWidth = (int)flag.getIntx();
                continue;
            }
            if (flag.getName().equals("BciProfileWidth")) {
                BciProfileWidth = (int)flag.getIntx();
                continue;
            }
            if (!flag.getName().equals("CompileThreshold")) continue;
            CompileThreshold = (int)flag.getIntx();
        }
        cellSize = (int)VM.getVM().getAddressSize();
        dataSize = new CIntField(type.getCIntegerField("_data_size"), 0L);
        data = type.getAddressField("_data[0]");
        sizeofMethodDataOopDesc = (int)type.getSize();
        Reason_many = db.lookupIntConstant("Deoptimization::Reason_many");
        Reason_none = db.lookupIntConstant("Deoptimization::Reason_none");
        Reason_LIMIT = db.lookupIntConstant("Deoptimization::Reason_LIMIT");
        Reason_RECORDED_LIMIT = db.lookupIntConstant("Deoptimization::Reason_RECORDED_LIMIT");
        trapReasonName = new String[Reason_LIMIT];
        Iterator i = db.getIntConstants();
        String prefix = "Deoptimization::Reason_";
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!name.startsWith(prefix) || name.endsWith("Reason_many") || name.endsWith("Reason_LIMIT") || name.endsWith("Reason_RECORDED_LIMIT")) continue;
            String trimmed = name.substring(prefix.length());
            int value = db.lookupIntConstant(name);
            if (trapReasonName[value] != null) {
                throw new InternalError("duplicate reasons: " + trapReasonName[value] + " " + trimmed);
            }
            MethodData.trapReasonName[value] = trimmed;
        }
        for (int index = 0; index < trapReasonName.length; ++index) {
            if (trapReasonName[index] != null) continue;
            throw new InternalError("missing reason for " + index);
        }
    }

    MethodData(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    @Override
    public boolean isMethodData() {
        return true;
    }

    @Override
    public long getObjectSize() {
        return MethodData.alignObjectSize(size.getValue(this));
    }

    public Method getMethod() {
        return (Method)method.getValue(this);
    }

    @Override
    public void printValueOn(PrintStream tty) {
        Method m = this.getMethod();
        tty.print("MethodData for " + m.getName().asString() + m.getSignature().asString());
    }

    @Override
    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(method, true);
            visitor.doCInt(size, true);
        }
    }

    int dataSize() {
        if (dataSize == null) {
            return 0;
        }
        return (int)dataSize.getValue(this);
    }

    boolean outOfBounds(int dataIndex) {
        return dataIndex >= this.dataSize();
    }

    ProfileData dataAt(int dataIndex) {
        if (this.outOfBounds(dataIndex)) {
            return null;
        }
        DataLayout dataLayout = new DataLayout(this, dataIndex + (int)data.getOffset());
        switch (dataLayout.tag()) {
            default: {
                throw new InternalError(dataIndex + " " + this.dataSize() + " " + dataLayout.tag());
            }
            case 1: {
                return new BitData(dataLayout);
            }
            case 2: {
                return new CounterData(dataLayout);
            }
            case 3: {
                return new JumpData(dataLayout);
            }
            case 4: {
                return new ReceiverTypeData(dataLayout);
            }
            case 5: {
                return new VirtualCallData(dataLayout);
            }
            case 6: {
                return new RetData(dataLayout);
            }
            case 7: {
                return new BranchData(dataLayout);
            }
            case 8: 
        }
        return new MultiBranchData(dataLayout);
    }

    int dpToDi(int dp) {
        return dp - (int)data.getOffset();
    }

    int firstDi() {
        return 0;
    }

    public ProfileData firstData() {
        return this.dataAt(this.firstDi());
    }

    public ProfileData nextData(ProfileData current) {
        int currentIndex = this.dpToDi(current.dp());
        int nextIndex = currentIndex + current.sizeInBytes();
        return this.dataAt(nextIndex);
    }

    boolean isValid(ProfileData current) {
        return current != null;
    }

    public void printDataOn(PrintStream st) {
        ProfileData data = this.firstData();
        while (this.isValid(data)) {
            st.print(this.dpToDi(data.dp()));
            st.print(" ");
            data.printDataOn(st);
            data = this.nextData(data);
        }
    }

    private byte[] fetchDataAt(Address base, long offset, long size) {
        byte[] result = new byte[(int)size];
        int i = 0;
        while ((long)i < size) {
            result[i] = base.getJByteAt(offset + (long)i);
            ++i;
        }
        return result;
    }

    public byte[] orig() {
        return this.fetchDataAt(this.getHandle(), 0L, sizeofMethodDataOopDesc);
    }

    public long[] data() {
        OopHandle base = this.getHandle();
        long offset = data.getOffset();
        int elements = this.dataSize() / cellSize;
        long[] result = new long[elements];
        for (int i = 0; i < elements; ++i) {
            Address value = base.getAddressAt(offset + (long)(i * cellSize));
            if (value == null) continue;
            result[i] = value.minus(null);
        }
        return result;
    }

    int mileageOf(Method method) {
        long mileage = 0L;
        int iic = method.interpreterInvocationCount();
        if (mileage < (long)iic) {
            mileage = iic;
        }
        long ic = method.getInvocationCounter();
        long bc = method.getBackedgeCounter();
        long icval = ic >> 3;
        if ((ic & 4L) != 0L) {
            icval += (long)CompileThreshold;
        }
        if (mileage < icval) {
            mileage = icval;
        }
        long bcval = bc >> 3;
        if ((bc & 4L) != 0L) {
            bcval += (long)CompileThreshold;
        }
        if (mileage < bcval) {
            mileage = bcval;
        }
        return (int)mileage;
    }

    public int currentMileage() {
        return 20000;
    }

    static {
        dsReasonMask = DataLayout.trapMask >> 1;
        dsRecompileBit = DataLayout.trapMask - dsReasonMask;
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MethodData.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

