/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.util.Strings;

class SSHBuilder {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    SSHBuilder() {
    }

    public void u32(long l) {
        this.bos.write((int)(l >>> 24 & 0xFFL));
        this.bos.write((int)(l >>> 16 & 0xFFL));
        this.bos.write((int)(l >>> 8 & 0xFFL));
        this.bos.write((int)(l & 0xFFL));
    }

    public void rawArray(byte[] byArray) {
        this.u32(byArray.length);
        try {
            this.bos.write(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
    }

    public void write(byte[] byArray) {
        try {
            this.bos.write(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
    }

    public void writeString(String string) {
        this.rawArray(Strings.toByteArray(string));
    }

    public byte[] getBytes() {
        return this.bos.toByteArray();
    }
}

