/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@Immutable
@CheckReturnValue
public class SuppressionInfo {
    public static final SuppressionInfo EMPTY = new SuppressionInfo((Set<String>)ImmutableSet.of(), (Set<Class<? extends Annotation>>)ImmutableSet.of(), false);
    private static final ImmutableSet<String> GENERATED_ANNOTATIONS = ImmutableSet.of((Object)"javax.annotation.Generated", (Object)"javax.annotation.processing.Generated");
    private final ImmutableSet<String> suppressWarningsStrings;
    private final ImmutableSet<Class<? extends Annotation>> customSuppressions;
    private final boolean inGeneratedCode;

    private SuppressionInfo(Set<String> suppressWarningsStrings, Set<Class<? extends Annotation>> customSuppressions, boolean inGeneratedCode) {
        this.suppressWarningsStrings = ImmutableSet.copyOf(suppressWarningsStrings);
        this.customSuppressions = ImmutableSet.copyOf(customSuppressions);
        this.inGeneratedCode = inGeneratedCode;
    }

    private static boolean isGenerated(Symbol sym, VisitorState state) {
        for (String annotation : GENERATED_ANNOTATIONS) {
            if (!ASTHelpers.hasAnnotation(sym, annotation, state)) continue;
            return true;
        }
        return false;
    }

    public SuppressedState suppressedState(Suppressible suppressible, boolean suppressedInGeneratedCode) {
        if (this.inGeneratedCode && suppressedInGeneratedCode) {
            return SuppressedState.SUPPRESSED;
        }
        if (suppressible.supportsSuppressWarnings() && !Collections.disjoint(suppressible.allNames(), this.suppressWarningsStrings)) {
            return SuppressedState.SUPPRESSED;
        }
        if (!Collections.disjoint(suppressible.customSuppressionAnnotations(), this.customSuppressions)) {
            return SuppressedState.SUPPRESSED;
        }
        return SuppressedState.UNSUPPRESSED;
    }

    public boolean isNameSuppressed(String name) {
        return this.suppressWarningsStrings.contains((Object)name);
    }

    public SuppressionInfo forCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final AtomicBoolean generated = new AtomicBoolean(false);
        new SimpleTreeVisitor<Void, Void>(){

            @Override
            public Void visitClass(ClassTree node, Void unused) {
                Symbol.ClassSymbol symbol = ASTHelpers.getSymbol(node);
                generated.compareAndSet(false, symbol != null && SuppressionInfo.isGenerated(symbol, state));
                return null;
            }
        }.visit(tree.getTypeDecls(), null);
        return new SuppressionInfo((Set<String>)this.suppressWarningsStrings, (Set<Class<? extends Annotation>>)this.customSuppressions, generated.get());
    }

    public SuppressionInfo withExtendedSuppressions(Symbol sym, VisitorState state, Set<Class<? extends Annotation>> customSuppressionAnnosToLookFor) {
        boolean newInGeneratedCode = this.inGeneratedCode || SuppressionInfo.isGenerated(sym, state);
        boolean anyModification = newInGeneratedCode != this.inGeneratedCode;
        Object newCustomSuppressions = null;
        for (Class<? extends Annotation> annotationType : customSuppressionAnnosToLookFor) {
            if (this.customSuppressions.contains(annotationType) || !ASTHelpers.hasAnnotation(sym, annotationType, state)) continue;
            anyModification = true;
            if (newCustomSuppressions == null) {
                newCustomSuppressions = new HashSet<Class<? extends Annotation>>((Collection<Class<? extends Annotation>>)this.customSuppressions);
            }
            newCustomSuppressions.add(annotationType);
        }
        Object newSuppressions = null;
        for (Attribute.Compound attr : sym.getAnnotationMirrors()) {
            if (attr.type.tsym != state.getSymtab().suppressWarningsType.tsym && !attr.type.tsym.getQualifiedName().contentEquals("android.annotation.SuppressLint")) continue;
            for (Pair<Symbol.MethodSymbol, Attribute> value : attr.values) {
                if (!((Symbol.MethodSymbol)value.fst).name.contentEquals("value")) continue;
                if (value.snd instanceof Attribute.Array) {
                    for (Attribute suppress : ((Attribute.Array)value.snd).values) {
                        String suppressedWarning = (String)suppress.getValue();
                        if (this.suppressWarningsStrings.contains((Object)suppressedWarning)) continue;
                        anyModification = true;
                        if (newSuppressions == null) {
                            newSuppressions = new HashSet<String>((Collection<String>)this.suppressWarningsStrings);
                        }
                        newSuppressions.add(suppressedWarning);
                    }
                    continue;
                }
                throw new RuntimeException("Expected SuppressWarnings/SuppressLint annotation to take array type");
            }
        }
        if (!anyModification) {
            return this;
        }
        if (newCustomSuppressions == null) {
            newCustomSuppressions = this.customSuppressions;
        }
        if (newSuppressions == null) {
            newSuppressions = this.suppressWarningsStrings;
        }
        return new SuppressionInfo((Set<String>)newSuppressions, (Set<Class<? extends Annotation>>)newCustomSuppressions, newInGeneratedCode);
    }

    public static enum SuppressedState {
        UNSUPPRESSED,
        SUPPRESSED;

    }
}

