/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.HashSet;
import javax.annotation.Nullable;

@BugPattern(name="EqualsBrokenForNull", summary="equals() implementation may throw NullPointerException when given null", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class EqualsBrokenForNull
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, final VisitorState state) {
        if (!Matchers.equalsMethodDeclaration().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final HashSet impliesNonNull = new HashSet();
        final HashSet<Symbol.VarSymbol> incomingVariableSymbols = new HashSet<Symbol.VarSymbol>();
        Symbol.VarSymbol varSymbol = ASTHelpers.getSymbol((VariableTree)((VariableTree)Iterables.getOnlyElement(tree.getParameters())));
        incomingVariableSymbols.add(varSymbol);
        final NullnessAnalysis analysis = NullnessAnalysis.instance((Context)state.context);
        final boolean[] crashesWithNull = new boolean[]{false};
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void unused) {
                Nullness nullness;
                Symbol symbol;
                if (!crashesWithNull[0] && (symbol = ASTHelpers.getSymbol((Tree)node.getExpression())) instanceof Symbol.VarSymbol && incomingVariableSymbols.contains(symbol) && (nullness = analysis.getNullness(new TreePath(this.getCurrentPath(), node.getExpression()), state.context)) == Nullness.NULLABLE) {
                    crashesWithNull[0] = true;
                }
                return (Void)super.visitMemberSelect(node, null);
            }

            @Override
            public Void visitVariable(VariableTree variableTree, Void unused) {
                InstanceOfTree instanceOf;
                ExpressionTree initializer = variableTree.getInitializer();
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
                if ((symbol.flags() & 0x20000000010L) != 0L && initializer instanceof InstanceOfTree && (instanceOf = (InstanceOfTree)initializer).getExpression() instanceof IdentifierTree && incomingVariableSymbols.contains(ASTHelpers.getSymbol((Tree)instanceOf.getExpression()))) {
                    impliesNonNull.add(ASTHelpers.getSymbol((VariableTree)variableTree));
                }
                if (incomingVariableSymbols.contains(this.findVariable(variableTree.getInitializer()))) {
                    incomingVariableSymbols.add(ASTHelpers.getSymbol((VariableTree)variableTree));
                }
                return (Void)super.visitVariable(variableTree, null);
            }

            @Override
            public Void visitIf(IfTree ifTree, Void unused) {
                ExpressionTree condition = ASTHelpers.stripParentheses((ExpressionTree)ifTree.getCondition());
                if (condition instanceof IdentifierTree && impliesNonNull.contains(ASTHelpers.getSymbol((Tree)condition))) {
                    return (Void)this.scan(ifTree.getElseStatement(), null);
                }
                return (Void)super.visitIf(ifTree, unused);
            }

            @Nullable
            private Symbol.VarSymbol findVariable(Tree tree) {
                block5: while (tree != null) {
                    switch (tree.getKind()) {
                        case TYPE_CAST: {
                            tree = ((TypeCastTree)tree).getExpression();
                            continue block5;
                        }
                        case PARENTHESIZED: {
                            tree = ((ParenthesizedTree)tree).getExpression();
                            continue block5;
                        }
                        case IDENTIFIER: {
                            Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                            return symbol instanceof Symbol.VarSymbol ? (Symbol.VarSymbol)symbol : null;
                        }
                    }
                    return null;
                }
                return null;
            }
        }.scan(state.getPath(), (Void)null);
        if (!crashesWithNull[0]) {
            return Description.NO_MATCH;
        }
        String stringAddition = String.format("if (%s == null) { return false; }\n", varSymbol.name);
        SuggestedFix fix = SuggestedFix.prefixWith((Tree)tree.getBody().getStatements().get(0), (String)stringAddition);
        return this.describeMatch(tree, (Fix)fix);
    }
}

