#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger-web
version: 1.15
id: hledger-web-1.15-7mKFF4UOzeaLGLXMbFjRka
key: hledger-web-1.15-7mKFF4UOzeaLGLXMbFjRka
license: GPL-3.0-only
maintainer: Simon Michael <simon@joyful.com>
author: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Web interface for the hledger accounting tool
description:
    This is hledger'\''s web interface.
    It provides a more user-friendly and collaborative UI than the
    command-line or curses-style interfaces.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance
abi: 4b40a823af81e0945cc15d82e7ca795e
exposed: True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Json Hledger.Web.Main
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common
hidden-modules: Paths_hledger_web
import-dirs: /usr/lib/ghc-8.6.5/site-local/hledger-web-1.15
library-dirs: /usr/lib/ghc-8.6.5/site-local/hledger-web-1.15
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/hledger-web
hs-libraries: HShledger-web-1.15-7mKFF4UOzeaLGLXMbFjRka
depends:
    Decimal-0.5.1-4FeZt58Uuh79syDeoBiHXf
    aeson-1.4.4.0-B759jesA16BBzbLoqI31GW base-4.12.0.0
    blaze-html-0.9.1.2-LFnllGMPezqEutot32d3pA
    blaze-markup-0.8.2.2-IwLwNWRUxfsEuYbkQ0Gv5Q bytestring-0.10.8.2
    case-insensitive-1.2.1.0-L7BR5PaOPZy5cAHpLYQKhk
    clientsession-0.9.1.2-EM3b0Z05jU5GAgTvKJTt2
    cmdargs-0.10.20-HFOpHQTj4XE8aEWjoI1u1
    conduit-1.3.1.1-7uQvxkXSawE7t4T2ZzYFLO
    conduit-extra-1.3.4-A6uYuJUr0NV2BK9tpZGRHv containers-0.6.0.1
    data-default-0.7.1.1-5JZ15VDIkjR94TfgciXLrQ directory-1.3.3.0
    filepath-1.4.2.1 hjsmin-0.2.0.4-JdaGi79JbWbIYBzLTeX5ol
    hledger-1.15.2-5V4GfdvJTaQH2xBxPvz8mF
    hledger-lib-1.15.2-58DBtF0Q5WsJ20kd25LvDh
    http-client-0.6.4-IYZM7eWNkdh6wFMVK3AnMc
    http-conduit-2.3.7.3-DQTX0wGqztvJLA6Qx120qS
    http-types-0.12.3-HC8QVCkRWraINFy4YJ7OYV
    json-0.9.3-KMo6fueTh6fHhtSWtpDb75
    megaparsec-7.0.5-7nNPtHGYzPNBh8epow1r1w mtl-2.2.2
    shakespeare-2.0.22-4E8w3hvU79w3ueBJcyXWIC template-haskell-2.14.0.0
    text-1.2.3.1 time-1.8.0.2 transformers-0.5.6.2
    wai-3.2.2.1-Cf1QznwLY1e38bxndDSCcE
    wai-extra-3.0.28-C9tBV19seVkDzEeOOuttK7
    wai-handler-launch-3.0.2.4-1iuQ3zM5bET1nCFie5Eiul
    warp-3.3.4-3nkMnAN1wJ7LukCRkbB22W
    yaml-0.11.2.0-28jGXfAUMjS3k5okNWdMYQ
    yesod-1.6.0-2B1ozUJ0pvFAsmQmbDGvfM
    yesod-core-1.6.16.1-A6vVO54H5jF8usFtrelDSv
    yesod-form-1.6.7-HKeaPe3AjtPBY2DFCWJiAU
    yesod-static-1.6.0.1-1G276xD0U1867VFjXGW5D3
haddock-interfaces: /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html: /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

