/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.bugpatterns.javadoc.AutoValue_JavadocTag;

@AutoValue
abstract class JavadocTag {
    static final ImmutableSet<JavadocTag> KNOWN_OTHER_TAGS = ImmutableSet.of((Object)JavadocTag.blockTag("apiNote"), (Object)JavadocTag.blockTag("attr"), (Object)JavadocTag.blockTag("contact"), (Object)JavadocTag.blockTag("hide"), (Object)JavadocTag.blockTag("implNote"), (Object)JavadocTag.blockTag("implSpec"), (Object[])new JavadocTag[]{JavadocTag.blockTag("required"), JavadocTag.blockTag("team")});
    private static final ImmutableSet<JavadocTag> COMMON_TAGS = ImmutableSet.of((Object)JavadocTag.inlineTag("code"), (Object)JavadocTag.blockTag("deprecated"), (Object)JavadocTag.inlineTag("docRoot"), (Object)JavadocTag.inlineTag("link"), (Object)JavadocTag.inlineTag("linkplain"), (Object)JavadocTag.inlineTag("literal"), (Object[])new JavadocTag[]{JavadocTag.blockTag("see"), JavadocTag.blockTag("since")});
    static final ImmutableSet<JavadocTag> VALID_CLASS_TAGS = ImmutableSet.builder().addAll(COMMON_TAGS).add((Object[])new JavadocTag[]{JavadocTag.blockTag("author"), JavadocTag.inlineTag("inheritDoc"), JavadocTag.blockTag("param"), JavadocTag.inlineTag("value"), JavadocTag.blockTag("version")}).build();
    static final ImmutableSet<JavadocTag> VALID_VARIABLE_TAGS = ImmutableSet.builder().addAll(COMMON_TAGS).add((Object[])new JavadocTag[]{JavadocTag.blockTag("serial"), JavadocTag.blockTag("serialData"), JavadocTag.blockTag("serialField"), JavadocTag.inlineTag("value")}).build();
    static final ImmutableSet<JavadocTag> VALID_METHOD_TAGS = ImmutableSet.builder().addAll(COMMON_TAGS).add((Object[])new JavadocTag[]{JavadocTag.blockTag("author"), JavadocTag.blockTag("exception"), JavadocTag.inlineTag("inheritDoc"), JavadocTag.blockTag("param"), JavadocTag.blockTag("return"), JavadocTag.blockTag("serial"), JavadocTag.blockTag("throws"), JavadocTag.blockTag("serialData"), JavadocTag.blockTag("serialField"), JavadocTag.inlineTag("value"), JavadocTag.blockTag("version")}).build();

    JavadocTag() {
    }

    abstract String name();

    abstract TagType type();

    static JavadocTag blockTag(String name) {
        return JavadocTag.of(name, TagType.BLOCK);
    }

    static JavadocTag inlineTag(String name) {
        return JavadocTag.of(name, TagType.INLINE);
    }

    private static JavadocTag of(String name, TagType type) {
        return new AutoValue_JavadocTag(name, type);
    }

    static enum TagType {
        BLOCK,
        INLINE;

    }
}

