export declare enum BackendTypeLabel {
    DEVELOPMENT = "Development",
    EDGE = "Edge",
    INTERNAL = "Internal",
    LOCALHOST = "Localhost",
    PRODUCTION = "Production",
    RC = "RC"
}
export declare type BackendTypeLabelKey = keyof typeof BackendTypeLabel;
export declare const URL_WEBAPP: {
    DEVELOPMENT: string;
    EDGE: string;
    INTERNAL: string;
    LOCALHOST: string;
    PRODUCTION: string;
    RC: string;
};
export declare const app: {
    ENV: "internal" | "production";
    IS_DEVELOPMENT: boolean;
    IS_PRODUCTION: boolean;
    UPDATE_URL_WIN: string;
};
export declare const getEnvironment: () => "DEVELOPMENT" | "EDGE" | "INTERNAL" | "LOCALHOST" | "PRODUCTION" | "RC";
export declare const platform: {
    IS_LINUX: boolean;
    IS_MAC_OS: boolean;
    IS_WINDOWS: boolean;
};
export declare const linuxDesktop: {
    isGnomeX11: boolean;
    isPopOS: boolean;
    isUbuntuUnity: boolean;
};
export declare const setEnvironment: (env: "DEVELOPMENT" | "EDGE" | "INTERNAL" | "LOCALHOST" | "PRODUCTION" | "RC") => void;
export declare const web: {
    getAdminUrl: (path?: string | undefined) => string;
    getWebappUrl: (env?: string | undefined) => string;
    getWebsiteUrl: (path?: string | undefined) => string;
};
